/*
 * Decompiled with CFR 0.152.
 */
package model.components.nodes.node.sdn;

import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class SdnServer
extends SdnNode {
    public SdnServer(String nameNetwork, int number, String operatingSystem, int cpu, int memory, int diskSpace, int maxVirtualNodesNumber) {
        super(nameNetwork, SdnServer.class.getSimpleName(), number, "Server", operatingSystem, cpu, memory, maxVirtualNodesNumber, "/icons/greyPhysicalServer.png", "/icons/greenPhysicalServer.png", "/icons/yellowPhysicalServer.png", "/icons/redPhysicalServer.png");
        this.setStorage(diskSpace);
        this.setAvailableStorage(diskSpace);
    }

    @Override
    public SdnServer getCopy() {
        SdnServer sdnServer = new SdnServer(this.getNetworkName(), this.getNumber(), this.getOS(), this.getCPU(), this.getRAM(), this.getStorage(), this.getAvailableVirtualNodesNumber());
        sdnServer.setInitialNumber(this.getInitialNumber());
        sdnServer.setNamePrefix(this.getNamePrefix());
        sdnServer.setType(this.getType());
        sdnServer.setAvailableCPU(this.getAvailableCPU());
        sdnServer.setAvailableRAM(this.getAvailableRAM());
        sdnServer.setAvailableStorage(this.getAvailableStorage());
        sdnServer.setMaxVirtualNodesNumber(this.getMaxVirtualNodesNumber());
        sdnServer.setTimeStamp(this.getTimeStamp());
        sdnServer.setSelected(this.isSelected());
        for (VirtualNode virtualNode : this.getVirtualNodes()) {
            sdnServer.add(virtualNode.getCopy());
        }
        return sdnServer;
    }

    @Override
    public SdnServer getSoftCopy() {
        SdnServer sdnServer = new SdnServer(this.getNetworkName(), this.getNumber(), this.getOS(), this.getCPU(), this.getRAM(), this.getStorage(), this.getAvailableVirtualNodesNumber());
        sdnServer.setInitialNumber(this.getInitialNumber());
        sdnServer.setNamePrefix(this.getNamePrefix());
        sdnServer.setType(this.getType());
        sdnServer.setAvailableCPU(this.getAvailableCPU());
        sdnServer.setAvailableRAM(this.getAvailableRAM());
        sdnServer.setAvailableStorage(this.getAvailableStorage());
        sdnServer.setMaxVirtualNodesNumber(this.getMaxVirtualNodesNumber());
        sdnServer.setTimeStamp(this.getTimeStamp());
        sdnServer.setSelected(this.isSelected());
        return sdnServer;
    }
}

