/*
 * Decompiled with CFR 0.152.
 */
package model.components.nodes.node.sdn;

import java.util.ArrayList;
import java.util.List;
import model.components.nodes.node.Node;
import model.components.nodes.node.virtual.VirtualNode;

public class SdnNode
extends Node {
    private int availableCPU;
    private int availableRAM;
    protected int availableStorage;
    private int maxVirtualNodesNumber;
    private int availableVirtualNodesNumber;
    private List<VirtualNode> virtualNodes;

    public int getAvailableCPU() {
        return this.availableCPU;
    }

    public void setAvailableCPU(int availableCPU) {
        this.availableCPU = availableCPU;
    }

    public int getAvailableRAM() {
        return this.availableRAM;
    }

    public void setAvailableRAM(int availableRAM) {
        this.availableRAM = availableRAM;
    }

    public int getAvailableStorage() {
        return this.availableStorage;
    }

    public void setAvailableStorage(int availableStorage) {
        this.availableStorage = availableStorage;
    }

    public int getMaxVirtualNodesNumber() {
        return this.maxVirtualNodesNumber;
    }

    public void setMaxVirtualNodesNumber(int maxVirtualNodesNumber) {
        this.maxVirtualNodesNumber = maxVirtualNodesNumber;
    }

    public int getAvailableVirtualNodesNumber() {
        return this.availableVirtualNodesNumber;
    }

    public void setAvailableVirtualNodesNumber(int availableVirtualNodesNumber) {
        this.availableVirtualNodesNumber = availableVirtualNodesNumber;
    }

    public List<VirtualNode> getVirtualNodes() {
        return this.virtualNodes;
    }

    public void setVirtualNodes(List<VirtualNode> virtualNodes) {
        this.virtualNodes = virtualNodes;
    }

    public SdnNode(String networkName, String namePrefix, int number, String type, String os, int cpu, int ram, int maxVirtualNodesNumber, String greyIcon, String greenIcon, String yellowIcon, String redIcon) {
        super(networkName, namePrefix, number, type, os, cpu, ram, greyIcon, greenIcon, yellowIcon, redIcon);
        this.setAvailableCPU(cpu);
        this.setAvailableRAM(ram);
        this.setMaxVirtualNodesNumber(maxVirtualNodesNumber);
        this.setAvailableVirtualNodesNumber(maxVirtualNodesNumber);
        this.setVirtualNodes(new ArrayList<VirtualNode>());
    }

    @Override
    public SdnNode getCopy() {
        return null;
    }

    public SdnNode getSoftCopy() {
        return null;
    }

    public void add(VirtualNode virtualNode) {
        this.getVirtualNodes().add(virtualNode);
    }

    public void remove(VirtualNode virtualNodeToRemove) {
        int virtualNodeIndex = -1;
        for (VirtualNode virtualNode : this.getVirtualNodes()) {
            if (!virtualNode.equals(virtualNodeToRemove)) continue;
            virtualNodeIndex = this.getVirtualNodes().indexOf(virtualNode);
        }
        if (virtualNodeIndex != -1) {
            this.getVirtualNodes().remove(virtualNodeIndex);
        }
    }
}

