/*
 * Decompiled with CFR 0.152.
 */
package model.components.networks.virtual;

import cern.jet.random.Exponential;
import cern.jet.random.Poisson;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import model.components.links.link.VirtualLink;
import model.components.networks.NetworkGraph;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.virtual.VirtualMachine;
import model.components.nodes.node.virtual.VirtualRouter;
import model.components.nodes.node.virtual.VirtualSwitch;

public class VirtualNetworks {
    public static final String NAME_PREFIX = VirtualNetwork.class.getSimpleName();
    public static final int NETWORKS_NUMBER = 10;
    public static final int WINDOW_TIME_UNITS_NUMBER = 1;
    public static final double POISSON_ARRIVES = 1.0;
    public static final double EXPONENTIAL_LIFETIME = 10.0;
    public static final int MIN_ROUTERS_NUMBER = 1;
    public static final int MAX_ROUTERS_NUMBER = 5;
    public static final int MIN_SERVERS_NUMBER = 1;
    public static final int MAX_SERVERS_NUMBER = 5;
    public static final int MIN_SWITCHES_NUMBER = 1;
    public static final int MAX_SWITCHES_NUMBER = 5;
    public static final int LINUX_PERCENTAGE = 100;
    public static final int WINDOWS_PERCENTAGE = 0;
    public static final int SOLARIS_PERCENTAGE = 0;
    public static final int ANDROID_PERCENTAGE = 0;
    public static final int MIN_CPU = 1;
    public static final int MAX_CPU = 20;
    public static final int MIN_RAM = 1;
    public static final int MAX_RAM = 20;
    public static final int MIN_STORAGE = 1;
    public static final int MAX_STORAGE = 20;
    public static final int MIN_BW = 1;
    public static final int MAX_BW = 50;
    private List<VirtualNetwork> virtualNetworks;
    public static final int MIN_NODES_NUMBER = 8;
    public static final int MAX_NODES_NUMBER = 8;
    public static final int LINKS_NUMBER_PERCENTAGE = 25;
    public static final int MIN_LINKS_NUMBER_RANGE = 1;
    public static final int MAX_LINKS_NUMBER_RANGE = 10;

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.virtualNetworks;
    }

    public void setVirtualNetworks(List<VirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
    }

    public VirtualNetworks(String namePrefix, int networksNumber, int windowTimeUnitsNumber, double poissonArrives, double exponentialLifetime, int minNodesNumber, int maxNodesNumber, int routersPercentage, int switchesPercentage, int serversPercentage, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCpu, int maxCpu, int minMemory, int maxMemory, int minDiskSpace, int maxDiskSpace, int linksNumberPercentage, int vlanPercentage, int sonetPercentage, int eight0211Percentage, int minBandwidth, int maxBandwidth) {
    }

    public VirtualNetworks(String namePrefix, int networksNumber, int windowTimeUnitsNumber, double poissonArrives, double exponentialLifetime, int minNodesNumber, int maxNodesNumber, int routersPercentage, int switchesPercentage, int serversPercentage, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCpu, int maxCpu, int minMemory, int maxMemory, int minDiskSpace, int maxDiskSpace, int minLinksNumber, int maxLinksNumber, int vlanPercentage, int sonetPercentage, int eight0211Percentage, int minBandwidth, int maxBandwidth) {
    }

    public VirtualNetworks() {
        List<VirtualNetwork> virtualNetworks = this.virtualNetworks(NAME_PREFIX, 10, 1, 1.0, 10.0, 1, 5, 1, 5, 1, 5, 100, 0, 0, 0, 1, 20, 1, 20, 1, 20, 1, 50);
        this.setVirtualNetworks(virtualNetworks);
    }

    public VirtualNetworks(String namePrefix, int networksNumber, int windowTimeUnitsNumber, double poissonArrives, double exponentialLifetime, int minRoutersNumber, int maxRoutersNumber, int minSwitchesNumber, int maxSwitchesNumber, int minServersNumber, int maxServersNumber, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCPU, int maxCPU, int minRAM, int maxRAM, int minStorage, int maxStorage, int minBW, int maxBW) {
        List<VirtualNetwork> virtualNetworks = this.virtualNetworks(namePrefix, networksNumber, windowTimeUnitsNumber, poissonArrives, exponentialLifetime, minRoutersNumber, maxRoutersNumber, minSwitchesNumber, maxSwitchesNumber, minServersNumber, maxServersNumber, linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage, minCPU, maxCPU, minRAM, maxRAM, minStorage, maxStorage, minBW, maxBW);
        this.setVirtualNetworks(virtualNetworks);
    }

    private List<VirtualNetwork> virtualNetworks(String namePrefix, int networksNumber, int windowTimeUnitsNumber, double poissonArrives, double exponentialLifetime, int minRoutersNumber, int maxRoutersNumber, int minSwitchesNumber, int maxSwitchesNumber, int minServersNumber, int maxServersNumber, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCPU, int maxCPU, int minRAM, int maxRAM, int minStorage, int maxStorage, int minBW, int maxBW) {
        ArrayList<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
        Poisson poisson = new Poisson(poissonArrives, new DRand());
        Exponential exponential = new Exponential(1.0 / exponentialLifetime, new DRand());
        int networkNumber = 0;
        int startingDate = 0;
        while (networkNumber < networksNumber) {
            int virtualNetworkRequestsNumber = poisson.nextInt();
            int i = 0;
            while (i < virtualNetworkRequestsNumber) {
                if (networkNumber < networksNumber) {
                    int endingDate = startingDate + exponential.nextInt();
                    String nameNetwork = String.valueOf(namePrefix) + networkNumber;
                    NetworkGraph graph = new NetworkGraph();
                    int nodeCount = 0;
                    int virtualRoutersNumber = this.randomMinMaxNumber(minRoutersNumber, maxRoutersNumber);
                    ArrayList<VirtualRouter> virtualRouters = new ArrayList<VirtualRouter>();
                    int j = 0;
                    while (j < virtualRoutersNumber) {
                        String os = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                        int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                        int ram = this.randomMinMaxNumber(minRAM, maxRAM);
                        VirtualRouter sdnRouter = new VirtualRouter(nameNetwork, startingDate, endingDate, nodeCount++, os, cpu, ram);
                        virtualRouters.add(sdnRouter);
                        graph.addVertex(sdnRouter);
                        ++j;
                    }
                    int virtualSwitchesNumber = this.randomMinMaxNumber(minSwitchesNumber, maxSwitchesNumber);
                    ArrayList<VirtualSwitch> virtualSwitches = new ArrayList<VirtualSwitch>();
                    int j2 = 0;
                    while (j2 < virtualSwitchesNumber) {
                        String os = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                        int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                        int n = this.randomMinMaxNumber(minRAM, maxRAM);
                        VirtualSwitch virtualSwitch = new VirtualSwitch(nameNetwork, startingDate, endingDate, nodeCount++, os, cpu, n);
                        virtualSwitches.add(virtualSwitch);
                        graph.addVertex(virtualSwitch);
                        ++j2;
                    }
                    int virtualMachinesNumber = this.randomMinMaxNumber(minServersNumber, maxServersNumber);
                    ArrayList<Object> virtualMachines = new ArrayList<Object>();
                    int j3 = 0;
                    while (j3 < virtualMachinesNumber) {
                        String string = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                        int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                        int ram = this.randomMinMaxNumber(minRAM, maxRAM);
                        int storage = this.randomMinMaxNumber(minStorage, maxStorage);
                        VirtualMachine virtualMachine = new VirtualMachine(nameNetwork, startingDate, endingDate, nodeCount++, string, cpu, ram, storage);
                        virtualMachines.add(virtualMachine);
                        graph.addVertex(virtualMachine);
                        ++j3;
                    }
                    int linkCount = 0;
                    for (VirtualRouter virtualRouter : virtualRouters) {
                        List<VirtualSwitch> randomVirtualSwitches = this.randomVirtualSwitches(virtualSwitches);
                        for (VirtualSwitch randomVirtualSwitch : randomVirtualSwitches) {
                            int bw = this.randomMinMaxNumber(minBW, maxBW);
                            VirtualLink virtualLink = new VirtualLink(nameNetwork, startingDate, endingDate, linkCount++, bw);
                            graph.addEdge(virtualLink, virtualRouter, randomVirtualSwitch);
                        }
                    }
                    for (VirtualSwitch virtualSwitch : virtualSwitches) {
                        for (VirtualSwitch otherVirtualSwitch : virtualSwitches) {
                            if (virtualSwitch.getNumber() >= otherVirtualSwitch.getNumber()) continue;
                            int bw = this.randomMinMaxNumber(minBW, maxBW);
                            VirtualLink virtualLink = new VirtualLink(nameNetwork, startingDate, endingDate, linkCount++, bw);
                            graph.addEdge(virtualLink, virtualSwitch, otherVirtualSwitch);
                        }
                    }
                    for (VirtualMachine virtualMachine : virtualMachines) {
                        int bw = this.randomMinMaxNumber(minBW, maxBW);
                        VirtualLink virtualLink = new VirtualLink(nameNetwork, startingDate, endingDate, linkCount++, bw);
                        VirtualSwitch virtualSwitch = (VirtualSwitch)virtualSwitches.get(this.randomMinMaxNumber(0, virtualSwitches.size() - 1));
                        graph.addEdge(virtualLink, virtualMachine, virtualSwitch);
                    }
                    virtualNetworks.add(new VirtualNetwork(namePrefix, networkNumber++, graph, startingDate, startingDate + exponential.nextInt()));
                }
                ++i;
            }
            startingDate += windowTimeUnitsNumber;
        }
        return virtualNetworks;
    }

    private String randomOS(int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage) {
        double randomOS = 100.0 * Math.random();
        if (0.0 <= randomOS && randomOS < (double)linuxPercentage) {
            return "Linux";
        }
        if ((double)linuxPercentage <= randomOS && randomOS < (double)(linuxPercentage + windowsPercentage)) {
            return "Windows";
        }
        if ((double)(linuxPercentage + windowsPercentage) <= randomOS && randomOS < (double)(linuxPercentage + windowsPercentage + solarisPercentage)) {
            return "Solaris";
        }
        if ((double)(linuxPercentage + windowsPercentage + solarisPercentage) <= randomOS && randomOS < 100.0) {
            return "Android";
        }
        return null;
    }

    private int randomMinMaxNumber(int minNumber, int maxNumber) {
        return minNumber + (int)(Math.random() * (double)(maxNumber - minNumber + 1));
    }

    private List<VirtualSwitch> randomVirtualSwitches(List<VirtualSwitch> virtualSwitches) {
        ArrayList<VirtualSwitch> randomVirtualSwitches = new ArrayList<VirtualSwitch>();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        int randomVirtualSwitchesNumber = this.randomMinMaxNumber(1, virtualSwitches.size());
        int numberOk = 0;
        while (numberOk < randomVirtualSwitchesNumber) {
            int randomIndex = this.randomMinMaxNumber(0, virtualSwitches.size() - 1);
            boolean isSelected = false;
            Iterator iterator = selectedIndexes.iterator();
            while (iterator.hasNext()) {
                int selectedIndex = (Integer)iterator.next();
                if (selectedIndex != randomIndex) continue;
                isSelected = true;
                break;
            }
            if (isSelected) continue;
            selectedIndexes.add(randomIndex);
            randomVirtualSwitches.add(virtualSwitches.get(randomIndex));
            ++numberOk;
        }
        return randomVirtualSwitches;
    }
}

