/*
 * Decompiled with CFR 0.152.
 */
package model.components.networks.sdn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import model.components.links.link.SdnLink;
import model.components.networks.NetworkGraph;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.node.sdn.SdnRouter;
import model.components.nodes.node.sdn.SdnServer;
import model.components.nodes.node.sdn.SdnSwitch;

public class SdnNetworks {
    public static final String NAME_PREFIX = SdnNetwork.class.getSimpleName();
    public static final int NETWORKS_NUMBER = 5;
    public static final int MIN_ROUTERS_NUMBER = 1;
    public static final int MAX_ROUTERS_NUMBER = 5;
    public static final int MIN_SERVERS_NUMBER = 3;
    public static final int MAX_SERVERS_NUMBER = 10;
    public static final int MIN_SWITCHES_NUMBER = 3;
    public static final int MAX_SWITCHES_NUMBER = 10;
    public static final int LINUX_PERCENTAGE = 100;
    public static final int WINDOWS_PERCENTAGE = 0;
    public static final int SOLARIS_PERCENTAGE = 0;
    public static final int ANDROID_PERCENTAGE = 0;
    public static final int MIN_CPU = 50;
    public static final int MAX_CPU = 100;
    public static final int MIN_CPU_PRICE = 50;
    public static final int MAX_CPU_PRICE = 100;
    public static final int MIN_RAM = 50;
    public static final int MAX_RAM = 100;
    public static final int MIN_RAM_PRICE = 50;
    public static final int MAX_RAM_PRICE = 100;
    public static final int MIN_STORAGE = 50;
    public static final int MAX_STORAGE = 100;
    public static final int MIN_STORAGE_PRICE = 50;
    public static final int MAX_STORAGE_PRICE = 100;
    public static final int MAX_VIRTUAL_NODES_NUMBER = 10;
    public static final int MIN_BW = 500;
    public static final int MAX_BW = 1000;
    public static final int MIN_BW_PRICE = 50;
    public static final int MAX_BW_PRICE = 100;
    public static final int MIN_DISTANCE = 1;
    public static final int MAX_DISTANCE = 100;
    private List<SdnNetwork> sdnNetworks;

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public SdnNetworks() {
        List<SdnNetwork> sdnNetworks = this.sdnNetworks(NAME_PREFIX, 5, 1, 5, 3, 10, 3, 10, 100, 0, 0, 0, 50, 100, 50, 100, 50, 100, 50, 100, 50, 100, 50, 100, 10, 500, 1000, 50, 100, 1, 100);
        this.setSdnNetworks(sdnNetworks);
    }

    public SdnNetworks(String namePrefix, int networksNumber, int minRoutersNumber, int maxRoutersNumber, int minSwitchesNumber, int maxSwitchesNumber, int minServersNumber, int maxServersNumber, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCPU, int maxCPU, int minCPUprice, int maxCPUprice, int minRAM, int maxRAM, int minRAMprice, int maxRAMprice, int minStorage, int maxStorage, int minStoragePrice, int maxStoragePrice, int maxVirtualNodesNumber, int minBW, int maxBW, int minBWprice, int maxBWprice, int minDistance, int maxDistance) {
        List<SdnNetwork> sdnNetworks = this.sdnNetworks(namePrefix, networksNumber, minRoutersNumber, maxRoutersNumber, minSwitchesNumber, maxSwitchesNumber, minServersNumber, maxServersNumber, linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage, minCPU, maxCPU, minCPUprice, maxCPUprice, minRAM, maxRAM, minRAMprice, maxRAMprice, minStorage, maxStorage, minStoragePrice, maxStoragePrice, maxVirtualNodesNumber, minBW, maxBW, minBWprice, maxBWprice, minDistance, maxDistance);
        this.setSdnNetworks(sdnNetworks);
    }

    private List<SdnNetwork> sdnNetworks(String namePrefix, int networksNumber, int minRoutersNumber, int maxRoutersNumber, int minSwitchesNumber, int maxSwitchesNumber, int minServersNumber, int maxServersNumber, int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage, int minCPU, int maxCPU, int minCPUprice, int maxCPUprice, int minRAM, int maxRAM, int minRAMprice, int maxRAMprice, int minStorage, int maxStorage, int minStoragePrice, int maxStoragePrice, int maxVirtualNodesNumber, int minBW, int maxBW, int minBWprice, int maxBWprice, int minDistance, int maxDistance) {
        ArrayList<SdnNetwork> sdnNetworks = new ArrayList<SdnNetwork>();
        int i = 0;
        while (i < networksNumber) {
            SdnLink sdnLink;
            int distance;
            int bw;
            int n;
            String nameNetwork = String.valueOf(namePrefix) + i;
            NetworkGraph graph = new NetworkGraph();
            int nodeCount = 0;
            int sdnRoutersNumber = this.randomMinMaxNumber(minRoutersNumber, maxRoutersNumber);
            ArrayList<SdnRouter> sdnRouters = new ArrayList<SdnRouter>();
            int j = 0;
            while (j < sdnRoutersNumber) {
                String os = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                int ram = this.randomMinMaxNumber(minRAM, maxRAM);
                SdnRouter sdnRouter = new SdnRouter(nameNetwork, nodeCount++, os, cpu, ram, maxVirtualNodesNumber);
                sdnRouters.add(sdnRouter);
                graph.addVertex(sdnRouter);
                ++j;
            }
            int sdnSwitchesNumber = this.randomMinMaxNumber(minSwitchesNumber, maxSwitchesNumber);
            ArrayList<SdnSwitch> sdnSwitches = new ArrayList<SdnSwitch>();
            int j2 = 0;
            while (j2 < sdnSwitchesNumber) {
                String os = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                n = this.randomMinMaxNumber(minRAM, maxRAM);
                SdnSwitch sdnSwitch = new SdnSwitch(nameNetwork, nodeCount++, os, cpu, n, maxVirtualNodesNumber);
                sdnSwitches.add(sdnSwitch);
                graph.addVertex(sdnSwitch);
                ++j2;
            }
            int sdnServersNumber = this.randomMinMaxNumber(minServersNumber, maxServersNumber);
            ArrayList<Object> sdnServers = new ArrayList<Object>();
            int j3 = 0;
            while (j3 < sdnServersNumber) {
                String string = this.randomOS(linuxPercentage, windowsPercentage, solarisPercentage, androidPercentage);
                int cpu = this.randomMinMaxNumber(minCPU, maxCPU);
                int ram = this.randomMinMaxNumber(minRAM, maxRAM);
                int storage = this.randomMinMaxNumber(minStorage, maxStorage);
                SdnServer sdnServer = new SdnServer(nameNetwork, nodeCount++, string, cpu, ram, storage, maxVirtualNodesNumber);
                sdnServers.add(sdnServer);
                graph.addVertex(sdnServer);
                ++j3;
            }
            int linkCount = 0;
            for (SdnRouter sdnRouter : sdnRouters) {
                List<SdnSwitch> randomSdnSwitches = this.randomSdnSwitches(sdnSwitches);
                for (SdnSwitch randomSdnSwitch : randomSdnSwitches) {
                    bw = 100;
                    distance = 10;
                    sdnLink = new SdnLink(nameNetwork, linkCount++, bw, distance);
                    graph.addEdge(sdnLink, sdnRouter, randomSdnSwitch);
                }
            }
            for (SdnSwitch sdnSwitch : sdnSwitches) {
                for (SdnSwitch otherSdnSwitch : sdnSwitches) {
                    if (sdnSwitch.getNumber() >= otherSdnSwitch.getNumber()) continue;
                    int bw2 = 100;
                    int distance2 = 10;
                    SdnLink sdnLink2 = new SdnLink(nameNetwork, linkCount++, bw2, distance2);
                    graph.addEdge(sdnLink2, sdnSwitch, otherSdnSwitch);
                }
            }
            for (SdnServer sdnServer : sdnServers) {
                List<SdnSwitch> randomSdnSwitches = this.randomSdnSwitches(sdnSwitches);
                for (SdnSwitch randomSdnSwitch : randomSdnSwitches) {
                    bw = 100;
                    distance = 10;
                    sdnLink = new SdnLink(nameNetwork, linkCount++, bw, distance);
                    graph.addEdge(sdnLink, sdnServer, randomSdnSwitch);
                }
            }
            n = this.randomMinMaxNumber(minCPUprice, maxCPUprice);
            int ramPrice = this.randomMinMaxNumber(minRAMprice, maxRAMprice);
            int storagePrice = this.randomMinMaxNumber(minStoragePrice, maxStoragePrice);
            int bwPrice = this.randomMinMaxNumber(minBWprice, maxBWprice);
            sdnNetworks.add(new SdnNetwork(namePrefix, i, graph, n, ramPrice, storagePrice, bwPrice));
            ++i;
        }
        return sdnNetworks;
    }

    private int randomMinMaxNumber(int minNumber, int maxNumber) {
        return minNumber + (int)(Math.random() * (double)(maxNumber - minNumber + 1));
    }

    private String randomOS(int linuxPercentage, int windowsPercentage, int solarisPercentage, int androidPercentage) {
        double randomOS = 100.0 * Math.random();
        if (0.0 <= randomOS && randomOS < (double)linuxPercentage) {
            return "Linux";
        }
        if ((double)linuxPercentage <= randomOS && randomOS < (double)(linuxPercentage + windowsPercentage)) {
            return "Windows";
        }
        if ((double)(linuxPercentage + windowsPercentage) <= randomOS && randomOS < (double)(linuxPercentage + windowsPercentage + solarisPercentage)) {
            return "Solaris";
        }
        if ((double)(linuxPercentage + windowsPercentage + solarisPercentage) <= randomOS && randomOS < 100.0) {
            return "Android";
        }
        return null;
    }

    private List<SdnSwitch> randomSdnSwitches(List<SdnSwitch> sdnSwitches) {
        ArrayList<SdnSwitch> randomSdnSwitches = new ArrayList<SdnSwitch>();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        int randomSdnSwitchesNumber = sdnSwitches.size();
        int numberOk = 0;
        while (numberOk < randomSdnSwitchesNumber) {
            int randomIndex = this.randomMinMaxNumber(0, sdnSwitches.size() - 1);
            boolean isSelected = false;
            Iterator iterator = selectedIndexes.iterator();
            while (iterator.hasNext()) {
                int selectedIndex = (Integer)iterator.next();
                if (selectedIndex != randomIndex) continue;
                isSelected = true;
                break;
            }
            if (isSelected) continue;
            selectedIndexes.add(randomIndex);
            randomSdnSwitches.add(sdnSwitches.get(randomIndex));
            ++numberOk;
        }
        return randomSdnSwitches;
    }
}

