/*
 * Decompiled with CFR 0.152.
 */
package model.components.networks;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import model.components.links.link.Link;
import model.components.nodes.node.Node;

public class NetworkGraph
extends SparseMultigraph<Node, Link>
implements UndirectedGraph<Node, Link> {
    public Graph<Node, Link> getCopy() {
        NetworkGraph networkGraph = new NetworkGraph();
        for (Link link : this.getEdges()) {
            Node secondNode;
            Pair endPoints = this.getEndpoints(link);
            Node firstNode = networkGraph.getNode(((Node)endPoints.getFirst()).getNumber());
            if (firstNode == null) {
                firstNode = ((Node)endPoints.getFirst()).getCopy();
            }
            if ((secondNode = networkGraph.getNode(((Node)endPoints.getSecond()).getNumber())) == null) {
                secondNode = ((Node)endPoints.getSecond()).getCopy();
            }
            networkGraph.addEdge(link.getCopy(), firstNode, secondNode);
        }
        return networkGraph;
    }

    private Node getNode(int identifier) {
        for (Node node : this.getVertices()) {
            if (node.getNumber() != identifier) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean addEdge(Link link, Node first, Node second) {
        return super.addEdge(link, first, second);
    }
}

