/*
 * Decompiled with CFR 0.152.
 */
package model.components.networks;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import model.components.links.comparator.LinkNumberComparator;
import model.components.links.link.Link;
import model.components.nodes.comparator.NodeNumberComparator;
import model.components.nodes.node.Node;

public class Network {
    public static final String ACCEPTED_STATE = "Accepted";
    public static final String REJECTED_STATE = "Rejected";
    public static final String AVAILABLE_STATE = "Available";
    public static final String READY_STATE = "Ready";
    private String namePrefix;
    private int number;
    private String name;
    private int timeStamp;
    private Graph<Node, Link> graph;
    private String state;
    private boolean change = false;

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.setName(String.valueOf(this.getNamePrefix()) + number);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(int timeStamp) {
        this.timeStamp = timeStamp;
        for (Node node : this.getNodes()) {
            node.setTimeStamp(timeStamp);
        }
        for (Link link : this.getLinks()) {
            link.setTimeStamp(timeStamp);
        }
    }

    public Graph<Node, Link> getGraph() {
        return this.graph;
    }

    public void setGraph(Graph<Node, Link> graph) {
        this.graph = graph;
        this.setEndPoints();
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isChange() {
        return this.change;
    }

    public void setChange(boolean change) {
        this.change = change;
    }

    public Network(String namePrefix, int number, Graph<Node, Link> graph) {
        this.setNamePrefix(namePrefix);
        this.setNumber(number);
        this.setGraph(graph);
        this.setState(AVAILABLE_STATE);
        this.setTimeStamp(-1);
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : this.getGraph().getVertices()) {
            nodes.add(node);
        }
        Collections.sort(nodes, new NodeNumberComparator());
        return nodes;
    }

    public List<Link> getLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link link : this.getGraph().getEdges()) {
            links.add(link);
        }
        Collections.sort(links, new LinkNumberComparator());
        return links;
    }

    public void addLinkAndNodes(Link link, Node firstNode, Node secondNode) {
        this.getGraph().addEdge(link, firstNode, secondNode);
        this.getGraph().addVertex(firstNode);
        this.getGraph().addVertex(secondNode);
        this.setEndPoints();
    }

    private void setEndPoints() {
        for (Link link : this.getGraph().getEdges()) {
            link.setFirstNode(this.getGraph().getEndpoints(link).getFirst());
            link.setSecondNode(this.getGraph().getEndpoints(link).getSecond());
        }
    }
}

