/*
 * Decompiled with CFR 0.152.
 */
package model.components.links.link;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import model.components.links.link.BWbackupFlag;
import model.components.links.link.Link;
import model.components.links.link.SdnLink;

public class VirtualLink
extends Link {
    private int startingDate;
    private int endingDate;
    private int lifeTime;
    private LinkedHashMap<SdnLink, BWbackupFlag> sdnLinksBWbackupFlags;
    private int bwPrice;

    public int getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(int startingDate) {
        this.startingDate = startingDate;
    }

    public int getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(int endingDate) {
        this.endingDate = endingDate;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public LinkedHashMap<SdnLink, BWbackupFlag> getSdnLinksBWbackupFlags() {
        return this.sdnLinksBWbackupFlags;
    }

    public void setSdnLinksBWbackupFlags(LinkedHashMap<SdnLink, BWbackupFlag> sdnLinksBWbackupFlags) {
        this.sdnLinksBWbackupFlags = sdnLinksBWbackupFlags;
    }

    public int getBWprice() {
        return this.bwPrice;
    }

    public void setBWprice(int bwPrice) {
        this.bwPrice = bwPrice;
    }

    public VirtualLink(String networkName, int startingDate, int endingDate, int number, int bw) {
        super(networkName, VirtualLink.class.getSimpleName(), number, bw, "/icons/virtualLink.png");
        this.setStartingDate(startingDate);
        this.setEndingDate(endingDate);
        this.setLifeTime(endingDate - startingDate);
        this.setSdnLinksBWbackupFlags(new LinkedHashMap<SdnLink, BWbackupFlag>());
    }

    @Override
    public VirtualLink getCopy() {
        VirtualLink virtualLink = new VirtualLink(this.getNetworkName(), this.getStartingDate(), this.getEndingDate(), this.getNumber(), this.getBW());
        virtualLink.setNamePrefix(this.getNamePrefix());
        virtualLink.setName(this.getName());
        virtualLink.setFirstNode(this.getFirstNode().getCopy());
        virtualLink.setSecondNode(this.getSecondNode().getCopy());
        virtualLink.setTimeStamp(this.getTimeStamp());
        virtualLink.setSelected(this.isSelected());
        virtualLink.setBWprice(this.getBWprice());
        virtualLink.setSdnLinksBWbackupFlags(new LinkedHashMap<SdnLink, BWbackupFlag>());
        for (Map.Entry<SdnLink, BWbackupFlag> entry : this.getSdnLinksBWbackupFlags().entrySet()) {
            virtualLink.getSdnLinksBWbackupFlags().put(entry.getKey().getSoftCopy(), entry.getValue().getCopy());
        }
        return virtualLink;
    }

    public void put(SdnLink sdnLink, int bw, int backupFlag) {
        this.getSdnLinksBWbackupFlags().put(sdnLink, new BWbackupFlag(bw, backupFlag));
    }

    public void remove(SdnLink removeSdnLink) {
        Iterator<Map.Entry<SdnLink, BWbackupFlag>> sdnLinksBWbackupFlagsIterator = this.getSdnLinksBWbackupFlags().entrySet().iterator();
        SdnLink sdnLink = null;
        while (sdnLinksBWbackupFlagsIterator.hasNext()) {
            sdnLink = sdnLinksBWbackupFlagsIterator.next().getKey();
            if (removeSdnLink.equals(sdnLink)) break;
        }
        this.getSdnLinksBWbackupFlags().remove(sdnLink);
    }
}

