/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.splitting;

import java.util.ArrayList;
import java.util.List;
import model.components.links.link.VirtualLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class SplittingAlgorithm {
    private String name;
    private VirtualNetwork virtualNetwork;
    private List<SdnNetwork> sdnNetworks;
    private int[][] matchingNodesNumber;
    private boolean[][] matchingNodes;
    private double[][] nodesMappingCost;
    private double[][][][] linksMappingCost;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public void setVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
    }

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public int[][] getMatchingNodesNumber() {
        return this.matchingNodesNumber;
    }

    public void setMatchingNodesNumber(int[][] matchingNodesNumber) {
        this.matchingNodesNumber = matchingNodesNumber;
    }

    private int[][] matchingNodesNumber() {
        int[][] attributesMatchingNumber = new int[this.getSdnNetworks().size()][this.getVirtualNetwork().getNodes().size()];
        int i = 0;
        for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
            for (VirtualNode virtualNode : this.getVirtualNetwork().getVirtualNodes()) {
                for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
                    if (sdnNode.getAvailableVirtualNodesNumber() <= 0 || !virtualNode.getType().equals(sdnNode.getType()) || !virtualNode.getOS().equals(sdnNode.getOS()) || virtualNode.getCPU() >= sdnNode.getAvailableCPU() || virtualNode.getRAM() >= sdnNode.getAvailableRAM()) continue;
                    if (virtualNode.getType().equals("Router") || virtualNode.getType().equals("Switch")) {
                        int[] nArray = attributesMatchingNumber[i];
                        int n = virtualNode.getNumber();
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    if (!virtualNode.getType().equals("Server") || virtualNode.getStorage() >= sdnNode.getAvailableStorage()) continue;
                    int[] nArray = attributesMatchingNumber[i];
                    int n = virtualNode.getNumber();
                    nArray[n] = nArray[n] + 1;
                }
            }
            ++i;
        }
        return attributesMatchingNumber;
    }

    public boolean[][] getMatchingNodes() {
        return this.matchingNodes;
    }

    public void setMatchingNodes(boolean[][] matchingNodes) {
        this.matchingNodes = matchingNodes;
    }

    private boolean[][] matchingNodes() {
        boolean[][] matchingNodes = new boolean[this.getSdnNetworks().size()][this.getVirtualNetwork().getNodes().size()];
        int i = 0;
        for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
            block1: for (VirtualNode virtualNode : this.getVirtualNetwork().getVirtualNodes()) {
                for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
                    if (sdnNode.getAvailableVirtualNodesNumber() <= 0 || !virtualNode.getType().equals(sdnNode.getType()) || !virtualNode.getOS().equals(sdnNode.getOS()) || virtualNode.getCPU() >= sdnNode.getAvailableCPU() || virtualNode.getRAM() >= sdnNode.getAvailableRAM()) continue;
                    if (virtualNode.getType().equals("Router") || virtualNode.getType().equals("Switch")) {
                        matchingNodes[i][virtualNode.getNumber()] = true;
                        continue block1;
                    }
                    if (!virtualNode.getType().equals("Server") || virtualNode.getStorage() >= sdnNode.getAvailableStorage()) continue;
                    matchingNodes[i][virtualNode.getNumber()] = true;
                    continue block1;
                }
            }
            ++i;
        }
        return matchingNodes;
    }

    public double[][] getNodesMappingCost() {
        return this.nodesMappingCost;
    }

    public void setNodesMappingCost(double[][] nodesMappingCost) {
        this.nodesMappingCost = nodesMappingCost;
    }

    private double[][] nodesMappingCost() {
        boolean[][] matchingNodes = this.getMatchingNodes();
        double[][] nodesMappingCost = new double[this.getSdnNetworks().size()][this.getVirtualNetwork().getNodes().size()];
        int i = 0;
        while (i < this.getSdnNetworks().size()) {
            SdnNetwork sdnNetwork = this.getSdnNetworks().get(i);
            for (VirtualNode virtualNode : this.getVirtualNetwork().getVirtualNodes()) {
                if (matchingNodes[i][virtualNode.getNumber()]) {
                    nodesMappingCost[i][virtualNode.getNumber()] = virtualNode.getCPU() * sdnNetwork.getCPUprice() + virtualNode.getRAM() * sdnNetwork.getRAMprice();
                    if (!virtualNode.getType().equals("Server")) continue;
                    double[] dArray = nodesMappingCost[i];
                    int n = virtualNode.getNumber();
                    dArray[n] = dArray[n] + (double)(virtualNode.getStorage() * sdnNetwork.getStoragePrice());
                    continue;
                }
                nodesMappingCost[i][virtualNode.getNumber()] = Double.MAX_VALUE;
            }
            ++i;
        }
        return nodesMappingCost;
    }

    public double[][][][] getLinksMappingCost() {
        return this.linksMappingCost;
    }

    public void setLinksMappingCost(double[][][][] linksMappingCost) {
        this.linksMappingCost = linksMappingCost;
    }

    private double[][][][] linksMappingCost() {
        int sdnNetworksNumber = this.getSdnNetworks().size();
        int virtualNodesNumber = this.getVirtualNetwork().getNodes().size();
        double[][][][] linksMappingCost = new double[sdnNetworksNumber][sdnNetworksNumber][virtualNodesNumber][virtualNodesNumber];
        int i = 0;
        while (i < sdnNetworksNumber) {
            int j = 0;
            while (j < sdnNetworksNumber) {
                for (VirtualLink virtualLink : this.getVirtualNetwork().getVirtualLinks()) {
                    int k = virtualLink.getFirstNode().getNumber();
                    int l = virtualLink.getSecondNode().getNumber();
                    if (virtualLink.getBW() != 0) {
                        if (i == j) {
                            linksMappingCost[i][j][k][l] = virtualLink.getBW() * this.getSdnNetworks().get(i).getBWprice();
                            linksMappingCost[i][j][l][k] = virtualLink.getBW() * this.getSdnNetworks().get(i).getBWprice();
                            continue;
                        }
                        linksMappingCost[i][j][k][l] = virtualLink.getBW() * 3 * this.maxBWprice();
                        linksMappingCost[i][j][l][k] = virtualLink.getBW() * 3 * this.maxBWprice();
                        continue;
                    }
                    linksMappingCost[i][j][k][l] = 2.147483647E9;
                }
                ++j;
            }
            ++i;
        }
        return linksMappingCost;
    }

    private int maxBWprice() {
        int maxBWprice = 0;
        for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
            if (sdnNetwork.getBWprice() <= maxBWprice) continue;
            maxBWprice = sdnNetwork.getBWprice();
        }
        return maxBWprice;
    }

    public SplittingAlgorithm(String name) {
        this.setName(name);
    }

    public List<VirtualNetwork> run(VirtualNetwork virtualNetwork) {
        this.setVirtualNetwork(virtualNetwork);
        this.setMatchingNodesNumber(this.matchingNodesNumber());
        this.setMatchingNodes(this.matchingNodes());
        this.setNodesMappingCost(this.nodesMappingCost());
        this.setLinksMappingCost(this.linksMappingCost());
        int[] bestNodesMapping = this.bestNodesMapping();
        double coste = this.networkMappingCost(bestNodesMapping);
        System.out.println(coste);
        if (coste < 2000000.0 && (bestNodesMapping = this.nodesMappingCheck(bestNodesMapping)) != null) {
            return this.virtualSubnetworks(bestNodesMapping);
        }
        return null;
    }

    protected int[] bestNodesMapping() {
        return null;
    }

    protected int[] nodesMapping(int[] nodesMapping, int trials) {
        VirtualNetwork virtualNetwork = this.getVirtualNetwork();
        double[][][][] linksMappingCost = this.getLinksMappingCost();
        double[][] nodesMappingCost = this.getNodesMappingCost();
        double[][] bandwidths = virtualNetwork.getBandwidths();
        int virtualNodesNumber = virtualNetwork.getNodes().size();
        int sdnNetworksNumber = this.getSdnNetworks().size();
        int h = 0;
        while (h < trials) {
            int virtualNodeNumber = (int)(Math.random() * (double)virtualNodesNumber);
            int sdnNetworkNumber = (int)(Math.random() * (double)sdnNetworksNumber);
            double networkMappingCost = 0.0;
            int i = 0;
            while (i < virtualNodesNumber) {
                networkMappingCost = i == virtualNodeNumber ? (networkMappingCost += nodesMappingCost[sdnNetworkNumber][i]) : (networkMappingCost += nodesMappingCost[nodesMapping[i]][i]);
                ++i;
            }
            i = 0;
            while (i < virtualNodesNumber) {
                int j = i;
                while (j < virtualNodesNumber) {
                    if (bandwidths[i][j] != 0.0) {
                        if (i == virtualNodeNumber) {
                            networkMappingCost += linksMappingCost[sdnNetworkNumber][nodesMapping[j]][i][j];
                        } else if (j == virtualNodeNumber) {
                            networkMappingCost += linksMappingCost[nodesMapping[i]][sdnNetworkNumber][i][j];
                        } else if (i != virtualNodeNumber && j != virtualNodeNumber) {
                            networkMappingCost += linksMappingCost[nodesMapping[i]][nodesMapping[j]][i][j];
                        }
                    }
                    ++j;
                }
                ++i;
            }
            double currentNetworkMappingCost = this.networkMappingCost(nodesMapping);
            if (networkMappingCost < currentNetworkMappingCost) {
                nodesMapping[virtualNodeNumber] = sdnNetworkNumber;
            }
            ++h;
        }
        return nodesMapping;
    }

    protected double networkMappingCost(int[] nodesMapping) {
        int virtualNodesNumber = this.getVirtualNetwork().getNodes().size();
        double[][] virtualNetworkBandwidths = this.getVirtualNetwork().getBandwidths();
        double[][] nodesMappingCost = this.getNodesMappingCost();
        double[][][][] linksMappingCost = this.getLinksMappingCost();
        double networkMappingCost = 0.0;
        int i = 0;
        while (i < virtualNodesNumber) {
            networkMappingCost += nodesMappingCost[nodesMapping[i]][i];
            ++i;
        }
        i = 0;
        while (i < virtualNodesNumber) {
            int j = i;
            while (j < virtualNodesNumber) {
                if (virtualNetworkBandwidths[i][j] != 0.0) {
                    networkMappingCost += linksMappingCost[nodesMapping[i]][nodesMapping[j]][i][j];
                }
                ++j;
            }
            ++i;
        }
        return networkMappingCost;
    }

    private int[] nodesMappingCheck(int[] nodesMapping) {
        double[][] nodesMappingCost = this.getNodesMappingCost();
        boolean nodesMappingCheck = false;
        int[][] attributesMatchingNumber = this.getMatchingNodesNumber();
        List<List<Integer>> sameRequestNodes = this.sameVirtualNodes();
        while (!nodesMappingCheck) {
            double networkMappingCost;
            nodesMappingCheck = true;
            int i = 0;
            while (i < this.getVirtualNetwork().getNodes().size()) {
                int j = 0;
                while (j < this.getSdnNetworks().size()) {
                    int counter = 0;
                    int k = 0;
                    while (k < sameRequestNodes.get(i).size()) {
                        if (nodesMapping[sameRequestNodes.get(i).get(k)] == j) {
                            ++counter;
                        }
                        if (counter > attributesMatchingNumber[j][i]) {
                            nodesMappingCost[j][sameRequestNodes.get((int)i).get((int)k).intValue()] = 2.147483647E9;
                            nodesMappingCheck = false;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.setNodesMappingCost(nodesMappingCost);
            if (!nodesMappingCheck) {
                nodesMapping = this.bestNodesMapping();
            }
            if (!((networkMappingCost = this.networkMappingCost(nodesMapping)) > 200000.0)) continue;
            nodesMappingCheck = true;
            nodesMapping = null;
        }
        return nodesMapping;
    }

    private List<List<Integer>> sameVirtualNodes() {
        VirtualNetwork virtualNetwork = this.getVirtualNetwork();
        ArrayList<List<Integer>> sameVirtualNodes = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < virtualNetwork.getNodes().size()) {
            sameVirtualNodes.add(new ArrayList());
            ++i;
        }
        for (VirtualNode virtualNodeA : virtualNetwork.getVirtualNodes()) {
            for (VirtualNode virtualNodeB : virtualNetwork.getVirtualNodes()) {
                if (!virtualNodeA.getType().equals(virtualNodeB.getType()) || !virtualNodeA.getOS().equals(virtualNodeB.getOS())) continue;
                ((List)sameVirtualNodes.get(virtualNodeA.getNumber())).add(virtualNodeB.getNumber());
            }
        }
        return sameVirtualNodes;
    }

    private List<VirtualNetwork> virtualSubnetworks(int[] nodesMapping) {
        VirtualNetwork virtualNetwork = this.getVirtualNetwork();
        List<SdnNetwork> physicalNetworks = this.getSdnNetworks();
        int virtualNodesNumber = virtualNetwork.getNodes().size();
        ArrayList<VirtualNetwork> virtualSubnetworks = new ArrayList<VirtualNetwork>();
        String[] virtualSubnetworksNames = new String[virtualNodesNumber];
        String physicalNetworksNamePrefix = physicalNetworks.get(0).getNamePrefix();
        int i = 0;
        while (i < virtualNodesNumber) {
            virtualSubnetworksNames[i] = String.valueOf(physicalNetworksNamePrefix) + nodesMapping[i];
            ++i;
        }
        i = 0;
        for (SdnNetwork physicalNetwork : physicalNetworks) {
            VirtualNetwork virtualSubnetwork = new VirtualNetwork(String.valueOf(virtualNetwork.getName()) + "part", i++, virtualNetwork.getStartingDate(), virtualNetwork.getEndingDate());
            for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
                if (!virtualSubnetworksNames[virtualNode.getNumber()].contains(physicalNetwork.getName())) continue;
                virtualSubnetwork.getGraph().addVertex(virtualNode);
                virtualSubnetwork.setSdnNetworkName(physicalNetwork.getName());
            }
            virtualSubnetworks.add(virtualSubnetwork);
        }
        for (VirtualNetwork virtualSubnetwork : virtualSubnetworks) {
            for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                int checkingLink = 0;
                for (VirtualNode virtualNode : virtualSubnetwork.getVirtualNodes()) {
                    if (virtualNode.getNumber() == virtualLink.getFirstNode().getNumber()) {
                        ++checkingLink;
                    }
                    if (virtualNode.getNumber() != virtualLink.getSecondNode().getNumber()) continue;
                    ++checkingLink;
                }
                if (checkingLink != 2) continue;
                virtualSubnetwork.addLinkAndNodes(virtualLink, virtualLink.getFirstNode(), virtualLink.getSecondNode());
            }
        }
        for (VirtualNetwork virtualSubnetwork : virtualSubnetworks) {
            this.setNumberVirtualNetwork(virtualSubnetwork);
        }
        return virtualSubnetworks;
    }

    private void setNumberVirtualNetwork(VirtualNetwork virtualNetwork) {
        int i = 0;
        for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
            virtualNode.setNumber(i++);
        }
        i = 0;
        for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
            virtualLink.setNumber(i++);
        }
    }
}

