/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.splitting;

import model.algorithms.splitting.SplittingAlgorithm;
import model.components.networks.virtual.VirtualNetwork;

public class IteratedLocalSearch2
extends SplittingAlgorithm {
    public IteratedLocalSearch2(String name) {
        super(name);
    }

    @Override
    protected int[] bestNodesMapping() {
        VirtualNetwork requestNetwork = this.getVirtualNetwork();
        double[][] nodesMappingCost = this.getNodesMappingCost();
        int requestNodesNumber = requestNetwork.getNodes().size();
        int substrateNetworksNumber = this.getSdnNetworks().size();
        int[] nodesMapping = new int[requestNodesNumber];
        int j = 0;
        while (j < requestNodesNumber) {
            double minNodesMappingCost = 2.147483647E9;
            int i = 0;
            while (i < substrateNetworksNumber) {
                if (nodesMappingCost[i][j] < minNodesMappingCost) {
                    minNodesMappingCost = nodesMappingCost[i][j];
                    nodesMapping[j] = i;
                }
                ++i;
            }
            ++j;
        }
        int trialsNumber = 10 * substrateNetworksNumber * requestNodesNumber;
        nodesMapping = this.nodesMapping(nodesMapping, trialsNumber);
        int maxExperimentsNumber = 5;
        int[] bestNodesMapping = new int[requestNodesNumber];
        double bestNetworkMappingCost = 2.147483647E9;
        int g = 0;
        while (g < maxExperimentsNumber) {
            int perturbation_strength = (int)Math.round(0.7 * (double)requestNodesNumber);
            int i = 0;
            while (i < perturbation_strength) {
                nodesMapping[i] = (int)(Math.random() * (double)substrateNetworksNumber);
                ++i;
            }
            double networkMappingCost = this.networkMappingCost(nodesMapping = this.nodesMapping(nodesMapping, trialsNumber));
            if (networkMappingCost < bestNetworkMappingCost) {
                bestNetworkMappingCost = networkMappingCost;
                bestNodesMapping = (int[])nodesMapping.clone();
            }
            ++g;
        }
        return bestNodesMapping;
    }
}

