/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.splitting;

import model.algorithms.splitting.SplittingAlgorithm;
import model.components.networks.virtual.VirtualNetwork;

public class IteratedLocalSearch
extends SplittingAlgorithm {
    public IteratedLocalSearch(String name) {
        super(name);
    }

    @Override
    protected int[] bestNodesMapping() {
        VirtualNetwork virtualNetwork = this.getVirtualNetwork();
        int virtualNodesNumber = virtualNetwork.getNodes().size();
        int physicalNodesNumber = this.getSdnNetworks().size();
        int[] nodesMapping = new int[virtualNodesNumber];
        int i = 0;
        while (i < virtualNodesNumber) {
            nodesMapping[i] = (int)(Math.random() * (double)physicalNodesNumber);
            ++i;
        }
        int trialsNumber = 10 * physicalNodesNumber * virtualNodesNumber;
        nodesMapping = this.nodesMapping(nodesMapping, trialsNumber);
        int maxExperimentsNumber = 5;
        double currentNetworkMappingCost = 2.147483647E9;
        int[] bestNodesMapping = new int[virtualNodesNumber];
        int g = 0;
        while (g < maxExperimentsNumber) {
            int perturbation = (int)Math.round(0.8 * (double)virtualNodesNumber);
            int i2 = 0;
            while (i2 < perturbation) {
                nodesMapping[i2] = (int)(Math.random() * (double)physicalNodesNumber);
                ++i2;
            }
            double networkMappingCost = this.networkMappingCost(nodesMapping = this.nodesMapping(nodesMapping, trialsNumber));
            if (networkMappingCost < currentNetworkMappingCost) {
                currentNetworkMappingCost = networkMappingCost;
                bestNodesMapping = (int[])nodesMapping.clone();
            }
            ++g;
        }
        return bestNodesMapping;
    }
}

