/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.splitting;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.cplex.IloCplex;
import model.algorithms.splitting.SplittingAlgorithm;
import model.components.networks.virtual.VirtualNetwork;

public class Exact
extends SplittingAlgorithm {
    public Exact(String name) {
        super(name);
    }

    @Override
    protected int[] bestNodesMapping() {
        int[] bestNodesMapping;
        block37: {
            VirtualNetwork virtualNetwork = this.getVirtualNetwork();
            double[][][][] linksMappingCost = this.getLinksMappingCost();
            double[][] nodesMappingCost = this.getNodesMappingCost();
            int virtualNodesNumber = virtualNetwork.getNodes().size();
            int physicalNetworksNumber = this.getSdnNetworks().size();
            bestNodesMapping = new int[virtualNodesNumber];
            try {
                int i;
                int k;
                int l;
                int k2;
                int j;
                IloCplex cplex = new IloCplex();
                cplex.setOut(null);
                cplex.setParam(IloCplex.DoubleParam.CutsFactor, 1.0);
                cplex.setParam(IloCplex.IntParam.PreDual, 1);
                cplex.setParam(IloCplex.IntParam.PPriInd, 4);
                cplex.setParam(IloCplex.IntParam.Probe, -1);
                cplex.setParam(IloCplex.IntParam.MCFCuts, -1);
                IloNumVar[][] x = new IloNumVar[physicalNetworksNumber][];
                int i2 = 0;
                while (i2 < physicalNetworksNumber) {
                    x[i2] = cplex.numVarArray(virtualNodesNumber, 0.0, 1.0, IloNumVarType.Int);
                    ++i2;
                }
                IloNumVar[][][][] y = new IloNumVar[physicalNetworksNumber][][][];
                int i3 = 0;
                while (i3 < physicalNetworksNumber) {
                    y[i3] = new IloNumVar[physicalNetworksNumber][][];
                    int j2 = 0;
                    while (j2 < physicalNetworksNumber) {
                        y[i3][j2] = new IloNumVar[virtualNodesNumber][];
                        int k3 = 0;
                        while (k3 < virtualNodesNumber) {
                            y[i3][j2][k3] = cplex.numVarArray(virtualNodesNumber, 0.0, 1.0, IloNumVarType.Int);
                            ++k3;
                        }
                        ++j2;
                    }
                    ++i3;
                }
                IloLinearNumExpr nodes = cplex.linearNumExpr();
                int i4 = 0;
                while (i4 < physicalNetworksNumber) {
                    int j3 = 0;
                    while (j3 < virtualNodesNumber) {
                        nodes.addTerm(nodesMappingCost[i4][j3], x[i4][j3]);
                        ++j3;
                    }
                    ++i4;
                }
                IloLinearNumExpr links = cplex.linearNumExpr();
                int i5 = 0;
                while (i5 < physicalNetworksNumber) {
                    j = 0;
                    while (j < physicalNetworksNumber) {
                        k2 = 0;
                        while (k2 < virtualNodesNumber) {
                            l = k2 + 1;
                            while (l < virtualNodesNumber) {
                                links.addTerm(linksMappingCost[i5][j][k2][l], y[i5][j][k2][l]);
                                ++l;
                            }
                            ++k2;
                        }
                        ++j;
                    }
                    ++i5;
                }
                IloNumExpr expr = cplex.sum((IloNumExpr)nodes, (IloNumExpr)links);
                cplex.addMinimize(expr);
                int i6 = 0;
                while (i6 < physicalNetworksNumber) {
                    k2 = 0;
                    while (k2 < virtualNodesNumber) {
                        l = 0;
                        while (l < virtualNodesNumber) {
                            IloLinearNumExpr sum1 = cplex.linearNumExpr();
                            int j4 = 0;
                            while (j4 < physicalNetworksNumber) {
                                sum1.addTerm(y[i6][j4][k2][l], 1.0);
                                ++j4;
                            }
                            cplex.addEq((IloNumExpr)sum1, (IloNumExpr)x[i6][k2]);
                            ++l;
                        }
                        ++k2;
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < physicalNetworksNumber) {
                    int j5 = 0;
                    while (j5 < physicalNetworksNumber) {
                        k = 0;
                        while (k < virtualNodesNumber) {
                            int l2 = 0;
                            while (l2 < virtualNodesNumber) {
                                IloNumExpr sum2 = null;
                                sum2 = cplex.sum((IloNumExpr)x[i6][k], (IloNumExpr)x[j5][l2]);
                                sum2 = cplex.sum(sum2, cplex.prod((IloNumExpr)y[i6][j5][k][l2], -1.0));
                                cplex.addLe(sum2, 1.0);
                                ++l2;
                            }
                            ++k;
                        }
                        ++j5;
                    }
                    ++i6;
                }
                j = 0;
                while (j < virtualNodesNumber) {
                    IloLinearNumExpr sum3 = cplex.linearNumExpr();
                    i = 0;
                    while (i < physicalNetworksNumber) {
                        sum3.addTerm(x[i][j], 1.0);
                        ++i;
                    }
                    cplex.addEq((IloNumExpr)sum3, 1.0);
                    ++j;
                }
                i6 = 0;
                while (i6 < physicalNetworksNumber) {
                    int j6 = 0;
                    while (j6 < physicalNetworksNumber) {
                        k = 0;
                        while (k < virtualNodesNumber) {
                            int l3 = 0;
                            while (l3 < virtualNodesNumber) {
                                cplex.addEq((IloNumExpr)y[i6][j6][k][l3], (IloNumExpr)y[j6][i6][l3][k]);
                                ++l3;
                            }
                            ++k;
                        }
                        ++j6;
                    }
                    ++i6;
                }
                if (!cplex.solve()) {
                    System.out.println("denial");
                    cplex.end();
                    break block37;
                }
                double[][] xVar = new double[physicalNetworksNumber][virtualNodesNumber];
                int i7 = 0;
                while (i7 < physicalNetworksNumber) {
                    xVar[i7] = cplex.getValues(x[i7]);
                    ++i7;
                }
                double[][][][] yVar = new double[physicalNetworksNumber][physicalNetworksNumber][virtualNodesNumber][virtualNodesNumber];
                i = 0;
                while (i < physicalNetworksNumber) {
                    int j7 = 0;
                    while (j7 < physicalNetworksNumber) {
                        int k4 = 0;
                        while (k4 < virtualNodesNumber) {
                            int l4 = 0;
                            while (l4 < virtualNodesNumber) {
                                try {
                                    yVar[i][j7][k4][l4] = cplex.getValue(y[i][j7][k4][l4]);
                                }
                                catch (IloException e) {
                                    System.out.println("error");
                                }
                                ++l4;
                            }
                            ++k4;
                        }
                        ++j7;
                    }
                    ++i;
                }
                i = 0;
                while (i < physicalNetworksNumber) {
                    int j8 = 0;
                    while (j8 < virtualNodesNumber) {
                        if (xVar[i][j8] != 0.0) {
                            bestNodesMapping[j8] = i;
                        }
                        ++j8;
                    }
                    ++i;
                }
                cplex.end();
            }
            catch (IloException e) {
                System.err.println("Concert exception caught: " + e);
            }
        }
        return bestNodesMapping;
    }
}

