/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.rounding;

import java.util.LinkedHashMap;
import model.algorithms.rounding.RoundingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class Randomized2
extends RoundingAlgorithm {
    public Randomized2(String name) {
        super(name);
    }

    @Override
    public LinkedHashMap<VirtualNode, SdnNode> run(VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, double[][][] x, double[][][] f) {
        LinkedHashMap<VirtualNode, SdnNode> mappingNodes = new LinkedHashMap<VirtualNode, SdnNode>();
        boolean[] nodesSubSel = new boolean[physicalNetwork.getNodes().size()];
        double[] sumFlows = new double[physicalNetwork.getNodes().size()];
        boolean control = true;
        for (VirtualNode nodeRequest : virtualNetwork.getVirtualNodes()) {
            int iNodeReq = nodeRequest.getNumber();
            double sumFlowsTotal = 0.0;
            for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
                int iNodeSub = nodeSubstrate.getNumber();
                int iNodeAug = iNodeSub + virtualNetwork.getNodes().size();
                if (!nodeRequest.getType().equalsIgnoreCase(nodeSubstrate.getType()) || nodesSubSel[iNodeSub]) continue;
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    int n = iNodeSub;
                    sumFlows[n] = sumFlows[n] + x[i][iNodeReq][iNodeAug] * (f[i][iNodeReq][iNodeAug] + f[i][iNodeAug][iNodeReq]);
                    ++i;
                }
                sumFlowsTotal += sumFlows[iNodeSub];
            }
            double averageSumFlows = 0.0;
            double random = Math.random();
            SdnNode nodeSubSel = null;
            for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
                if (!nodeRequest.getType().equalsIgnoreCase(nodeSubstrate.getType()) || nodesSubSel[nodeSubstrate.getNumber()]) continue;
                int n = nodeSubstrate.getNumber();
                sumFlows[n] = sumFlows[n] / sumFlowsTotal;
                if (!((averageSumFlows += sumFlows[nodeSubstrate.getNumber()]) > random)) continue;
                nodesSubSel[nodeSubstrate.getNumber()] = true;
                nodeSubSel = nodeSubstrate;
                mappingNodes.put(nodeRequest, nodeSubSel);
                break;
            }
            if (nodeSubSel != null) continue;
            control = false;
        }
        if (!control) {
            mappingNodes = null;
        }
        return mappingNodes;
    }
}

