/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.rounding;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import model.algorithms.rounding.RoundingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class Randomized
extends RoundingAlgorithm {
    public Randomized(String name) {
        super(name);
    }

    @Override
    public LinkedHashMap<VirtualNode, SdnNode> run(VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, double[][][] x, double[][][] f) {
        LinkedHashMap<VirtualNode, SdnNode> mappingNodes = new LinkedHashMap<VirtualNode, SdnNode>();
        SdnNetwork substrateCopy = physicalNetwork.getCopy();
        LinkedHashMap<SdnNode, Integer> correspondence = new LinkedHashMap<SdnNode, Integer>();
        for (VirtualNode nodeRequest : virtualNetwork.getVirtualNodes()) {
            if (substrateCopy.getNodes().size() != 0) {
                int i;
                int iNodeReq = nodeRequest.getNumber();
                double sumFlowsTotal = 0.0;
                LinkedHashMap<SdnNode, Double> nodesSubSumFlows = new LinkedHashMap<SdnNode, Double>();
                for (SdnNode nodeSubstrate : substrateCopy.getSdnNodes()) {
                    if (!nodeRequest.getType().equalsIgnoreCase(nodeSubstrate.getType())) continue;
                    int iNodeAug = nodeSubstrate.getNumber() + virtualNetwork.getNodes().size();
                    double sumFlows = 0.0;
                    i = 0;
                    while (i < virtualNetwork.getVirtualLinks().size()) {
                        sumFlows += x[i][iNodeReq][iNodeAug] * (f[i][iNodeReq][iNodeAug] + f[i][iNodeAug][iNodeReq]);
                        ++i;
                    }
                    sumFlowsTotal += sumFlows;
                    nodesSubSumFlows.put(nodeSubstrate, sumFlows);
                }
                for (SdnNode nodeSubstrate : substrateCopy.getSdnNodes()) {
                    if (!nodesSubSumFlows.containsKey(nodeSubstrate)) continue;
                    double averageSumFlows = (Double)nodesSubSumFlows.get(nodeSubstrate) / sumFlowsTotal;
                    nodesSubSumFlows.put(nodeSubstrate, averageSumFlows);
                }
                Set nodesSub = nodesSubSumFlows.keySet();
                sumFlowsTotal = 0.0;
                ArrayList<Double> sumsFlowsTotal = new ArrayList<Double>();
                for (SdnNode nodeSubstrate : nodesSub) {
                    sumsFlowsTotal.add(sumFlowsTotal += ((Double)nodesSubSumFlows.get(nodeSubstrate)).doubleValue());
                    correspondence.put(nodeSubstrate, sumsFlowsTotal.size() - 1);
                }
                double random = Math.random() * sumFlowsTotal;
                int iNodeSubSel = -1;
                i = 0;
                while (i < sumsFlowsTotal.size()) {
                    if ((Double)sumsFlowsTotal.get(i) > random) {
                        iNodeSubSel = i;
                        break;
                    }
                    ++i;
                }
                SdnNode nodeSubSel = null;
                for (SdnNode nodeSubstrate : nodesSub) {
                    if (Integer.valueOf(iNodeSubSel).compareTo((Integer)correspondence.get(nodeSubstrate)) != 0) continue;
                    nodeSubSel = nodeSubstrate;
                    break;
                }
                mappingNodes.put(nodeRequest, nodeSubSel);
                substrateCopy.getNodes().remove(nodeSubSel);
                continue;
            }
            mappingNodes = null;
        }
        return mappingNodes;
    }
}

