/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.rounding;

import java.util.LinkedHashMap;
import model.algorithms.rounding.RoundingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class Deterministic2
extends RoundingAlgorithm {
    public Deterministic2(String name) {
        super(name);
    }

    @Override
    public LinkedHashMap<VirtualNode, SdnNode> run(VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, double[][][] x, double[][][] f) {
        LinkedHashMap<VirtualNode, SdnNode> mappingNodes = new LinkedHashMap<VirtualNode, SdnNode>();
        double[] nodesSubSel = new double[physicalNetwork.getNodes().size()];
        double[] sumFlows = new double[physicalNetwork.getNodes().size()];
        boolean control = true;
        for (VirtualNode nodeRequest : virtualNetwork.getVirtualNodes()) {
            int iNodeReq = nodeRequest.getNumber();
            double sumFlowsMax = -1.0;
            int iNodeSubMax = 0;
            SdnNode nodeSubSel = null;
            for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
                if (!nodeRequest.getType().equalsIgnoreCase(nodeSubstrate.getType())) continue;
                int iNodeSub = nodeSubstrate.getNumber();
                int iNodeAug = nodeSubstrate.getNumber() + virtualNetwork.getNodes().size();
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    int n = iNodeSub;
                    sumFlows[n] = sumFlows[n] + x[i][iNodeReq][iNodeAug] * (f[i][iNodeReq][iNodeAug] + f[i][iNodeAug][iNodeReq]);
                    ++i;
                }
                if (!(sumFlows[iNodeSub] > sumFlowsMax) || nodesSubSel[iNodeSub] != 0.0) continue;
                sumFlowsMax = sumFlows[iNodeSub];
                iNodeSubMax = iNodeSub;
                nodeSubSel = nodeSubstrate;
            }
            if (sumFlowsMax != 0.0) {
                nodesSubSel[iNodeSubMax] = 1.0;
                mappingNodes.put(nodeRequest, nodeSubSel);
                continue;
            }
            control = false;
        }
        if (!control) {
            mappingNodes = null;
        }
        return mappingNodes;
    }
}

