/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.nodesMapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import model.algorithms.nodesMapping.NodesMappingAlgorithm;
import model.components.networks.Network;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.comparator.AvailableVirtualNodesNumberComparator;
import model.components.nodes.comparator.NodeNumberComparator;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.sdn.SdnRouter;
import model.components.nodes.node.sdn.SdnServer;
import model.components.nodes.node.sdn.SdnSwitch;
import model.components.nodes.node.virtual.VirtualNode;

public class Greedy
extends NodesMappingAlgorithm {
    public Greedy(String name) {
        super(name);
    }

    @Override
    public LinkedHashMap<VirtualNode, SdnNode> run(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork) {
        LinkedHashMap<VirtualNode, SdnNode> nodesMapping = new LinkedHashMap<VirtualNode, SdnNode>();
        SdnNetwork copySdnNetwork = sdnNetwork.getCopy();
        double[] sdnNetworkAvailability = this.physicalNetworkAvailability(copySdnNetwork);
        double[][] virtualNodesCapacities = virtualNetwork.getNodesCapacities();
        double[][] sdnNodesAvailableCapacities = copySdnNetwork.getSdnNodesAvailableCapacities();
        String[][] virtualNodesAttributes = this.getNodesAttributes(virtualNetwork);
        String[][] physicalNodesAttributes = this.getNodesAttributes(copySdnNetwork);
        for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
            double max = 0.0;
            SdnNode selectedPhysicalNode = null;
            List<SdnNode> physicalNodes = null;
            if (virtualNode.getType().equals("Router")) {
                physicalNodes = this.getRoutersSubstrateAvailability(copySdnNetwork);
            } else if (virtualNode.getType().equals("Switch")) {
                physicalNodes = this.getSwitchesSubstrateAvailability(copySdnNetwork);
            } else if (virtualNode.getType().equals("Server")) {
                physicalNodes = this.getServersSubstrateAvailability(copySdnNetwork);
            }
            for (SdnNode PhysicalNode : physicalNodes) {
                int checkCapacities = 0;
                int checkAttributes = 0;
                int i = 0;
                while (i < 3) {
                    if (sdnNodesAvailableCapacities[i][PhysicalNode.getNumber()] >= virtualNodesCapacities[i][virtualNode.getNumber()]) {
                        ++checkCapacities;
                    }
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    if (physicalNodesAttributes[PhysicalNode.getNumber()][i].equals(virtualNodesAttributes[virtualNode.getNumber()][i])) {
                        ++checkAttributes;
                    }
                    ++i;
                }
                if (checkCapacities != 3 || checkAttributes != 2 || !(sdnNetworkAvailability[PhysicalNode.getNumber()] > max)) continue;
                max = sdnNetworkAvailability[PhysicalNode.getNumber()];
                selectedPhysicalNode = PhysicalNode;
            }
            if (selectedPhysicalNode == null) break;
            nodesMapping.put(virtualNode, selectedPhysicalNode);
            copySdnNetwork.getGraph().removeVertex(selectedPhysicalNode);
        }
        if (nodesMapping.size() != virtualNetwork.getNodes().size()) {
            nodesMapping = null;
        }
        return nodesMapping;
    }

    public List<SdnNode> getRoutersSubstrateAvailability(SdnNetwork physicalNetwork) {
        ArrayList<SdnNode> routersSubstrateAvailability = new ArrayList<SdnNode>();
        for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
            if (!(nodeSubstrate instanceof SdnRouter)) continue;
            routersSubstrateAvailability.add(nodeSubstrate);
        }
        Collections.sort(routersSubstrateAvailability, new NodeNumberComparator());
        Collections.sort(routersSubstrateAvailability, new AvailableVirtualNodesNumberComparator());
        return routersSubstrateAvailability;
    }

    public List<SdnNode> getSwitchesSubstrateAvailability(SdnNetwork physicalNetwork) {
        ArrayList<SdnNode> switchesSubstrateAvailability = new ArrayList<SdnNode>();
        for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
            if (!(nodeSubstrate instanceof SdnSwitch)) continue;
            switchesSubstrateAvailability.add(nodeSubstrate);
        }
        Collections.sort(switchesSubstrateAvailability, new NodeNumberComparator());
        Collections.sort(switchesSubstrateAvailability, new AvailableVirtualNodesNumberComparator());
        return switchesSubstrateAvailability;
    }

    public List<SdnNode> getServersSubstrateAvailability(SdnNetwork physicalNetwork) {
        ArrayList<SdnNode> serversSubstrateAvailability = new ArrayList<SdnNode>();
        for (SdnNode nodeSubstrate : physicalNetwork.getSdnNodes()) {
            if (!(nodeSubstrate instanceof SdnServer)) continue;
            serversSubstrateAvailability.add(nodeSubstrate);
        }
        Collections.sort(serversSubstrateAvailability, new NodeNumberComparator());
        Collections.sort(serversSubstrateAvailability, new AvailableVirtualNodesNumberComparator());
        return serversSubstrateAvailability;
    }

    public double[] physicalNetworkAvailability(SdnNetwork physicalNetwork) {
        double[] availability = new double[physicalNetwork.getSdnNodes().size()];
        int i = 0;
        while (i < physicalNetwork.getSdnNodes().size()) {
            SdnNode substrateNode = physicalNetwork.getSdnNodes().get(i);
            availability[i] = substrateNode.getAvailableCPU() + substrateNode.getAvailableRAM();
            if (substrateNode instanceof SdnServer) {
                int n = i;
                availability[n] = availability[n] + (double)substrateNode.getAvailableStorage();
            }
            ++i;
        }
        double[][] bandwidthsAvailable = physicalNetwork.getAvailableBWs();
        double[] bandwidthAdjacent = new double[physicalNetwork.getSdnNodes().size()];
        int i2 = 0;
        while (i2 < physicalNetwork.getSdnNodes().size()) {
            int j = 0;
            while (j < physicalNetwork.getSdnNodes().size()) {
                if (bandwidthsAvailable[i2][j] != 0.0) {
                    int n = i2;
                    bandwidthAdjacent[n] = bandwidthAdjacent[n] + bandwidthsAvailable[i2][j];
                }
                ++j;
            }
            int n = i2;
            availability[n] = availability[n] * bandwidthAdjacent[i2];
            ++i2;
        }
        return availability;
    }

    public String[][] getNodesAttributes(Network network) {
        String[][] nodesAttributes = new String[network.getGraph().getVertexCount()][2];
        for (Node node : network.getGraph().getVertices()) {
            nodesAttributes[node.getNumber()][0] = node.getType();
            nodesAttributes[node.getNumber()][1] = node.getOS();
        }
        return nodesAttributes;
    }
}

