/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.linksMapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import model.algorithms.linksMapping.LinksMappingAlgorithm;
import model.components.links.link.Link;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class ShortPath
extends LinksMappingAlgorithm {
    public ShortPath(String name) {
        super(name);
    }

    @Override
    protected int[][][] linksMapping(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork, LinkedHashMap<VirtualNode, SdnNode> nodesMapping, double[][] availableBWsIn) {
        int j;
        int[][][] linksMapping = new int[virtualNetwork.getLinks().size()][sdnNetwork.getNodes().size()][sdnNetwork.getNodes().size()];
        boolean isLinksMapping = true;
        List<Link> virtualLinks = virtualNetwork.getLinks();
        int sdnNodesNumber = sdnNetwork.getNodes().size();
        double[][] availableBWs = new double[sdnNodesNumber][sdnNodesNumber];
        double[][] availableBWsCostMetric = new double[sdnNodesNumber][sdnNodesNumber];
        int i = 0;
        while (i < sdnNetwork.getNodes().size()) {
            j = 0;
            while (j < sdnNetwork.getNodes().size()) {
                availableBWs[i][j] = availableBWsIn[i][j];
                availableBWsCostMetric[i][j] = availableBWsIn[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sdnNodesNumber) {
            j = 0;
            while (j < sdnNodesNumber) {
                if (availableBWsCostMetric[i][j] != 0.0) {
                    availableBWsCostMetric[i][j] = 1.0 / availableBWsCostMetric[i][j];
                }
                ++j;
            }
            ++i;
        }
        for (Link virtualLink : virtualLinks) {
            int firstSubstrateNodeNumber = 0;
            int secondSubstrateNodeNumber = 0;
            Iterator<Map.Entry<VirtualNode, SdnNode>> iterator = nodesMapping.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isFirstSubstrateNodeNumber = false;
                boolean isSecondSubstrateNodeNumber = false;
                Map.Entry<VirtualNode, SdnNode> nodeMapping = iterator.next();
                if (virtualLink.getFirstNode().getNumber() == nodeMapping.getKey().getNumber()) {
                    isFirstSubstrateNodeNumber = true;
                    firstSubstrateNodeNumber = nodeMapping.getValue().getNumber();
                }
                if (virtualLink.getSecondNode().getNumber() == nodeMapping.getKey().getNumber()) {
                    isSecondSubstrateNodeNumber = true;
                    secondSubstrateNodeNumber = nodeMapping.getValue().getNumber();
                }
                if (isFirstSubstrateNodeNumber && isSecondSubstrateNodeNumber) break;
            }
            double bandwidthCostMetric = 1 / virtualLink.getBW();
            int[] previousSubstrateNodeNumber = null;
            if (this.getCostMetric().equals("distance")) {
                previousSubstrateNodeNumber = this.shortestDistanceNodesNumbers(sdnNetwork, firstSubstrateNodeNumber, availableBWs, virtualLink.getBW());
            } else if (this.getCostMetric().equals("availableBandwidth")) {
                previousSubstrateNodeNumber = this.higherAvailableBandwidthNodesNumbers(sdnNetwork, firstSubstrateNodeNumber, availableBWsCostMetric, bandwidthCostMetric);
            }
            List<Object> shortPath = new ArrayList();
            if (previousSubstrateNodeNumber == null) {
                isLinksMapping = false;
                break;
            }
            shortPath = this.shortPath(previousSubstrateNodeNumber, firstSubstrateNodeNumber, secondSubstrateNodeNumber);
            if ((Integer)shortPath.get(shortPath.size() - 1) != secondSubstrateNodeNumber) {
                isLinksMapping = false;
                break;
            }
            int i2 = 0;
            while (i2 < shortPath.size() - 1) {
                int substrateNodeNumber = (Integer)shortPath.get(i2);
                int nextSubstrateNodeNumber = (Integer)shortPath.get(i2 + 1);
                linksMapping[virtualLink.getNumber()][substrateNodeNumber][nextSubstrateNodeNumber] = virtualLink.getBW();
                availableBWsCostMetric[substrateNodeNumber][nextSubstrateNodeNumber] = 1.0 / availableBWsCostMetric[substrateNodeNumber][nextSubstrateNodeNumber] - 1.0 / Math.abs(bandwidthCostMetric);
                availableBWsCostMetric[substrateNodeNumber][nextSubstrateNodeNumber] = 1.0 / availableBWsCostMetric[substrateNodeNumber][nextSubstrateNodeNumber];
                availableBWsCostMetric[nextSubstrateNodeNumber][substrateNodeNumber] = availableBWsCostMetric[substrateNodeNumber][nextSubstrateNodeNumber];
                double[] dArray = availableBWs[substrateNodeNumber];
                int n = nextSubstrateNodeNumber;
                dArray[n] = dArray[n] - (double)virtualLink.getBW();
                availableBWs[nextSubstrateNodeNumber][substrateNodeNumber] = availableBWs[substrateNodeNumber][nextSubstrateNodeNumber];
                ++i2;
            }
        }
        if (!isLinksMapping) {
            linksMapping = null;
        }
        return linksMapping;
    }

    private List<Integer> shortPath(int[] previousNodesNumbers, int firstNodeNumber, int secondNodeNumber) {
        ArrayList<Integer> shortPath = new ArrayList<Integer>();
        int previousSecondNodeNumber = secondNodeNumber;
        while (previousSecondNodeNumber != firstNodeNumber && previousSecondNodeNumber > -1) {
            shortPath.add(0, previousSecondNodeNumber);
            previousSecondNodeNumber = previousNodesNumbers[previousSecondNodeNumber];
        }
        shortPath.add(0, firstNodeNumber);
        return shortPath;
    }

    private int[] higherAvailableBandwidthNodesNumbers(SdnNetwork substrateNetwork, int firstNodeNumber, double[][] availableBandwidthsCostMetric, double bandwidthCostMetric) {
        int nodesNumber = substrateNetwork.getNodes().size();
        double[] shortestDistances = new double[nodesNumber];
        int i = 0;
        while (i < shortestDistances.length) {
            shortestDistances[i] = 2.147483647E9;
            ++i;
        }
        shortestDistances[firstNodeNumber] = 0.0;
        boolean[] areVisitedNodes = new boolean[nodesNumber];
        int[] shortestDistanceNodesNumbers = new int[nodesNumber];
        int i2 = 0;
        while (i2 < shortestDistances.length) {
            int shortestDistanceNodeNumber = this.shortestDistanceNodeNumber(shortestDistances, areVisitedNodes);
            if (shortestDistanceNodeNumber == -1) break;
            areVisitedNodes[shortestDistanceNodeNumber] = true;
            ArrayList<Integer> neighbourNodesNumbers = new ArrayList<Integer>();
            int j = 0;
            while (j < nodesNumber) {
                if (availableBandwidthsCostMetric[shortestDistanceNodeNumber][j] != 0.0 && availableBandwidthsCostMetric[shortestDistanceNodeNumber][j] < Math.abs(bandwidthCostMetric)) {
                    neighbourNodesNumbers.add(j);
                }
                ++j;
            }
            j = 0;
            while (j < neighbourNodesNumbers.size()) {
                int neighbourNodeNumber = (Integer)neighbourNodesNumbers.get(j);
                double shortestDistance = shortestDistances[shortestDistanceNodeNumber] + availableBandwidthsCostMetric[shortestDistanceNodeNumber][neighbourNodeNumber];
                if (shortestDistance < shortestDistances[neighbourNodeNumber]) {
                    shortestDistances[neighbourNodeNumber] = shortestDistance;
                    shortestDistanceNodesNumbers[neighbourNodeNumber] = shortestDistanceNodeNumber;
                }
                ++j;
            }
            ++i2;
        }
        return shortestDistanceNodesNumbers;
    }

    private int[] shortestDistanceNodesNumbers(SdnNetwork substrateNetwork, int firstNodeNumber, double[][] availableBandwidths, double bandwidth) {
        int nodesNumber = substrateNetwork.getNodes().size();
        double[][] distances = this.distances(substrateNetwork);
        double[] shortestDistances = new double[nodesNumber];
        int i = 0;
        while (i < shortestDistances.length) {
            shortestDistances[i] = 2.147483647E9;
            ++i;
        }
        shortestDistances[firstNodeNumber] = 0.0;
        boolean[] areVisitedNodes = new boolean[nodesNumber];
        int[] shortestDistanceNodesNumbers = new int[nodesNumber];
        int i2 = 0;
        while (i2 < nodesNumber) {
            shortestDistanceNodesNumbers[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < shortestDistances.length) {
            int shortestDistanceNodeNumber = this.shortestDistanceNodeNumber(shortestDistances, areVisitedNodes);
            if (shortestDistanceNodeNumber == -1) break;
            areVisitedNodes[shortestDistanceNodeNumber] = true;
            ArrayList<Integer> neighbourNodesNumbers = new ArrayList<Integer>();
            int j = 0;
            while (j < nodesNumber) {
                if (availableBandwidths[shortestDistanceNodeNumber][j] != 0.0 && bandwidth < availableBandwidths[shortestDistanceNodeNumber][j]) {
                    neighbourNodesNumbers.add(j);
                }
                ++j;
            }
            j = 0;
            while (j < neighbourNodesNumbers.size()) {
                int neighbourNodeNumber = (Integer)neighbourNodesNumbers.get(j);
                double shortestDistance = shortestDistances[shortestDistanceNodeNumber] + distances[shortestDistanceNodeNumber][neighbourNodeNumber];
                if (shortestDistance < shortestDistances[neighbourNodeNumber]) {
                    shortestDistances[neighbourNodeNumber] = shortestDistance;
                    shortestDistanceNodesNumbers[neighbourNodeNumber] = shortestDistanceNodeNumber;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nodesNumber) {
            if (shortestDistanceNodesNumbers[i2] != -1) {
                return shortestDistanceNodesNumbers;
            }
            ++i2;
        }
        return null;
    }

    private int shortestDistanceNodeNumber(double[] shortestDistances, boolean[] areVisitedNodes) {
        double shortestDistance = 2.147483647E9;
        int shortDistanceNodeNumber = -1;
        int i = 0;
        while (i < shortestDistances.length) {
            if (!areVisitedNodes[i] && shortestDistances[i] < shortestDistance) {
                shortestDistance = shortestDistances[i];
                shortDistanceNodeNumber = i;
            }
            ++i;
        }
        return shortDistanceNodeNumber;
    }
}

