/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.linksMapping;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import java.util.LinkedHashMap;
import java.util.List;
import model.algorithms.linksMapping.LinksMappingAlgorithm;
import model.components.links.link.Link;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class MultiCommodityFlow
extends LinksMappingAlgorithm {
    public MultiCommodityFlow(String name) {
        super(name);
    }

    @Override
    protected int[][][] linksMapping(VirtualNetwork requestNetwork, SdnNetwork substrateNetwork, LinkedHashMap<VirtualNode, SdnNode> nodesMapping, double[][] availableBandwidth) {
        List<Link> requestLinks = requestNetwork.getLinks();
        List<Node> requestNodes = requestNetwork.getNodes();
        int requestLinksNumber = requestLinks.size();
        int substrateNodesNumber = substrateNetwork.getNodes().size();
        int[][][] linksMapping = new int[requestLinksNumber][substrateNodesNumber][substrateNodesNumber];
        try {
            IloLinearNumExpr left;
            int i;
            int[] firstRequestNodeNumber = new int[requestLinksNumber];
            int[] secondRequestNodeNumber = new int[requestLinksNumber];
            for (Link requestLink : requestLinks) {
                firstRequestNodeNumber[requestLink.getNumber()] = requestLink.getFirstNode().getNumber();
                secondRequestNodeNumber[requestLink.getNumber()] = requestLink.getSecondNode().getNumber();
            }
            int[] firstSubstrateNodeNumber = new int[requestLinksNumber];
            int i2 = 0;
            while (i2 < firstRequestNodeNumber.length) {
                if (nodesMapping.containsKey(requestNodes.get(firstRequestNodeNumber[i2]))) {
                    firstSubstrateNodeNumber[i2] = nodesMapping.get(requestNodes.get(firstRequestNodeNumber[i2])).getNumber();
                }
                ++i2;
            }
            int[] secondSubstrateNodeNumber = new int[requestLinksNumber];
            int i3 = 0;
            while (i3 < secondRequestNodeNumber.length) {
                if (nodesMapping.containsKey(requestNodes.get(secondRequestNodeNumber[i3]))) {
                    secondSubstrateNodeNumber[i3] = nodesMapping.get(requestNodes.get(secondRequestNodeNumber[i3])).getNumber();
                }
                ++i3;
            }
            IloCplex multiCommodityFlowCplex = new IloCplex();
            multiCommodityFlowCplex.setParam(IloCplex.DoubleParam.TiLim, 600.0);
            multiCommodityFlowCplex.setParam(IloCplex.DoubleParam.ObjLLim, -1.7976931348623157E308);
            multiCommodityFlowCplex.setParam(IloCplex.DoubleParam.ObjULim, Double.MAX_VALUE);
            multiCommodityFlowCplex.setOut(null);
            IloNumVar[][][] linksMappingFunction = new IloNumVar[requestLinksNumber][substrateNodesNumber][substrateNodesNumber];
            int k = 0;
            while (k < requestLinksNumber) {
                i = 0;
                while (i < substrateNodesNumber) {
                    linksMappingFunction[k][i] = multiCommodityFlowCplex.numVarArray(substrateNodesNumber, 0.0, Double.MAX_VALUE);
                    ++i;
                }
                ++k;
            }
            k = 0;
            while (k < requestLinksNumber) {
                i = 0;
                while (i < substrateNodesNumber) {
                    left = multiCommodityFlowCplex.linearNumExpr();
                    if (firstSubstrateNodeNumber[k] != i && secondSubstrateNodeNumber[k] != i) {
                        int j = 0;
                        while (j < substrateNodesNumber) {
                            left.addTerm(1.0, linksMappingFunction[k][i][j]);
                            left.addTerm(-1.0, linksMappingFunction[k][j][i]);
                            ++j;
                        }
                    }
                    multiCommodityFlowCplex.addEq((IloNumExpr)left, 0.0);
                    ++i;
                }
                ++k;
            }
            double[][] requestLinksBandwidth = requestNetwork.getBandwidths();
            int k2 = 0;
            while (k2 < requestLinksNumber) {
                left = multiCommodityFlowCplex.linearNumExpr();
                int i4 = 0;
                while (i4 < substrateNodesNumber) {
                    left.addTerm(1.0, linksMappingFunction[k2][firstSubstrateNodeNumber[k2]][i4]);
                    left.addTerm(-1.0, linksMappingFunction[k2][i4][firstSubstrateNodeNumber[k2]]);
                    ++i4;
                }
                double right = requestLinksBandwidth[firstRequestNodeNumber[k2]][secondRequestNodeNumber[k2]];
                multiCommodityFlowCplex.addEq((IloNumExpr)left, right);
                ++k2;
            }
            k2 = 0;
            while (k2 < requestLinksNumber) {
                left = multiCommodityFlowCplex.linearNumExpr();
                int i5 = 0;
                while (i5 < substrateNodesNumber) {
                    left.addTerm(1.0, linksMappingFunction[k2][secondSubstrateNodeNumber[k2]][i5]);
                    left.addTerm(-1.0, linksMappingFunction[k2][i5][secondSubstrateNodeNumber[k2]]);
                    ++i5;
                }
                double right = -requestLinksBandwidth[firstRequestNodeNumber[k2]][secondRequestNodeNumber[k2]];
                multiCommodityFlowCplex.addEq((IloNumExpr)left, right);
                ++k2;
            }
            i = 0;
            while (i < substrateNodesNumber) {
                int j = 0;
                while (j < substrateNodesNumber) {
                    IloNumExpr left2 = multiCommodityFlowCplex.prod((IloNumExpr)linksMappingFunction[0][0][0], 0.0);
                    int k3 = 0;
                    while (k3 < requestLinksNumber) {
                        IloNumExpr a = multiCommodityFlowCplex.prod((IloNumExpr)linksMappingFunction[k3][i][j], 1.0);
                        IloNumExpr b = multiCommodityFlowCplex.prod((IloNumExpr)linksMappingFunction[k3][j][i], 1.0);
                        IloNumExpr sum = multiCommodityFlowCplex.sum(a, b);
                        left2 = multiCommodityFlowCplex.sum(left2, sum);
                        ++k3;
                    }
                    double right = availableBandwidth[i][j];
                    multiCommodityFlowCplex.addLe(left2, right);
                    ++j;
                }
                ++i;
            }
            double[][] distances = this.distances(substrateNetwork);
            IloLinearNumExpr objectiveFunction = multiCommodityFlowCplex.linearNumExpr();
            int k4 = 0;
            while (k4 < requestLinksNumber) {
                int i6 = 0;
                while (i6 < substrateNodesNumber) {
                    int j = 0;
                    while (j < substrateNodesNumber) {
                        double cost = 0.0;
                        if (this.getCostMetric().equals("distance")) {
                            cost = distances[i6][j];
                        } else if (this.getCostMetric().equals("availableBandwidth")) {
                            cost = 1.0 / (availableBandwidth[i6][j] + Double.MIN_VALUE);
                        }
                        objectiveFunction.addTerm(cost, linksMappingFunction[k4][i6][j]);
                        ++j;
                    }
                    ++i6;
                }
                ++k4;
            }
            multiCommodityFlowCplex.addMinimize(objectiveFunction);
            if (multiCommodityFlowCplex.solve()) {
                k4 = 0;
                while (k4 < requestLinksNumber) {
                    int i7 = 0;
                    while (i7 < substrateNodesNumber) {
                        int j = 0;
                        while (j < substrateNodesNumber) {
                            linksMapping[k4][i7][j] = (int)multiCommodityFlowCplex.getValue(linksMappingFunction[k4][i7][j]);
                            ++j;
                        }
                        ++i7;
                    }
                    ++k4;
                }
            } else {
                linksMapping = null;
            }
            multiCommodityFlowCplex.end();
        }
        catch (IloException e) {
            System.err.println("Concert exception caught: " + e.toString());
        }
        return linksMapping;
    }
}

