/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.linksMapping;

import java.util.LinkedHashMap;
import model.components.links.link.SdnLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class LinksMappingAlgorithm {
    public static final String DISTANCE_COST = "distance";
    public static final String BW_COST = "availableBandwidth";
    private String name;
    private String costMetric;
    private boolean isBackupVirtualNetwork;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCostMetric() {
        return this.costMetric;
    }

    public void setCostMetric(String costMetric) {
        this.costMetric = costMetric;
    }

    public boolean isBackupVirtualNetwork() {
        return this.isBackupVirtualNetwork;
    }

    public void setBackupVirtualNetwork(boolean isBackupVirtualNetwork) {
        this.isBackupVirtualNetwork = isBackupVirtualNetwork;
    }

    public LinksMappingAlgorithm(String name) {
        this.setName(name);
    }

    public int[][][][] run(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork, LinkedHashMap<VirtualNode, SdnNode> nodesMapping) {
        int j;
        int i;
        double[][] availableBWs = sdnNetwork.getAvailableBWs();
        int[][][] normalLinksMapping = this.linksMapping(virtualNetwork, sdnNetwork, nodesMapping, availableBWs);
        if (normalLinksMapping == null) {
            return null;
        }
        int requestLinksNumber = virtualNetwork.getLinks().size();
        int substrateNodesNumber = sdnNetwork.getNodes().size();
        int[][][][] linksMapping = new int[requestLinksNumber][substrateNodesNumber][substrateNodesNumber][2];
        int k = 0;
        while (k < requestLinksNumber) {
            i = 0;
            while (i < substrateNodesNumber) {
                j = 0;
                while (j < substrateNodesNumber) {
                    linksMapping[k][i][j][0] = normalLinksMapping[k][i][j];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        if (this.isBackupVirtualNetwork()) {
            k = 0;
            while (k < requestLinksNumber) {
                i = 0;
                while (i < substrateNodesNumber) {
                    j = 0;
                    while (j < substrateNodesNumber) {
                        if (normalLinksMapping[k][i][j] != 0) {
                            availableBWs[i][j] = 0.0;
                            availableBWs[j][i] = 0.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            int[][][] backupLinksMapping = this.linksMapping(virtualNetwork, sdnNetwork, nodesMapping, availableBWs);
            if (backupLinksMapping == null) {
                return null;
            }
            int k2 = 0;
            while (k2 < requestLinksNumber) {
                int i2 = 0;
                while (i2 < substrateNodesNumber) {
                    int j2 = 0;
                    while (j2 < substrateNodesNumber) {
                        if (backupLinksMapping[k2][i2][j2] != 0) {
                            linksMapping[k2][i2][j2][1] = backupLinksMapping[k2][i2][j2];
                        }
                        ++j2;
                    }
                    ++i2;
                }
                ++k2;
            }
        }
        return linksMapping;
    }

    protected int[][][] linksMapping(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork, LinkedHashMap<VirtualNode, SdnNode> nodesMapping, double[][] availableBWs) {
        return null;
    }

    public double[][] distances(SdnNetwork substrateNetwork) {
        int substrateNodesNumber = substrateNetwork.getSdnNodes().size();
        double[][] distances = new double[substrateNodesNumber][substrateNodesNumber];
        int i = 0;
        while (i < substrateNodesNumber) {
            int j = 0;
            while (j < substrateNodesNumber) {
                distances[i][j] = Double.MAX_VALUE;
                ++j;
            }
            ++i;
        }
        for (SdnLink substrateLink : substrateNetwork.getSdnLinks()) {
            distances[substrateLink.getFirstNode().getNumber()][substrateLink.getSecondNode().getNumber()] = substrateLink.getDistance();
            distances[substrateLink.getSecondNode().getNumber()][substrateLink.getFirstNode().getNumber()] = substrateLink.getDistance();
        }
        return distances;
    }
}

