/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.embedding;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import model.algorithms.embedding.EmbeddingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;

public class ViNE
extends EmbeddingAlgorithm {
    public ViNE(String name) {
        super(name);
    }

    @Override
    protected void minimize(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        IloLinearNumExpr linksCost = this.linksCost(cplex, f, virtualNetwork, augmentedPhysicalNetwork);
        IloLinearNumExpr nodesCost = this.nodesCost(cplex, x, virtualNetwork, physicalNetwork);
        cplex.addMinimize(this.sumCosts(cplex, linksCost, nodesCost));
    }

    private IloLinearNumExpr linksCost(IloCplex cplex, IloNumVar[][][] f, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        IloLinearNumExpr linksCost = cplex.linearNumExpr();
        double[][] availableBandwidths = augmentedPhysicalNetwork.getAvailableBWs();
        int u = virtualNetwork.getNodes().size();
        while (u < augmentedPhysicalNetwork.getNodes().size()) {
            int v = virtualNetwork.getNodes().size();
            while (v < augmentedPhysicalNetwork.getNodes().size()) {
                double alpha = 1.0;
                double delta = Double.MIN_VALUE;
                double linkCost = alpha / (availableBandwidths[u][v] + delta);
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    linksCost.addTerm(linkCost, f[i][u][v]);
                    ++i;
                }
                ++v;
            }
            ++u;
        }
        return linksCost;
    }

    private IloLinearNumExpr nodesCost(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) throws IloException {
        IloLinearNumExpr nodesCost = cplex.linearNumExpr();
        double[][] virtualNodesCapacities = virtualNetwork.getNodesCapacities();
        double[][] availablePhysicalNodesCapacities = physicalNetwork.getSdnNodesAvailableCapacities();
        int j = 0;
        while (j < 3) {
            int a = 0;
            while (a < this.nodesNumberByType(virtualNetwork).size()) {
                for (int w : this.nodesNumberByType(physicalNetwork).get(a)) {
                    double beta = 1.0;
                    double delta = Double.MIN_VALUE;
                    double nodeCost = beta / (availablePhysicalNodesCapacities[j][w] + delta);
                    for (int m : this.nodesNumberByType(virtualNetwork).get(a)) {
                        int i = 0;
                        while (i < virtualNetwork.getVirtualLinks().size()) {
                            nodesCost.addTerm(nodeCost * virtualNodesCapacities[j][m], x[i][m][w + virtualNetwork.getNodes().size()]);
                            ++i;
                        }
                    }
                }
                ++a;
            }
            ++j;
        }
        return nodesCost;
    }

    private IloNumExpr sumCosts(IloCplex cplex, IloLinearNumExpr linksCost, IloLinearNumExpr nodesCost) throws IloException {
        return cplex.sum((IloNumExpr)linksCost, (IloNumExpr)nodesCost);
    }
}

