/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.embedding;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import model.algorithms.embedding.EmbeddingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;

public class NCM
extends EmbeddingAlgorithm {
    public NCM(String name) {
        super(name);
    }

    @Override
    protected void minimize(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        IloLinearNumExpr linksCost = this.linksCost(cplex, f, virtualNetwork, augmentedPhysicalNetwork);
        IloLinearNumExpr nodesCost = this.nodesCost(cplex, x, virtualNetwork, physicalNetwork);
        IloLinearNumExpr hopsCost = this.hopsCost(cplex, x, virtualNetwork, augmentedPhysicalNetwork);
        cplex.addMinimize(this.costsSum(cplex, linksCost, nodesCost, hopsCost));
    }

    private IloLinearNumExpr linksCost(IloCplex cplex, IloNumVar[][][] f, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        IloLinearNumExpr costsLinks = cplex.linearNumExpr();
        double[][] availableBandwidths = augmentedPhysicalNetwork.getAvailableBWs();
        int u = virtualNetwork.getNodes().size();
        while (u < augmentedPhysicalNetwork.getNodes().size()) {
            int v = virtualNetwork.getNodes().size();
            while (v < augmentedPhysicalNetwork.getNodes().size()) {
                double alpha = 1.0;
                double delta = Double.MIN_VALUE;
                double costLink = alpha / (availableBandwidths[u][v] + delta);
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    costsLinks.addTerm(costLink, f[i][u][v]);
                    ++i;
                }
                ++v;
            }
            ++u;
        }
        return costsLinks;
    }

    private IloLinearNumExpr nodesCost(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) throws IloException {
        IloLinearNumExpr nodesCost = cplex.linearNumExpr();
        double[][] virtualNodesCapacities = virtualNetwork.getNodesCapacities();
        double[][] availablePhysicalNodesCapacities = physicalNetwork.getSdnNodesAvailableCapacities();
        int j = 0;
        while (j < 3) {
            int a = 0;
            while (a < this.nodesNumberByType(virtualNetwork).size()) {
                for (int w : this.nodesNumberByType(physicalNetwork).get(a)) {
                    double beta = 1.0;
                    double delta = Double.MIN_VALUE;
                    double nodeCost = beta / (availablePhysicalNodesCapacities[j][w] + delta);
                    for (int m : this.nodesNumberByType(virtualNetwork).get(a)) {
                        int i = 0;
                        while (i < virtualNetwork.getVirtualLinks().size()) {
                            nodesCost.addTerm(nodeCost * virtualNodesCapacities[j][m], x[i][m][w + virtualNetwork.getNodes().size()]);
                            ++i;
                        }
                    }
                }
                ++a;
            }
            ++j;
        }
        return nodesCost;
    }

    private IloLinearNumExpr hopsCost(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        IloLinearNumExpr hopsCost = cplex.linearNumExpr();
        double[][] availableBandwidths = augmentedPhysicalNetwork.getAvailableBWs();
        int u = virtualNetwork.getNodes().size();
        while (u < augmentedPhysicalNetwork.getNodes().size()) {
            int v = virtualNetwork.getNodes().size();
            while (v < augmentedPhysicalNetwork.getNodes().size()) {
                double gamma = 1.0;
                double delta = Double.MIN_VALUE;
                double hopCost = gamma / (availableBandwidths[u][v] + delta);
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    hopsCost.addTerm(hopCost, x[i][u][v]);
                    ++i;
                }
                ++v;
            }
            ++u;
        }
        return hopsCost;
    }

    private IloNumExpr costsSum(IloCplex cplex, IloLinearNumExpr linksCost, IloLinearNumExpr nodesCost, IloLinearNumExpr hopsCost) throws IloException {
        return cplex.sum(cplex.sum((IloNumExpr)linksCost, (IloNumExpr)nodesCost), (IloNumExpr)hopsCost);
    }
}

