/*
 * Decompiled with CFR 0.152.
 */
package model.algorithms.embedding;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import java.util.ArrayList;
import java.util.List;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.Network;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class EmbeddingAlgorithm {
    private String name;
    private double[][][] fValues;
    private double[][][] xValues;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[][][] getFValues() {
        return this.fValues;
    }

    public void setFValues(double[][][] fValues) {
        this.fValues = fValues;
    }

    public double[][][] getXValues() {
        return this.xValues;
    }

    public void setXValues(double[][][] xValues) {
        this.xValues = xValues;
    }

    public EmbeddingAlgorithm(String name) {
        this.setName(name);
    }

    public boolean run(VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) {
        boolean isSolve = false;
        try {
            SdnNetwork augmentedPhysicalNetwork = this.augmentedPhysicalNetwork(virtualNetwork, physicalNetwork);
            IloNumVar[][][] f = new IloNumVar[virtualNetwork.getVirtualLinks().size()][augmentedPhysicalNetwork.getNodes().size()][augmentedPhysicalNetwork.getNodes().size()];
            IloNumVar[][][] x = new IloNumVar[virtualNetwork.getVirtualLinks().size()][augmentedPhysicalNetwork.getNodes().size()][augmentedPhysicalNetwork.getNodes().size()];
            IloCplex cplex = this.setCplex(new IloCplex());
            cplex.setOut(null);
            this.setConstrains(cplex, f, x, virtualNetwork, physicalNetwork, augmentedPhysicalNetwork);
            this.minimize(cplex, f, x, virtualNetwork, physicalNetwork, augmentedPhysicalNetwork);
            isSolve = cplex.solve();
            if (isSolve) {
                this.setFValues(this.fValues(cplex, f, virtualNetwork, augmentedPhysicalNetwork));
                this.setXValues(this.xValues(cplex, x, virtualNetwork, augmentedPhysicalNetwork));
            }
            cplex.end();
        }
        catch (IloException e) {
            System.err.println("Concert exception caught: " + e);
        }
        return isSolve;
    }

    private SdnNetwork augmentedPhysicalNetwork(VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) {
        SdnNetwork copyPhysicalNetwork = physicalNetwork.getCopy();
        for (SdnNode copyPhysicalNode : copyPhysicalNetwork.getSdnNodes()) {
            copyPhysicalNode.setNumber(copyPhysicalNode.getNumber() + virtualNetwork.getNodes().size());
        }
        SdnNetwork augmentedPhysicalNetwork = new SdnNetwork("augmentedPhysicalNetwork");
        for (SdnLink physicalLink : copyPhysicalNetwork.getSdnLinks()) {
            augmentedPhysicalNetwork.addLinkAndNodes(physicalLink, physicalLink.getFirstNode(), physicalLink.getSecondNode());
        }
        int i = augmentedPhysicalNetwork.getSdnLinks().size() + 1;
        for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
            for (SdnNode copyPhysicalNode : copyPhysicalNetwork.getSdnNodes()) {
                augmentedPhysicalNetwork.addLinkAndNodes(new SdnLink(physicalNetwork.getName(), i++, Integer.MAX_VALUE, 0), virtualNode, copyPhysicalNode);
            }
        }
        return augmentedPhysicalNetwork;
    }

    private IloCplex setCplex(IloCplex cplex) throws IloException {
        cplex.setParam(IloCplex.DoubleParam.TiLim, 600.0);
        cplex.setParam(IloCplex.DoubleParam.ObjULim, Double.MAX_VALUE);
        cplex.setParam(IloCplex.DoubleParam.ObjLLim, -1.7976931348623157E308);
        return cplex;
    }

    private void setConstrains(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        this.setDomainConstrains(cplex, f, x, virtualNetwork, augmentedPhysicalNetwork);
        this.setNodeCapacitiesConstrains(cplex, f, virtualNetwork, physicalNetwork);
        this.setLinkCapacitiesConstrains(cplex, f, x, virtualNetwork, augmentedPhysicalNetwork);
        this.setFlowConstrains(cplex, f, virtualNetwork, augmentedPhysicalNetwork);
        this.setOneNodeConstrains(cplex, x, virtualNetwork, physicalNetwork);
        this.setSameTypeConstrains(cplex, x, virtualNetwork, physicalNetwork, augmentedPhysicalNetwork);
        this.setXConstrains(cplex, f, x, virtualNetwork, augmentedPhysicalNetwork);
        this.setGraphConnectedConstrains(cplex, x, virtualNetwork, augmentedPhysicalNetwork);
        this.setMatchingConstrains(cplex, x, virtualNetwork, physicalNetwork);
    }

    private void setDomainConstrains(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        int u;
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            u = 0;
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                f[i][u] = cplex.numVarArray(augmentedPhysicalNetwork.getNodes().size(), 0.0, Double.MAX_VALUE);
                ++u;
            }
            ++i;
        }
        i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            u = 0;
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                x[i][u] = cplex.numVarArray(augmentedPhysicalNetwork.getNodes().size(), 0.0, 1.0);
                ++u;
            }
            ++i;
        }
    }

    private void setNodeCapacitiesConstrains(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) throws IloException {
        double[][] virtualNodesCapacities = virtualNetwork.getNodesCapacities();
        double[][] availablePhysicalNodesCapacities = physicalNetwork.getSdnNodesAvailableCapacities();
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int a = 0;
            while (a < this.nodesNumberByType(physicalNetwork).size()) {
                for (int w : this.nodesNumberByType(physicalNetwork).get(a)) {
                    for (int m : this.nodesNumberByType(virtualNetwork).get(a)) {
                        int j = 0;
                        while (j < 3) {
                            cplex.addLe(cplex.prod(virtualNodesCapacities[j][m], (IloNumExpr)x[i][m][w + virtualNetwork.getNodes().size()]), availablePhysicalNodesCapacities[j][w]);
                            ++j;
                        }
                    }
                }
                ++a;
            }
            ++i;
        }
    }

    private void setLinkCapacitiesConstrains(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        double[][] availablePhysicalBandwidth = augmentedPhysicalNetwork.getAvailableBWs();
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int u = virtualNetwork.getNodes().size();
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                int v = virtualNetwork.getNodes().size();
                while (v < augmentedPhysicalNetwork.getNodes().size()) {
                    cplex.addLe(cplex.sum((IloNumExpr)f[i][u][v], (IloNumExpr)f[i][v][u]), cplex.prod(availablePhysicalBandwidth[u][v], (IloNumExpr)x[i][u][v]));
                    ++v;
                }
                ++u;
            }
            ++i;
        }
        int u = 0;
        while (u < augmentedPhysicalNetwork.getNodes().size()) {
            int v = 0;
            while (v < augmentedPhysicalNetwork.getNodes().size()) {
                IloNumExpr virtualBandwidth = cplex.prod((IloNumExpr)x[0][0][0], 0.0);
                int i2 = 0;
                while (i2 < virtualNetwork.getVirtualLinks().size()) {
                    virtualBandwidth = cplex.sum((IloNumExpr)f[i2][u][v], (IloNumExpr)f[i2][v][u]);
                    ++i2;
                }
                cplex.addLe(virtualBandwidth, availablePhysicalBandwidth[u][v]);
                ++v;
            }
            ++u;
        }
    }

    private void setFlowConstrains(IloCplex cplex, IloNumVar[][][] f, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        int w;
        IloLinearNumExpr mappedVirtualBandwidth;
        int[] source = new int[virtualNetwork.getVirtualLinks().size()];
        int[] sink = new int[virtualNetwork.getVirtualLinks().size()];
        for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
            source[virtualLink.getNumber()] = virtualLink.getFirstNode().getNumber();
            sink[virtualLink.getNumber()] = virtualLink.getSecondNode().getNumber();
        }
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int u = 0;
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                if (u != source[i] && u != sink[i]) {
                    mappedVirtualBandwidth = cplex.linearNumExpr();
                    w = 0;
                    while (w < augmentedPhysicalNetwork.getNodes().size()) {
                        mappedVirtualBandwidth.addTerm(1.0, f[i][u][w]);
                        mappedVirtualBandwidth.addTerm(-1.0, f[i][w][u]);
                        ++w;
                    }
                    cplex.addEq((IloNumExpr)mappedVirtualBandwidth, 0.0);
                }
                ++u;
            }
            ++i;
        }
        double[][] virtualBandwidths = virtualNetwork.getBandwidths();
        int i2 = 0;
        while (i2 < virtualNetwork.getVirtualLinks().size()) {
            mappedVirtualBandwidth = cplex.linearNumExpr();
            w = 0;
            while (w < augmentedPhysicalNetwork.getNodes().size()) {
                mappedVirtualBandwidth.addTerm(1.0, f[i2][source[i2]][w]);
                mappedVirtualBandwidth.addTerm(-1.0, f[i2][w][source[i2]]);
                ++w;
            }
            cplex.addEq((IloNumExpr)mappedVirtualBandwidth, virtualBandwidths[source[i2]][sink[i2]]);
            ++i2;
        }
        i2 = 0;
        while (i2 < virtualNetwork.getVirtualLinks().size()) {
            mappedVirtualBandwidth = cplex.linearNumExpr();
            w = 0;
            while (w < augmentedPhysicalNetwork.getNodes().size()) {
                mappedVirtualBandwidth.addTerm(1.0, f[i2][sink[i2]][w]);
                mappedVirtualBandwidth.addTerm(-1.0, f[i2][w][sink[i2]]);
                ++w;
            }
            cplex.addEq((IloNumExpr)mappedVirtualBandwidth, -virtualBandwidths[source[i2]][sink[i2]]);
            ++i2;
        }
    }

    private void setOneNodeConstrains(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) throws IloException {
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int a = 0;
            while (a < this.nodesNumberByType(physicalNetwork).size()) {
                for (int m : this.nodesNumberByType(virtualNetwork).get(a)) {
                    IloLinearNumExpr nodesNumber = cplex.linearNumExpr();
                    for (int w : this.nodesNumberByType(physicalNetwork).get(a)) {
                        nodesNumber.addTerm(x[i][m][w + virtualNetwork.getNodes().size()], 1.0);
                    }
                    cplex.addEq((IloNumExpr)nodesNumber, 1.0);
                }
                ++a;
            }
            ++i;
        }
    }

    private void setSameTypeConstrains(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int a = 0;
            while (a < this.nodesNumberByType(physicalNetwork).size()) {
                for (int w : this.nodesNumberByType(physicalNetwork).get(a)) {
                    IloLinearNumExpr sameType = cplex.linearNumExpr();
                    for (int m : this.nodesNumberByType(virtualNetwork).get(a)) {
                        sameType.addTerm(x[i][m][w + virtualNetwork.getNodes().size()], 1.0);
                    }
                    cplex.addLe((IloNumExpr)sameType, 1.0);
                }
                ++a;
            }
            ++i;
        }
        i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int m = 0;
            while (m < virtualNetwork.getNodes().size()) {
                IloLinearNumExpr sameType = cplex.linearNumExpr();
                int w = virtualNetwork.getNodes().size();
                while (w < augmentedPhysicalNetwork.getNodes().size()) {
                    sameType.addTerm(x[i][m][w], 1.0);
                    ++w;
                }
                cplex.addLe((IloNumExpr)sameType, 1.0);
                ++m;
            }
            ++i;
        }
    }

    private void setXConstrains(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        int v;
        int u;
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            u = 0;
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                v = 0;
                while (v < augmentedPhysicalNetwork.getNodes().size()) {
                    cplex.addGe(cplex.sum((IloNumExpr)f[i][u][v], (IloNumExpr)f[i][v][u]), (IloNumExpr)x[i][u][v]);
                    ++v;
                }
                ++u;
            }
            ++i;
        }
        i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            u = 0;
            while (u < augmentedPhysicalNetwork.getNodes().size()) {
                v = 0;
                while (v < augmentedPhysicalNetwork.getNodes().size()) {
                    cplex.addEq((IloNumExpr)x[i][u][v], (IloNumExpr)x[i][v][u]);
                    ++v;
                }
                ++u;
            }
            ++i;
        }
    }

    private void setGraphConnectedConstrains(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
        int i = 0;
        while (i < virtualNetwork.getVirtualLinks().size()) {
            int j = 0;
            while (j < virtualNetwork.getVirtualLinks().size()) {
                int u = 0;
                while (u < virtualNetwork.getNodes().size()) {
                    int v = virtualNetwork.getNodes().size();
                    while (v < augmentedPhysicalNetwork.getNodes().size()) {
                        cplex.addEq((IloNumExpr)x[i][u][v], (IloNumExpr)x[j][u][v]);
                        ++v;
                    }
                    ++u;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setMatchingConstrains(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork) throws IloException {
        for (Node nodSub : physicalNetwork.getNodes()) {
            for (Node nodReq : virtualNetwork.getNodes()) {
                if (nodSub.getType().equals(nodReq.getType()) && nodSub.getOS().equals(nodReq.getOS())) continue;
                int i = 0;
                while (i < virtualNetwork.getVirtualLinks().size()) {
                    cplex.addEq((IloNumExpr)x[i][nodReq.getNumber()][nodSub.getNumber() + virtualNetwork.getNodes().size()], 0.0);
                    ++i;
                }
            }
        }
    }

    protected void minimize(IloCplex cplex, IloNumVar[][][] f, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork physicalNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloException {
    }

    private double[][][] fValues(IloCplex cplex, IloNumVar[][][] f, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloCplex.UnknownObjectException, IloException {
        double[][][] fValues = new double[virtualNetwork.getVirtualLinks().size()][augmentedPhysicalNetwork.getNodes().size()][augmentedPhysicalNetwork.getNodes().size()];
        int k = 0;
        while (k < virtualNetwork.getVirtualLinks().size()) {
            int i = 0;
            while (i < augmentedPhysicalNetwork.getNodes().size()) {
                fValues[k][i] = cplex.getValues(f[k][i]);
                ++i;
            }
            ++k;
        }
        return fValues;
    }

    private double[][][] xValues(IloCplex cplex, IloNumVar[][][] x, VirtualNetwork virtualNetwork, SdnNetwork augmentedPhysicalNetwork) throws IloCplex.UnknownObjectException, IloException {
        double[][][] xValues = new double[virtualNetwork.getVirtualLinks().size()][augmentedPhysicalNetwork.getNodes().size()][augmentedPhysicalNetwork.getNodes().size()];
        int k = 0;
        while (k < virtualNetwork.getVirtualLinks().size()) {
            int i = 0;
            while (i < augmentedPhysicalNetwork.getNodes().size()) {
                xValues[k][i] = cplex.getValues(x[k][i]);
                ++i;
            }
            ++k;
        }
        return xValues;
    }

    public List<List<Integer>> nodesNumberByType(Network network) {
        ArrayList<List<Integer>> nodesNumberByType = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < 3) {
            nodesNumberByType.add(new ArrayList());
            ++i;
        }
        i = 0;
        while (i < network.getNodes().size()) {
            String nodeType = network.getNodes().get(i).getType();
            if (nodeType.equals("Router")) {
                ((List)nodesNumberByType.get(0)).add(i);
            } else if (nodeType.equals("Switch")) {
                ((List)nodesNumberByType.get(1)).add(i);
            } else if (nodeType.equals("Server")) {
                ((List)nodesNumberByType.get(2)).add(i);
            }
            ++i;
        }
        return nodesNumberByType;
    }
}

