/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.utils.universe.Viewer;
import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sensor;
import javax.media.j3d.SoundRenderer;
import javax.media.j3d.SoundScheduler;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.ViewCache;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public class View {
    public static final int NOMINAL_HEAD = 0;
    public static final int NOMINAL_FEET = 1;
    public static final int NOMINAL_SCREEN = 2;
    public static final int SCALE_SCREEN_SIZE = 0;
    public static final int SCALE_EXPLICIT = 1;
    public static final int VIRTUAL_SCREEN = 0;
    public static final int PHYSICAL_SCREEN = 1;
    public static final int VIRTUAL_EYE = 2;
    public static final int PHYSICAL_EYE = 3;
    public static final int VIRTUAL_WORLD = 0;
    public static final int PHYSICAL_WORLD = 1;
    public static final int RELATIVE_TO_SCREEN = 0;
    public static final int RELATIVE_TO_WINDOW = 1;
    public static final int RELATIVE_TO_FIELD_OF_VIEW = 2;
    public static final int RELATIVE_TO_COEXISTENCE = 3;
    public static final int LEFT_EYE_VIEW = 0;
    public static final int RIGHT_EYE_VIEW = 1;
    public static final int CYCLOPEAN_EYE_VIEW = 2;
    public static final int SCREEN_VIEW = 0;
    public static final int HMD_VIEW = 1;
    public static final int PARALLEL_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int VISIBILITY_DRAW_VISIBLE = 0;
    public static final int VISIBILITY_DRAW_INVISIBLE = 1;
    public static final int VISIBILITY_DRAW_ALL = 2;
    public static final int TRANSPARENCY_SORT_NONE = 0;
    public static final int TRANSPARENCY_SORT_GEOMETRY = 1;
    private Vector canvases = new Vector(3);
    VirtualUniverse universe = null;
    RenderBin renderBin = null;
    SoundScheduler soundScheduler = null;
    SoundRenderer soundRenderer = new SoundRenderer();
    static final int NUMBER_FRAME_START_TIMES = 10;
    long[] frameStartTimes = new long[10];
    long[] frameNumbers = new long[10];
    int currentFrameIndex = 0;
    long currentFrameStartTime = 0L;
    long currentFrameDuration = 0L;
    long currentFrameNumber = 0L;
    long frameNumber = 0L;
    long startTime = 0L;
    long stopTime = 0L;
    Viewer viewer = null;
    boolean firstTime = true;
    float dvrFactor = 1.0f;
    boolean dvrResizeCompensation = true;
    long minFrameCycleTime;
    boolean stopBehavior;
    ViewCache viewCache = null;
    static final int COMPATIBILITY_MODE_DIRTY = 1;
    static final int SCREEN_SCALE_POLICY_DIRTY = 2;
    static final int SCREEN_SCALE_DIRTY = 4;
    static final int WINDOW_RESIZE_POLICY_DIRTY = 8;
    static final int VIEW_POLICY_DIRTY = 16;
    static final int CLIP_DIRTY = 32;
    static final int PROJECTION_POLICY_DIRTY = 64;
    static final int WINDOW_MOVEMENT_POLICY_DIRTY = 128;
    static final int WINDOW_EYE_POINT_POLICY_DIRTY = 256;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 512;
    static final int FIELD_OF_VIEW_DIRTY = 1024;
    static final int TRACKING_ENABLE_DIRTY = 2048;
    static final int USER_HEAD_TO_VWORLD_ENABLE_DIRTY = 4096;
    static final int COEXISTENCE_CENTERING_ENABLE_DIRTY = 8192;
    static final int LEFT_MANUAL_EYE_IN_COEXISTENCE_DIRTY = 16384;
    static final int RIGHT_MANUAL_EYE_IN_COEXISTENCE_DIRTY = 32768;
    static final int VISIBILITY_POLICY_DIRTY = 65536;
    static final int VPR_VIEW_ATTACH_POLICY_DIRTY = 65536;
    static final int VPR_VIEWPLATFORM_DIRTY = 131072;
    static final int PE_COE_TO_TRACKER_BASE_DIRTY = 0x100000;
    static final int PE_TRACKING_AVAILABLE_DIRTY = 0x200000;
    static final int PE_COE_CENTER_IN_PWORLD_POLICY_DIRTY = 0x400000;
    static final int PB_EYE_POSITION_DIRTY = 0x1000000;
    static final int PB_EAR_POSITION_DIRTY = 0x2000000;
    static final int PB_NOMINAL_EYE_HEIGHT_FROM_GROUND_DIRTY = 0x4000000;
    static final int PB_NOMINAL_EYE_OFFSET_FROM_NOMINAL_SCREEN_DIRTY = 0x8000000;
    int vDirtyMask = 131071;
    PhysicalBody physicalBody;
    PhysicalEnvironment physicalEnvironment;
    boolean compatibilityModeEnable = false;
    boolean coexistenceCenteringEnable = true;
    Point3d leftManualEyeInCoexistence = new Point3d();
    Point3d rightManualEyeInCoexistence = new Point3d();
    int viewPolicy = 0;
    int projectionPolicy = 1;
    double fieldOfView = 0.7853981633974483;
    double frontClipDistance = 0.1;
    double backClipDistance = 10.0;
    int screenScalePolicy = 0;
    double screenScale = 1.0;
    int windowResizePolicy = 1;
    int windowMovementPolicy = 1;
    int windowEyepointPolicy = 2;
    int monoscopicViewPolicy = 2;
    int frontClipPolicy = 3;
    int backClipPolicy = 3;
    int visibilityPolicy = 0;
    int transparencySortingPolicy = 0;
    boolean trackingEnable = false;
    boolean userHeadToVworldEnable = false;
    private ViewPlatform viewPlatform = null;
    Transform3D compatVpcToEc = new Transform3D();
    Transform3D compatLeftProjection = new Transform3D();
    Transform3D compatRightProjection = new Transform3D();
    Integer viewId = null;
    int viewIndex = -1;
    boolean primaryView = false;
    boolean active = false;
    boolean activeStatus = false;
    volatile boolean isRunning = true;
    boolean inCanvasCallback = false;
    boolean depthBufferFreezeTransparent = true;
    boolean sceneAntialiasingEnable = false;
    boolean localEyeLightingEnable = false;
    private ArrayList screenList = new ArrayList();
    private ArrayList canvasList = new ArrayList();
    private Canvas3D[][] cachedCanvasList;
    private Canvas3D[] cachedCanvases;
    private Canvas3D[] cachedOffScreenCanvases;
    private Screen3D[] cachedScreens;
    private int longestScreenList = 0;
    private boolean canvasesDirty = true;
    volatile boolean renderOnceFinish = true;
    private Object startStopViewLock = new Object();
    private Object evaluateLock = new Object();
    int stopViewCount = -1;
    boolean isMinCycleTimeAchieve = true;
    long sleepTime = 0L;
    volatile boolean inRenderThreadData = false;
    boolean renderBinReady = false;
    long universeCount = 0L;
    long resetUnivCount = 0L;
    volatile boolean doneUnregister = false;
    static final int TRANSP_SORT_POLICY_CHANGED = 1;
    static final int OTHER_ATTRS_CHANGED = 2;

    public View() {
        this.viewCache = new ViewCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPolicy(int n) {
        Object object;
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("View0"));
        }
        if (n == 1) {
            object = this.canvasList;
            synchronized (object) {
                int n2 = this.canvases.size() - 1;
                while (n2 >= 0) {
                    Canvas3D canvas3D = (Canvas3D)this.canvases.elementAt(n2);
                    if (canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
                        throw new IllegalStateException(J3dI18N.getString("View31"));
                    }
                    --n2;
                }
            }
        }
        object = this;
        synchronized (object) {
            this.viewPolicy = n;
            this.vDirtyMask |= 0x10;
        }
        this.repaint();
    }

    public int getViewPolicy() {
        return this.viewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectionPolicy(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("View1"));
        }
        View view = this;
        synchronized (view) {
            this.projectionPolicy = n;
            this.vDirtyMask |= 0x40;
        }
        this.repaint();
    }

    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenScalePolicy(int n) {
        View view = this;
        synchronized (view) {
            this.screenScalePolicy = n;
            this.vDirtyMask |= 2;
        }
        this.repaint();
    }

    public int getScreenScalePolicy() {
        return this.screenScalePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowResizePolicy(int n) {
        View view = this;
        synchronized (view) {
            this.windowResizePolicy = n;
            this.vDirtyMask |= 8;
        }
        this.repaint();
    }

    public int getWindowResizePolicy() {
        return this.windowResizePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowMovementPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.windowMovementPolicy = n;
            this.vDirtyMask |= 0x80;
        }
        this.repaint();
    }

    public int getWindowMovementPolicy() {
        return this.windowMovementPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowEyepointPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.windowEyepointPolicy = n;
            this.vDirtyMask |= 0x100;
        }
        this.repaint();
    }

    public int getWindowEyepointPolicy() {
        return this.windowEyepointPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonoscopicViewPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.monoscopicViewPolicy = n;
            this.vDirtyMask |= 0x200;
        }
        this.repaint();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceCenteringEnable(boolean bl) {
        View view = this;
        synchronized (view) {
            this.coexistenceCenteringEnable = bl;
            this.vDirtyMask |= 0x2000;
        }
        this.repaint();
    }

    public boolean getCoexistenceCenteringEnable() {
        return this.coexistenceCenteringEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompatibilityModeEnable(boolean bl) {
        View view = this;
        synchronized (view) {
            this.compatibilityModeEnable = bl;
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public boolean getCompatibilityModeEnable() {
        return this.compatibilityModeEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftProjection(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View2"));
        }
        View view = this;
        synchronized (view) {
            this.compatLeftProjection.setWithLock(transform3D);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightProjection(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View2"));
        }
        View view = this;
        synchronized (view) {
            this.compatRightProjection.setWithLock(transform3D);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public void getLeftProjection(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View4"));
        }
        transform3D.set(this.compatLeftProjection);
    }

    public void getRightProjection(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View4"));
        }
        transform3D.set(this.compatRightProjection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVpcToEc(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View6"));
        }
        if (!transform3D.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("View7"));
        }
        View view = this;
        synchronized (view) {
            this.compatVpcToEc.setWithLock(transform3D);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public void getVpcToEc(Transform3D transform3D) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View8"));
        }
        transform3D.set(this.compatVpcToEc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalBody(PhysicalBody physicalBody) {
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            if (this.activeStatus) {
                if (this.physicalBody != null) {
                    this.physicalBody.removeUser(this);
                }
                physicalBody.addUser(this);
            }
        }
        this.physicalBody = physicalBody;
        this.repaint();
    }

    public PhysicalBody getPhysicalBody() {
        return this.physicalBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalEnvironment(PhysicalEnvironment physicalEnvironment) {
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            if (this.activeStatus) {
                if (this.physicalEnvironment != null) {
                    this.physicalEnvironment.removeUser(this);
                }
                physicalEnvironment.addUser(this);
            }
        }
        this.physicalEnvironment = physicalEnvironment;
        if (this.viewPlatform != null && this.viewPlatform.isLive()) {
            VirtualUniverse.mc.postRequest(MasterControl.PHYSICAL_ENV_CHANGE, this);
        }
        this.repaint();
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return this.physicalEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenScale(double d) {
        View view = this;
        synchronized (view) {
            this.screenScale = d;
            this.vDirtyMask |= 4;
        }
        this.repaint();
    }

    public double getScreenScale() {
        return this.screenScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldOfView(double d) {
        View view = this;
        synchronized (view) {
            this.fieldOfView = d;
            this.vDirtyMask |= 0x400;
        }
        this.repaint();
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftManualEyeInCoexistence(Point3d point3d) {
        View view = this;
        synchronized (view) {
            this.leftManualEyeInCoexistence.set(point3d);
            this.vDirtyMask |= 0x4000;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightManualEyeInCoexistence(Point3d point3d) {
        View view = this;
        synchronized (view) {
            this.rightManualEyeInCoexistence.set(point3d);
            this.vDirtyMask |= 0x8000;
        }
        this.repaint();
    }

    public void getLeftManualEyeInCoexistence(Point3d point3d) {
        point3d.set(this.leftManualEyeInCoexistence);
    }

    public void getRightManualEyeInCoexistence(Point3d point3d) {
        point3d.set(this.rightManualEyeInCoexistence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontClipDistance(double d) {
        View view = this;
        synchronized (view) {
            this.frontClipDistance = d;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public double getFrontClipDistance() {
        return this.frontClipDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackClipDistance(double d) {
        View view = this;
        synchronized (view) {
            this.backClipDistance = d;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public double getBackClipDistance() {
        return this.backClipDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserHeadToVworld(Transform3D transform3D) {
        if (this.userHeadToVworldEnable) {
            Canvas3D canvas3D = (Canvas3D)this.canvases.firstElement();
            CanvasViewCache canvasViewCache = canvas3D.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(canvas3D.canvasViewCache.getHeadToVworld());
            }
        } else {
            throw new RestrictedAccessException(J3dI18N.getString("View9"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontClipPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.frontClipPolicy = n;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public int getFrontClipPolicy() {
        return this.frontClipPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackClipPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.backClipPolicy = n;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public int getBackClipPolicy() {
        return this.backClipPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibilityPolicy(int n) {
        View view = this;
        synchronized (view) {
            this.visibilityPolicy = n;
            this.vDirtyMask |= 0x10000;
        }
        if (this.activeStatus && this.isRunning) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.universe = this.universe;
            j3dMessage.view = this;
            j3dMessage.type = 4;
            j3dMessage.threads = 128;
            j3dMessage.args[0] = this;
            BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
            synchronized (boundingSphere) {
                j3dMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
            }
            j3dMessage.args[2] = new Integer(2);
            j3dMessage.args[3] = new Integer(this.transparencySortingPolicy);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    public int getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    public void setTransparencySortingPolicy(int n) {
        if (n == this.transparencySortingPolicy) {
            return;
        }
        this.transparencySortingPolicy = n;
        if (this.activeStatus && this.isRunning) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.universe = this.universe;
            j3dMessage.view = this;
            j3dMessage.type = 4;
            j3dMessage.threads = 128;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = null;
            j3dMessage.args[2] = new Integer(1);
            j3dMessage.args[3] = new Integer(n);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    public int getTransparencySortingPolicy() {
        return this.transparencySortingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackingEnable(boolean bl) {
        View view = this;
        synchronized (view) {
            this.trackingEnable = bl;
            this.vDirtyMask |= 0x800;
        }
        this.repaint();
    }

    public boolean getTrackingEnable() {
        return this.trackingEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserHeadToVworldEnable(boolean bl) {
        View view = this;
        synchronized (view) {
            this.userHeadToVworldEnable = bl;
            this.vDirtyMask |= 0x1000;
        }
        this.repaint();
    }

    public boolean getUserHeadToVworldEnable() {
        return this.userHeadToVworldEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSensorToVworld(Sensor sensor, Transform3D transform3D) {
        Canvas3D canvas3D = (Canvas3D)this.canvases.firstElement();
        Transform3D transform3D2 = new Transform3D();
        CanvasViewCache canvasViewCache = canvas3D.canvasViewCache;
        synchronized (canvasViewCache) {
            transform3D.set(canvas3D.canvasViewCache.getVworldToTrackerBase());
        }
        transform3D.invert();
        sensor.getRead(transform3D2);
        transform3D.mul(transform3D2);
    }

    public void getSensorHotspotInVworld(Sensor sensor, Point3f point3f) {
        Canvas3D canvas3D = (Canvas3D)this.canvases.firstElement();
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        this.getSensorToVworld(sensor, transform3D);
        sensor.getHotspot(point3d);
        point3f.set(point3d);
        transform3D.transform(point3f);
    }

    public void getSensorHotspotInVworld(Sensor sensor, Point3d point3d) {
        Canvas3D canvas3D = (Canvas3D)this.canvases.firstElement();
        Transform3D transform3D = new Transform3D();
        this.getSensorToVworld(sensor, transform3D);
        sensor.getHotspot(point3d);
        transform3D.transform(point3d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanvas3D(Canvas3D canvas3D, int n) {
        Canvas3D canvas3D2;
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            canvas3D2 = (Canvas3D)this.canvases.elementAt(n);
            this.canvases.setElementAt(canvas3D, n);
            this.removeFromCanvasList(canvas3D2);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        canvas3D2.setView(null);
        if (canvas3D.added) {
            this.evaluateActive();
        }
        if (canvas3D2.added) {
            this.evaluateActive();
        }
    }

    public Canvas3D getCanvas3D(int n) {
        return (Canvas3D)this.canvases.elementAt(n);
    }

    public Enumeration getAllCanvas3Ds() {
        return this.canvases.elements();
    }

    public int numCanvas3Ds() {
        return this.canvases.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCanvas3D(Canvas3D canvas3D) {
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            this.canvases.addElement(canvas3D);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        if (canvas3D.added) {
            if ((canvas3D.visible || canvas3D.offScreen) && canvas3D.firstPaintCalled) {
                canvas3D.active = true;
            }
            this.evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCanvas3D(Canvas3D canvas3D, int n) {
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            this.canvases.insertElementAt(canvas3D, n);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        if (canvas3D.added) {
            if ((canvas3D.visible || canvas3D.offScreen) && canvas3D.firstPaintCalled) {
                canvas3D.active = true;
            }
            this.evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCanvas3D(int n) {
        Canvas3D canvas3D;
        if (n == -1) {
            return;
        }
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            canvas3D = (Canvas3D)this.canvases.elementAt(n);
            this.canvases.removeElementAt(n);
            this.removeFromCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        VirtualUniverse.mc.postRequest(MasterControl.RESET_CANVAS, canvas3D);
        canvas3D.pendingView = null;
        this.computeCanvasesCached();
        if (canvas3D.added) {
            canvas3D.active = false;
            this.evaluateActive();
        }
        if (this.universe != null) {
            this.universe.waitForMC();
        }
    }

    public int indexOfCanvas3D(Canvas3D canvas3D) {
        return this.canvases.indexOf(canvas3D);
    }

    public void removeCanvas3D(Canvas3D canvas3D) {
        this.removeCanvas3D(this.canvases.indexOf(canvas3D));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCanvas3Ds() {
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            int n = this.canvases.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Canvas3D canvas3D = (Canvas3D)this.canvases.elementAt(n2);
                this.canvases.removeElementAt(n2);
                this.removeFromCanvasList(canvas3D);
                this.canvasesDirty = true;
                VirtualUniverse.mc.postRequest(MasterControl.RESET_CANVAS, canvas3D);
                canvas3D.pendingView = null;
                if (canvas3D.added) {
                    canvas3D.active = false;
                }
                --n2;
            }
            this.computeCanvasesCached();
        }
        this.evaluateActive();
        if (this.universe != null) {
            this.universe.waitForMC();
        }
    }

    private void addToCanvasList(Canvas3D canvas3D) {
        int n = this.screenList.size() - 1;
        while (n >= 0) {
            if ((Screen3D)this.screenList.get(n) == canvas3D.screen) {
                ((ArrayList)this.canvasList.get(n)).add(canvas3D);
                this.canvasesDirty = true;
                return;
            }
            --n;
        }
        this.screenList.add(canvas3D.screen);
        ArrayList<Canvas3D> arrayList = new ArrayList<Canvas3D>();
        this.canvasList.add(arrayList);
        arrayList.add(canvas3D);
        this.canvasesDirty = true;
    }

    private void removeFromCanvasList(Canvas3D canvas3D) {
        int n = this.screenList.size() - 1;
        while (n >= 0) {
            if ((Screen3D)this.screenList.get(n) == canvas3D.screen) {
                ArrayList arrayList = (ArrayList)this.canvasList.get(n);
                arrayList.remove(arrayList.indexOf(canvas3D));
                if (arrayList.size() == 0) {
                    this.canvasList.remove(n);
                    this.screenList.remove(n);
                    this.canvasesDirty = true;
                }
                return;
            }
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCanvasesCached() {
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            int n;
            int n2 = this.canvases.size();
            int n3 = 0;
            Canvas3D[] canvas3DArray = new Canvas3D[n2];
            int n4 = 0;
            while (n4 < n2) {
                canvas3DArray[n4] = (Canvas3D)this.canvases.get(n4);
                if (canvas3DArray[n4].offScreen) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                this.cachedOffScreenCanvases = new Canvas3D[n3];
                n3 = 0;
            }
            this.cachedCanvases = canvas3DArray;
            n2 = 0;
            this.longestScreenList = 0;
            this.cachedCanvasList = new Canvas3D[this.canvasList.size()][0];
            int n5 = 0;
            while (n5 < this.cachedCanvasList.length) {
                ArrayList arrayList2 = (ArrayList)this.canvasList.get(n5);
                n2 = arrayList2.size();
                this.cachedCanvasList[n5] = new Canvas3D[n2];
                int n6 = 0;
                while (n6 < n2) {
                    this.cachedCanvasList[n5][n6] = (Canvas3D)arrayList2.get(n6);
                    ++n6;
                }
                if (this.cachedCanvasList[n5][0].offScreen) {
                    n = 0;
                    while (n < n2) {
                        this.cachedOffScreenCanvases[n3++] = this.cachedCanvasList[n5][n];
                        ++n;
                    }
                }
                if (n2 > this.longestScreenList) {
                    this.longestScreenList = n2;
                }
                ++n5;
            }
            n2 = this.screenList.size();
            Screen3D[] screen3DArray = new Screen3D[n2];
            n = 0;
            while (n < n2) {
                screen3DArray[n] = (Screen3D)this.screenList.get(n);
                ++n;
            }
            this.cachedScreens = screen3DArray;
            this.canvasesDirty = false;
        }
    }

    Canvas3D[][] getCanvasList(boolean bl) {
        if (this.canvasesDirty && bl) {
            this.computeCanvasesCached();
        }
        return this.cachedCanvasList;
    }

    int getLongestScreenList() {
        return this.longestScreenList;
    }

    Canvas3D[] getCanvases() {
        return this.cachedCanvases;
    }

    Canvas3D[] getOffScreenCanvases() {
        return this.cachedOffScreenCanvases;
    }

    Screen3D[] getScreens() {
        return this.cachedScreens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Canvas3D getFirstCanvas() {
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            block4: {
                if (this.canvases.size() <= 0) break block4;
                Canvas3D canvas3D = (Canvas3D)this.canvases.elementAt(0);
                return canvas3D;
            }
            Canvas3D canvas3D = null;
            return canvas3D;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentFrameStartTime() {
        long[] lArray = this.frameStartTimes;
        synchronized (lArray) {
            long l = this.currentFrameStartTime;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastFrameDuration() {
        long[] lArray = this.frameStartTimes;
        synchronized (lArray) {
            long l = this.currentFrameDuration;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameNumber() {
        long[] lArray = this.frameStartTimes;
        synchronized (lArray) {
            long l = this.currentFrameNumber;
            return l;
        }
    }

    public static int getMaxFrameStartTimes() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameStartTimes(long[] lArray) {
        long l;
        long[] lArray2 = this.frameStartTimes;
        synchronized (lArray2) {
            int n = this.currentFrameIndex - 1;
            if (n < 0) {
                n = 9;
            }
            l = this.frameNumbers[n];
            int n2 = lArray.length <= 10 ? lArray.length : 10;
            int n3 = 0;
            while (n3 < n2) {
                lArray[n3] = this.frameStartTimes[n];
                if (--n < 0) {
                    n = 9;
                }
                ++n3;
            }
            if (lArray.length > 10) {
                while (n3 < lArray.length) {
                    lArray[n3] = 0L;
                    ++n3;
                }
            }
        }
        return l;
    }

    public void setMinimumFrameCycleTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("View27"));
        }
        this.minFrameCycleTime = l;
        VirtualUniverse.mc.setWork();
    }

    public long getMinimumFrameCycleTime() {
        return this.minFrameCycleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFrameTimingValues() {
        long[] lArray = this.frameStartTimes;
        synchronized (lArray) {
            if (this.currentFrameIndex == 10) {
                this.currentFrameIndex = 0;
            }
            this.frameNumbers[this.currentFrameIndex] = this.frameNumber;
            this.frameStartTimes[this.currentFrameIndex++] = this.startTime;
            this.currentFrameStartTime = this.startTime;
            this.currentFrameDuration = this.stopTime - this.startTime;
            this.currentFrameNumber = this.frameNumber;
        }
    }

    void computeCycleTime() {
        if (this.minFrameCycleTime == 0L) {
            this.isMinCycleTimeAchieve = true;
            this.sleepTime = 0L;
        } else {
            this.sleepTime = this.minFrameCycleTime - (System.currentTimeMillis() - this.startTime);
            this.isMinCycleTimeAchieve = this.sleepTime <= 0L;
        }
    }

    public void setDepthBufferFreezeTransparent(boolean bl) {
        this.depthBufferFreezeTransparent = bl;
        this.repaint();
    }

    public boolean getDepthBufferFreezeTransparent() {
        return this.depthBufferFreezeTransparent;
    }

    public void setSceneAntialiasingEnable(boolean bl) {
        this.sceneAntialiasingEnable = bl;
        this.repaint();
    }

    public boolean getSceneAntialiasingEnable() {
        return this.sceneAntialiasingEnable;
    }

    public void setLocalEyeLightingEnable(boolean bl) {
        this.localEyeLightingEnable = bl;
        this.repaint();
    }

    public boolean getLocalEyeLightingEnable() {
        return this.localEyeLightingEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachViewPlatform(ViewPlatform viewPlatform) {
        if (viewPlatform != null && viewPlatform == this.viewPlatform) {
            return;
        }
        if (this.viewPlatform != null) {
            ((ViewPlatformRetained)this.viewPlatform.retained).removeView(this);
            if (this.viewPlatform.isLive()) {
                Object object = this.evaluateLock;
                synchronized (object) {
                    this.viewPlatform = null;
                    this.evaluateActive();
                    this.viewPlatform = viewPlatform;
                }
                if (this.universe != null) {
                    this.universe.waitForMC();
                }
            } else {
                this.viewPlatform = viewPlatform;
            }
        } else {
            this.viewPlatform = viewPlatform;
        }
        if (viewPlatform != null) {
            if (viewPlatform.isLive()) {
                this.checkView();
                this.setUniverse(((ViewPlatformRetained)viewPlatform.retained).universe);
            }
            ((ViewPlatformRetained)viewPlatform.retained).setView(this);
        }
        this.evaluateActive();
        if (viewPlatform == null && this.universe != null) {
            this.universe.waitForMC();
        }
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    void checkView() {
        if (this.physicalBody == null) {
            throw new IllegalStateException(J3dI18N.getString("View13"));
        }
        if (this.physicalEnvironment == null) {
            throw new IllegalStateException(J3dI18N.getString("View14"));
        }
    }

    public final long[] stopBehaviorScheduler() {
        long[] lArray = new long[2];
        if (this.checkBehaviorSchedulerState("View15", "View16")) {
            if (this.activeStatus && this.isRunning && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.stopBehaviorScheduler(lArray);
            } else if (this.universe != null && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.userStop = true;
            }
        }
        this.stopBehavior = true;
        return lArray;
    }

    public final void startBehaviorScheduler() {
        if (this.checkBehaviorSchedulerState("View17", "View18")) {
            if (this.activeStatus && this.isRunning && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.startBehaviorScheduler();
            } else if (this.universe != null && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.userStop = false;
            }
        }
        this.stopBehavior = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkBehaviorSchedulerState(String string, String string2) {
        Thread thread = Thread.currentThread();
        if (this.inCanvasCallback) {
            ArrayList arrayList = this.canvasList;
            synchronized (arrayList) {
                int n = this.canvases.size() - 1;
                while (n >= 0) {
                    if (((Canvas3D)this.canvases.elementAt((int)n)).screen.renderer == thread) {
                        throw new IllegalStateException(J3dI18N.getString(string));
                    }
                    --n;
                }
            }
        }
        if (this.viewPlatform != null && this.viewPlatform.isLive()) {
            if (this.universe.inBehavior && this.universe.behaviorScheduler == thread) {
                throw new IllegalStateException(J3dI18N.getString(string2));
            }
            return true;
        }
        return false;
    }

    public final boolean isBehaviorSchedulerRunning() {
        return this.universe != null && !this.stopBehavior && this.universe.behaviorScheduler != null ? !this.universe.behaviorScheduler.userStop : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopView() {
        this.checkViewState("View19", "View20");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.activeStatus && this.isRunning) {
                VirtualUniverse.mc.postRequest(MasterControl.STOP_VIEW, this);
                while (this.isRunning) {
                    MasterControl.threadYield();
                }
            } else {
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startView() {
        this.checkViewState("View21", "View22");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.activeStatus && !this.isRunning) {
                VirtualUniverse.mc.postRequest(MasterControl.START_VIEW, this);
                while (!this.isRunning) {
                    MasterControl.threadYield();
                }
                VirtualUniverse.mc.sendRunMessage(this, 16);
            } else {
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkViewState(String string, String string2) throws IllegalStateException {
        if (this.inCanvasCallback) {
            Thread thread = Thread.currentThread();
            ArrayList arrayList = this.canvasList;
            synchronized (arrayList) {
                int n = this.canvases.size() - 1;
                while (n >= 0) {
                    Canvas3D canvas3D = (Canvas3D)this.canvases.elementAt(n);
                    if (canvas3D.screen.renderer == thread) {
                        throw new IllegalStateException(J3dI18N.getString(string));
                    }
                    --n;
                }
            }
        }
        if (this.viewPlatform != null && this.viewPlatform.isLive() && this.universe.inBehavior && Thread.currentThread() == this.universe.behaviorScheduler) {
            throw new IllegalStateException(J3dI18N.getString(string2));
        }
    }

    public final boolean isViewRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOnce() {
        this.checkViewState("View28", "View29");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.isRunning) {
                throw new IllegalStateException(J3dI18N.getString("View30"));
            }
            this.renderOnceFinish = false;
            VirtualUniverse.mc.postRequest(MasterControl.RENDER_ONCE, this);
            while (!this.renderOnceFinish) {
                MasterControl.threadYield();
            }
            this.renderOnceFinish = true;
        }
    }

    public void repaint() {
        if (this.activeStatus && this.isRunning) {
            VirtualUniverse.mc.sendRunMessage(this, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateViewCache() {
        if (this.firstTime) {
            this.viewer = Viewer.removeViewerMapEntry((View)this);
            this.firstTime = false;
        }
        if (this.viewer != null) {
            if (this.viewer.isDvrEnabled()) {
                this.dvrFactor = this.viewer.getDvrFactor();
                this.dvrResizeCompensation = this.viewer.getDvrResizeCompensationEnable();
            } else {
                this.dvrFactor = 1.0f;
                this.dvrResizeCompensation = true;
            }
        }
        View view = this;
        synchronized (view) {
            this.viewCache.snapshot();
            this.viewCache.computeDerivedData();
        }
        ArrayList arrayList = this.canvasList;
        synchronized (arrayList) {
            int n = this.canvases.size() - 1;
            while (n >= 0) {
                Screen3D screen3D;
                if ((screen3D = ((Canvas3D)this.canvases.elementAt(n--)).getScreen3D()) == null) continue;
                screen3D.updateViewCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateActive() {
        Object object = this.evaluateLock;
        synchronized (object) {
            if (this.universe == null) {
                return;
            }
            if (this.viewPlatform == null || !this.viewPlatform.isLive() || !((ViewPlatformRetained)this.viewPlatform.retained).switchState.currentSwitchOn) {
                if (this.activeStatus) {
                    this.deactivate();
                    this.activeStatus = false;
                }
                if (VirtualUniverse.mc.isRegistered(this) && (this.universe.isEmpty() || this.canvases.isEmpty() && (this.viewPlatform == null || !this.viewPlatform.isLive()))) {
                    this.universe.unRegViewWaiting = this;
                    this.resetUnivCount = this.universeCount;
                    VirtualUniverse.mc.postRequest(MasterControl.UNREGISTER_VIEW, this);
                }
            } else {
                int n;
                VirtualUniverse virtualUniverse = null;
                ArrayList arrayList = this.canvasList;
                synchronized (arrayList) {
                    n = this.canvases.size() - 1;
                    while (n >= 0) {
                        Canvas3D canvas3D = (Canvas3D)this.canvases.elementAt(n);
                        if (canvas3D.active) {
                            if (this.activeStatus || this.universeCount <= this.resetUnivCount) break;
                            virtualUniverse = this.universe;
                            break;
                        }
                        --n;
                    }
                }
                if (virtualUniverse != null) {
                    this.activate(virtualUniverse);
                    this.activeStatus = true;
                    return;
                }
                if (n < 0 && this.activeStatus) {
                    this.deactivate();
                    this.activeStatus = false;
                    return;
                }
                if (VirtualUniverse.mc.isRegistered(this)) {
                    VirtualUniverse.mc.postRequest(MasterControl.REEVALUATE_CANVAS, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUniverse(VirtualUniverse virtualUniverse) {
        UnorderList unorderList = VirtualUniverse.mc.requestObjList;
        synchronized (unorderList) {
            if (this.renderBin == null || this.renderBin.universe != virtualUniverse) {
                if (this.renderBin != null) {
                    this.renderBin.cleanup();
                }
                this.renderBin = new RenderBin(virtualUniverse, this);
                this.renderBin.universe = virtualUniverse;
            }
            if (this.soundScheduler == null || this.soundScheduler.universe != virtualUniverse) {
                if (this.soundScheduler != null) {
                    this.soundScheduler.cleanup();
                }
                this.soundScheduler = new SoundScheduler(virtualUniverse, this);
            }
            ++this.universeCount;
            this.universe = virtualUniverse;
        }
        this.evaluateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(VirtualUniverse virtualUniverse) {
        virtualUniverse.checkForEnableEvents();
        if (this.physicalBody != null) {
            this.physicalBody.addUser(this);
        }
        if (!VirtualUniverse.mc.isRegistered(this)) {
            virtualUniverse.regViewWaiting = this;
        }
        VirtualUniverse.mc.postRequest(MasterControl.ACTIVATE_VIEW, this);
        if (!virtualUniverse.isSceneGraphLock) {
            virtualUniverse.waitForMC();
        }
        if (this.soundScheduler != null) {
            this.soundScheduler.reset(this);
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.universe = virtualUniverse;
        j3dMessage.view = this;
        j3dMessage.type = 4;
        j3dMessage.threads = 386;
        j3dMessage.args[0] = this;
        BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
        synchronized (boundingSphere) {
            j3dMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
        }
        j3dMessage.args[2] = new Integer(2);
        j3dMessage.args[3] = new Integer(this.transparencySortingPolicy);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        VirtualUniverse.mc.postRequest(MasterControl.DEACTIVATE_VIEW, this);
        if (this.physicalBody != null) {
            this.physicalBody.removeUser(this);
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.universe = this.universe;
        j3dMessage.view = this;
        j3dMessage.type = 4;
        j3dMessage.threads = 386;
        j3dMessage.args[0] = this;
        if (this.viewPlatform != null) {
            BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
            synchronized (boundingSphere) {
                j3dMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
            }
        } else {
            j3dMessage.args[1] = new Float(0.0f);
        }
        j3dMessage.args[2] = new Integer(2);
        j3dMessage.args[3] = new Integer(this.transparencySortingPolicy);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void cleanupViewId() {
        this.universe.addViewIdToFreeList(this.viewId);
        this.viewId = null;
    }

    void assignViewId() {
        if (this.viewId == null) {
            this.viewId = this.universe.getViewId();
            this.viewIndex = this.viewId;
        }
    }

    void sendEventToSoundScheduler(AWTEvent aWTEvent) {
        if (this.soundScheduler != null) {
            this.soundScheduler.receiveAWTEvent(aWTEvent);
        }
    }

    void reset() {
        int n = 0;
        while (n < this.canvases.size()) {
            ((Canvas3D)this.canvases.get(n)).reset();
            ++n;
        }
        this.renderBinReady = false;
        this.soundScheduler.cleanup();
        this.soundScheduler = null;
        this.soundRenderer = new SoundRenderer();
        this.viewCache = new ViewCache(this);
        this.getCanvasList(true);
        this.cleanupViewId();
        this.renderBin.cleanup();
        this.renderBin = null;
        this.universe = null;
    }
}

