/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Link;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class SceneGraphPath {
    Locale root = null;
    Node[] interior = null;
    Node item = null;
    Transform3D transform = new Transform3D();
    Point3d intersectPoint = new Point3d();
    double pickDistance;

    public SceneGraphPath() {
    }

    public SceneGraphPath(Locale locale, Node node) {
        this.item = node;
        this.root = locale;
    }

    public SceneGraphPath(Locale locale, Node[] nodeArray, Node node) {
        this.item = node;
        this.root = locale;
        this.interior = new Node[nodeArray.length];
        int n = 0;
        while (n < nodeArray.length) {
            this.interior[n] = nodeArray[n];
            ++n;
        }
    }

    SceneGraphPath(SceneGraphPath sceneGraphPath) {
        this.set(sceneGraphPath);
    }

    public final void set(SceneGraphPath sceneGraphPath) {
        this.root = sceneGraphPath.root;
        this.item = sceneGraphPath.item;
        this.transform.set(sceneGraphPath.transform);
        if (sceneGraphPath.interior != null && sceneGraphPath.interior.length > 0) {
            this.interior = new Node[sceneGraphPath.interior.length];
            int n = 0;
            while (n < this.interior.length) {
                this.interior[n] = sceneGraphPath.interior[n];
                ++n;
            }
        } else {
            this.interior = null;
        }
    }

    public final void setLocale(Locale locale) {
        this.root = locale;
    }

    public final void setObject(Node node) {
        this.item = node;
    }

    public final void setNodes(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            this.interior = new Node[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                this.interior[n] = nodeArray[n];
                ++n;
            }
        } else {
            this.interior = null;
        }
    }

    public final void setNode(int n, Node node) {
        if (this.interior == null) {
            throw new NullPointerException(J3dI18N.getString("SceneGraphPath0"));
        }
        this.interior[n] = node;
    }

    public final void setTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
    }

    public final Transform3D getTransform() {
        return new Transform3D(this.transform);
    }

    public final Locale getLocale() {
        return this.root;
    }

    public final Node getObject() {
        return this.item;
    }

    public final int nodeCount() {
        if (this.interior == null) {
            return 0;
        }
        return this.interior.length;
    }

    public final Node getNode(int n) {
        if (this.interior == null) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SceneGraphPath1"));
        }
        return this.interior[n];
    }

    public boolean equals(SceneGraphPath sceneGraphPath) {
        boolean bl;
        block9: {
            bl = true;
            try {
                if (sceneGraphPath == null || this.root != sceneGraphPath.root || this.item != sceneGraphPath.item) {
                    return false;
                }
                bl = this.transform.equals(sceneGraphPath.transform);
                if (!bl) {
                    return false;
                }
                if (this.interior == null || sceneGraphPath.interior == null) {
                    if (this.interior != sceneGraphPath.interior) {
                        return false;
                    }
                    bl = this.root == sceneGraphPath.root && this.item == sceneGraphPath.item;
                    break block9;
                }
                if (this.interior.length == sceneGraphPath.interior.length) {
                    int n = 0;
                    while (n < this.interior.length) {
                        if (this.interior[n] != sceneGraphPath.interior[n]) {
                            return false;
                        }
                        ++n;
                    }
                    break block9;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        try {
            SceneGraphPath sceneGraphPath = (SceneGraphPath)object;
            if (sceneGraphPath == null || this.root != sceneGraphPath.root || this.item != sceneGraphPath.item) {
                return false;
            }
            bl = this.transform.equals(sceneGraphPath.transform);
            if (!bl) {
                return false;
            }
            if (this.interior == null || sceneGraphPath.interior == null) {
                if (this.interior != sceneGraphPath.interior) {
                    return false;
                }
                bl = this.root == sceneGraphPath.root && this.item == sceneGraphPath.item;
            } else if (this.interior.length == sceneGraphPath.interior.length) {
                int n = 0;
                while (n < this.interior.length) {
                    if (this.interior[n] != sceneGraphPath.interior[n]) {
                        return false;
                    }
                    ++n;
                }
            } else {
                return false;
            }
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        HashKey hashKey = new HashKey(250);
        if (this.interior != null && this.item != null) {
            int n = 0;
            while (n < this.interior.length) {
                hashKey.append(LinkRetained.plus).append(this.item.toString());
                ++n;
            }
        }
        return hashKey.hashCode() + this.transform.hashCode();
    }

    public final boolean isSamePath(SceneGraphPath sceneGraphPath) {
        int n = 0;
        if (sceneGraphPath == null || sceneGraphPath.item != this.item || this.root != sceneGraphPath.root) {
            return false;
        }
        if (this.interior != null && sceneGraphPath.interior != null) {
            int n2 = 0;
            while (n2 < this.interior.length) {
                if (this.interior[n2] instanceof Link) {
                    while (n < sceneGraphPath.interior.length) {
                        if (sceneGraphPath.interior[n] instanceof Link) {
                            if (sceneGraphPath.interior[n] != this.interior[n2]) {
                                return false;
                            }
                            ++n;
                            break;
                        }
                        if (++n != sceneGraphPath.interior.length) continue;
                        return false;
                    }
                }
                ++n2;
            }
            while (n < sceneGraphPath.interior.length) {
                if (sceneGraphPath.interior[n] instanceof Link) {
                    return false;
                }
                ++n;
            }
        } else if (this.interior != sceneGraphPath.interior) {
            return false;
        }
        return true;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.root == null && this.interior == null && this.item == null) {
            return super.toString();
        }
        if (this.root != null) {
            stringBuffer.append(this.root + " : ");
        }
        if (this.interior != null) {
            int n = 0;
            while (n < this.interior.length) {
                stringBuffer.append(this.interior[n].getClass().getName());
                object = this.interior[n].getUserData();
                if (object == null) {
                    stringBuffer.append(" : ");
                } else {
                    stringBuffer.append(", " + object + " : ");
                }
                ++n;
            }
        }
        if (this.item != null) {
            stringBuffer.append(this.item.getClass().getName());
            object = this.item.getUserData();
            if (object != null) {
                stringBuffer.append(", " + object);
            }
            try {
                if (this.item.getClass().getName().equals("javax.media.j3d.Shape3D")) {
                    stringBuffer.append(((Shape3D)this.item).getGeometry());
                }
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                // empty catch block
            }
        }
        stringBuffer.append("\nLocalToVworld Transform:\n" + this.transform);
        return new String(stringBuffer);
    }

    /*
     * Unable to fully structure code
     */
    boolean validate() {
        var1_1 = (NodeRetained)this.item.retained;
        var2_2 = var1_1.locale;
        if (this.root != null) {
            if (this.item.isLive() && var2_2 != this.root) {
                return false;
            }
        } else {
            this.root = var2_2;
        }
        v0 = var3_3 = this.interior == null ? 0 : this.interior.length;
        do {
            block6: {
                if (!(var1_1 instanceof SharedGroupRetained)) break block6;
                if (this.interior != null) ** GOTO lbl-1000
                return false;
                while (!((SharedGroupRetained)var1_1).parents.contains(this.interior[var3_3].retained)) lbl-1000:
                // 2 sources

                {
                    if (--var3_3 > 0) continue;
                }
                if (var3_3 < 0) {
                    return false;
                }
                var1_1 = (NodeRetained)this.interior[var3_3].retained;
                continue;
            }
            var1_1 = var1_1.parent;
        } while (var1_1 != null);
        return true;
    }

    void getHashKey(HashKey hashKey) {
        if (this.interior != null) {
            hashKey.reset();
            hashKey.append(this.root.nodeId);
            int n = 0;
            while (n < this.interior.length) {
                Node node = this.interior[n];
                if (!node.isLive()) {
                    throw new RuntimeException(J3dI18N.getString("SceneGraphPath3"));
                }
                NodeRetained nodeRetained = (NodeRetained)node.retained;
                if (nodeRetained.nodeType == 9) {
                    hashKey.append("+").append(nodeRetained.nodeId);
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean validate(HashKey var1_1) {
        block13: {
            if (this.root == null) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath2"));
            }
            if (this.item == null) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath10"));
            }
            if (!this.item.isLive()) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath3"));
            }
            try {
                this.getHashKey(var1_1);
            }
            catch (RuntimeException var3_2) {
                throw new IllegalArgumentException(var3_2.getMessage());
            }
            var5_4 = null;
            var7_5 = false;
            var3_3 = (NodeRetained)this.item.retained;
            if (this.interior == null) break block13;
            var2_6 = this.interior.length - 1;
            while (var2_6 >= 0) {
                block14: {
                    var5_4 = (NodeRetained)this.interior[var2_6].retained;
                    var4_7 = var3_3.parent;
                    if (var4_7 != null || !(var3_3 instanceof SharedGroupRetained)) ** GOTO lbl35
                    if (!((SharedGroupRetained)var3_3).parents.contains(var5_4)) break block14;
                    var4_7 = var5_4;
                    if (true) ** GOTO lbl35
                }
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                do {
                    if (var4_7 == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath11"));
                    }
                    if (var4_7 instanceof SharedGroupRetained) {
                        if (((SharedGroupRetained)var4_7).parents.contains(var5_4)) {
                            var4_7 = var5_4;
                            continue;
                        }
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                    }
                    var4_7 = var4_7.parent;
lbl35:
                    // 4 sources

                } while (var4_7 != var5_4);
                var3_3 = var4_7;
                --var2_6;
            }
        }
        if ((var4_7 = var3_3.parent) != null || !(var3_3 instanceof SharedGroupRetained)) ** GOTO lbl48
        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
lbl-1000:
        // 1 sources

        {
            if (var4_7 instanceof LinkRetained) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
            }
            var3_3 = var4_7;
            var4_7 = var4_7.parent;
            if (var4_7 != null || !(var3_3 instanceof SharedGroupRetained)) continue;
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
lbl48:
            // 2 sources

            ** while (var4_7 != null)
        }
lbl49:
        // 1 sources

        var6_8 = (Node)var3_3.source;
        if (!this.root.branchGroups.contains(var6_8)) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath9"));
        }
        return true;
    }

    double getDistanceFrom(Point3d point3d) {
        return this.intersectPoint.distance(point3d);
    }

    double getDistance() {
        return this.pickDistance;
    }

    final void setIntersectPoint(Point3d point3d) {
        this.intersectPoint.set(point3d);
    }

    final void setIntersectPointDis(Point4d point4d) {
        this.intersectPoint.x = point4d.x;
        this.intersectPoint.y = point4d.y;
        this.intersectPoint.z = point4d.z;
        this.pickDistance = point4d.w;
    }

    final Point3d getIntersectPoint() {
        return this.intersectPoint;
    }
}

