/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

class RasterRetained
extends GeometryRetained {
    int type = 1;
    int clipMode = 0;
    Point3f position = new Point3f();
    int xSrcOffset = 0;
    int ySrcOffset = 0;
    private int xOffset = 0;
    private int yOffset = 0;
    int width = 0;
    int height = 0;
    int xDstOffset = 0;
    int yDstOffset = 0;
    ImageComponent2DRetained image = null;
    DepthComponentRetained depthComponent = null;
    float lastAlpha = 1.0f;
    private Point3d adjPos;
    private Point2d winCoord;
    private Transform3D vwip;
    private boolean validVwip;

    RasterRetained() {
        this.geoType = 15;
        this.vwip = new Transform3D();
        this.adjPos = new Point3d();
        this.winCoord = new Point2d();
    }

    final void setPosition(Point3f point3f) {
        this.geomLock.getLock();
        this.position.x = point3f.x;
        this.position.y = point3f.y;
        this.position.z = point3f.z;
        this.geomLock.unLock();
        this.sendChangedMessage(64, null, null);
    }

    final void getPosition(Point3f point3f) {
        point3f.x = this.position.x;
        point3f.y = this.position.y;
        point3f.z = this.position.z;
    }

    final void setType(int n) {
        this.geomLock.getLock();
        this.type = n;
        this.geomLock.unLock();
    }

    final int getType() {
        return this.type;
    }

    final void setClipMode(int n) {
        this.geomLock.getLock();
        this.clipMode = n;
        this.geomLock.unLock();
        this.computeBoundingBox();
        if (this.source.isLive()) {
            int n2 = this.userLists.size();
            int n3 = 0;
            while (n3 < n2) {
                ArrayList arrayList = (ArrayList)this.userLists.get(n3);
                int n4 = arrayList.size();
                int n5 = 0;
                while (n5 < n4) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(n5);
                    Shape3DRetained shape3DRetained2 = (Shape3DRetained)shape3DRetained.sourceNode;
                    shape3DRetained2.setBoundsAutoCompute(false);
                    shape3DRetained2.setBounds(this.geoBounds);
                    ++n5;
                }
                ++n3;
            }
        }
    }

    final int getClipMode() {
        return this.clipMode;
    }

    final void setSrcOffset(int n, int n2) {
        this.geomLock.getLock();
        this.xSrcOffset = n;
        this.ySrcOffset = n2;
        this.geomLock.unLock();
    }

    final void getSrcOffset(Point point) {
        point.setLocation(this.xSrcOffset, this.ySrcOffset);
    }

    final void setSize(int n, int n2) {
        this.geomLock.getLock();
        this.width = n;
        this.height = n2;
        this.geomLock.unLock();
    }

    final void getSize(Dimension dimension) {
        dimension.setSize(this.width, this.height);
    }

    final void setDstOffset(int n, int n2) {
        this.geomLock.getLock();
        this.xDstOffset = n;
        this.yDstOffset = n2;
        this.geomLock.unLock();
    }

    final void getDstOffset(Point point) {
        point.setLocation(this.xDstOffset, this.yDstOffset);
    }

    final void setImage(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained = this.image;
        if (this.source.isLive()) {
            if (this.image != null) {
                this.image.clearLive(this.refCount);
            }
            if (imageComponent2D != null) {
                ((ImageComponent2DRetained)imageComponent2D.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.geomLock.getLock();
        if (imageComponent2D != null) {
            ImageComponent2DRetained imageComponent2DRetained2 = (ImageComponent2DRetained)imageComponent2D.retained;
            imageComponent2DRetained2.setRasterRef();
            this.image = imageComponent2DRetained2;
        } else {
            this.image = null;
        }
        this.lastAlpha = 1.0f;
        this.geomLock.unLock();
        this.sendChangedMessage(1152, imageComponent2DRetained, this.image);
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void setDepthComponent(DepthComponent depthComponent) {
        if (this.source.isLive()) {
            if (this.depthComponent != null) {
                this.depthComponent.clearLive(this.refCount);
            }
            if (depthComponent != null) {
                ((DepthComponentRetained)depthComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.geomLock.getLock();
        this.depthComponent = depthComponent == null ? null : (DepthComponentRetained)depthComponent.retained;
        this.geomLock.unLock();
    }

    final DepthComponent getDepthComponent() {
        return this.depthComponent == null ? null : (DepthComponent)this.depthComponent.source;
    }

    void setLive(boolean bl, int n) {
        super.doSetLive(bl, n);
        if (this.image != null) {
            this.image.setLive(bl, n);
        }
        if (this.depthComponent != null) {
            this.depthComponent.setLive(bl, n);
        }
        this.isEditable = this.source.getCapability(3) || this.source.getCapability(1) || (this.type & 1) != 0 && this.source.getCapability(5) || (this.type & 2) != 0 && this.source.getCapability(7) || this.source.getCapability(9);
        super.markAsLive();
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.image != null) {
            this.image.clearLive(n);
        }
        if (this.depthComponent != null) {
            this.depthComponent.clearLive(n);
        }
    }

    void computeBoundingBox() {
        if (this.clipMode == 1) {
            Point3d point3d = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Point3d point3d2 = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.geoBounds.setUpper(point3d2);
            this.geoBounds.setLower(point3d);
        } else {
            Point3d point3d = new Point3d();
            point3d.x = this.position.x;
            point3d.y = this.position.y;
            point3d.z = this.position.z;
            this.geoBounds.setUpper(point3d);
            this.geoBounds.setLower(point3d);
        }
    }

    void update() {
        this.computeBoundingBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedMessage(int n, Object object, Object object2) {
        Object object3 = this.liveStateLock;
        synchronized (object3) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int n2 = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        j3dMessageArray[n3] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n3].type = 17;
                        j3dMessageArray[n3].threads = n;
                        j3dMessageArray[n3].args[0] = Shape3DRetained.getGeomAtomsArray((ArrayList)this.userLists.get(n3));
                        j3dMessageArray[n3].args[1] = this;
                        Object[] objectArray = new Object[]{object, object2};
                        j3dMessageArray[n3].args[2] = objectArray;
                        j3dMessageArray[n3].args[3] = new Integer(this.changedFrequent);
                        j3dMessageArray[n3].universe = (VirtualUniverse)this.universeList.get(n3);
                        ++n3;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    native void execute(long var1, GeometryRetained var3, boolean var4, float var5, int var6, int var7, int var8, int var9, int var10, float var11, float var12, float var13, byte[] var14);

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int n2) {
        this.validVwip = true;
        this.adjPos.set(this.position.x, this.position.y, this.position.z);
        if (this.xDstOffset != 0 || this.yDstOffset != 0) {
            this.getOffsetPos(canvas3D, renderAtom, this.adjPos);
        }
        this.xOffset = this.xSrcOffset;
        this.yOffset = this.ySrcOffset;
        if (this.clipMode == 1) {
            this.clipImage(canvas3D, renderAtom, this.adjPos);
        }
        if (!this.validVwip) {
            return;
        }
        if (this.image != null && !this.image.imageYdownCacheDirty && this.image != null && this.image.imageYdown[0] != null) {
            if (bl2) {
                this.image.updateAlpha(canvas3D, n, f);
                this.execute(canvas3D.ctx, this, bl2, f, this.type, this.width, this.height, this.xOffset, this.yOffset, (float)this.adjPos.x, (float)this.adjPos.y, (float)this.adjPos.z, this.image.imageYdown[n]);
            } else {
                this.execute(canvas3D.ctx, this, bl2, f, this.type, this.width, this.height, this.xOffset, this.yOffset, (float)this.adjPos.x, (float)this.adjPos.y, (float)this.adjPos.z, this.image.imageYdown[0]);
            }
        }
    }

    private void getOffsetPos(Canvas3D canvas3D, RenderAtom renderAtom, Point3d point3d) {
        this.computeWinCoord(canvas3D, renderAtom, this.winCoord, point3d);
        this.winCoord.x -= (double)this.xDstOffset;
        this.winCoord.y -= (double)this.yDstOffset;
        this.computeObjCoord(canvas3D, this.winCoord, point3d);
    }

    private void clipImage(Canvas3D canvas3D, RenderAtom renderAtom, Point3d point3d) {
        if (this.xDstOffset == 0 && this.yDstOffset == 0) {
            double d = point3d.x;
            double d2 = point3d.y;
            double d3 = point3d.z;
            this.computeWinCoord(canvas3D, renderAtom, this.winCoord, point3d);
            if (this.winCoord.x > 0.0 && this.winCoord.y > 0.0) {
                point3d.x = d;
                point3d.y = d2;
                point3d.z = d3;
                return;
            }
        } else if (this.winCoord.x > 0.0 && this.winCoord.y > 0.0) {
            return;
        }
        if (this.winCoord.x < 1.0) {
            this.xOffset = (int)(-this.winCoord.x) + 1;
            this.winCoord.x = 1.0;
        }
        if (this.winCoord.y < 1.0) {
            this.yOffset = (int)(-this.winCoord.y) + 1;
            this.winCoord.y = 1.0;
        }
        if (this.xOffset < this.xSrcOffset) {
            this.xOffset = this.xSrcOffset;
        }
        if (this.yOffset < this.ySrcOffset) {
            this.yOffset = this.ySrcOffset;
        }
        if (this.xDstOffset == 0 && this.yDstOffset == 0) {
            this.computeObjCoord(canvas3D, this.winCoord, point3d);
        } else {
            canvas3D.getPixelLocationInImagePlate(this.winCoord.x, this.winCoord.y, point3d.z, point3d);
            this.vwip.transform(point3d);
        }
    }

    private void computeObjCoord(Canvas3D canvas3D, Point2d point2d, Point3d point3d) {
        canvas3D.getPixelLocationInImagePlate(point2d.x, point2d.y, point3d.z, point3d);
        this.vwip.invert();
        this.vwip.transform(point3d);
    }

    private void computeWinCoord(Canvas3D canvas3D, RenderAtom renderAtom, Point2d point2d, Point3d point3d) {
        RenderMolecule renderMolecule = renderAtom.renderMolecule;
        if (renderMolecule == null) {
            this.validVwip = false;
            return;
        }
        Transform3D transform3D = renderMolecule.localToVworld[renderMolecule.localToVworldIndex[0]];
        canvas3D.getLastVworldToImagePlate(this.vwip);
        this.vwip.mul(transform3D);
        this.vwip.transform(point3d);
        canvas3D.getPixelLocationFromImagePlate(point3d, point2d);
    }

    int getClassType() {
        return 5;
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
    }

    boolean intersect(PickShape pickShape, double[] dArray, Point3d point3d) {
        return false;
    }

    boolean intersect(Bounds bounds) {
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        return false;
    }

    void handleFrequencyChange(int n) {
        if (n == 5) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

