/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingPolytope
extends Bounds {
    Vector4d[] planes;
    double[] mag;
    double[] pDotN;
    Point3d[] verts;
    int nVerts;
    Point3d centroid = new Point3d();
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;

    public BoundingPolytope(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.boundId = 4;
        this.planes = new Vector4d[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        int n = 0;
        while (n < vector4dArray.length) {
            this.mag[n] = Math.sqrt(vector4dArray[n].x * vector4dArray[n].x + vector4dArray[n].y * vector4dArray[n].y + vector4dArray[n].z * vector4dArray[n].z);
            double d = 1.0 / this.mag[n];
            this.planes[n] = new Vector4d(vector4dArray[n].x * d, vector4dArray[n].y * d, vector4dArray[n].z * d, vector4dArray[n].w * d);
            ++n;
        }
        this.computeAllVerts();
    }

    public BoundingPolytope() {
        this.boundId = 4;
        this.planes = new Vector4d[6];
        this.mag = new double[this.planes.length];
        this.pDotN = new double[this.planes.length];
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.computeAllVerts();
    }

    public BoundingPolytope(Bounds bounds) {
        this.boundId = 4;
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(boundingSphere.center.x + boundingSphere.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingSphere.center.x - boundingSphere.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(boundingSphere.center.y + boundingSphere.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingSphere.center.y - boundingSphere.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(boundingSphere.center.z + boundingSphere.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingSphere.center.z - boundingSphere.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.planes = new Vector4d[6];
            this.pDotN = new double[this.planes.length];
            this.mag = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -boundingBox.upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingBox.lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -boundingBox.upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingBox.lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -boundingBox.upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingBox.lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.planes = new Vector4d[boundingPolytope.planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            int n = 0;
            while (n < this.planes.length) {
                this.planes[n] = new Vector4d(boundingPolytope.planes[n]);
                this.mag[n] = boundingPolytope.mag[n];
                this.pDotN[n] = boundingPolytope.pDotN[n];
                ++n;
            }
            n = 0;
            while (n < this.verts.length) {
                this.verts[n] = new Point3d(boundingPolytope.verts[n]);
                ++n;
            }
            this.centroid = boundingPolytope.centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope0"));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BoundingPolytope(Bounds[] var1_1) {
        super();
        var2_2 = 0;
        this.boundId = 4;
        if (var1_1 != null && var1_1.length > 0) ** GOTO lbl13
        this.boundsIsEmpty = true;
        this.boundsIsInfinite = false;
        this.initEmptyPolytope();
        this.computeAllVerts();
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl13:
            // 2 sources

            ** while (var1_1[var2_2] == null && var2_2 < var1_1.length)
        }
lbl14:
        // 1 sources

        if (var2_2 >= var1_1.length) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = var1_1[var2_2].boundsIsEmpty;
        this.boundsIsInfinite = var1_1[var2_2].boundsIsInfinite;
        if (var1_1[var2_2].boundId == 2) {
            var3_3 /* !! */  = (BoundingSphere)var1_1[var2_2];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(var3_3 /* !! */ .center.x + var3_3 /* !! */ .radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, var3_3 /* !! */ .center.x - var3_3 /* !! */ .radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(var3_3 /* !! */ .center.y + var3_3 /* !! */ .radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, var3_3 /* !! */ .center.y - var3_3 /* !! */ .radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(var3_3 /* !! */ .center.z + var3_3 /* !! */ .radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, var3_3 /* !! */ .center.z - var3_3 /* !! */ .radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (var1_1[var2_2].boundId == 1) {
            var3_3 /* !! */  = (BoundingBox)var1_1[var2_2];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -var3_3 /* !! */ .upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, var3_3 /* !! */ .lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -var3_3 /* !! */ .upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, var3_3 /* !! */ .lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -var3_3 /* !! */ .upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, var3_3 /* !! */ .lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (var1_1[var2_2].boundId == 4) {
            var3_3 /* !! */  = (BoundingPolytope)var1_1[var2_2];
            this.planes = new Vector4d[var3_3 /* !! */ .planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = var3_3 /* !! */ .nVerts;
            this.verts = new Point3d[this.nVerts];
            var2_2 = 0;
            while (var2_2 < this.planes.length) {
                this.planes[var2_2] = new Vector4d(var3_3 /* !! */ .planes[var2_2]);
                this.pDotN[var2_2] = var3_3 /* !! */ .pDotN[var2_2];
                this.mag[var2_2] = var3_3 /* !! */ .mag[var2_2];
                ++var2_2;
            }
            var2_2 = 0;
            while (var2_2 < this.verts.length) {
                this.verts[var2_2] = new Point3d(var3_3 /* !! */ .verts[var2_2]);
                ++var2_2;
            }
            this.centroid = var3_3 /* !! */ .centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope1"));
        }
        ++var2_2;
        while (var2_2 < var1_1.length) {
            this.combine(var1_1[var2_2]);
            ++var2_2;
        }
    }

    public void setPlanes(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.planes = new Vector4d[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.boundsIsEmpty = false;
        if (vector4dArray.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        int n = 0;
        while (n < vector4dArray.length) {
            this.mag[n] = Math.sqrt(vector4dArray[n].x * vector4dArray[n].x + vector4dArray[n].y * vector4dArray[n].y + vector4dArray[n].z * vector4dArray[n].z);
            double d = 1.0 / this.mag[n];
            this.planes[n] = new Vector4d(vector4dArray[n].x * d, vector4dArray[n].y * d, vector4dArray[n].z * d, vector4dArray[n].w * d);
            ++n;
        }
        this.computeAllVerts();
    }

    public void getPlanes(Vector4d[] vector4dArray) {
        int n = 0;
        while (n < vector4dArray.length) {
            vector4dArray[n].x = this.planes[n].x * this.mag[n];
            vector4dArray[n].y = this.planes[n].y * this.mag[n];
            vector4dArray[n].z = this.planes[n].z * this.mag[n];
            vector4dArray[n].w = this.planes[n].w * this.mag[n];
            ++n;
        }
    }

    public int getNumPlanes() {
        return this.planes.length;
    }

    public void set(Bounds bounds) {
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            int n = 0;
            while (n < this.planes.length) {
                this.planes[n].w = -(boundingSphere.center.x * this.planes[n].x + boundingSphere.center.y * this.planes[n].y + boundingSphere.center.z * this.planes[n].z + boundingSphere.radius);
                ++n;
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            int n = 0;
            while (n < this.planes.length) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8 = boundingBox.upper.x * this.planes[n].x;
                double d9 = boundingBox.upper.y * this.planes[n].y;
                double d10 = boundingBox.upper.z * this.planes[n].z;
                double d11 = boundingBox.lower.x * this.planes[n].x;
                double d12 = boundingBox.lower.y * this.planes[n].y;
                double d13 = boundingBox.lower.z * this.planes[n].z;
                this.planes[n].w = -(d8 + d9 + d10);
                double d14 = d8 + d9 + d13;
                if (d7 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d8 + d12 + d10;
                if (d6 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d8 + d12 + d13;
                if (d5 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d11 + d9 + d10;
                if (d4 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d11 + d9 + d13;
                if (d3 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d11 + d12 + d10;
                if (d2 + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                d14 = d11 + d12 + d13;
                if (d + this.planes[n].w > 0.0) {
                    this.planes[n].w = -d14;
                }
                ++n;
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            int n;
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.planes.length != boundingPolytope.planes.length) {
                this.planes = new Vector4d[boundingPolytope.planes.length];
                n = 0;
                while (n < boundingPolytope.planes.length) {
                    this.planes[n] = new Vector4d();
                    ++n;
                }
                this.mag = new double[boundingPolytope.planes.length];
                this.pDotN = new double[boundingPolytope.planes.length];
            }
            int n2 = 0;
            while (n2 < boundingPolytope.planes.length) {
                this.planes[n2].x = boundingPolytope.planes[n2].x;
                this.planes[n2].y = boundingPolytope.planes[n2].y;
                this.planes[n2].z = boundingPolytope.planes[n2].z;
                this.planes[n2].w = boundingPolytope.planes[n2].w;
                this.mag[n2] = boundingPolytope.mag[n2];
                ++n2;
            }
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            n = 0;
            while (n < this.nVerts) {
                this.verts[n] = new Point3d(boundingPolytope.verts[n]);
                ++n;
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope2"));
        }
    }

    public Object clone() {
        return new BoundingPolytope(this.planes);
    }

    public boolean equals(Object object) {
        try {
            BoundingPolytope boundingPolytope = (BoundingPolytope)object;
            if (this.planes.length != boundingPolytope.planes.length) {
                return false;
            }
            int n = 0;
            while (n < this.planes.length) {
                if (!this.planes[n].equals(boundingPolytope.planes[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        int n = 0;
        while (n < this.planes.length) {
            l = 31L * l + Double.doubleToLongBits(this.planes[n].x);
            l = 31L * l + Double.doubleToLongBits(this.planes[n].y);
            l = 31L * l + Double.doubleToLongBits(this.planes[n].z);
            l = 31L * l + Double.doubleToLongBits(this.planes[n].w);
            ++n;
        }
        return (int)(l ^ l >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            int n = 0;
            while (n < this.planes.length) {
                double d = boundingSphere.radius + boundingSphere.center.x * this.planes[n].x + boundingSphere.center.y * this.planes[n].y + boundingSphere.center.z * this.planes[n].z + this.planes[n].w;
                if (d > 0.0) {
                    this.planes[n].w += -d;
                }
                ++n;
            }
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (!this.allocBoxVerts) {
                this.boxVerts = new Point3d[8];
                int n = 0;
                while (n < 8) {
                    this.boxVerts[n] = new Point3d();
                    ++n;
                }
                this.allocBoxVerts = true;
            }
            this.boxVerts[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[2].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[3].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[4].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[5].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
            this.boxVerts[6].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[7].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
            this.combine(this.boxVerts);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope3"));
        }
        this.computeAllVerts();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void combine(Bounds[] var1_1) {
        var2_2 = 0;
        if (var1_1 != null && var1_1.length > 0 && !this.boundsIsInfinite) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl5:
            // 2 sources

            ** while (var2_2 < var1_1.length && (var1_1[var2_2] == null || var1_1[var2_2].boundsIsEmpty))
        }
lbl6:
        // 1 sources

        if (var2_2 >= var1_1.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(var1_1[var2_2++]);
        }
        if (!this.boundsIsInfinite) ** GOTO lbl53
        return;
lbl-1000:
        // 1 sources

        {
            if (var1_1[var2_2] != null && !var1_1[var2_2].boundsIsEmpty) {
                if (var1_1[var2_2].boundsIsInfinite) {
                    this.set(var1_1[var2_2]);
                    break;
                }
                if (var1_1[var2_2].boundId == 2) {
                    var5_4 /* !! */  = (BoundingSphere)var1_1[var2_2];
                    var6_5 = 0;
                    while (var6_5 < this.planes.length) {
                        var3_3 = var5_4 /* !! */ .radius + var5_4 /* !! */ .center.x * this.planes[var6_5].x + var5_4 /* !! */ .center.y * this.planes[var6_5].y + var5_4 /* !! */ .center.z * this.planes[var6_5].z + this.planes[var6_5].w;
                        if (var3_3 > 0.0) {
                            this.planes[var6_5].w += -var3_3;
                        }
                        ++var6_5;
                    }
                } else if (var1_1[var2_2].boundId == 1) {
                    var5_4 /* !! */  = (BoundingBox)var1_1[var2_2];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        var6_5 = 0;
                        while (var6_5 < 8) {
                            this.boxVerts[var6_5] = new Point3d();
                            ++var6_5;
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(var5_4 /* !! */ .lower.x, var5_4 /* !! */ .lower.y, var5_4 /* !! */ .lower.z);
                    this.boxVerts[1].set(var5_4 /* !! */ .lower.x, var5_4 /* !! */ .upper.y, var5_4 /* !! */ .lower.z);
                    this.boxVerts[2].set(var5_4 /* !! */ .upper.x, var5_4 /* !! */ .lower.y, var5_4 /* !! */ .lower.z);
                    this.boxVerts[3].set(var5_4 /* !! */ .upper.x, var5_4 /* !! */ .upper.y, var5_4 /* !! */ .lower.z);
                    this.boxVerts[4].set(var5_4 /* !! */ .lower.x, var5_4 /* !! */ .lower.y, var5_4 /* !! */ .upper.z);
                    this.boxVerts[5].set(var5_4 /* !! */ .lower.x, var5_4 /* !! */ .upper.y, var5_4 /* !! */ .upper.z);
                    this.boxVerts[6].set(var5_4 /* !! */ .upper.x, var5_4 /* !! */ .lower.y, var5_4 /* !! */ .upper.z);
                    this.boxVerts[7].set(var5_4 /* !! */ .upper.x, var5_4 /* !! */ .upper.y, var5_4 /* !! */ .upper.z);
                    this.combine(this.boxVerts);
                } else if (var1_1[var2_2] instanceof BoundingPolytope) {
                    var5_4 /* !! */  = (BoundingPolytope)var1_1[var2_2];
                    this.combine(var5_4 /* !! */ .verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope4"));
                }
            }
            this.computeAllVerts();
            ++var2_2;
lbl53:
            // 2 sources

            ** while (var2_2 < var1_1.length)
        }
lbl54:
        // 2 sources

    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = 1;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3d.x, point3d.y, point3d.z);
            int n = 0;
            while (n < this.planes.length) {
                this.pDotN[n] = 0.0;
                ++n;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3d.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3d.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3d.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3d.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3d.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3d.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3d.x;
            this.centroid.y = point3d.y;
            this.centroid.z = point3d.z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        } else {
            int n = 0;
            while (n < this.planes.length) {
                double d = point3d.x * this.planes[n].x + point3d.y * this.planes[n].y + point3d.z * this.planes[n].z + this.planes[n].w;
                if (d > 0.0) {
                    this.planes[n].w += -d;
                }
                ++n;
            }
            this.computeAllVerts();
        }
    }

    public void combine(Point3d[] point3dArray) {
        int n;
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = point3dArray.length;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3dArray[0].x, point3dArray[0].y, point3dArray[0].z);
            n = 0;
            while (n < this.planes.length) {
                this.pDotN[n] = 0.0;
                ++n;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3dArray[0].x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3dArray[0].x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3dArray[0].y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3dArray[0].y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3dArray[0].z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3dArray[0].z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3dArray[0].x;
            this.centroid.y = point3dArray[0].y;
            this.centroid.z = point3dArray[0].z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            n = 0;
            while (n < this.planes.length) {
                double d = point3dArray[n2].x * this.planes[n].x + point3dArray[n2].y * this.planes[n].y + point3dArray[n2].z * this.planes[n].z + this.planes[n].w;
                if (d > 0.0) {
                    this.planes[n].w += -d;
                }
                ++n;
            }
            ++n2;
        }
        this.computeAllVerts();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = new BoundingSphere((BoundingSphere)bounds);
            boundingSphere.transform(transform3D);
            this.set(boundingSphere);
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox((BoundingBox)bounds);
            boundingBox.transform(transform3D);
            this.set(boundingBox);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            boundingPolytope.transform(transform3D);
            this.set(boundingPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope5"));
        }
    }

    public void transform(Transform3D transform3D) {
        if (this.boundsIsInfinite) {
            return;
        }
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(transform3D);
        transform3D2.invert();
        transform3D2.transpose();
        int n = 0;
        while (n < this.planes.length) {
            this.planes[n].x *= this.mag[n];
            this.planes[n].y *= this.mag[n];
            this.planes[n].z *= this.mag[n];
            this.planes[n].w *= this.mag[n];
            transform3D2.transform(this.planes[n]);
            ++n;
        }
        VirtualUniverse.mc.addToTransformFreeList(transform3D2);
        n = 0;
        while (n < this.planes.length) {
            this.mag[n] = Math.sqrt(this.planes[n].x * this.planes[n].x + this.planes[n].y * this.planes[n].y + this.planes[n].z * this.planes[n].z);
            double d = 1.0 / this.mag[n];
            this.planes[n] = new Vector4d(this.planes[n].x * d, this.planes[n].y * d, this.planes[n].z * d, this.planes[n].w * d);
            ++n;
        }
        n = 0;
        while (n < this.verts.length) {
            transform3D.transform(this.verts[n]);
            ++n;
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        double d = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d2 = vector3d.x * d;
        double d3 = vector3d.y * d;
        double d4 = vector3d.z * d;
        int n = 0;
        while (n < this.planes.length) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.planes[n].x * d2 + this.planes[n].y * d3 + this.planes[n].z * d4;
            double d10 = -(this.planes[n].x * point3d.x + this.planes[n].y * point3d.y + this.planes[n].z * point3d.z + this.planes[n].w);
            if (d9 != 0.0 && (d8 = d10 / d9) >= 0.0 && this.pointInPolytope(d7 = point3d.x + d2 * d8, d6 = point3d.y + d3 * d8, d5 = point3d.z + d4 * d8)) {
                point3d2.x = d7;
                point3d2.y = d6;
                point3d2.z = d5;
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d2 = vector3d.x * d;
        double d3 = vector3d.y * d;
        double d4 = vector3d.z * d;
        int n = 0;
        while (n < this.planes.length) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.planes[n].x * d2 + this.planes[n].y * d3 + this.planes[n].z * d4;
            double d10 = -(this.planes[n].x * point3d.x + this.planes[n].y * point3d.y + this.planes[n].z * point3d.z + this.planes[n].w);
            if (d9 != 0.0 && (d8 = d10 / d9) >= 0.0 && this.pointInPolytope(d7 = point3d.x + d2 * d8, d6 = point3d.y + d3 * d8, d5 = point3d.z + d4 * d8)) {
                point4d.x = d7;
                point4d.y = d6;
                point4d.z = d5;
                point4d.w = d8;
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        int n = 0;
        while (n < this.planes.length) {
            if (point3d.x * this.planes[n].x + point3d.y * this.planes[n].y + point3d.z * this.planes[n].z + this.planes[n].w > 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Point3d point3d3 = new Point3d();
        point3d3.x = point3d2.x - point3d.x;
        point3d3.y = point3d2.y - point3d.y;
        point3d3.z = point3d2.z - point3d.z;
        int n = 0;
        while (n < this.planes.length) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.planes[n].x * point3d3.x + this.planes[n].y * point3d3.y + this.planes[n].z * point3d3.z;
            double d6 = -(this.planes[n].x * point3d.x + this.planes[n].y * point3d.y + this.planes[n].z * point3d.z + this.planes[n].w);
            if (d5 != 0.0 && (d4 = d6 / d5) >= 0.0 && this.pointInPolytope(d3 = point3d.x + point3d3.x * d4, d2 = point3d.y + point3d3.y * d4, d = point3d.z + point3d3.z * d4) && d4 <= 1.0) {
                point4d.x = d3;
                point4d.y = d2;
                point4d.z = d;
                point4d.w = d4;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        int n = 0;
        while (n < this.planes.length) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.planes[n].x * vector3d.x + this.planes[n].y * vector3d.y + this.planes[n].z * vector3d.z;
            double d6 = -(this.planes[n].x * point3d.x + this.planes[n].y * point3d.y + this.planes[n].z * point3d.z + this.planes[n].w);
            if (d5 != 0.0 && (d4 = d6 / d5) >= 0.0 && this.pointInPolytope(d3 = point3d.x + vector3d.x * d4, d2 = point3d.y + vector3d.y * d4, d = point3d.z + vector3d.z * d4)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty || this.nVerts <= 0;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        int n = 0;
        while (n < this.planes.length) {
            if (point3d.x * this.planes[n].x + point3d.y * this.planes[n].y + point3d.z * this.planes[n].z + this.planes[n].w > 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 2) {
            return this.intersect_ptope_sphere(this, (BoundingSphere)bounds);
        }
        if (bounds.boundId == 1) {
            return this.intersect_ptope_abox(this, (BoundingBox)bounds);
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_ptope(this, (BoundingPolytope)bounds);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        int n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty && (this.boundsIsInfinite || boundsArray[n].boundsIsInfinite)) {
                return true;
            }
            if (boundsArray[n].boundId == 2) {
                BoundingSphere boundingSphere = (BoundingSphere)boundsArray[n];
                double d = boundingSphere.radius;
                d *= d;
                double d2 = boundingSphere.center.distanceSquared(boundingSphere.center);
                if (d2 < d) {
                    return true;
                }
            } else if (boundsArray[n].boundId == 1) {
                if (this.intersect(boundsArray[n])) {
                    return true;
                }
            } else if (boundsArray[n].boundId == 4) {
                if (this.intersect(boundsArray[n])) {
                    return true;
                }
            } else {
                throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope7"));
            }
            ++n;
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingPolytope boundingPolytope) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingPolytope.set(bounds);
            return true;
        }
        if (!this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        if (this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        BoundingBox boundingBox = new BoundingBox();
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.intersect(boundingSphere)) {
                BoundingBox boundingBox2 = new BoundingBox(boundingSphere);
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox4 = (BoundingBox)bounds;
            if (this.intersect(boundingBox4)) {
                BoundingBox boundingBox5 = new BoundingBox(this);
                boundingBox5.intersect((Bounds)boundingBox4, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope2 = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope2)) {
                Vector4d[] vector4dArray = new Vector4d[this.planes.length + boundingPolytope2.planes.length];
                int n = 0;
                while (n < this.planes.length) {
                    vector4dArray[n] = new Vector4d(this.planes[n]);
                    ++n;
                }
                n = 0;
                while (n < boundingPolytope2.planes.length) {
                    vector4dArray[this.planes.length + n] = new Vector4d(boundingPolytope2.planes[n]);
                    ++n;
                }
                BoundingPolytope boundingPolytope3 = new BoundingPolytope(vector4dArray);
                boundingPolytope.set(boundingPolytope3);
                return true;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
        }
        boundingPolytope.boundsIsEmpty = true;
        boundingPolytope.boundsIsInfinite = false;
        boundingPolytope.computeAllVerts();
        return false;
    }

    public boolean intersect(Bounds[] boundsArray, BoundingPolytope boundingPolytope) {
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        int n = 0;
        while (boundsArray[n] == null && n < boundsArray.length) {
            ++n;
        }
        if (n >= boundsArray.length) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        boolean bl = false;
        BoundingBox boundingBox = new BoundingBox();
        n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                Bounds bounds;
                Vector4d[] vector4dArray;
                Bounds bounds2;
                if (boundsArray[n].boundId == 2) {
                    bounds2 = (BoundingSphere)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(bounds2);
                        bounds = new BoundingBox(this);
                        bounds.intersect((Bounds)vector4dArray, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n].boundId == 1) {
                    bounds2 = (BoundingBox)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(this);
                        vector4dArray.intersect(bounds2, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds2 = (BoundingPolytope)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new Vector4d[this.planes.length + ((BoundingPolytope)bounds2).planes.length];
                        n = 0;
                        while (n < this.planes.length) {
                            vector4dArray[n] = new Vector4d(this.planes[n]);
                            ++n;
                        }
                        n = 0;
                        while (n < ((BoundingPolytope)bounds2).planes.length) {
                            vector4dArray[this.planes.length + n] = new Vector4d(((BoundingPolytope)bounds2).planes[n]);
                            ++n;
                        }
                        bounds = new BoundingPolytope(vector4dArray);
                        if (bl) {
                            boundingPolytope.combine(bounds);
                        } else {
                            boundingPolytope.set(bounds);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
                }
            }
            if (boundingPolytope.boundsIsInfinite) break;
            ++n;
        }
        if (!bl) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        boolean bl = false;
        double d = Double.MAX_VALUE;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && this.intersect(boundsArray[n2])) {
                int n3;
                boolean bl2;
                double d5;
                Bounds bounds;
                if (boundsArray[n2] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n2];
                    d5 = Math.sqrt((this.centroid.x - bounds.center.x) * (this.centroid.x - bounds.center.x) + (this.centroid.y - bounds.center.y) * (this.centroid.y - bounds.center.y) + (this.centroid.z - bounds.center.z) * (this.centroid.z - bounds.center.z));
                    bl2 = true;
                    n3 = 0;
                    while (n3 < this.planes.length) {
                        double d6;
                        if (bounds.center.x * this.planes[n3].x + bounds.center.y * this.planes[n3].y + bounds.center.z * this.planes[n3].z + this.planes[n2].w > 0.0 && (d6 = bounds.center.x * this.planes[n3].x + bounds.center.y * this.planes[n3].y + bounds.center.z * this.planes[n3].z + this.planes[n3].w) > bounds.radius) {
                            bl2 = false;
                        }
                        ++n3;
                    }
                    if (bl2) {
                        if (!bl) {
                            n = n2;
                            d = d5;
                            bl = true;
                        } else if (d5 < d) {
                            n = n2;
                            d = d5;
                        }
                    } else if (!bl && d5 < d) {
                        n = n2;
                        d = d5;
                    }
                } else if (boundsArray[n2] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n2];
                    d2 = (((BoundingBox)bounds).upper.x + ((BoundingBox)bounds).lower.x) / 2.0;
                    d3 = (((BoundingBox)bounds).upper.y + ((BoundingBox)bounds).lower.y) / 2.0;
                    d4 = (((BoundingBox)bounds).upper.z + ((BoundingBox)bounds).lower.z) / 2.0;
                    d5 = Math.sqrt((this.centroid.x - d2) * (this.centroid.x - d2) + (this.centroid.y - d3) * (this.centroid.y - d3) + (this.centroid.z - d4) * (this.centroid.z - d4));
                    bl2 = true;
                    if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                        bl2 = false;
                    }
                    if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                        bl2 = false;
                    }
                    if (bl2) {
                        if (!bl) {
                            n = n2;
                            d = d5;
                            bl = true;
                        } else if (d5 < d) {
                            n = n2;
                            d = d5;
                        }
                    } else if (!bl && d5 < d) {
                        n = n2;
                        d = d5;
                    }
                } else if (boundsArray[n2] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n2];
                    d5 = Math.sqrt((this.centroid.x - ((BoundingPolytope)bounds).centroid.x) * (this.centroid.x - ((BoundingPolytope)bounds).centroid.x) + (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) * (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) + (this.centroid.z - ((BoundingPolytope)bounds).centroid.z) * (this.centroid.z - ((BoundingPolytope)bounds).centroid.z));
                    bl2 = true;
                    n3 = 0;
                    while (n3 < ((BoundingPolytope)bounds).nVerts) {
                        if (!this.pointInPolytope(((BoundingPolytope)bounds).verts[n3].x, ((BoundingPolytope)bounds).verts[n3].y, ((BoundingPolytope)bounds).verts[n3].z)) {
                            bl2 = false;
                        }
                        ++n3;
                    }
                    if (bl2) {
                        if (!bl) {
                            n = n2;
                            d = d5;
                            bl = true;
                        } else if (d5 < d) {
                            n = n2;
                            d = d5;
                        }
                    } else if (!bl && d5 < d) {
                        n = n2;
                        d = d5;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope10"));
                }
            }
            ++n2;
        }
        return boundsArray[n];
    }

    public String toString() {
        String string = new String("BoundingPolytope:\n Num Planes =" + this.planes.length);
        int n = 0;
        while (n < this.planes.length) {
            string = string + "\n" + this.mag[n] * this.planes[n].x + " " + this.mag[n] * this.planes[n].y + " " + this.mag[n] * this.planes[n].z + " " + this.mag[n] * this.planes[n].w;
            ++n;
        }
        return string;
    }

    private void computeVertex(int n, int n2, int n3) {
        double d = this.planes[n].x * this.planes[n2].y * this.planes[n3].z + this.planes[n].y * this.planes[n2].z * this.planes[n3].x + this.planes[n].z * this.planes[n2].x * this.planes[n3].y - this.planes[n].z * this.planes[n2].y * this.planes[n3].x - this.planes[n].y * this.planes[n2].x * this.planes[n3].z - this.planes[n].x * this.planes[n2].z * this.planes[n3].y;
        if (d * d < 1.0E-6) {
            return;
        }
        d = 1.0 / d;
        double d2 = (this.planes[n2].y * this.planes[n3].z - this.planes[n2].z * this.planes[n3].y) * this.pDotN[n];
        double d3 = (this.planes[n2].z * this.planes[n3].x - this.planes[n2].x * this.planes[n3].z) * this.pDotN[n];
        double d4 = (this.planes[n2].x * this.planes[n3].y - this.planes[n2].y * this.planes[n3].x) * this.pDotN[n];
        d2 += (this.planes[n3].y * this.planes[n].z - this.planes[n3].z * this.planes[n].y) * this.pDotN[n2];
        d3 += (this.planes[n3].z * this.planes[n].x - this.planes[n3].x * this.planes[n].z) * this.pDotN[n2];
        d4 += (this.planes[n3].x * this.planes[n].y - this.planes[n3].y * this.planes[n].x) * this.pDotN[n2];
        d2 += (this.planes[n].y * this.planes[n2].z - this.planes[n].z * this.planes[n2].y) * this.pDotN[n3];
        d3 += (this.planes[n].z * this.planes[n2].x - this.planes[n].x * this.planes[n2].z) * this.pDotN[n3];
        d4 += (this.planes[n].x * this.planes[n2].y - this.planes[n].y * this.planes[n2].x) * this.pDotN[n3];
        if (this.pointInPolytope(d2 *= d, d3 *= d, d4 *= d)) {
            if (this.nVerts >= this.verts.length) {
                Point3d[] point3dArray = new Point3d[this.nVerts << 1];
                int n4 = 0;
                while (n4 < this.nVerts) {
                    point3dArray[n4] = this.verts[n4];
                    ++n4;
                }
                this.verts = point3dArray;
            }
            this.verts[this.nVerts++] = new Point3d(d2, d3, d4);
        }
    }

    private void computeAllVerts() {
        this.nVerts = 0;
        if (this.boundsIsEmpty) {
            this.verts = null;
            return;
        }
        this.verts = new Point3d[this.planes.length * this.planes.length];
        int n = 0;
        while (n < this.planes.length) {
            this.pDotN[n] = -this.planes[n].x * this.planes[n].w * this.planes[n].x - this.planes[n].y * this.planes[n].w * this.planes[n].y - this.planes[n].z * this.planes[n].w * this.planes[n].z;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.planes.length - 2) {
            int n3 = n2 + 1;
            while (n3 < this.planes.length - 1) {
                int n4 = n3 + 1;
                while (n4 < this.planes.length) {
                    this.computeVertex(n2, n3, n4);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Point3d[] point3dArray = new Point3d[this.nVerts];
        n = 0;
        while (n < this.nVerts) {
            d3 += this.verts[n].x;
            d2 += this.verts[n].y;
            d += this.verts[n].z;
            point3dArray[n] = this.verts[n];
            ++n;
        }
        this.verts = point3dArray;
        this.centroid.x = d3 / (double)this.nVerts;
        this.centroid.y = d2 / (double)this.nVerts;
        this.centroid.z = d / (double)this.nVerts;
        this.checkBoundsIsEmpty();
    }

    private boolean pointInPolytope(double d, double d2, double d3) {
        int n = 0;
        while (n < this.planes.length) {
            if (d * this.planes[n].x + d2 * this.planes[n].y + d3 * this.planes[n].z + this.planes[n].w > 1.0E-6) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void checkBoundsIsEmpty() {
        this.boundsIsEmpty = this.planes.length < 4;
    }

    private void initEmptyPolytope() {
        this.planes = new Vector4d[6];
        this.pDotN = new double[6];
        this.mag = new double[6];
        this.verts = new Point3d[this.planes.length * this.planes.length];
        this.nVerts = 0;
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.checkBoundsIsEmpty();
    }

    Point3d getCenter() {
        return this.centroid;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (boundingPolytope.planes.length != this.planes.length) {
                boundingPolytope.planes = new Vector4d[this.planes.length];
                int n = 0;
                while (n < boundingPolytope.planes.length) {
                    boundingPolytope.planes[n] = new Vector4d();
                    ++n;
                }
                boundingPolytope.mag = new double[this.planes.length];
                boundingPolytope.pDotN = new double[this.planes.length];
                boundingPolytope.verts = new Point3d[this.nVerts];
                boundingPolytope.nVerts = this.nVerts;
                n = 0;
                while (n < this.nVerts) {
                    boundingPolytope.verts[n] = new Point3d(this.verts[n]);
                    ++n;
                }
            }
            int n = 0;
            while (n < this.planes.length) {
                boundingPolytope.planes[n].x = this.planes[n].x;
                boundingPolytope.planes[n].y = this.planes[n].y;
                boundingPolytope.planes[n].z = this.planes[n].z;
                boundingPolytope.planes[n].w = this.planes[n].w;
                boundingPolytope.mag[n] = this.mag[n];
                ++n;
            }
            boundingPolytope.boundsIsEmpty = this.boundsIsEmpty;
            boundingPolytope.boundsIsInfinite = this.boundsIsInfinite;
            return boundingPolytope;
        }
        return (Bounds)this.clone();
    }

    int getPickType() {
        return 8;
    }
}

