/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloAddable;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSet;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloLPMatrix;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloModel;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarBound;
import ilog.concert.IloNumVarBoundType;
import ilog.concert.IloRange;
import ilog.concert.IloSOS1;
import ilog.concert.IloSOS2;
import ilog.cplex.Cplex;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxAndGoal;
import ilog.cplex.CpxApplyGoal;
import ilog.cplex.CpxBranchAsCplex;
import ilog.cplex.CpxBranchCallback;
import ilog.cplex.CpxCallback;
import ilog.cplex.CpxControlCallback;
import ilog.cplex.CpxCutArrayGoal;
import ilog.cplex.CpxCutCallback;
import ilog.cplex.CpxCutGoal;
import ilog.cplex.CpxDisjunctiveCutCallback;
import ilog.cplex.CpxDisjunctiveCutInfoCallback;
import ilog.cplex.CpxException;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxFailGoal;
import ilog.cplex.CpxFlowMIRCutCallback;
import ilog.cplex.CpxFlowMIRCutInfoCallback;
import ilog.cplex.CpxFractionalCutCallback;
import ilog.cplex.CpxFractionalCutInfoCallback;
import ilog.cplex.CpxGlobalCutArrayGoal;
import ilog.cplex.CpxGlobalCutGoal;
import ilog.cplex.CpxHeuristicCallback;
import ilog.cplex.CpxIncumbentCallback;
import ilog.cplex.CpxIntSetVar;
import ilog.cplex.CpxLPCallback;
import ilog.cplex.CpxLPMatrix;
import ilog.cplex.CpxLimitSearchGoal;
import ilog.cplex.CpxMIPCallback;
import ilog.cplex.CpxMIPInfoCallback;
import ilog.cplex.CpxNetworkCallback;
import ilog.cplex.CpxNode;
import ilog.cplex.CpxNodeCallback;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxNumVarBound;
import ilog.cplex.CpxOrGoal;
import ilog.cplex.CpxProbingCallback;
import ilog.cplex.CpxProbingInfoCallback;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSOS;
import ilog.cplex.CpxSolutionGoal;
import ilog.cplex.CpxSolveCallback;
import ilog.cplex.CpxTuningCallback;
import ilog.cplex.EvalVisitor;
import ilog.cplex.IloCplexModeler;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class IloCplex
extends IloCplexModeler {
    static final String IBM_COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5725-A06 5725-A29 5724-Y48 5724-Y49 5724-Y54 5724-Y55\nCopyright IBM Corp. 2001, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1220L;
    CplexI _cplexi;
    private IloCopyManager _copier;
    public static final int IncumbentId = -1;
    private DeleteMode _deleteMode = DeleteMode.LeaveBasis;

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        throw new UnsupportedOperationException();
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    public IloCopyable getCopy(IloCopyable iloCopyable) throws IloException {
        return iloCopyable.makeCopy(this._copier);
    }

    public void setModel(IloModel iloModel) throws IloException {
        this._model.uninstallCon();
        super.setModel(iloModel);
        this._model.installCon(this._cplexi);
    }

    public IloConstraint addUserCut(IloConstraint iloConstraint) throws IloException {
        IloConstraint[] iloConstraintArray = new IloRange[]{(IloRange)iloConstraint};
        this.addUserCuts(iloConstraintArray, 0, 1);
        return iloConstraint;
    }

    public IloConstraint[] addUserCuts(IloConstraint[] iloConstraintArray) throws IloException {
        return this.addUserCuts(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public IloConstraint[] addUserCuts(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        this._cplexi.addCuts(iloConstraintArray, n, n2, 0);
        return iloConstraintArray;
    }

    public void clearUserCuts() throws IloException {
        this._cplexi.delCuts(0);
    }

    public IloConstraint addLazyConstraint(IloConstraint iloConstraint) throws IloException {
        IloConstraint[] iloConstraintArray = new IloConstraint[]{iloConstraint};
        this.addLazyConstraints(iloConstraintArray, 0, 1);
        return iloConstraint;
    }

    public IloConstraint[] addLazyConstraints(IloConstraint[] iloConstraintArray) throws IloException {
        return this.addLazyConstraints(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public IloConstraint[] addLazyConstraints(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        this._cplexi.addCuts(iloConstraintArray, n, n2, 1);
        return iloConstraintArray;
    }

    public void clearLazyConstraints() throws IloException {
        this._cplexi.delCuts(1);
    }

    public IloConstraint addCut(IloConstraint iloConstraint) throws IloException {
        return this.addLazyConstraint(iloConstraint);
    }

    public IloConstraint[] addCuts(IloConstraint[] iloConstraintArray) throws IloException {
        return this.addLazyConstraints(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public IloConstraint[] addCuts(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        return this.addLazyConstraints(iloConstraintArray, n, n2);
    }

    public void clearCuts() throws IloException {
        this.clearLazyConstraints();
    }

    public void exportModel(String string) throws IloException {
        this._cplexi.exportModel(string, this);
    }

    public void importModel(String string) throws IloException {
        CplexI.importModel(string, this);
    }

    public void clearModel() throws IloException {
        this._model.emptyModel();
    }

    public void endModel() throws IloException {
        this._model.endAll();
        this._cplexi.endModel();
    }

    public void end(IloAddable[] iloAddableArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (iloAddableArray[i + n] instanceof CpxRange) {
                cpxRangeArray[n3++] = (CpxRange)iloAddableArray[i + n];
                continue;
            }
            ((CpxExtractable)iloAddableArray[i + n]).end();
        }
        CpxRange.end(cpxRangeArray, n3);
    }

    public void end(IloAddable[] iloAddableArray) throws IloException {
        this.end(iloAddableArray, 0, iloAddableArray.length);
    }

    public void end(IloAddable iloAddable) throws IloException {
        IloAddable[] iloAddableArray = new IloAddable[]{iloAddable};
        this.end(iloAddableArray);
    }

    public int getNcols() {
        return this._cplexi == null ? 0 : this._cplexi.getNcols();
    }

    public int getNrows() {
        return this._cplexi == null ? 0 : this._cplexi.getNrows();
    }

    public int getNQCs() {
        return this._cplexi == null ? 0 : this._cplexi.getNQCs();
    }

    public int getNSOS1() {
        return this._model._sos1.size();
    }

    public int getNSOS2() {
        return this._model._sos2.size();
    }

    public int getNSOSs() {
        return this._cplexi == null ? 0 : this._cplexi.getNSOSs();
    }

    public int getNNZs() {
        return this._cplexi == null ? 0 : this._cplexi.getNNZs();
    }

    public int getNintVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNintVars();
    }

    public int getNbinVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNbinVars();
    }

    public int getNsemiContVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNsemiContVars();
    }

    public int getNsemiIntVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNsemiIntVars();
    }

    public boolean isMIP() {
        return this._cplexi.isMIP();
    }

    public boolean isQO() {
        return this._cplexi.isQO();
    }

    public boolean isQC() {
        return this._cplexi.isQC();
    }

    static Status makeStatus(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 1: 
            case 5: 
            case 102: 
            case 129: 
            case 130: {
                return Status.Optimal;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: {
                return Status.Infeasible;
            }
            case 6: 
            case 14: 
            case 16: 
            case 18: {
                return Status.Unknown;
            }
            case 2: {
                return Status.Unbounded;
            }
            case 23: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 116: 
            case 128: {
                if (bl2) {
                    return Status.Optimal;
                }
                return Status.Feasible;
            }
            case 4: {
                return Status.InfeasibleOrUnbounded;
            }
            case 10: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 106: 
            case 110: 
            case 112: 
            case 117: 
            case 126: {
                if (bl && bl2) {
                    return Status.Optimal;
                }
                if (bl) {
                    return Status.Feasible;
                }
                if (bl2) {
                    return Status.Bounded;
                }
                return Status.Unknown;
            }
            case 0: {
                return Status.Unknown;
            }
        }
        return Status.Error;
    }

    public Status getStatus() throws IloException {
        return IloCplex.makeStatus(this.getCplexIntStatus(), this._cplexi.isPfeas(), this._cplexi.isDfeas());
    }

    public boolean isPrimalFeasible() throws IloException {
        return this._cplexi.isPfeas();
    }

    public boolean isDualFeasible() throws IloException {
        return this._cplexi.isDfeas();
    }

    public void setParam(IntParam intParam, int n) throws IloException {
        this._cplexi.setIntParam(intParam.getValue(), n);
    }

    public int getParam(IntParam intParam) throws IloException {
        return this._cplexi.getIntParam(intParam.getValue());
    }

    public int getMin(IntParam intParam) throws IloException {
        return this._cplexi.minIntParam(intParam.getValue());
    }

    public int getMax(IntParam intParam) throws IloException {
        return this._cplexi.maxIntParam(intParam.getValue());
    }

    public int getDefault(IntParam intParam) throws IloException {
        return this._cplexi.defIntParam(intParam.getValue());
    }

    public void setParam(BooleanParam booleanParam, boolean bl) throws IloException {
        if (bl) {
            this._cplexi.setIntParam(booleanParam.getValue(), 1);
        } else {
            this._cplexi.setIntParam(booleanParam.getValue(), 0);
        }
    }

    public boolean getParam(BooleanParam booleanParam) throws IloException {
        return this._cplexi.getIntParam(booleanParam.getValue()) == 1;
    }

    public boolean getDefault(BooleanParam booleanParam) throws IloException {
        return this._cplexi.defIntParam(booleanParam.getValue()) == 1;
    }

    public void setParam(DoubleParam doubleParam, double d) throws IloException {
        this._cplexi.setDoubleParam(doubleParam.getValue(), d);
    }

    public double getParam(DoubleParam doubleParam) throws IloException {
        return this._cplexi.getDoubleParam(doubleParam.getValue());
    }

    public double getMin(DoubleParam doubleParam) throws IloException {
        return this._cplexi.minDoubleParam(doubleParam.getValue());
    }

    public double getMax(DoubleParam doubleParam) throws IloException {
        return this._cplexi.maxDoubleParam(doubleParam.getValue());
    }

    public double getDefault(DoubleParam doubleParam) throws IloException {
        return this._cplexi.defDoubleParam(doubleParam.getValue());
    }

    public void setParam(StringParam stringParam, String string) throws IloException {
        this._cplexi.setStringParam(stringParam.getValue(), string);
    }

    public String getParam(StringParam stringParam) throws IloException {
        return this._cplexi.getStringParam(stringParam.getValue());
    }

    public String getDefault(StringParam stringParam) throws IloException {
        return this._cplexi.defStringParam(stringParam.getValue());
    }

    public void setDefaults() throws IloException {
        if (this._cplexi != null) {
            this._cplexi.setDefaults();
        }
    }

    public ParameterSet getParameterSet() throws IloException {
        return this._cplexi.getParameterSet();
    }

    public void setParameterSet(ParameterSet parameterSet) throws IloException {
        this._cplexi.setParameterSet(parameterSet);
    }

    public String getVersion() throws IloException {
        return this._cplexi == null ? "" : this._cplexi.getVersion();
    }

    public void setDeleteMode(DeleteMode deleteMode) {
        this._deleteMode = deleteMode;
        if (this._deleteMode == DeleteMode.FixBasis) {
            this._cplexi.setFixBasis(true);
        } else {
            this._cplexi.setFixBasis(false);
        }
    }

    public DeleteMode getDeleteMode() {
        return this._deleteMode;
    }

    public CplexStatus getCplexStatus() throws IloException {
        return CplexStatus.getStatus(this._cplexi.getCplexStatus());
    }

    final int getCplexIntStatus() throws IloException {
        return this.getCplexStatus().getValue();
    }

    public CplexStatus getCplexSubStatus() throws IloException {
        int n = this._cplexi.getCplexSubStatus();
        return CplexStatus.getStatus(n);
    }

    public int getAlgorithm() throws IloException {
        return this._cplexi.getMethod();
    }

    public int getSubAlgorithm() throws IloException {
        return this._cplexi.getSubMethod();
    }

    public double getObjValue() throws IloException {
        return this._cplexi.getObjValue();
    }

    public double getObjValue(int n) throws IloException {
        return this._cplexi.getObjValue(n);
    }

    public double getBestObjValue() throws IloException {
        return this._cplexi.getBestObjValue();
    }

    public double getMIPRelativeGap() throws IloException {
        return this._cplexi.getMIPRelativeGap();
    }

    public double getCutoff() throws IloException {
        return this._cplexi.getCutoff();
    }

    public double[] getValues(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getValues(iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n) throws UnknownObjectException, IloException {
        return this.getValues(iloLPMatrix, 0, iloLPMatrix.getNcols(), n);
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getValues(cpxLPMatrix._var, n, n2);
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n, int n2, int n3) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getValues(cpxLPMatrix._var, n, n2, n3);
    }

    public double getValue(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        return this._cplexi.getXcache()[cpxNumVar.getVarIndexValue()];
    }

    public double getValue(IloNumVar iloNumVar, int n) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        if (n == -1) {
            return this._cplexi.getXcache()[cpxNumVar.getVarIndexValue()];
        }
        IloNumVar[] iloNumVarArray = new IloNumVar[]{iloNumVar};
        return this.getValues(iloNumVarArray, 0, 1, n)[0];
    }

    public double[] getValues(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n) throws UnknownObjectException, IloException {
        return this.getValues(iloNumVarArray, 0, iloNumVarArray.length, n);
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getXcache();
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2, int n3) throws UnknownObjectException, IloException {
        return this._cplexi.getValues(iloNumVarArray, n, n2, n3);
    }

    public double[] getReducedCosts(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getReducedCosts(iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public double[] getReducedCosts(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getReducedCosts(cpxLPMatrix._var, n, n2);
    }

    public double getReducedCost(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        double[] dArray = this._cplexi.getReducedCosts(cpxNumVar.getVarIndexValue(), cpxNumVar.getVarIndexValue());
        return dArray[0];
    }

    public double getInfeasibility(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        double[] dArray = this._cplexi.getColInfeasibilities(cpxNumVar.getVarIndexValue(), cpxNumVar.getVarIndexValue());
        return dArray[0];
    }

    public double[] getReducedCosts(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getReducedCosts(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getInfeasibilities(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getReducedCosts(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getReducedCosts(0, this.getNcols() - 1);
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getInfeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getColInfeasibilities(0, this.getNcols() - 1);
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getDuals(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getDuals(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getDuals(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        return this.getDuals(((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public double getDual(IloRange iloRange) throws UnknownObjectException, IloException {
        CpxRange cpxRange = (CpxRange)iloRange;
        int n = cpxRange.getIndexValue();
        if (n < 0) {
            throw new UnknownObjectException(cpxRange);
        }
        return this._cplexi.getPi(n, n)[0];
    }

    public double[] getDuals(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getDuals(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getDuals(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = n; i < n5; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            int n6 = cpxRangeArray[i - n].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getPi(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxRangeArray[i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getSlacks(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n) throws UnknownObjectException, IloException {
        return this.getSlacks(iloLPMatrix, 0, iloLPMatrix.getNrows(), n);
    }

    public double[] getInfeasibilities(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        return this.getSlacks(((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n, int n2, int n3) throws UnknownObjectException, IloException {
        return this.getSlacks(((CpxLPMatrix)iloLPMatrix)._row, n, n2, n3);
    }

    public double[] getInfeasibilities(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        IloConstraint[] iloConstraintArray = cpxLPMatrix.getRanges();
        return this.getInfeasibilities(iloConstraintArray, n, n2);
    }

    public double getSlack(IloRange iloRange) throws UnknownObjectException, IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        return this.getSlacks(iloRangeArray, 0, 1)[0];
    }

    public double getSlack(IloRange iloRange, int n) throws UnknownObjectException, IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        return this.getSlacks(iloRangeArray, 0, 1, n)[0];
    }

    public double getInfeasibility(IloConstraint iloConstraint) throws UnknownObjectException, IloException {
        IloConstraint[] iloConstraintArray = new IloConstraint[]{iloConstraint};
        return this.getInfeasibilities(iloConstraintArray, 0, 1)[0];
    }

    public double[] getSlacks(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, 0, iloRangeArray.length, n);
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, n, n2, -1);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n, int n2, int n3) throws UnknownObjectException, IloException {
        int n4;
        if (n2 <= 0) {
            return null;
        }
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        double[] dArray = new double[n2];
        for (int i = n; i < n7; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            if (cpxRangeArray[i - n].isQC()) {
                dArray[i] = this._cplexi.getQCSlack(cpxRangeArray[i - n].getIndexValue(), n3);
                continue;
            }
            n4 = cpxRangeArray[i - n].getIndexValue();
            if (n4 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n4 > n6) {
                n6 = n4;
            }
            if (n4 >= n5) continue;
            n5 = n4;
        }
        if (n5 <= n6) {
            double[] dArray2 = this._cplexi.getSlacks(n5, n6, n3);
            for (n4 = 0; n4 < n2; ++n4) {
                if (cpxRangeArray[n4].isQC()) continue;
                dArray[n4] = dArray2[cpxRangeArray[n4].getIndexValue() - n5];
            }
        }
        return dArray;
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        return this._cplexi.getInfeasibilities(iloConstraintArray, n, n2);
    }

    public double getValue(IloNumExpr iloNumExpr) throws IloException {
        EvalVisitor evalVisitor = new EvalVisitor(this._cplexi.getXcache());
        CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
        cpxNumExpr.accept(evalVisitor);
        return evalVisitor.getValue();
    }

    public double getValue(IloNumExpr iloNumExpr, int n) throws IloException {
        int n2 = this.getNcols();
        double[] dArray = new double[n2];
        this._cplexi.getValuesForExpr(dArray, n);
        EvalVisitor evalVisitor = new EvalVisitor(dArray);
        CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
        cpxNumExpr.accept(evalVisitor);
        return evalVisitor.getValue();
    }

    public double[] getAX(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getAX(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getAX(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        for (int i = n; i < n5; ++i) {
            int n6 = cpxLPMatrix._row[i].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloLPMatrix);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getAX(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxLPMatrix._row[n + i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public double getAX(IloRange iloRange) throws UnknownObjectException, IloException {
        int n = ((CpxRange)iloRange).getIndexValue();
        if (n < 0) {
            throw new UnknownObjectException(iloRange);
        }
        return this._cplexi.getAX(n, n)[0];
    }

    public double[] getAX(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getAX(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getAX(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = n; i < n5; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            int n6 = cpxRangeArray[i - n].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getAX(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxRangeArray[i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public BasisStatus getBasisStatus(IloNumVar iloNumVar) throws IloException {
        return this._cplexi.getColumnBasis(((CpxNumVar)iloNumVar).getVarIndex());
    }

    public BasisStatus[] getBasisStatuses(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getBasisStatuses(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public BasisStatus[] getBasisStatuses(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        return this._cplexi.getColumnBasis(cplexIndexArray, 0, n2);
    }

    public BasisStatus getBasisStatus(IloConstraint iloConstraint) throws IloException {
        return this._cplexi.getRowBasis(((CpxRange)iloConstraint).getIndex());
    }

    public BasisStatus[] getBasisStatuses(IloConstraint[] iloConstraintArray) throws IloException {
        return this.getBasisStatuses(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public BasisStatus[] getBasisStatuses(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloConstraintArray[i + n];
        }
        return this._cplexi.getRowBasis(cpxRangeArray, 0, n2);
    }

    public void setBasisStatuses(IloNumVar[] iloNumVarArray, BasisStatus[] basisStatusArray, IloRange[] iloRangeArray, BasisStatus[] basisStatusArray2) throws IloException {
        this.setBasisStatuses(iloNumVarArray, basisStatusArray, 0, iloNumVarArray.length, iloRangeArray, basisStatusArray2, 0, iloRangeArray.length);
    }

    public void setBasisStatuses(IloNumVar[] iloNumVarArray, BasisStatus[] basisStatusArray, int n, int n2, IloConstraint[] iloConstraintArray, BasisStatus[] basisStatusArray2, int n3, int n4) throws IloException {
        int n5;
        int n6 = n + n2;
        CplexIndex[] cplexIndexArray = new CplexIndex[n6];
        for (n5 = n; n5 < n6; ++n5) {
            cplexIndexArray[n5] = ((CpxNumVar)iloNumVarArray[n5]).getVarIndex();
        }
        n5 = n3 + n4;
        CplexIndex[] cplexIndexArray2 = new CplexIndex[n5];
        for (int i = n3; i < n5; ++i) {
            cplexIndexArray2[i] = ((CpxRange)iloConstraintArray[i]).getIndex();
        }
        this._cplexi.setBasis(cplexIndexArray, basisStatusArray, n, n2, cplexIndexArray2, basisStatusArray2, n3, n4);
    }

    public void setVectors(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray) throws IloException {
        int n = iloNumVarArray != null ? iloNumVarArray.length : 0;
        int n2 = iloRangeArray != null ? iloRangeArray.length : 0;
        this.setVectors(dArray, dArray2, iloNumVarArray, 0, n, dArray3, dArray4, iloRangeArray, 0, n2);
    }

    public void setVectors(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
        int n5 = iloNumVarArray != null ? n : 0;
        int n6 = iloNumVarArray != null ? n2 : 0;
        int n7 = iloRangeArray != null ? n3 : 0;
        int n8 = iloRangeArray != null ? n4 : 0;
        this._cplexi.setVectors(dArray, dArray2, iloNumVarArray, n5, n6, dArray3, dArray4, iloRangeArray, n7, n8);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this._cplexi.addMIPStart(iloNumVarArray, dArray, n, n2, mIPStartEffort, string);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length, mIPStartEffort, string);
    }

    public int addMIPStart(MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this.addMIPStart(null, null, mIPStartEffort, string);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, mIPStartEffort, null);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, MIPStartEffort.Auto, null);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, String string) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, MIPStartEffort.Auto, string);
    }

    public int addMIPStart(MIPStartEffort mIPStartEffort) throws IloException {
        return this.addMIPStart(null, null, mIPStartEffort, null);
    }

    public int addMIPStart(String string) throws IloException {
        return this.addMIPStart(null, null, MIPStartEffort.Auto, string);
    }

    public int addMIPStart() throws IloException {
        return this.addMIPStart(null, null, MIPStartEffort.Auto, null);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3, MIPStartEffort mIPStartEffort) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, n2, n3, mIPStartEffort);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length, mIPStartEffort);
    }

    public void deleteMIPStarts(int n, int n2) throws IloException {
        this._cplexi.deleteMIPStarts(n, n2);
    }

    public void deleteMIPStarts(int n) throws IloException {
        this._cplexi.deleteMIPStarts(n, 1);
    }

    public void changeMIPStart(int n, MIPStartEffort mIPStartEffort) throws IloException {
        this.changeMIPStart(n, null, null, mIPStartEffort);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length);
    }

    public int getNMIPStarts() throws IloException {
        return this._cplexi.getNMIPStarts();
    }

    public String getMIPStartName(int n) throws IloException {
        return this._cplexi.getMIPStartName(n);
    }

    public int getMIPStartIndex(String string) throws IloException {
        return this._cplexi.getMIPStartIndex(string);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, int n2, int n3, double[] dArray, boolean[] blArray) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n3];
        for (int i = 0; i < n3; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n2]).getVarIndex();
        }
        return this._cplexi.getMIPStart(n, cplexIndexArray, dArray, blArray);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, boolean[] blArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, blArray);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, int n2, int n3, double[] dArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, null);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, null);
    }

    public MIPStartEffort getMIPStart(int n) throws IloException {
        return this._cplexi.getMIPStart(n, null, null, null);
    }

    public boolean feasOpt(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.feasOpt(iloConstraintArray, dArray);
    }

    public boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4) throws IloException {
        return this._cplexi.feasOpt(iloRangeArray, dArray, dArray2, iloNumVarArray, dArray3, dArray4);
    }

    public boolean feasOpt(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) throws IloException {
        return this.feasOpt(null, null, null, iloNumVarArray, dArray, dArray2);
    }

    public boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2) throws IloException {
        return this.feasOpt(iloRangeArray, dArray, dArray2, null, null, null);
    }

    public IIS getIIS() throws IloException {
        IIS.Status[][] statusArray = new IIS.Status[1][];
        IIS.Status[][] statusArray2 = new IIS.Status[1][];
        IloNumVar[][] iloNumVarArray = new IloNumVar[1][];
        IloConstraint[][] iloConstraintArray = new IloConstraint[1][];
        this._cplexi.getIIS(statusArray, iloNumVarArray, statusArray2, iloConstraintArray);
        return new IIS(statusArray[0], iloNumVarArray[0], statusArray2[0], iloConstraintArray[0]);
    }

    public IloNumVarBound bound(IloNumVar iloNumVar, IloNumVarBoundType iloNumVarBoundType) {
        return new CpxNumVarBound(iloNumVar, iloNumVarBoundType);
    }

    public IloNumVarBound lowerBound(IloNumVar iloNumVar) {
        return new CpxNumVarBound(iloNumVar, 1);
    }

    public IloNumVarBound upperBound(IloNumVar iloNumVar) {
        return new CpxNumVarBound(iloNumVar, 2);
    }

    public boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray);
    }

    public boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray, n, n2);
    }

    public boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    public boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    public ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray) throws IloException {
        return this._cplexi.getConflict(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public ConflictStatus getConflict(IloConstraint iloConstraint) throws IloException {
        IloConstraint[] iloConstraintArray = new IloConstraint[]{iloConstraint};
        return this._cplexi.getConflict(iloConstraintArray, 0, 1)[0];
    }

    public ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        return this._cplexi.getConflict(iloConstraintArray, n, n2);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix) throws IloException {
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, cpxLPMatrix._var, n, n2);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloNumVar[] iloNumVarArray) throws IloException {
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        this._cplexi.getBoundSA(dArray, dArray2, dArray3, dArray4, cplexIndexArray, 0, n2);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix) throws IloException {
        this.getObjSA(dArray, dArray2, iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this.getObjSA(dArray, dArray2, ((CpxLPMatrix)iloLPMatrix)._var, n, n2);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray) throws IloException {
        this.getObjSA(dArray, dArray2, iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        this._cplexi.getObjSA(dArray, dArray2, cplexIndexArray, 0, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray) throws IloException {
        this.getRangeSA(dArray, dArray2, dArray3, dArray4, iloRangeArray, 0, iloRangeArray.length);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloRangeArray[i + n];
        }
        this._cplexi.getRangeSA(dArray, dArray2, dArray3, dArray4, cpxRangeArray, 0, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this._cplexi.getRangeSA(dArray, dArray2, dArray3, dArray4, ((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix) throws IloException {
        this.getRangeSA(dArray, dArray2, dArray3, dArray4, iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloRange[] iloRangeArray) throws IloException {
        this.getRHSSA(dArray, dArray2, iloRangeArray, 0, iloRangeArray.length);
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloRange[] iloRangeArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloRangeArray[i + n];
        }
        this._cplexi.getRHSSA(dArray, dArray2, cpxRangeArray, 0, n2);
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix) throws IloException {
        this.getRHSSA(dArray, dArray2, iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this._cplexi.getRHSSA(dArray, dArray2, ((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public Quality getQuality(QualityType qualityType) throws IloException {
        Quality quality = this._cplexi.getQuality(qualityType.getValue(), -1);
        quality.type = qualityType;
        return quality;
    }

    public Quality getQuality(QualityType qualityType, int n) throws IloException {
        Quality quality = this._cplexi.getQuality(qualityType.getValue(), n);
        quality.type = qualityType;
        return quality;
    }

    public IloIntSet getIntSetValue(IloIntSetVar iloIntSetVar) throws UnknownObjectException, IloException {
        return this._cplexi.getIntSetValue((CpxIntSetVar)iloIntSetVar);
    }

    public IloCplex() throws IloException {
        this._cplexi = new CplexI();
        this._copier = new IloCopyManager(this);
        this.setCplexI(this._cplexi);
        this._cplexi.setIloCplex(this);
    }

    public PrintStream output() {
        return this._cplexi.output();
    }

    public PrintStream warning() {
        return this._cplexi.warning();
    }

    public void setOut(OutputStream outputStream) {
        this._cplexi.setOut(outputStream);
    }

    public void setWarning(OutputStream outputStream) {
        this._cplexi.setWarning(outputStream);
    }

    public boolean solve() throws IloException {
        this._cplexi.solve();
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public boolean solveFixed() throws IloException {
        this._cplexi.solveFixed(-1);
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public boolean solveFixed(int n) throws IloException {
        this._cplexi.solveFixed(n);
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public int tuneParam() throws IloException {
        return this._cplexi.tuneParam(null);
    }

    public int tuneParam(ParameterSet parameterSet) throws IloException {
        return this._cplexi.tuneParam(parameterSet);
    }

    public int tuneParam(String[] stringArray) throws IloException {
        return this._cplexi.tuneParam(stringArray, null);
    }

    public int tuneParam(String[] stringArray, ParameterSet parameterSet) throws IloException {
        return this._cplexi.tuneParam(stringArray, parameterSet);
    }

    public int getNiterations() {
        return this._cplexi == null ? 0 : this._cplexi.getNiterations();
    }

    public int getNphaseOneIterations() {
        return this._cplexi == null ? 0 : this._cplexi.getNphaseOneIterations();
    }

    public int getNbarrierIterations() {
        return this._cplexi == null ? 0 : this._cplexi.getNbarrierIterations();
    }

    public int getNsiftingIterations() {
        return this._cplexi == null ? 0 : this._cplexi.getNsiftingIterations();
    }

    public int getNsiftingPhaseOneIterations() {
        return this._cplexi == null ? 0 : this._cplexi.getNsiftingPhaseOneIterations();
    }

    public int getNcrossDExch() {
        return this._cplexi == null ? 0 : this._cplexi.getNcrossDExch();
    }

    public int getNcrossDPush() {
        return this._cplexi == null ? 0 : this._cplexi.getNcrossDPush();
    }

    public int getNcrossPExch() {
        return this._cplexi == null ? 0 : this._cplexi.getNcrossPExch();
    }

    public int getNcrossPPush() {
        return this._cplexi == null ? 0 : this._cplexi.getNcrossPPush();
    }

    public int getNdualSuperbasics() {
        return this._cplexi == null ? 0 : this._cplexi.getNdualSuperbasics();
    }

    public int getNprimalSuperbasics() {
        return this._cplexi == null ? 0 : this._cplexi.getNprimalSuperbasics();
    }

    public int getNnodes() {
        return this._cplexi == null ? 0 : this._cplexi.getNnodes();
    }

    public int getNnodesLeft() {
        return this._cplexi == null ? 0 : this._cplexi.getNnodesLeft();
    }

    public int getIncumbentNode() {
        return this._cplexi == null ? 0 : this._cplexi.getIncumbentNode();
    }

    public int getNcuts(int n) throws IloException {
        return this._cplexi.getNcuts(n);
    }

    public void setPriority(IloNumVar iloNumVar, int n) throws IloException {
        this._cplexi.setPriority(this.getIndexOrException(iloNumVar), n);
    }

    public void setPriorities(IloNumVar[] iloNumVarArray, int[] nArray) throws IloException {
        this.setPriorities(iloNumVarArray, nArray, 0, iloNumVarArray.length);
    }

    public void setPriorities(IloNumVar[] iloNumVarArray, int[] nArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        this._cplexi.setPriorities(cplexIndexArray, nArray, n, n2);
    }

    private final CplexIndex getIndexOrException(IloNumVar iloNumVar) throws IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        CplexIndex cplexIndex = cpxNumVar.getVarIndex();
        if (cplexIndex == null || cplexIndex.getValue() < 0) {
            throw new UnknownObjectException(iloNumVar);
        }
        return cplexIndex;
    }

    private final CplexIndex[] getIndexOrException(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        CplexIndex[] cplexIndexArray = new CplexIndex[n3];
        for (int i = n; i < n3; ++i) {
            cplexIndexArray[i] = this.getIndexOrException(iloNumVarArray[i]);
        }
        return cplexIndexArray;
    }

    public void setDirection(IloNumVar iloNumVar, BranchDirection branchDirection) throws IloException {
        this._cplexi.setDirection(this.getIndexOrException(iloNumVar), branchDirection.getValue());
    }

    public void setDirections(IloNumVar[] iloNumVarArray, BranchDirection[] branchDirectionArray) throws IloException {
        this.setDirections(iloNumVarArray, branchDirectionArray, 0, iloNumVarArray.length);
    }

    public void setDirections(IloNumVar[] iloNumVarArray, BranchDirection[] branchDirectionArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray[i] = branchDirectionArray[i].getValue();
        }
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        this._cplexi.setDirections(cplexIndexArray, nArray, n, n2);
    }

    public void delPriority(IloNumVar iloNumVar) throws IloException {
        this.setPriority(iloNumVar, 0);
    }

    public void delPriorities(IloNumVar[] iloNumVarArray) throws IloException {
        this.delPriorities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void delPriorities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray[i] = 0;
        }
        this.setPriorities(iloNumVarArray, nArray, n, n2);
    }

    public void delDirection(IloNumVar iloNumVar) throws IloException {
        this.setDirection(iloNumVar, BranchDirection.Global);
    }

    public void delDirections(IloNumVar[] iloNumVarArray) throws IloException {
        this.delDirections(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void delDirections(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        BranchDirection[] branchDirectionArray = new BranchDirection[n3];
        for (int i = n; i < n3; ++i) {
            branchDirectionArray[i] = BranchDirection.Global;
        }
        this.setDirections(iloNumVarArray, branchDirectionArray, n, n2);
    }

    public int getPriority(IloNumVar iloNumVar) throws IloException {
        return this._cplexi.getPriority(this.getIndexOrException(iloNumVar));
    }

    public int[] getPriorities(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getPriorities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public int[] getPriorities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        int[] nArray = new int[n2];
        this._cplexi.getPriorities(nArray, cplexIndexArray, n, n2);
        return nArray;
    }

    public BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
        CplexIndex cplexIndex = this.getIndexOrException(iloNumVar);
        return BranchDirection.getDirection(this._cplexi.getDirection(cplexIndex));
    }

    public BranchDirection[] getDirections(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getDirections(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public BranchDirection[] getDirections(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        int[] nArray = new int[n2];
        this._cplexi.getDirections(nArray, cplexIndexArray, n, n2);
        BranchDirection[] branchDirectionArray = new BranchDirection[n2];
        for (int i = 0; i < n2; ++i) {
            branchDirectionArray[i] = BranchDirection.getDirection(nArray[i]);
        }
        return branchDirectionArray;
    }

    public void writeOrder(String string) throws IloException {
        this._cplexi.writeOrder(string);
    }

    public void writeConflict(String string) throws IloException {
        this._cplexi.writeConflict(string);
    }

    public void writeParam(String string) throws IloException {
        this._cplexi.writeParam(string);
    }

    public void writeBasis(String string) throws IloException {
        this._cplexi.writeBasis(string);
    }

    public void writeSolution(String string) throws IloException {
        this._cplexi.writeSolution(string, -1);
    }

    public void writeSolution(String string, int n) throws IloException {
        this._cplexi.writeSolution(string, n);
    }

    public void writeSolutions(String string) throws IloException {
        this._cplexi.writeSolutions(string);
    }

    public void writeVectors(String string) throws IloException {
        this._cplexi.writeVectors(string);
    }

    public void writeTextSolution(String string) throws IloException {
        this._cplexi.writeTextSolution(string);
    }

    public void writeMIPStart(String string) throws IloException {
        this._cplexi.writeMIPStart(string, 0);
    }

    public void writeMIPStart(String string, int n) throws IloException {
        this._cplexi.writeMIPStart(string, n);
    }

    public void writeMIPStarts(String string, int n, int n2) throws IloException {
        this._cplexi.writeMIPStarts(string, n, n2);
    }

    public void writeMIPStarts(String string) throws IloException {
        this.writeMIPStarts(string, 0, Integer.MAX_VALUE);
    }

    public void readOrder(String string) throws IloException {
        this._cplexi.readOrder(string);
    }

    public void readParam(String string) throws IloException {
        this._cplexi.readParam(string);
    }

    public void readBasis(String string) throws IloException {
        this._cplexi.readBasis(string);
    }

    public void readSolution(String string) throws IloException {
        this._cplexi.readSolution(string);
    }

    public void readVectors(String string) throws IloException {
        this._cplexi.readVectors(string);
    }

    public void readMIPStarts(String string) throws IloException {
        this._cplexi.readMIPStarts(string);
    }

    public void readMIPStart(String string) throws IloException {
        this._cplexi.readMIPStart(string);
    }

    public void use(Callback callback) throws IloException {
        if (callback.cb.getCplex() == this) {
            return;
        }
        if (callback.cb.getCplex() != null) {
            throw new IloException("callback already in use");
        }
        this._cplexi.setCallback(callback.cb);
        callback.cb.setCplex(this);
    }

    public void clearCallbacks() throws IloException {
        this._cplexi.clearCallbacks();
    }

    public IloLinearNumExpr getRay() throws IloException {
        return this._cplexi.getRay();
    }

    public IloCopyable getDiverging() throws IloException {
        return this._cplexi.getDiverging();
    }

    public double dualFarkas(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.dualFarkas(iloConstraintArray, dArray);
    }

    public void qpIndefCertificate(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._cplexi.qpIndefCertificate(iloNumVarArray, dArray);
    }

    public void end() {
        if (this._cplexi != null) {
            this._cplexi.callFinit();
            this._cplexi = null;
        }
    }

    protected void finalize() {
        this.end();
    }

    public static void registerLicense(String string, int n) throws IloException {
        if (CplexI.registerLicense(string, n) != 0) {
            throw new IloException("Incorrect license information passed to registerLicense");
        }
    }

    public static void putenv(String string) throws IloException {
        if (CplexI.putenv(string) != 0) {
            throw new IloException("putenv(" + string + ") unsuccessful");
        }
    }

    public final Goal and(Goal goal, Goal goal2) {
        return new CpxAndGoal(goal, goal2);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3) {
        return new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4), goal5);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5, Goal goal6) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4), goal5), goal6);
    }

    public final Goal or(Goal goal, Goal goal2) {
        return new CpxOrGoal(goal, goal2, 1.0E20, 1.0E20);
    }

    final Goal or(Goal goal, Goal goal2, double d, double d2) {
        return new CpxOrGoal(goal, goal2, d, d2);
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3) {
        return this.or(goal, this.or(goal2, goal3));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4) {
        return this.or(goal, this.or(goal2, goal3, goal4));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5) {
        return this.or(goal, this.or(goal2, goal3, goal4, goal5));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5, Goal goal6) {
        return this.or(goal, this.or(goal2, goal3, goal4, goal5, goal6));
    }

    public final Goal branchAsCplex() {
        return new CpxBranchAsCplex();
    }

    public final Goal apply(Goal goal, NodeEvaluator nodeEvaluator) {
        return this.and(new CpxApplyGoal(nodeEvaluator), goal);
    }

    public final Goal limitSearch(Goal goal, SearchLimit searchLimit) {
        return this.and(new CpxLimitSearchGoal(searchLimit), goal);
    }

    public final boolean solve(Goal goal) throws IloException {
        this._cplexi.solve(this, goal);
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public final Goal failGoal() {
        return new CpxFailGoal();
    }

    final void setDefaultSearch(boolean bl) {
        this._cplexi.setDefaultSearch(bl);
    }

    public final Goal constraintGoal(IloConstraint iloConstraint) throws IloException {
        return new CpxCutGoal(iloConstraint);
    }

    public final Goal constraintGoal(IloConstraint[] iloConstraintArray) throws IloException {
        return new CpxCutArrayGoal(iloConstraintArray);
    }

    public final Goal globalCutGoal(IloConstraint iloConstraint) throws IloException {
        return new CpxGlobalCutGoal(iloConstraint);
    }

    public final Goal globalCutGoal(IloConstraint[] iloConstraintArray) throws IloException {
        return new CpxGlobalCutArrayGoal(iloConstraintArray);
    }

    public final Goal solutionGoal(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return new CpxSolutionGoal(iloNumVarArray, dArray);
    }

    public Goal eqGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.eq(iloNumExpr, d));
    }

    public Goal eqGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.eq(iloNumExpr, iloNumExpr2));
    }

    public Goal eqGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.eq(d, iloNumExpr));
    }

    public Goal geGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.ge(iloNumExpr, d));
    }

    public Goal geGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.ge(iloNumExpr, iloNumExpr2));
    }

    public Goal geGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.ge(d, iloNumExpr));
    }

    public Goal leGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.le(iloNumExpr, d));
    }

    public Goal leGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.le(iloNumExpr, iloNumExpr2));
    }

    public Goal leGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.le(d, iloNumExpr));
    }

    public double getSolnPoolMeanObjValue() throws IloException {
        return this._cplexi.getSolnPoolMeanObjValue();
    }

    public int getSolnPoolNsolns() {
        return this._cplexi.getSolnPoolNsolns();
    }

    public int getSolnPoolNreplaced() {
        return this._cplexi.getSolnPoolNreplaced();
    }

    public void delSolnPoolSoln(int n) throws IloException {
        this._cplexi.delSolnPoolSolns(n, n);
    }

    public void delSolnPoolSolns(int n, int n2) throws IloException {
        this._cplexi.delSolnPoolSolns(n, n2);
    }

    public FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) {
        return this._cplexi.addDiversityFilter(d, d2, iloNumVarArray, dArray, dArray2, null);
    }

    public FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
        return this._cplexi.addDiversityFilter(d, d2, iloNumVarArray, dArray, dArray2, string);
    }

    public FilterIndex getFilterIndex(String string) throws IloException {
        return this._cplexi.getFilterIndex(string);
    }

    public int getNfilters() {
        return this._cplexi.getNfilters();
    }

    public int getFilterType(FilterIndex filterIndex) {
        return this._cplexi.getFilterType(filterIndex);
    }

    public double getDiversityFilterLowerCutoff(FilterIndex filterIndex) {
        return this._cplexi.getFilterLowerBound(filterIndex);
    }

    public double getDiversityFilterUpperCutoff(FilterIndex filterIndex) {
        return this._cplexi.getFilterUpperBound(filterIndex);
    }

    public IloNumVar[] getFilterVars(FilterIndex filterIndex) {
        return this._cplexi.getFilterVars(filterIndex);
    }

    public double[] getDiversityFilterWeights(FilterIndex filterIndex) {
        return this._cplexi.getFilterWeights(filterIndex);
    }

    public double[] getDiversityFilterRefVals(FilterIndex filterIndex) {
        return this._cplexi.getFilterRefVals(filterIndex);
    }

    public FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray) {
        return this._cplexi.addRangeFilter(d, d2, iloNumVarArray, dArray, null);
    }

    public FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, String string) {
        return this._cplexi.addRangeFilter(d, d2, iloNumVarArray, dArray, string);
    }

    public double getRangeFilterLowerBound(FilterIndex filterIndex) {
        return this._cplexi.getFilterLowerBound(filterIndex);
    }

    public double getRangeFilterUpperBound(FilterIndex filterIndex) {
        return this._cplexi.getFilterUpperBound(filterIndex);
    }

    public double[] getRangeFilterCoefs(FilterIndex filterIndex) {
        return this._cplexi.getFilterWeights(filterIndex);
    }

    public void delFilter(FilterIndex filterIndex) throws IloException {
        this._cplexi.delFilter(filterIndex);
    }

    public FilterIndex[] readFilters(String string) throws IloException {
        return this._cplexi.readFilters(string);
    }

    public void writeFilters(String string) throws IloException {
        this._cplexi.writeFilters(string);
    }

    public double getCplexTime() throws IloException {
        return this._cplexi.getCplexTime();
    }

    public boolean populate() throws IloException {
        this._cplexi.populate();
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public Aborter use(Aborter aborter) throws IloException {
        this._cplexi.use(aborter.getImpl());
        return aborter;
    }

    public Aborter getAborter() {
        return new Aborter(this._cplexi.getAborter());
    }

    public void remove(Aborter aborter) throws IloException {
        this._cplexi.remove(aborter.getImpl());
    }

    public static class Aborter {
        private CplexI.AborterI _impl;

        public Aborter() {
            this._impl = new CplexI.AborterI();
        }

        Aborter(CplexI.AborterI aborterI) {
            this._impl = aborterI;
        }

        public CplexI.AborterI getImpl() {
            return this._impl;
        }

        public void abort() {
            this._impl.abort();
        }

        public void clear() {
            this._impl.clear();
        }

        public boolean isAborted() {
            return this._impl.isAborted();
        }

        public void end() {
            this._impl = null;
        }
    }

    public static class FilterIndex
    extends CplexIndex {
        private static final long serialVersionUID = 1220L;

        public FilterIndex(int n) {
            super(n);
        }
    }

    public static abstract class FilterType {
        public static final int Diversity = 1;
        public static final int Range = 2;
    }

    public static abstract class SearchLimit
    implements Cloneable {
        boolean _isViolated = false;
        CpxNode _node;

        final SearchLimit makeClone() {
            try {
                SearchLimit searchLimit = (SearchLimit)this.clone();
                searchLimit._node = null;
                return searchLimit;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public abstract boolean check();

        public void init() {
        }

        final boolean checkNode(CpxNode cpxNode) {
            this._node = cpxNode;
            return this.check();
        }

        final void initNode(CpxNode cpxNode) {
            this._isViolated = false;
            this._node = cpxNode;
            this.init();
        }

        final void setViolated() {
            this._isViolated = true;
        }

        final boolean isViolated() {
            return this._isViolated;
        }

        public final int getDepth() {
            return this._node.getDepth();
        }

        public final int getLeftDepth() {
            return this._node.getLeftDepth();
        }

        public final int getRightDepth() {
            return this._node.getRightDepth();
        }
    }

    public static abstract class NodeEvaluator
    implements Cloneable {
        int _nIndex = -1;
        boolean _isInit = false;
        CpxNode _node;
        int _id = -1;

        protected NodeEvaluator() {
        }

        final CpxNode getNode() {
            return this._node;
        }

        final NodeEvaluator makeClone() {
            try {
                NodeEvaluator nodeEvaluator = (NodeEvaluator)this.clone();
                nodeEvaluator._node = null;
                return nodeEvaluator;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public final int getId() {
            return this._id;
        }

        protected abstract double evaluate() throws IloException;

        protected boolean subsume(double d, double d2) {
            return d2 > d;
        }

        protected void init() {
        }

        void initNode(CpxNode cpxNode) {
            this._node = cpxNode;
            this._isInit = true;
            this.init();
        }

        final boolean isInit() {
            return this._isInit;
        }

        final boolean callSubsume(double d, double d2) {
            return this.subsume(d, d2);
        }

        final double evaluateNode(CpxNode cpxNode, int n) throws IloException {
            this._node = cpxNode;
            this._nIndex = n;
            return this.evaluate();
        }

        protected final NodeId getNodeId() throws IloException {
            return new NodeId(this.getNode().getNodeCallback().getNodeId(this._nIndex));
        }

        protected final double getObjValue() throws IloException {
            return this.getNode().getNodeCallback().getObjValue(this._nIndex);
        }

        protected final double getEstimatedObjValue() throws IloException {
            return this.getNode().getNodeCallback().getEstimatedObjValue(this._nIndex);
        }

        protected final int getDepth() throws IloException {
            return this.getNode().getNodeCallback().getDepth(this._nIndex);
        }

        protected final double getInfeasibilitySum() throws IloException {
            return this.getNode().getNodeCallback().getInfeasibilitySum(this._nIndex);
        }

        protected final int getNinfeasibilities() throws IloException {
            return this.getNode().getNodeCallback().getNinfeasibilities(this._nIndex);
        }

        protected final IloNumVar getBranchVar() throws IloException {
            return this.getNode().getNodeCallback().getBranchVar(this._nIndex);
        }

        protected final int getLeftDepth() {
            return this._node.getLeftDepth();
        }

        protected final int getRightDepth() {
            return this._node.getRightDepth();
        }
    }

    public static abstract class Goal
    implements Cloneable {
        CpxNode _node = null;

        final int getIndex(IloNumVar iloNumVar) {
            return ((CpxNumVar)iloNumVar).getVarIndexValue();
        }

        final int getIndex(IloRange iloRange) {
            return ((CpxRange)iloRange).getVarIndexValue();
        }

        final int getIndex(IloSOS1 iloSOS1) {
            return ((CpxSOS)((Object)iloSOS1)).getIndexValue();
        }

        final int getIndex(IloSOS2 iloSOS2) {
            return ((CpxSOS)((Object)iloSOS2)).getIndexValue();
        }

        final Goal executeNode(IloCplex iloCplex, CpxNode cpxNode) throws IloException {
            this._node = cpxNode;
            return this.execute(iloCplex);
        }

        final CpxNode getNode() {
            return this._node;
        }

        final Goal makeClone() {
            try {
                Goal goal = (Goal)this.clone();
                goal._node = null;
                return goal;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public abstract Goal execute(IloCplex var1) throws IloException;

        protected double getBestObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getBestObjValue();
            }
            return this.getNode().getBranchCallback().getBestObjValue();
        }

        protected double getMIPRelativeGap() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getMIPRelativeGap();
            }
            return this.getNode().getBranchCallback().getMIPRelativeGap();
        }

        protected final double getCutoff() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCutoff();
            }
            return this.getNode().getBranchCallback().getCutoff();
        }

        protected final double getIncumbentObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjValue();
            }
            return this.getNode().getBranchCallback().getIncumbentObjValue();
        }

        protected final double getIncumbentValue(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getIncumbentValue(this.getIndex(iloNumVar));
        }

        protected final double[] getIncumbentValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getIncumbentValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getIncumbentValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            this.getNode().getBranchCallback().getIncumbentValues(dArray, nArray);
            return dArray;
        }

        protected final boolean isIntegerFeasible() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return true;
            }
            return this.getNode().getBranchCallback().isIntegerFeasible();
        }

        protected final boolean hasIncumbent() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().hasIncumbent();
            }
            return this.getNode().getBranchCallback().hasIncumbent();
        }

        protected final int getNnodes() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNnodes();
            }
            return this.getNode().getBranchCallback().getNnodes();
        }

        protected final int getNremainingNodes() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNremainingNodes();
            }
            return this.getNode().getBranchCallback().getNremainingNodes();
        }

        protected final int getNiterations() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNiterations();
            }
            return this.getNode().getBranchCallback().getNiterations();
        }

        protected int getNcuts(int n) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNcuts(n);
            }
            return this.getNode().getBranchCallback().getNcuts(n);
        }

        protected final int getNcliques() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNcliques();
            }
            return this.getNode().getBranchCallback().getNcliques();
        }

        protected final int getNcovers() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNcovers();
            }
            return this.getNode().getBranchCallback().getNcovers();
        }

        protected final int getNflowCovers() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNflowCovers();
            }
            return this.getNode().getBranchCallback().getNflowCovers();
        }

        protected final int getNflowPaths() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNflowPaths();
            }
            return this.getNode().getBranchCallback().getNflowPaths();
        }

        protected final int getNGUBcovers() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNGUBcovers();
            }
            return this.getNode().getBranchCallback().getNGUBcovers();
        }

        protected final int getNfractionalCuts() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNfractionalCuts();
            }
            return this.getNode().getBranchCallback().getNfractionalCuts();
        }

        protected final int getNdisjunctiveCuts() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNdisjunctiveCuts();
            }
            return this.getNode().getBranchCallback().getNdisjunctiveCuts();
        }

        protected final int getNMIRs() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNMIRs();
            }
            return this.getNode().getBranchCallback().getNMIRs();
        }

        protected final int getNimpliedBounds() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNimpliedBounds();
            }
            return this.getNode().getBranchCallback().getNimpliedBounds();
        }

        protected final int getNzeroHalfCuts() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNzeroHalfCuts();
            }
            return this.getNode().getBranchCallback().getNzeroHalfCuts();
        }

        protected final BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCplex().getDirection(iloNumVar);
            }
            return this.getNode().getBranchCallback().getCplex().getDirection(iloNumVar);
        }

        protected final int getPriority(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCplex().getPriority(iloNumVar);
            }
            return this.getNode().getBranchCallback().getCplex().getPriority(iloNumVar);
        }

        protected final double getLB(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getLB(this.getIndex(iloNumVar));
        }

        protected final double[] getLBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getLBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getLBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getLBs(dArray, nArray);
            return dArray;
        }

        protected final double getUB(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getUB(this.getIndex(iloNumVar));
        }

        protected final double[] getUBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getUBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getUBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getUBs(dArray, nArray);
            return dArray;
        }

        protected final double getObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjValue();
            }
            return this.getNode().getBranchCallback().getObjValue();
        }

        protected final double getValue(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getX(this.getIndex(iloNumVar));
        }

        protected final double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getX(dArray, nArray);
            return dArray;
        }

        protected final double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected final double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected final double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNode().getCplex().getNrows()];
            double[] dArray2 = new double[this.getNode().getCplex().getNQCs()];
            if (this.getNode().getIncumbentCallback() != null) {
                this.getNode().getIncumbentCallback().getSlacks(dArray, dArray2);
            } else {
                this.getNode().getBranchCallback().getSlacks(dArray, dArray2);
            }
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected final double getValue(IloNumExpr iloNumExpr) throws IloException {
            return this.getNode().getValue((CpxNumExpr)iloNumExpr);
        }

        protected final double getObjCoef(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjCoef(this.getIndex(iloNumVar));
            }
            return this.getNode().getBranchCallback().getObjCoef(this.getIndex(iloNumVar));
        }

        protected final double[] getObjCoefs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getObjCoefs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getObjCoefs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            if (this.getNode().getIncumbentCallback() != null) {
                this.getNode().getIncumbentCallback().getObjCoefs(dArray, nArray);
            } else {
                this.getNode().getBranchCallback().getObjCoefs(dArray, nArray);
            }
            return dArray;
        }

        protected final double getDownPseudoCost(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0.0;
            }
            return this.getNode().getBranchCallback().getDownPseudoCost(this.getIndex(iloNumVar));
        }

        protected final double getUpPseudoCost(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0.0;
            }
            return this.getNode().getBranchCallback().getUpPseudoCost(this.getIndex(iloNumVar));
        }

        protected final IntegerFeasibilityStatus getFeasibility(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            int n = this.getNode().getBranchCallback().getFeasibility(this.getIndex(iloNumVar));
            return IntegerFeasibilityStatus.map[n];
        }

        protected final IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getFeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int n3;
            IntegerFeasibilityStatus[] integerFeasibilityStatusArray = null;
            int[] nArray = null;
            if (this.getNode().getIncumbentCallback() != null) {
                integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
                for (int i = 0; i < n2; ++i) {
                    integerFeasibilityStatusArray[i] = IntegerFeasibilityStatus.Feasible;
                }
                return integerFeasibilityStatusArray;
            }
            int[] nArray2 = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = this.getIndex(iloNumVarArray[n3 + n]);
            }
            nArray = new int[n2];
            this.getNode().getBranchCallback().getFeasibilities(nArray, nArray2);
            integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                integerFeasibilityStatusArray[n3] = IntegerFeasibilityStatus.map[nArray[n3]];
            }
            return integerFeasibilityStatusArray;
        }

        protected final IntegerFeasibilityStatus getSOSFeasibility(IloSOS1 iloSOS1) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            if (this.getNode().getBranchCallback().getSOSFeasibility(this.getIndex(iloSOS1)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected final IntegerFeasibilityStatus getSOSFeasibility(IloSOS2 iloSOS2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            if (this.getNode().getBranchCallback().getSOSFeasibility(this.getIndex(iloSOS2)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected final NodeId getNodeId() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return new NodeId(this.getNode().getIncumbentCallback().getNodeId());
            }
            return new NodeId(this.getNode().getBranchCallback().getNodeId());
        }

        protected final int getNbranches() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0;
            }
            return this.getNode().getBranchCallback().getNbranches();
        }

        protected final BranchType getBranchType() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return BranchType.BranchOnVariable;
            }
            return this.getNode().getBranchCallback().getBranchType();
        }

        protected double[] getBranches(IloNumVar[][] iloNumVarArray, double[][] dArray, BranchDirection[][] branchDirectionArray) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return null;
            }
            return this.getNode().getBranchCallback().getBranches(iloNumVarArray, dArray, branchDirectionArray);
        }

        protected double[] getBranches(IloRange[][] iloRangeArray) throws IloException {
            return this.getNode().getBranchCallback().getBranches(iloRangeArray);
        }
    }

    public static class CplexEndedException
    extends IloException {
        private static final long serialVersionUID = 1220L;

        CplexEndedException() {
            super("illegal method invocation after IloCplex.end()");
        }
    }

    public static class MultipleUseException
    extends IloException {
        private static final long serialVersionUID = 1220L;

        MultipleUseException() {
            super("");
        }
    }

    public static class UnsupportedObjectException
    extends CpxException {
        private static final long serialVersionUID = 1220L;
        Object _obj;

        public UnsupportedObjectException(Object object) {
            super(-3, "CPLEX Error: object type is not supported by IloCplex");
            this._obj = object;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    public static class UnknownObjectException
    extends CpxException {
        private static final long serialVersionUID = 1220L;
        Object _obj;

        public UnknownObjectException(Object object) {
            super(-2, "CPLEX Error: object is unknown to IloCplex");
            this._obj = object;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    public static abstract class TuningCallback
    extends Callback {
        protected TuningCallback() {
            this.cb = new CpxTuningCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxTuningCallback)this.cb).getProgress();
        }
    }

    public static abstract class HeuristicCallback
    extends ControlCallback {
        protected HeuristicCallback() {
            this.cb = new CpxHeuristicCallback(this);
        }

        protected void setBounds(IloNumVar iloNumVar, double d, double d2) throws IloException {
            ((CpxHeuristicCallback)this.cb).setBounds(iloNumVar, d, d2);
        }

        protected void setBounds(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) throws IloException {
            this.setBounds(iloNumVarArray, dArray, dArray2, 0, iloNumVarArray.length);
        }

        protected void setBounds(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, int n, int n2) throws IloException {
            ((CpxHeuristicCallback)this.cb).setBounds(iloNumVarArray, dArray, dArray2, n, n2);
        }

        protected boolean solve(int n) throws IloException {
            ((CpxHeuristicCallback)this.cb).solveAlg(n);
            Status status = this.getStatus();
            return status == Status.Feasible || status == Status.Optimal;
        }

        protected boolean solve() throws IloException {
            return this.solve(2);
        }

        protected Status getStatus() throws IloException {
            return IloCplex.makeStatus(((CpxHeuristicCallback)this.cb).getCplexStatus(), ((CpxHeuristicCallback)this.cb).isPfeas(), ((CpxHeuristicCallback)this.cb).isDfeas());
        }

        protected CplexStatus getCplexStatus() throws IloException {
            return CplexStatus.getStatus(((CpxHeuristicCallback)this.cb).getCplexStatus());
        }

        public boolean isDualFeasible() throws IloException {
            return ((CpxHeuristicCallback)this.cb).isDfeas();
        }

        public boolean isPrimalFeasible() throws IloException {
            return ((CpxHeuristicCallback)this.cb).isPfeas();
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
            double[] dArray2 = this.getObjCoefs(iloNumVarArray, n, n2);
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                d += dArray2[i] * dArray[i + n];
            }
            this.setSolution(iloNumVarArray, dArray, n, n2, d);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
            this.setSolution(iloNumVarArray, dArray, 0, iloNumVarArray.length);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, double d) throws IloException {
            ((CpxHeuristicCallback)this.cb).setSolution(iloNumVarArray, dArray, n, n2, d);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, double d) throws IloException {
            this.setSolution(iloNumVarArray, dArray, 0, iloNumVarArray.length, d);
        }
    }

    public static abstract class BranchCallback
    extends ControlCallback {
        protected BranchCallback() {
            this.cb = new CpxBranchCallback(this);
        }

        protected NodeId getNodeId() throws IloException {
            return new NodeId(((CpxBranchCallback)this.cb).getNodeId());
        }

        protected int getNbranches() {
            return ((CpxBranchCallback)this.cb).getNbranches();
        }

        protected BranchType getBranchType() {
            return ((CpxBranchCallback)this.cb).getBranchType();
        }

        protected double[] getBranches(IloNumVar[][] iloNumVarArray, double[][] dArray, BranchDirection[][] branchDirectionArray) throws IloException {
            return ((CpxBranchCallback)this.cb).getBranches(iloNumVarArray, dArray, branchDirectionArray);
        }

        protected double[] getBranches(IloRange[][] iloRangeArray) throws IloException {
            return ((CpxBranchCallback)this.cb).getBranches(iloRangeArray);
        }

        protected boolean isIntegerFeasible() throws IloException {
            return ((CpxBranchCallback)this.cb).isIntegerFeasible();
        }

        protected NodeId makeBranch(IloNumVar[] iloNumVarArray, double[] dArray, BranchDirection[] branchDirectionArray, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVarArray, dArray, branchDirectionArray, d, null);
        }

        protected NodeId makeBranch(IloNumVar[] iloNumVarArray, double[] dArray, BranchDirection[] branchDirectionArray, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVarArray, dArray, branchDirectionArray, d, object);
        }

        protected NodeId makeBranch(IloNumVar iloNumVar, double d, BranchDirection branchDirection, double d2) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVar, d, branchDirection, d2, null);
        }

        protected NodeId makeBranch(IloNumVar iloNumVar, double d, BranchDirection branchDirection, double d2, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVar, d, branchDirection, d2, object);
        }

        protected NodeId makeBranch(IloRange[] iloRangeArray, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRangeArray, d, null);
        }

        protected NodeId makeBranch(IloRange[] iloRangeArray, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRangeArray, d, object);
        }

        protected NodeId makeBranch(IloRange iloRange, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRange, d, null);
        }

        protected NodeId makeBranch(IloRange iloRange, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRange, d, object);
        }

        protected void prune() {
            ((CpxBranchCallback)this.cb).prune();
        }
    }

    public static class BranchType {
        int _type;
        public static final BranchType BranchOnVariable = new _BranchOnVariable();
        public static final BranchType BranchOnAny = new _BranchOnAny();
        public static final BranchType BranchOnSOS1 = new _BranchOnSOS1();
        public static final BranchType BranchOnSOS2 = new _BranchOnSOS2();

        BranchType(int n) {
            this._type = n;
        }

        public boolean equals(Object object) {
            if (object instanceof BranchType) {
                return this._type == ((BranchType)object)._type;
            }
            return false;
        }

        public String toString() {
            switch (this._type) {
                case 49: {
                    return "BranchOnSOS1";
                }
                case 50: {
                    return "BranchOnSOS2";
                }
                case 65: {
                    return "BranchOnAny";
                }
            }
            return "BranchOnVariable";
        }

        private static class _BranchOnSOS2
        extends BranchType {
            _BranchOnSOS2() {
                super(50);
            }

            public String toString() {
                return "BranchOnSOS2";
            }
        }

        private static class _BranchOnSOS1
        extends BranchType {
            _BranchOnSOS1() {
                super(49);
            }

            public String toString() {
                return "BranchOnSOS1";
            }
        }

        private static class _BranchOnAny
        extends BranchType {
            _BranchOnAny() {
                super(65);
            }

            public String toString() {
                return "BranchOnAny";
            }
        }

        private static class _BranchOnVariable
        extends BranchType {
            _BranchOnVariable() {
                super(48);
            }

            public String toString() {
                return "BranchOnVariable";
            }
        }
    }

    public static abstract class NodeCallback
    extends MIPCallback {
        protected NodeCallback() {
            this.cb = new CpxNodeCallback(this);
        }

        protected NodeId getNodeId(int n) throws IloException {
            return new NodeId(((CpxNodeCallback)this.cb).getNodeId(n));
        }

        protected double getObjValue(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getObjValue(n);
        }

        protected double getEstimatedObjValue(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getEstimatedObjValue(n);
        }

        protected int getDepth(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getDepth(n);
        }

        protected double getInfeasibilitySum(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getInfeasibilitySum(n);
        }

        protected int getNinfeasibilities(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getNinfeasibilities(n);
        }

        protected void selectNode(int n) throws IloException {
            ((CpxNodeCallback)this.cb).selectNode(n);
        }

        protected IloNumVar getBranchVar(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getBranchVar(n);
        }

        protected Object getNodeData(int n) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeData(n);
        }

        protected int getNodeNumber(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeNumber(nodeId._id);
        }

        protected double getObjValue(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getObjValueById(nodeId._id);
        }

        protected double getEstimatedObjValue(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getEstimatedObjValueById(nodeId._id);
        }

        protected int getDepth(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getDepthById(nodeId._id);
        }

        protected double getInfeasibilitySum(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getInfeasibilitySumById(nodeId._id);
        }

        protected int getNinfeasibilities(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNinfeasibilitiesById(nodeId._id);
        }

        protected void selectNode(NodeId nodeId) throws IloException {
            ((CpxNodeCallback)this.cb).selectNodeById(nodeId._id);
        }

        protected IloNumVar getBranchVar(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getBranchVarById(nodeId._id);
        }

        protected Object getNodeData(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeDataById(nodeId._id);
        }
    }

    public static class NodeId {
        int _id;

        NodeId(int n) {
            this._id = n;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeId) {
                return this._id == ((NodeId)object)._id;
            }
            return false;
        }

        public String toString() {
            return "Node" + this._id;
        }
    }

    public static abstract class DisjunctiveCutCallback
    extends MIPCallback {
        protected DisjunctiveCutCallback() {
            this.cb = new CpxDisjunctiveCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxDisjunctiveCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class DisjunctiveCutInfoCallback
    extends MIPInfoCallback {
        protected DisjunctiveCutInfoCallback() {
            this.cb = new CpxDisjunctiveCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxDisjunctiveCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class FlowMIRCutCallback
    extends MIPCallback {
        protected FlowMIRCutCallback() {
            this.cb = new CpxFlowMIRCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFlowMIRCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class FlowMIRCutInfoCallback
    extends MIPInfoCallback {
        protected FlowMIRCutInfoCallback() {
            this.cb = new CpxFlowMIRCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFlowMIRCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class FractionalCutCallback
    extends MIPCallback {
        protected FractionalCutCallback() {
            this.cb = new CpxFractionalCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFractionalCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class FractionalCutInfoCallback
    extends MIPInfoCallback {
        protected FractionalCutInfoCallback() {
            this.cb = new CpxFractionalCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFractionalCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class ProbingCallback
    extends MIPCallback {
        protected ProbingCallback() {
            this.cb = new CpxProbingCallback(this);
        }

        protected int getPhase() throws IloException {
            return ((CpxProbingCallback)this.cb).getPhase();
        }

        protected double getProgress() throws IloException {
            return ((CpxProbingCallback)this.cb).getProgress();
        }
    }

    public static abstract class ProbingInfoCallback
    extends MIPInfoCallback {
        protected ProbingInfoCallback() {
            this.cb = new CpxProbingInfoCallback(this);
        }

        protected int getPhase() throws IloException {
            return ((CpxProbingInfoCallback)this.cb).getPhase();
        }

        protected double getProgress() throws IloException {
            return ((CpxProbingInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class UserCutCallback
    extends ControlCallback {
        protected IloConstraint add(IloConstraint iloConstraint) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloConstraint, false);
        }

        protected IloConstraint add(IloConstraint iloConstraint, boolean bl) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloConstraint, bl);
        }

        protected UserCutCallback() {
            this.cb = new CpxCutCallback(this, false);
        }
    }

    public static abstract class LazyConstraintCallback
    extends CutCallback {
        protected LazyConstraintCallback() {
            this.cb = new CpxCutCallback(this, true);
        }
    }

    public static abstract class CutCallback
    extends ControlCallback {
        protected IloConstraint add(IloConstraint iloConstraint) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloConstraint, false);
        }

        protected IloConstraint addLocal(IloConstraint iloConstraint) throws IloException {
            return ((CpxCutCallback)this.cb).addLocalCut(iloConstraint);
        }

        protected CutCallback() {
            this.cb = new CpxCutCallback(this, true);
        }
    }

    public static abstract class ControlCallback
    extends MIPCallback {
        protected double getLB(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getLB(this.getIndex(iloNumVar));
        }

        protected double[] getLBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getLBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getLBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getLBs(dArray, nArray);
            return dArray;
        }

        protected double getUB(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getUB(this.getIndex(iloNumVar));
        }

        protected double[] getUBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getUBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getUBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getUBs(dArray, nArray);
            return dArray;
        }

        protected double getObjValue() throws IloException {
            return ((CpxControlCallback)this.cb).getObjValue();
        }

        protected double getValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getX(this.getIndex(iloNumVar));
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getX(dArray, nArray);
            return dArray;
        }

        protected double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNrows()];
            double[] dArray2 = new double[this.getNQCs()];
            ((CpxControlCallback)this.cb).getSlacks(dArray, dArray2);
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected double getValue(IloNumExpr iloNumExpr) throws IloException {
            CpxControlCallback cpxControlCallback = (CpxControlCallback)this.cb;
            int n = cpxControlCallback.getCplexI().getNcols();
            double[] dArray = new double[n];
            cpxControlCallback.getX(dArray);
            EvalVisitor evalVisitor = new EvalVisitor(dArray);
            CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
            cpxNumExpr.accept(evalVisitor);
            return evalVisitor.getValue();
        }

        final double callGetValue(IloNumExpr iloNumExpr) throws IloException {
            return this.getValue(iloNumExpr);
        }

        protected double getDownPseudoCost(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getDownPseudoCost(this.getIndex(iloNumVar));
        }

        protected double getUpPseudoCost(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getUpPseudoCost(this.getIndex(iloNumVar));
        }

        protected IntegerFeasibilityStatus getFeasibility(IloNumVar iloNumVar) throws IloException {
            int n = ((CpxControlCallback)this.cb).getFeasibility(this.getIndex(iloNumVar));
            return IntegerFeasibilityStatus.map[n];
        }

        protected IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getFeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            int[] nArray2 = new int[n2];
            ((CpxControlCallback)this.cb).getFeasibilities(nArray2, nArray);
            IntegerFeasibilityStatus[] integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
            for (int i = 0; i < n2; ++i) {
                integerFeasibilityStatusArray[i] = IntegerFeasibilityStatus.map[nArray2[i]];
            }
            return integerFeasibilityStatusArray;
        }

        protected IntegerFeasibilityStatus getSOSFeasibility(IloSOS1 iloSOS1) throws IloException {
            if (((CpxControlCallback)this.cb).getSOSFeasibility(this.getIndex(iloSOS1)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected IntegerFeasibilityStatus getSOSFeasibility(IloSOS2 iloSOS2) throws IloException {
            if (((CpxControlCallback)this.cb).getSOSFeasibility(this.getIndex(iloSOS2)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected Object getNodeData() throws IloException {
            return ((CpxControlCallback)this.cb).getNodeData();
        }
    }

    public static class IntegerFeasibilityStatus {
        public static final IntegerFeasibilityStatus Feasible = new _Feasible();
        public static final IntegerFeasibilityStatus Implied = new _Implied();
        public static final IntegerFeasibilityStatus Infeasible = new _Infeasible();
        static IntegerFeasibilityStatus[] map = new IntegerFeasibilityStatus[]{Feasible, Infeasible, Implied};

        private static class _Infeasible
        extends IntegerFeasibilityStatus {
            private _Infeasible() {
            }

            public String toString() {
                return "IntegerInfeasible";
            }
        }

        private static class _Implied
        extends IntegerFeasibilityStatus {
            private _Implied() {
            }

            public String toString() {
                return "ImpliedIntegerFeasible";
            }
        }

        private static class _Feasible
        extends IntegerFeasibilityStatus {
            private _Feasible() {
            }

            public String toString() {
                return "IntegerFeasible";
            }
        }
    }

    public static abstract class SolveCallback
    extends MIPCallback {
        protected SolveCallback() {
            this.cb = new CpxSolveCallback(this);
        }

        protected boolean solve(int n) throws IloException {
            ((CpxSolveCallback)this.cb).solveAlg(n);
            Status status = this.getStatus();
            return status == Status.Feasible || status == Status.Optimal;
        }

        protected boolean solve() throws IloException {
            return this.solve(0);
        }

        protected Status getStatus() throws IloException {
            return IloCplex.makeStatus(((CpxSolveCallback)this.cb).getCplexStatus(), ((CpxSolveCallback)this.cb).isPfeas(), ((CpxSolveCallback)this.cb).isDfeas());
        }

        protected CplexStatus getCplexStatus() throws IloException {
            return CplexStatus.getStatus(((CpxSolveCallback)this.cb).getCplexStatus());
        }

        public boolean isDualFeasible() throws IloException {
            return ((CpxSolveCallback)this.cb).isDfeas();
        }

        public boolean isPrimalFeasible() throws IloException {
            return ((CpxSolveCallback)this.cb).isPfeas();
        }

        protected void useSolution() {
            ((CpxSolveCallback)this.cb).useSolution();
        }

        protected void setVectors(double[] dArray, IloNumVar[] iloNumVarArray, double[] dArray2, IloRange[] iloRangeArray) throws IloException {
            int n = iloNumVarArray != null ? iloNumVarArray.length : 0;
            int n2 = iloRangeArray != null ? iloRangeArray.length : 0;
            this.setVectors(dArray, iloNumVarArray, 0, n, dArray2, iloRangeArray, 0, n2);
        }

        protected void setVectors(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray2, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
            ((CpxSolveCallback)this.cb).setVectors(dArray, iloNumVarArray, n, n2, dArray2, iloRangeArray, n3, n4);
        }
    }

    public static abstract class IncumbentCallback
    extends MIPCallback {
        protected IncumbentCallback() {
            this.cb = new CpxIncumbentCallback(this);
        }

        protected double getObjValue() throws IloException {
            return ((CpxIncumbentCallback)this.cb).getObjValue();
        }

        protected double getValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getX(iloNumVar);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getX(iloNumVarArray, n, n2);
        }

        protected double getValue(IloNumExpr iloNumExpr) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getValue((CpxNumExpr)iloNumExpr);
        }

        protected double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNrows()];
            double[] dArray2 = new double[this.getNQCs()];
            ((CpxIncumbentCallback)this.cb).getSlacks(dArray, dArray2);
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected NodeId getNodeId() throws IloException {
            return new NodeId(((CpxIncumbentCallback)this.cb).getNodeId());
        }

        protected Object getNodeData() throws IloException {
            return ((CpxIncumbentCallback)this.cb).getNodeData();
        }

        protected void reject() {
            ((CpxIncumbentCallback)this.cb).reject();
        }
    }

    public static abstract class MIPCallback
    extends MIPInfoCallback {
        protected MIPCallback() {
            this.cb = new CpxMIPCallback(this);
        }

        protected int getUserThreads() throws IloException {
            return ((CpxMIPCallback)this.cb).getUserThreads();
        }

        protected int getNcuts(int n) throws IloException {
            return ((CpxMIPCallback)this.cb).getNcuts(n);
        }

        protected int getNcliques() throws IloException {
            return ((CpxMIPCallback)this.cb).getNcliques();
        }

        protected int getNcovers() throws IloException {
            return ((CpxMIPCallback)this.cb).getNcovers();
        }

        protected int getNflowCovers() throws IloException {
            return ((CpxMIPCallback)this.cb).getNflowCovers();
        }

        protected int getNflowPaths() throws IloException {
            return ((CpxMIPCallback)this.cb).getNflowPaths();
        }

        protected int getNGUBcovers() throws IloException {
            return ((CpxMIPCallback)this.cb).getNGUBcovers();
        }

        protected int getNfractionalCuts() throws IloException {
            return ((CpxMIPCallback)this.cb).getNfractionalCuts();
        }

        protected int getNdisjunctiveCuts() throws IloException {
            return ((CpxMIPCallback)this.cb).getNdisjunctiveCuts();
        }

        protected int getNMIRs() throws IloException {
            return ((CpxMIPCallback)this.cb).getNMIRs();
        }

        protected int getNimpliedBounds() throws IloException {
            return ((CpxMIPCallback)this.cb).getNimpliedBounds();
        }

        protected int getNzeroHalfCuts() throws IloException {
            return ((CpxMIPCallback)this.cb).getNzeroHalfCuts();
        }

        protected double getObjCoef(IloNumVar iloNumVar) throws IloException {
            return ((CpxMIPCallback)this.cb).getObjCoef(this.getIndex(iloNumVar));
        }

        protected double[] getObjCoefs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getObjCoefs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getObjCoefs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxMIPCallback)this.cb).getObjCoefs(dArray, nArray);
            return dArray;
        }
    }

    public static abstract class MIPInfoCallback
    extends OptimizationCallback {
        final int getIndex(IloNumVar iloNumVar) {
            return ((CpxNumVar)iloNumVar).getVarIndexValue();
        }

        final int getIndex(IloRange iloRange) {
            return ((CpxRange)iloRange).getIndexValue();
        }

        final int getIndex(IloSOS1 iloSOS1) {
            return ((CpxSOS)((Object)iloSOS1)).getIndexValue();
        }

        final int getIndex(IloSOS2 iloSOS2) {
            return ((CpxSOS)((Object)iloSOS2)).getIndexValue();
        }

        protected MIPInfoCallback() {
            this.cb = new CpxMIPInfoCallback(this);
        }

        protected int getMyThreadNum() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getMyThreadNum();
        }

        protected double getBestObjValue() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getBestObjValue();
        }

        protected double getMIPRelativeGap() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getMIPRelativeGap();
        }

        protected double getCutoff() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getCutoff();
        }

        protected double getIncumbentObjValue() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getIncumbentObjValue();
        }

        protected double getIncumbentValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getIncumbentValue(this.getIndex(iloNumVar));
        }

        protected double[] getIncumbentValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getIncumbentValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getIncumbentValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            ((CpxMIPInfoCallback)this.cb).getIncumbentValues(dArray, nArray);
            return dArray;
        }

        protected boolean hasIncumbent() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).hasIncumbent();
        }

        protected int getNnodes() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNnodes();
        }

        protected int getNremainingNodes() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNremainingNodes();
        }

        protected int getNiterations() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNiterations();
        }

        protected BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
            return this.cb.getCplex().getDirection(iloNumVar);
        }

        protected int getPriority(IloNumVar iloNumVar) throws IloException {
            return this.cb.getCplex().getPriority(iloNumVar);
        }

        protected Quality getQuality(QualityType qualityType) throws IloException {
            Quality quality = new Quality();
            quality.var = null;
            quality.rng = null;
            quality.value = ((CpxMIPInfoCallback)this.cb).getQuality(qualityType.getValue());
            quality.type = qualityType;
            return quality;
        }
    }

    public static abstract class NetworkCallback
    extends OptimizationCallback {
        protected NetworkCallback() {
            this.cb = new CpxNetworkCallback(this);
        }

        protected double getObjValue() throws IloException {
            return ((CpxNetworkCallback)this.cb).getObjValue();
        }

        protected double getInfeasibility() throws IloException {
            return ((CpxNetworkCallback)this.cb).getInfeasibility();
        }

        protected boolean isFeasible() throws IloException {
            return ((CpxNetworkCallback)this.cb).isFeasible();
        }

        protected int getNiterations() throws IloException {
            return ((CpxNetworkCallback)this.cb).getNiterations();
        }
    }

    public static abstract class CrossoverCallback
    extends OptimizationCallback {
        protected CrossoverCallback() {
            this.cb = new CpxLPCallback(this, 3);
        }

        protected int getNprimalPushes() throws IloException {
            return ((CpxLPCallback)this.cb).getNprimalPushes();
        }

        protected int getNprimalExchanges() throws IloException {
            return ((CpxLPCallback)this.cb).getNprimalExchanges();
        }

        protected int getNdualPushes() throws IloException {
            return ((CpxLPCallback)this.cb).getNdualPushes();
        }

        protected int getNdualExchanges() throws IloException {
            return ((CpxLPCallback)this.cb).getNdualExchanges();
        }

        protected int getNsuperbasics() throws IloException {
            return ((CpxLPCallback)this.cb).getNsuperbasics();
        }
    }

    public static abstract class PresolveCallback
    extends OptimizationCallback {
        protected PresolveCallback() {
            this.cb = new CpxLPCallback(this, 0);
        }

        protected int getNremovedRows() throws IloException {
            return ((CpxLPCallback)this.cb).getNremovedRows();
        }

        protected int getNremovedCols() throws IloException {
            return ((CpxLPCallback)this.cb).getNremovedCols();
        }

        protected int getNaggregations() throws IloException {
            return ((CpxLPCallback)this.cb).getNaggregations();
        }

        protected int getNmodifiedCoeffs() throws IloException {
            return ((CpxLPCallback)this.cb).getNmodifiedCoeffs();
        }
    }

    public static abstract class BarrierCallback
    extends ContinuousCallback {
        protected BarrierCallback() {
            super(2);
        }

        protected double getDualObjValue() throws IloException {
            return ((CpxLPCallback)this.cb).getDualObjValue();
        }
    }

    public static abstract class SimplexCallback
    extends ContinuousCallback {
        protected SimplexCallback() {
            super(1);
        }
    }

    public static abstract class ContinuousCallback
    extends OptimizationCallback {
        protected ContinuousCallback(int n) {
            this.cb = new CpxLPCallback(this, n);
        }

        protected ContinuousCallback() {
            this.cb = new CpxLPCallback(this, -1);
        }

        protected double getObjValue() throws IloException {
            return ((CpxLPCallback)this.cb).getObjValue();
        }

        protected double getInfeasibility() throws IloException {
            return ((CpxLPCallback)this.cb).getInfeasibility();
        }

        protected double getDualInfeasibility() throws IloException {
            return ((CpxLPCallback)this.cb).getDualInfeasibility();
        }

        protected boolean isFeasible() throws IloException {
            return ((CpxLPCallback)this.cb).isFeasible();
        }

        protected boolean isDualFeasible() throws IloException {
            return ((CpxLPCallback)this.cb).isDualFeasible();
        }

        protected int getNiterations() throws IloException {
            return ((CpxLPCallback)this.cb).getNiterations();
        }
    }

    public static abstract class OptimizationCallback
    extends Callback {
        protected IloModel getModel() throws IloException {
            return this.cb.getCplex().getModel();
        }

        protected int getNrows() {
            return this.cb.getCplex().getNrows();
        }

        protected int getNQCs() {
            return this.cb.getCplex().getNQCs();
        }

        protected int getNcols() {
            return this.cb.getCplex().getNcols();
        }
    }

    public static abstract class Callback
    implements Cloneable {
        CpxCallback cb;

        Callback() {
        }

        protected abstract void main() throws IloException;

        protected void abort() {
            this.cb.abort();
        }

        protected double getEndTime() throws IloException {
            return this.cb.getEndTime();
        }

        final Callback makeClone() {
            try {
                return (Callback)this.clone();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static abstract class BranchDirection {
        public static final BranchDirection Up = new _Up();
        public static final BranchDirection Down = new _Down();
        public static final BranchDirection Global = new _Global();
        static BranchDirection[] map = new BranchDirection[]{Down, Global, Up};

        abstract int getValue();

        static BranchDirection getDirection(int n) {
            return map[n + 1];
        }

        private static class _Global
        extends BranchDirection {
            private _Global() {
            }

            int getValue() {
                return 0;
            }

            public String toString() {
                return "Global";
            }
        }

        private static class _Down
        extends BranchDirection {
            private _Down() {
            }

            int getValue() {
                return -1;
            }

            public String toString() {
                return "Down";
            }
        }

        private static class _Up
        extends BranchDirection {
            private _Up() {
            }

            int getValue() {
                return 1;
            }

            public String toString() {
                return "Up";
            }
        }
    }

    public static class CutType {
        public static final int Cover = 0;
        public static final int GUBCover = 1;
        public static final int FlowCover = 2;
        public static final int CliqueCover = 3;
        public static final int Frac = 4;
        public static final int MCF = 10;
        public static final int MIR = 5;
        public static final int FlowPath = 6;
        public static final int Disj = 7;
        public static final int ImplBd = 8;
        public static final int ZeroHalf = 9;
        public static final int LocalCover = 11;
        public static final int Tighten = 12;
        public static final int ObjDisj = 13;
        public static final int User = 14;
        public static final int Table = 15;
        public static final int SolnPool = 16;
    }

    public static class TuningStatus {
        public static final int Complete = 0;
        public static final int Abort = 1;
        public static final int TimeLim = 2;
    }

    public static class Quality {
        QualityType type;
        IloNumVar var;
        IloConstraint rng;
        double value;

        public double getValue() {
            return this.value;
        }

        public IloNumVar getNumVar() {
            return this.var;
        }

        public IloConstraint getConstraint() {
            return this.rng;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public QualityType getQualityType() {
            return this.type;
        }
    }

    public static abstract class QualityType {
        public static final QualityType MaxPrimalInfeas = new _MaxPrimalInfeas();
        public static final QualityType MaxScaledPrimalInfeas = new _MaxScaledPrimalInfeas();
        public static final QualityType SumPrimalInfeas = new _SumPrimalInfeas();
        public static final QualityType SumScaledPrimalInfeas = new _SumScaledPrimalInfeas();
        public static final QualityType MaxDualInfeas = new _MaxDualInfeas();
        public static final QualityType MaxScaledDualInfeas = new _MaxScaledDualInfeas();
        public static final QualityType SumDualInfeas = new _SumDualInfeas();
        public static final QualityType SumScaledDualInfeas = new _SumScaledDualInfeas();
        public static final QualityType MaxIntInfeas = new _MaxIntInfeas();
        public static final QualityType SumIntInfeas = new _SumIntInfeas();
        public static final QualityType MaxPrimalResidual = new _MaxPrimalResidual();
        public static final QualityType MaxScaledPrimalResidual = new _MaxScaledPrimalResidual();
        public static final QualityType SumPrimalResidual = new _SumPrimalResidual();
        public static final QualityType SumScaledPrimalResidual = new _SumScaledPrimalResidual();
        public static final QualityType MaxDualResidual = new _MaxDualResidual();
        public static final QualityType MaxScaledDualResidual = new _MaxScaledDualResidual();
        public static final QualityType SumDualResidual = new _SumDualResidual();
        public static final QualityType SumScaledDualResidual = new _SumScaledDualResidual();
        public static final QualityType MaxCompSlack = new _MaxCompSlack();
        public static final QualityType SumCompSlack = new _SumCompSlack();
        public static final QualityType MaxX = new _MaxX();
        public static final QualityType MaxScaledX = new _MaxScaledX();
        public static final QualityType MaxPi = new _MaxPi();
        public static final QualityType MaxScaledPi = new _MaxScaledPi();
        public static final QualityType MaxSlack = new _MaxSlack();
        public static final QualityType MaxScaledSlack = new _MaxScaledSlack();
        public static final QualityType MaxRedCost = new _MaxRedCost();
        public static final QualityType MaxScaledRedCost = new _MaxScaledRedCost();
        public static final QualityType SumX = new _SumX();
        public static final QualityType SumScaledX = new _SumScaledX();
        public static final QualityType SumPi = new _SumPi();
        public static final QualityType SumScaledPi = new _SumScaledPi();
        public static final QualityType SumSlack = new _SumSlack();
        public static final QualityType SumScaledSlack = new _SumScaledSlack();
        public static final QualityType SumRedCost = new _SumRedCost();
        public static final QualityType SumScaledRedCost = new _SumScaledRedCost();
        public static final QualityType Kappa = new _Kappa();
        public static final QualityType ObjGap = new _ObjGap();
        public static final QualityType DualObj = new _DualObj();
        public static final QualityType PrimalObj = new _PrimalObj();
        public static final QualityType ExactKappa = new _ExactKappa();
        public static final QualityType KappaStable = new _KappaStable();
        public static final QualityType KappaSuspicious = new _KappaSuspicious();
        public static final QualityType KappaUnstable = new _KappaUnstable();
        public static final QualityType KappaIllposed = new _KappaIllposed();
        public static final QualityType KappaMax = new _KappaMax();
        public static final QualityType KappaAttention = new _KappaAttention();

        abstract int getValue();

        private static class _KappaAttention
        extends QualityType {
            private _KappaAttention() {
            }

            public String toString() {
                return "KappaAttention";
            }

            int getValue() {
                return 57;
            }
        }

        private static class _KappaMax
        extends QualityType {
            private _KappaMax() {
            }

            public String toString() {
                return "KappaMax";
            }

            int getValue() {
                return 56;
            }
        }

        private static class _KappaIllposed
        extends QualityType {
            private _KappaIllposed() {
            }

            public String toString() {
                return "KappaIllposed";
            }

            int getValue() {
                return 55;
            }
        }

        private static class _KappaUnstable
        extends QualityType {
            private _KappaUnstable() {
            }

            public String toString() {
                return "KappaUnstable";
            }

            int getValue() {
                return 54;
            }
        }

        private static class _KappaSuspicious
        extends QualityType {
            private _KappaSuspicious() {
            }

            public String toString() {
                return "KappaSuspicious";
            }

            int getValue() {
                return 53;
            }
        }

        private static class _KappaStable
        extends QualityType {
            private _KappaStable() {
            }

            public String toString() {
                return "KappaStable";
            }

            int getValue() {
                return 52;
            }
        }

        private static class _ExactKappa
        extends QualityType {
            private _ExactKappa() {
            }

            public String toString() {
                return "ExactKappa";
            }

            int getValue() {
                return 51;
            }
        }

        private static class _PrimalObj
        extends QualityType {
            private _PrimalObj() {
            }

            public String toString() {
                return "PrimalObj";
            }

            int getValue() {
                return 42;
            }
        }

        private static class _DualObj
        extends QualityType {
            private _DualObj() {
            }

            public String toString() {
                return "DualObj";
            }

            int getValue() {
                return 41;
            }
        }

        private static class _ObjGap
        extends QualityType {
            private _ObjGap() {
            }

            public String toString() {
                return "ObjGap";
            }

            int getValue() {
                return 40;
            }
        }

        private static class _Kappa
        extends QualityType {
            private _Kappa() {
            }

            public String toString() {
                return "Kappa";
            }

            int getValue() {
                return 39;
            }
        }

        private static class _SumScaledRedCost
        extends QualityType {
            private _SumScaledRedCost() {
            }

            public String toString() {
                return "SumScaledRedCost";
            }

            int getValue() {
                return 38;
            }
        }

        private static class _SumRedCost
        extends QualityType {
            private _SumRedCost() {
            }

            public String toString() {
                return "SumRedCost";
            }

            int getValue() {
                return 37;
            }
        }

        private static class _SumScaledSlack
        extends QualityType {
            private _SumScaledSlack() {
            }

            public String toString() {
                return "SumScaledSlack";
            }

            int getValue() {
                return 36;
            }
        }

        private static class _SumSlack
        extends QualityType {
            private _SumSlack() {
            }

            public String toString() {
                return "SumSlack";
            }

            int getValue() {
                return 35;
            }
        }

        private static class _SumScaledPi
        extends QualityType {
            private _SumScaledPi() {
            }

            public String toString() {
                return "SumScaledPi";
            }

            int getValue() {
                return 34;
            }
        }

        private static class _SumPi
        extends QualityType {
            private _SumPi() {
            }

            public String toString() {
                return "SumPi";
            }

            int getValue() {
                return 33;
            }
        }

        private static class _SumScaledX
        extends QualityType {
            private _SumScaledX() {
            }

            public String toString() {
                return "SumScaledX";
            }

            int getValue() {
                return 32;
            }
        }

        private static class _SumX
        extends QualityType {
            private _SumX() {
            }

            public String toString() {
                return "SumX";
            }

            int getValue() {
                return 31;
            }
        }

        private static class _MaxScaledRedCost
        extends QualityType {
            private _MaxScaledRedCost() {
            }

            public String toString() {
                return "MaxScaledRedCost";
            }

            int getValue() {
                return 30;
            }
        }

        private static class _MaxRedCost
        extends QualityType {
            private _MaxRedCost() {
            }

            public String toString() {
                return "MaxRedCost";
            }

            int getValue() {
                return 29;
            }
        }

        private static class _MaxScaledSlack
        extends QualityType {
            private _MaxScaledSlack() {
            }

            public String toString() {
                return "MaxScaledSlack";
            }

            int getValue() {
                return 28;
            }
        }

        private static class _MaxSlack
        extends QualityType {
            private _MaxSlack() {
            }

            public String toString() {
                return "MaxSlack";
            }

            int getValue() {
                return 27;
            }
        }

        private static class _MaxScaledPi
        extends QualityType {
            private _MaxScaledPi() {
            }

            public String toString() {
                return "MaxScaledPi";
            }

            int getValue() {
                return 26;
            }
        }

        private static class _MaxPi
        extends QualityType {
            private _MaxPi() {
            }

            public String toString() {
                return "MaxPi";
            }

            int getValue() {
                return 25;
            }
        }

        private static class _MaxScaledX
        extends QualityType {
            private _MaxScaledX() {
            }

            public String toString() {
                return "MaxScaledX";
            }

            int getValue() {
                return 24;
            }
        }

        private static class _MaxX
        extends QualityType {
            private _MaxX() {
            }

            public String toString() {
                return "MaxX";
            }

            int getValue() {
                return 23;
            }
        }

        private static class _SumCompSlack
        extends QualityType {
            private _SumCompSlack() {
            }

            public String toString() {
                return "SumCompSlack";
            }

            int getValue() {
                return 21;
            }
        }

        private static class _MaxCompSlack
        extends QualityType {
            private _MaxCompSlack() {
            }

            public String toString() {
                return "MaxCompSlack";
            }

            int getValue() {
                return 19;
            }
        }

        private static class _SumScaledDualResidual
        extends QualityType {
            private _SumScaledDualResidual() {
            }

            public String toString() {
                return "SumScaledDualResidual";
            }

            int getValue() {
                return 18;
            }
        }

        private static class _SumDualResidual
        extends QualityType {
            private _SumDualResidual() {
            }

            public String toString() {
                return "SumDualResidual";
            }

            int getValue() {
                return 17;
            }
        }

        private static class _MaxScaledDualResidual
        extends QualityType {
            private _MaxScaledDualResidual() {
            }

            public String toString() {
                return "MaxScaledDualResidual";
            }

            int getValue() {
                return 16;
            }
        }

        private static class _MaxDualResidual
        extends QualityType {
            private _MaxDualResidual() {
            }

            public String toString() {
                return "MaxDualResidual";
            }

            int getValue() {
                return 15;
            }
        }

        private static class _SumScaledPrimalResidual
        extends QualityType {
            private _SumScaledPrimalResidual() {
            }

            public String toString() {
                return "SumScaledPrimalResidual";
            }

            int getValue() {
                return 14;
            }
        }

        private static class _SumPrimalResidual
        extends QualityType {
            private _SumPrimalResidual() {
            }

            public String toString() {
                return "SumPrimalResidual";
            }

            int getValue() {
                return 13;
            }
        }

        private static class _MaxScaledPrimalResidual
        extends QualityType {
            private _MaxScaledPrimalResidual() {
            }

            public String toString() {
                return "MaxScaledPrimalResidual";
            }

            int getValue() {
                return 12;
            }
        }

        private static class _MaxPrimalResidual
        extends QualityType {
            private _MaxPrimalResidual() {
            }

            public String toString() {
                return "MaxPrimalResidual";
            }

            int getValue() {
                return 11;
            }
        }

        private static class _SumIntInfeas
        extends QualityType {
            private _SumIntInfeas() {
            }

            public String toString() {
                return "SumIntInfeas";
            }

            int getValue() {
                return 10;
            }
        }

        private static class _MaxIntInfeas
        extends QualityType {
            private _MaxIntInfeas() {
            }

            public String toString() {
                return "MaxIntInfeas";
            }

            int getValue() {
                return 9;
            }
        }

        private static class _SumScaledDualInfeas
        extends QualityType {
            private _SumScaledDualInfeas() {
            }

            public String toString() {
                return "SumScaledDualInfeas";
            }

            int getValue() {
                return 8;
            }
        }

        private static class _SumDualInfeas
        extends QualityType {
            private _SumDualInfeas() {
            }

            public String toString() {
                return "SumDualInfeas";
            }

            int getValue() {
                return 7;
            }
        }

        private static class _MaxScaledDualInfeas
        extends QualityType {
            private _MaxScaledDualInfeas() {
            }

            public String toString() {
                return "MaxScaledDualInfeas";
            }

            int getValue() {
                return 6;
            }
        }

        private static class _MaxDualInfeas
        extends QualityType {
            private _MaxDualInfeas() {
            }

            public String toString() {
                return "MaxDualInfeas";
            }

            int getValue() {
                return 5;
            }
        }

        private static class _SumScaledPrimalInfeas
        extends QualityType {
            private _SumScaledPrimalInfeas() {
            }

            public String toString() {
                return "SumScaledPrimalInfeas";
            }

            int getValue() {
                return 4;
            }
        }

        private static class _SumPrimalInfeas
        extends QualityType {
            private _SumPrimalInfeas() {
            }

            public String toString() {
                return "SumPrimalInfeas";
            }

            int getValue() {
                return 3;
            }
        }

        private static class _MaxScaledPrimalInfeas
        extends QualityType {
            private _MaxScaledPrimalInfeas() {
            }

            public String toString() {
                return "MaxScaledPrimalInfeas";
            }

            int getValue() {
                return 2;
            }
        }

        private static class _MaxPrimalInfeas
        extends QualityType {
            private _MaxPrimalInfeas() {
            }

            public String toString() {
                return "MaxPrimalInfeas";
            }

            int getValue() {
                return 1;
            }
        }
    }

    public static class ConflictStatus
    implements Serializable {
        private static final long serialVersionUID = 1220L;
        private int _stat;
        public static final ConflictStatus Excluded = new ConflictStatus(-1);
        public static final ConflictStatus PossibleMember = new ConflictStatus(0);
        public static final ConflictStatus Member = new ConflictStatus(3);

        private ConflictStatus(int n) {
            this._stat = n;
        }

        static ConflictStatus make(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    return PossibleMember;
                }
                case 3: 
                case 4: 
                case 5: {
                    return Member;
                }
            }
            return Excluded;
        }

        public String toString() {
            switch (this._stat) {
                case 0: {
                    return "PossibleMember";
                }
                case 3: {
                    return "Member";
                }
            }
            return "Excluded";
        }

        public boolean equals(Object object) {
            if (object instanceof ConflictStatus) {
                return this._stat == ((ConflictStatus)object)._stat;
            }
            return false;
        }
    }

    public static class IIS {
        Status[] _cstat;
        IloNumVar[] _var;
        Status[] _rstat;
        IloConstraint[] _rng;

        public IloNumVar[] getNumVars() {
            return this._var;
        }

        public Status[] getNumVarStatuses() {
            return this._cstat;
        }

        public IloConstraint[] getConstraints() {
            return this._rng;
        }

        public Status[] getConstraintStatuses() {
            return this._rstat;
        }

        IIS(Status[] statusArray, IloNumVar[] iloNumVarArray, Status[] statusArray2, IloConstraint[] iloConstraintArray) {
            this._cstat = statusArray;
            this._rstat = statusArray2;
            this._var = iloNumVarArray;
            this._rng = iloConstraintArray;
        }

        public static class Status {
            int _stat;
            public static final Status AtLower = new Status(0);
            public static final Status Fixed = new Status(1);
            public static final Status AtUpper = new Status(2);

            Status(int n) {
                this._stat = n;
            }

            public String toString() {
                switch (this._stat) {
                    case 0: {
                        return "AtLower";
                    }
                    case 1: {
                        return "Fixed";
                    }
                    case 2: {
                        return "AtUpper";
                    }
                }
                return "NotAnIISStatus";
            }

            public boolean equals(Object object) {
                if (object instanceof Status) {
                    Status status = (Status)object;
                    return status._stat == this._stat;
                }
                return false;
            }
        }
    }

    public static class Relaxation {
        public static final int MinSum = 0;
        public static final int OptSum = 1;
        public static final int MinInf = 2;
        public static final int OptInf = 3;
        public static final int MinQuad = 4;
        public static final int OptQuad = 5;
    }

    public static class MIPStartEffort {
        int _value;
        public static final MIPStartEffort Auto = new MIPStartEffort(0);
        public static final MIPStartEffort CheckFeas = new MIPStartEffort(1);
        public static final MIPStartEffort SolveFixed = new MIPStartEffort(2);
        public static final MIPStartEffort SolveMIP = new MIPStartEffort(3);
        public static final MIPStartEffort Repair = new MIPStartEffort(4);

        MIPStartEffort(int n) {
            this._value = n;
        }
    }

    public static class WriteLevel {
        public static final int Auto = 0;
        public static final int AllVars = 1;
        public static final int NonzeroVars = 3;
        public static final int DiscreteVars = 2;
        public static final int NonzeroDiscreteVars = 4;
    }

    public static class BasisStatus {
        int _stat;
        public static final BasisStatus NotABasicStatus = new BasisStatus(-1);
        public static final BasisStatus AtLower = new BasisStatus(0);
        public static final BasisStatus Basic = new BasisStatus(1);
        public static final BasisStatus AtUpper = new BasisStatus(2);
        public static final BasisStatus FreeOrSuperbasic = new BasisStatus(3);

        BasisStatus(int n) {
            this._stat = n;
        }

        public String toString() {
            switch (this._stat) {
                case 0: {
                    return "AtLower";
                }
                case 1: {
                    return "Basic";
                }
                case 2: {
                    return "AtUpper";
                }
                case 3: {
                    return "FreeOrSuperbasic";
                }
            }
            return "NotABasicStatus";
        }

        public boolean equals(Object object) {
            if (object instanceof BasisStatus) {
                BasisStatus basisStatus = (BasisStatus)object;
                return basisStatus._stat == this._stat;
            }
            return false;
        }
    }

    public static class CplexStatus
    implements Serializable {
        static final long serialVersionUID = -7367834674783924158L;
        int _status;
        String _name;
        public static final CplexStatus Unknown = new CplexStatus(0, "Unknown");
        static final int Unknown_Status = 0;
        public static final CplexStatus Optimal = new CplexStatus(1, "Optimal");
        static final int Optimal_Status = 1;
        public static final CplexStatus Unbounded = new CplexStatus(2, "Unbounded");
        static final int Unbounded_Status = 2;
        public static final CplexStatus Infeasible = new CplexStatus(3, "Infeasible");
        static final int Infeasible_Status = 3;
        public static final CplexStatus InfOrUnbd = new CplexStatus(4, "InfOrUnbd");
        static final int InfOrUnbd_Status = 4;
        public static final CplexStatus OptimalInfeas = new CplexStatus(5, "OptimalInfeas");
        static final int OptimalInfeas_Status = 5;
        public static final CplexStatus NumBest = new CplexStatus(6, "NumBest");
        static final int NumBest_Status = 6;
        public static final CplexStatus FeasibleRelaxedSum = new CplexStatus(14, "FeasibleRelaxedSum");
        static final int FeasibleRelaxedSum_Status = 14;
        public static final CplexStatus OptimalRelaxedSum = new CplexStatus(15, "OptimalRelaxedSum");
        static final int OptimalRelaxedSum_Status = 15;
        public static final CplexStatus FeasibleRelaxedInf = new CplexStatus(16, "FeasibleRelaxedInf");
        static final int FeasibleRelaxedInf_Status = 16;
        public static final CplexStatus OptimalRelaxedInf = new CplexStatus(17, "OptimalRelaxedInf");
        static final int OptimalRelaxedInf_Status = 17;
        public static final CplexStatus FeasibleRelaxedQuad = new CplexStatus(18, "FeasibleRelaxedQuad");
        static final int FeasibleRelaxedQuad_Status = 18;
        public static final CplexStatus OptimalRelaxedQuad = new CplexStatus(19, "OptimalRelaxedQuad");
        static final int OptimalRelaxedQuad_Status = 19;
        public static final CplexStatus AbortRelaxed = new CplexStatus(126, "AbortRelaxed");
        static final int AbortRelaxed_Status = 126;
        public static final CplexStatus AbortObjLim = new CplexStatus(12, "AbortObjLim");
        static final int AbortObjLim_Status = 12;
        public static final CplexStatus AbortPrimObjLim = new CplexStatus(21, "AbortPrimObjLim");
        static final int AbortPrimObjLim_Status = 21;
        public static final CplexStatus AbortDualObjLim = new CplexStatus(22, "AbortDualObjLim");
        static final int AbortDualObjLim_Status = 22;
        public static final CplexStatus AbortItLim = new CplexStatus(10, "AbortItLim");
        static final int AbortItLim_Status = 10;
        public static final CplexStatus AbortTimeLim = new CplexStatus(11, "AbortTimeLim");
        static final int AbortTimeLim_Status = 11;
        public static final CplexStatus AbortUser = new CplexStatus(13, "AbortUser");
        static final int AbortUser_Status = 13;
        public static final CplexStatus OptimalFaceUnbounded = new CplexStatus(20, "OptimalFaceUnbounded");
        static final int OptimalFaceUnbounded_Status = 20;
        public static final CplexStatus OptimalTol = new CplexStatus(102, "OptimalTol");
        static final int OptimalTol_Status = 102;
        public static final CplexStatus SolLim = new CplexStatus(104, "SolLim");
        static final int SolLim_Status = 104;
        public static final CplexStatus PopulateSolLim = new CplexStatus(128, "PopulateSolLim");
        static final int PopulateSolLim_Status = 128;
        public static final CplexStatus NodeLimFeas = new CplexStatus(105, "NodeLimFeas");
        static final int NodeLimFeas_Status = 105;
        public static final CplexStatus NodeLimInfeas = new CplexStatus(106, "NodeLimInfeas");
        static final int NodeLimInfeas_Status = 106;
        public static final CplexStatus FailFeas = new CplexStatus(109, "FailFeas");
        static final int FailFeas_Status = 109;
        public static final CplexStatus FailInfeas = new CplexStatus(110, "FailInfeas");
        static final int FailInfeas_Status = 110;
        public static final CplexStatus MemLimFeas = new CplexStatus(111, "MemLimFeas");
        static final int MemLimFeas_Status = 111;
        public static final CplexStatus MemLimInfeas = new CplexStatus(112, "MemLimInfeas");
        static final int MemLimInfeas_Status = 112;
        public static final CplexStatus FailFeasNoTree = new CplexStatus(116, "FailFeasNoTree");
        static final int FailFeasNoTree_Status = 116;
        public static final CplexStatus FailInfeasNoTree = new CplexStatus(117, "FailInfeasNoTree");
        static final int FailInfeasNoTree_Status = 117;
        public static final CplexStatus ConflictFeasible = new CplexStatus(30, "ConflictFeasible");
        static final int ConflictFeasible_Status = 30;
        public static final CplexStatus ConflictMinimal = new CplexStatus(31, "ConflictMinimal");
        static final int ConflictMinimal_Status = 31;
        public static final CplexStatus ConflictAbortContradiction = new CplexStatus(32, "ConflictAbortContradiction");
        static final int ConflictAbortContradiction_Status = 32;
        public static final CplexStatus ConflictAbortTimeLim = new CplexStatus(33, "ConflictAbortTimeLim");
        static final int ConflictAbortTimeLim_Status = 33;
        public static final CplexStatus ConflictAbortItLim = new CplexStatus(34, "ConflictAbortItLim");
        static final int ConflictAbortItLim_Status = 34;
        public static final CplexStatus ConflictAbortNodeLim = new CplexStatus(35, "ConflictAbortNodeLim");
        static final int ConflictAbortNodeLim_Status = 35;
        public static final CplexStatus ConflictAbortObjLim = new CplexStatus(36, "ConflictAbortObjLim");
        static final int ConflictAbortObjLim_Status = 36;
        public static final CplexStatus ConflictAbortMemLim = new CplexStatus(37, "ConflictAbortMemLim");
        static final int ConflictAbortMemLim_Status = 37;
        public static final CplexStatus ConflictAbortUser = new CplexStatus(38, "ConflictAbortUser");
        static final int ConflictAbortUser_Status = 38;
        public static final CplexStatus Feasible = new CplexStatus(23, "Feasible");
        static final int Feasible_Status = 23;
        public static final CplexStatus OptimalPopulated = new CplexStatus(129, "OptimalPopulated");
        static final int OptimalPopulated_Status = 129;
        public static final CplexStatus OptimalPopulatedTol = new CplexStatus(130, "OptimalPopulatedTol");
        static final int OptimalPopulatedTol_Status = 130;

        CplexStatus(int n, String string) {
            this._status = n;
            this._name = string;
        }

        final int getValue() {
            return this._status;
        }

        static CplexStatus getStatus(int n) {
            switch (n) {
                case 0: {
                    return Unknown;
                }
                case 1: {
                    return Optimal;
                }
                case 2: {
                    return Unbounded;
                }
                case 3: {
                    return Infeasible;
                }
                case 4: {
                    return InfOrUnbd;
                }
                case 5: {
                    return OptimalInfeas;
                }
                case 6: {
                    return NumBest;
                }
                case 14: {
                    return FeasibleRelaxedSum;
                }
                case 15: {
                    return OptimalRelaxedSum;
                }
                case 16: {
                    return FeasibleRelaxedInf;
                }
                case 17: {
                    return OptimalRelaxedInf;
                }
                case 18: {
                    return FeasibleRelaxedQuad;
                }
                case 19: {
                    return OptimalRelaxedQuad;
                }
                case 126: {
                    return AbortRelaxed;
                }
                case 12: {
                    return AbortObjLim;
                }
                case 21: {
                    return AbortPrimObjLim;
                }
                case 22: {
                    return AbortDualObjLim;
                }
                case 10: {
                    return AbortItLim;
                }
                case 11: {
                    return AbortTimeLim;
                }
                case 13: {
                    return AbortUser;
                }
                case 20: {
                    return OptimalFaceUnbounded;
                }
                case 102: {
                    return OptimalTol;
                }
                case 104: {
                    return SolLim;
                }
                case 128: {
                    return PopulateSolLim;
                }
                case 105: {
                    return NodeLimFeas;
                }
                case 106: {
                    return NodeLimInfeas;
                }
                case 109: {
                    return FailFeas;
                }
                case 110: {
                    return FailInfeas;
                }
                case 111: {
                    return MemLimFeas;
                }
                case 112: {
                    return MemLimInfeas;
                }
                case 116: {
                    return FailFeasNoTree;
                }
                case 117: {
                    return FailInfeasNoTree;
                }
                case 30: {
                    return ConflictFeasible;
                }
                case 31: {
                    return ConflictMinimal;
                }
                case 32: {
                    return ConflictAbortContradiction;
                }
                case 33: {
                    return ConflictAbortTimeLim;
                }
                case 34: {
                    return ConflictAbortItLim;
                }
                case 35: {
                    return ConflictAbortNodeLim;
                }
                case 36: {
                    return ConflictAbortObjLim;
                }
                case 37: {
                    return ConflictAbortMemLim;
                }
                case 38: {
                    return ConflictAbortUser;
                }
                case 23: {
                    return Feasible;
                }
                case 129: {
                    return OptimalPopulated;
                }
                case 130: {
                    return OptimalPopulatedTol;
                }
                case 101: {
                    return Optimal;
                }
                case 103: {
                    return Infeasible;
                }
                case 107: {
                    return AbortTimeLim;
                }
                case 108: {
                    return AbortTimeLim;
                }
                case 113: {
                    return AbortUser;
                }
                case 114: {
                    return AbortUser;
                }
                case 115: {
                    return OptimalInfeas;
                }
                case 118: {
                    return Unbounded;
                }
                case 119: {
                    return InfOrUnbd;
                }
            }
            return Unknown;
        }

        public String toString() {
            return this._name;
        }

        public boolean equals(Object object) {
            if (object instanceof CplexStatus) {
                return ((CplexStatus)object).getValue() == this.getValue();
            }
            return false;
        }
    }

    public static class DeleteMode {
        public static final DeleteMode LeaveBasis = new DeleteMode();
        public static final DeleteMode FixBasis = new DeleteMode();

        private DeleteMode() {
        }
    }

    public static class MIPSearch {
        public static final int Auto = 0;
        public static final int Traditional = 1;
        public static final int Dynamic = 2;
    }

    public static class ParallelMode {
        public static final int Auto = 0;
        public static final int Deterministic = 1;
        public static final int Opportunistic = -1;
    }

    public static class DualPricing {
        public static final int Auto = 0;
        public static final int Full = 1;
        public static final int Steep = 2;
        public static final int FullSteep = 3;
        public static final int SteepQStart = 4;
        public static final int Devex = 5;
    }

    public static class PrimalPricing {
        public static final int Partial = -1;
        public static final int Auto = 0;
        public static final int Devex = 1;
        public static final int Steep = 2;
        public static final int SteepQStart = 3;
        public static final int Full = 4;
    }

    public static class NodeSelect {
        public static final int DFS = 0;
        public static final int BestBound = 1;
        public static final int BestEst = 2;
        public static final int BestEstAlt = 3;
    }

    public static class VariableSelect {
        public static final int MinInfeas = -1;
        public static final int DefaultVarSel = 0;
        public static final int MaxInfeas = 1;
        public static final int Pseudo = 2;
        public static final int Strong = 3;
        public static final int PseudoReduced = 4;
    }

    public static class MIPEmphasis {
        public static final int Balanced = 0;
        public static final int Feasibility = 1;
        public static final int Optimality = 2;
        public static final int BestBound = 3;
        public static final int HiddenFeas = 4;
    }

    public static class StringParameter
    extends Parameter {
        private StringParam _key;
        private String _value;

        public StringParameter(StringParam stringParam, String string) {
            this._key = stringParam;
            this._value = string;
        }

        public int getType() {
            return 3;
        }

        public StringParam getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }
    }

    public static class BooleanParameter
    extends Parameter {
        private BooleanParam _key;
        private boolean _value;

        public BooleanParameter(BooleanParam booleanParam, boolean bl) {
            this._key = booleanParam;
            this._value = bl;
        }

        public int getType() {
            return 2;
        }

        public BooleanParam getKey() {
            return this._key;
        }

        public boolean getValue() {
            return this._value;
        }
    }

    public static class DoubleParameter
    extends Parameter {
        private DoubleParam _key;
        private double _value;

        public DoubleParameter(DoubleParam doubleParam, double d) {
            this._key = doubleParam;
            this._value = d;
        }

        public int getType() {
            return 1;
        }

        public DoubleParam getKey() {
            return this._key;
        }

        public double getValue() {
            return this._value;
        }
    }

    public static class IntParameter
    extends Parameter {
        private IntParam _key;
        private int _value;

        public IntParameter(IntParam intParam, int n) {
            this._key = intParam;
            this._value = n;
        }

        public int getType() {
            return 0;
        }

        public IntParam getKey() {
            return this._key;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static abstract class Parameter {
        public static final int IntType = 0;
        public static final int DoubleType = 1;
        public static final int BooleanType = 2;
        public static final int StringType = 3;
        public static final int UnknownType = 4;

        public abstract int getType();
    }

    public static class ParameterSet
    implements Serializable {
        private static final long serialVersionUID = 1220L;
        Hashtable _params = new Hashtable();

        public void clear() {
            this._params.clear();
        }

        public void setParam(IntParam intParam, int n) {
            Integer n2 = new Integer(intParam.getValue());
            if (this._params.containsKey(n2)) {
                this._params.remove(n2);
            }
            this._params.put(n2, new Integer(n));
        }

        public void setParam(StringParam stringParam, String string) {
            Integer n = new Integer(stringParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, string);
        }

        public void setParam(BooleanParam booleanParam, boolean bl) {
            Integer n = new Integer(booleanParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, new Boolean(bl));
        }

        public void setParam(DoubleParam doubleParam, double d) {
            Integer n = new Integer(doubleParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, new Double(d));
        }

        public int getParam(IntParam intParam) throws IloException {
            Integer n = new Integer(intParam.getValue());
            if (this._params.containsKey(n)) {
                Integer n2 = (Integer)this._params.get(n);
                return n2;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public String getParam(StringParam stringParam) throws IloException {
            Integer n = new Integer(stringParam.getValue());
            if (this._params.containsKey(n)) {
                return (String)this._params.get(n);
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public boolean getParam(BooleanParam booleanParam) throws IloException {
            Integer n = new Integer(booleanParam.getValue());
            if (this._params.containsKey(n)) {
                Boolean bl = (Boolean)this._params.get(n);
                return bl;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public double getParam(DoubleParam doubleParam) throws IloException {
            Integer n = new Integer(doubleParam.getValue());
            if (this._params.containsKey(n)) {
                Double d = (Double)this._params.get(n);
                return d;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        void applyTo(CplexI cplexI) throws IloException {
            for (Integer n : this._params.keySet()) {
                Object v = this._params.get(n);
                if (v instanceof Boolean) {
                    int n2 = 0;
                    if (((Boolean)v).booleanValue()) {
                        n2 = 1;
                    }
                    cplexI.setIntParam(n, n2);
                    continue;
                }
                if (v instanceof Integer) {
                    cplexI.setIntParam(n, (Integer)v);
                    continue;
                }
                if (v instanceof Double) {
                    cplexI.setDoubleParam(n, (Double)v);
                    continue;
                }
                if (!(v instanceof String)) continue;
                cplexI.setStringParam(n, ((String)v).toString());
            }
        }

        void extractFrom(CplexI cplexI) throws IloException {
            this.clear();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1000];
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            int[] nArray6 = new int[1];
            int[] nArray7 = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            cplexI.CALL(Cplex.CPXgetchgparam(cplexI.getEnv(), nArray, nArray3, 1000, nArray2));
            for (int i = 0; i < nArray[0]; ++i) {
                int n = nArray3[i];
                if (Cplex.CPXinfointparam(cplexI.getEnv(), n, nArray4, nArray5, nArray6) == 0) {
                    Cplex.CPXgetintparam(cplexI.getEnv(), n, nArray7);
                    if (nArray6[0] != 1 || nArray5[0] != 0) {
                        if (n == 1063 || n == 2025) continue;
                        this._params.put(new Integer(n), new Integer(nArray7[0]));
                        continue;
                    }
                    boolean bl = false;
                    if (nArray7[0] == 1) {
                        bl = true;
                    }
                    this._params.put(new Integer(n), new Boolean(bl));
                    continue;
                }
                if (Cplex.CPXinfodblparam(cplexI.getEnv(), n, dArray, dArray2, dArray3) == 0) {
                    Cplex.CPXgetdblparam(cplexI.getEnv(), n, dArray4);
                    this._params.put(new Integer(n), new Double(dArray4[0]));
                    continue;
                }
                String[] stringArray = new String[1];
                Cplex.CPXgetstrparam(cplexI.getEnv(), n, stringArray);
                this._params.put(new Integer(n), stringArray[0]);
            }
        }

        public Iterator iterator() {
            Vector<Parameter> vector = new Vector<Parameter>();
            Enumeration enumeration = this._params.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = Param._revindex.get(k);
                Object v2 = this._params.get(k);
                if (v instanceof IntParam) {
                    vector.add(new IntParameter((IntParam)v, (Integer)v2));
                    continue;
                }
                if (v instanceof DoubleParam) {
                    vector.add(new DoubleParameter((DoubleParam)v, (Double)v2));
                    continue;
                }
                if (v instanceof BooleanParam) {
                    vector.add(new BooleanParameter((BooleanParam)v, (Boolean)v2));
                    continue;
                }
                if (!(v instanceof StringParam)) continue;
                vector.add(new StringParameter((StringParam)v, (String)v2));
            }
            return vector.iterator();
        }
    }

    public static abstract class StringParam
    extends Param {
        public static final StringParam WorkDir = new _WorkDir();

        private static class _WorkDir
        extends StringParam {
            public _WorkDir() {
                _revindex.put(new Integer(1064), this);
            }

            public String toString() {
                return "WorkDir";
            }

            public int getValue() {
                return 1064;
            }
        }
    }

    public static abstract class DoubleParam
    extends Param {
        public static final DoubleParam EpMrk = new _EpMrk();
        public static final DoubleParam EpOpt = new _EpOpt();
        public static final DoubleParam EpPer = new _EpPer();
        public static final DoubleParam EpRHS = new _EpRHS();
        public static final DoubleParam NetEpOpt = new _NetEpOpt();
        public static final DoubleParam NetEpRHS = new _NetEpRHS();
        public static final DoubleParam TiLim = new _TiLim();
        public static final DoubleParam TuningTiLim = new _TuningTiLim();
        public static final DoubleParam BtTol = new _BtTol();
        public static final DoubleParam CutLo = new _CutLo();
        public static final DoubleParam CutUp = new _CutUp();
        public static final DoubleParam EpGap = new _EpGap();
        public static final DoubleParam EpInt = new _EpInt();
        public static final DoubleParam EpAGap = new _EpAGap();
        public static final DoubleParam EpRelax = new _EpRelax();
        public static final DoubleParam ObjDif = new _ObjDif();
        public static final DoubleParam ObjLLim = new _ObjLLim();
        public static final DoubleParam ObjULim = new _ObjULim();
        public static final DoubleParam PolishTime = new _PolishTime();
        public static final DoubleParam PolishAfterEpAGap = new _PolishAfterEpAGap();
        public static final DoubleParam PolishAfterEpGap = new _PolishAfterEpGap();
        public static final DoubleParam PolishAfterTime = new _PolishAfterTime();
        public static final DoubleParam ProbeTime = new _ProbeTime();
        public static final DoubleParam RelObjDif = new _RelObjDif();
        public static final DoubleParam CutsFactor = new _CutsFactor();
        public static final DoubleParam TreLim = new _TreLim();
        public static final DoubleParam SolnPoolGap = new _SolnPoolGap();
        public static final DoubleParam SolnPoolAGap = new _SolnPoolAGap();
        public static final DoubleParam WorkMem = new _WorkMem();
        public static final DoubleParam BarEpComp = new _BarEpComp();
        public static final DoubleParam BarQCPEpComp = new _BarQCPEpComp();
        public static final DoubleParam BarGrowth = new _BarGrowth();
        public static final DoubleParam BarObjRng = new _BarObjRng();
        public static final DoubleParam EpLin = new _EpLin();

        private static class _EpLin
        extends DoubleParam {
            public _EpLin() {
                _revindex.put(new Integer(2068), this);
            }

            public String toString() {
                return "EpLin";
            }

            public int getValue() {
                return 2068;
            }
        }

        private static class _BarObjRng
        extends DoubleParam {
            public _BarObjRng() {
                _revindex.put(new Integer(3004), this);
            }

            public String toString() {
                return "BarObjRng";
            }

            public int getValue() {
                return 3004;
            }
        }

        private static class _BarGrowth
        extends DoubleParam {
            public _BarGrowth() {
                _revindex.put(new Integer(3003), this);
            }

            public String toString() {
                return "BarGrowth";
            }

            public int getValue() {
                return 3003;
            }
        }

        private static class _BarQCPEpComp
        extends DoubleParam {
            public _BarQCPEpComp() {
                _revindex.put(new Integer(3020), this);
            }

            public String toString() {
                return "BarQCPEpComp";
            }

            public int getValue() {
                return 3020;
            }
        }

        private static class _BarEpComp
        extends DoubleParam {
            public _BarEpComp() {
                _revindex.put(new Integer(3002), this);
            }

            public String toString() {
                return "BarEpComp";
            }

            public int getValue() {
                return 3002;
            }
        }

        private static class _WorkMem
        extends DoubleParam {
            public _WorkMem() {
                _revindex.put(new Integer(1065), this);
            }

            public String toString() {
                return "WorkMem";
            }

            public int getValue() {
                return 1065;
            }
        }

        private static class _SolnPoolAGap
        extends DoubleParam {
            public _SolnPoolAGap() {
                _revindex.put(new Integer(2106), this);
            }

            public String toString() {
                return "SolnPoolAGap";
            }

            public int getValue() {
                return 2106;
            }
        }

        private static class _SolnPoolGap
        extends DoubleParam {
            public _SolnPoolGap() {
                _revindex.put(new Integer(2105), this);
            }

            public String toString() {
                return "SolnPoolGap";
            }

            public int getValue() {
                return 2105;
            }
        }

        private static class _TreLim
        extends DoubleParam {
            public _TreLim() {
                _revindex.put(new Integer(2027), this);
            }

            public String toString() {
                return "TreLim";
            }

            public int getValue() {
                return 2027;
            }
        }

        private static class _CutsFactor
        extends DoubleParam {
            public _CutsFactor() {
                _revindex.put(new Integer(2033), this);
            }

            public String toString() {
                return "CutsFactor";
            }

            public int getValue() {
                return 2033;
            }
        }

        private static class _RelObjDif
        extends DoubleParam {
            public _RelObjDif() {
                _revindex.put(new Integer(2022), this);
            }

            public String toString() {
                return "RelObjDif";
            }

            public int getValue() {
                return 2022;
            }
        }

        private static class _ProbeTime
        extends DoubleParam {
            public _ProbeTime() {
                _revindex.put(new Integer(2065), this);
            }

            public String toString() {
                return "ProbeTime";
            }

            public int getValue() {
                return 2065;
            }
        }

        private static class _PolishAfterTime
        extends DoubleParam {
            public _PolishAfterTime() {
                _revindex.put(new Integer(2130), this);
            }

            public String toString() {
                return "PolishAfterTime";
            }

            public int getValue() {
                return 2130;
            }
        }

        private static class _PolishAfterEpGap
        extends DoubleParam {
            public _PolishAfterEpGap() {
                _revindex.put(new Integer(2127), this);
            }

            public String toString() {
                return "PolishAfterEpGap";
            }

            public int getValue() {
                return 2127;
            }
        }

        private static class _PolishAfterEpAGap
        extends DoubleParam {
            public _PolishAfterEpAGap() {
                _revindex.put(new Integer(2126), this);
            }

            public String toString() {
                return "PolishAfterEpAGap";
            }

            public int getValue() {
                return 2126;
            }
        }

        private static class _PolishTime
        extends DoubleParam {
            public _PolishTime() {
                _revindex.put(new Integer(2066), this);
            }

            public String toString() {
                return "PolishTime";
            }

            public int getValue() {
                return 2066;
            }
        }

        private static class _ObjULim
        extends DoubleParam {
            public _ObjULim() {
                _revindex.put(new Integer(1026), this);
            }

            public String toString() {
                return "ObjULim";
            }

            public int getValue() {
                return 1026;
            }
        }

        private static class _ObjLLim
        extends DoubleParam {
            public _ObjLLim() {
                _revindex.put(new Integer(1025), this);
            }

            public String toString() {
                return "ObjLLim";
            }

            public int getValue() {
                return 1025;
            }
        }

        private static class _ObjDif
        extends DoubleParam {
            public _ObjDif() {
                _revindex.put(new Integer(2019), this);
            }

            public String toString() {
                return "ObjDif";
            }

            public int getValue() {
                return 2019;
            }
        }

        private static class _EpRelax
        extends DoubleParam {
            public _EpRelax() {
                _revindex.put(new Integer(2073), this);
            }

            public String toString() {
                return "EpRelax";
            }

            public int getValue() {
                return 2073;
            }
        }

        private static class _EpAGap
        extends DoubleParam {
            public _EpAGap() {
                _revindex.put(new Integer(2008), this);
            }

            public String toString() {
                return "EpAGap";
            }

            public int getValue() {
                return 2008;
            }
        }

        private static class _EpInt
        extends DoubleParam {
            public _EpInt() {
                _revindex.put(new Integer(2010), this);
            }

            public String toString() {
                return "EpInt";
            }

            public int getValue() {
                return 2010;
            }
        }

        private static class _EpGap
        extends DoubleParam {
            public _EpGap() {
                _revindex.put(new Integer(2009), this);
            }

            public String toString() {
                return "EpGap";
            }

            public int getValue() {
                return 2009;
            }
        }

        private static class _CutUp
        extends DoubleParam {
            public _CutUp() {
                _revindex.put(new Integer(2007), this);
            }

            public String toString() {
                return "CutUp";
            }

            public int getValue() {
                return 2007;
            }
        }

        private static class _CutLo
        extends DoubleParam {
            public _CutLo() {
                _revindex.put(new Integer(2006), this);
            }

            public String toString() {
                return "CutLo";
            }

            public int getValue() {
                return 2006;
            }
        }

        private static class _BtTol
        extends DoubleParam {
            public _BtTol() {
                _revindex.put(new Integer(2002), this);
            }

            public String toString() {
                return "BtTol";
            }

            public int getValue() {
                return 2002;
            }
        }

        private static class _TuningTiLim
        extends DoubleParam {
            public _TuningTiLim() {
                _revindex.put(new Integer(1112), this);
            }

            public String toString() {
                return "TuningTiLim";
            }

            public int getValue() {
                return 1112;
            }
        }

        private static class _TiLim
        extends DoubleParam {
            public _TiLim() {
                _revindex.put(new Integer(1039), this);
            }

            public String toString() {
                return "TiLim";
            }

            public int getValue() {
                return 1039;
            }
        }

        private static class _NetEpRHS
        extends DoubleParam {
            public _NetEpRHS() {
                _revindex.put(new Integer(5003), this);
            }

            public String toString() {
                return "NetEpRHS";
            }

            public int getValue() {
                return 5003;
            }
        }

        private static class _NetEpOpt
        extends DoubleParam {
            public _NetEpOpt() {
                _revindex.put(new Integer(5002), this);
            }

            public String toString() {
                return "NetEpOpt";
            }

            public int getValue() {
                return 5002;
            }
        }

        private static class _EpRHS
        extends DoubleParam {
            public _EpRHS() {
                _revindex.put(new Integer(1016), this);
            }

            public String toString() {
                return "EpRHS";
            }

            public int getValue() {
                return 1016;
            }
        }

        private static class _EpPer
        extends DoubleParam {
            public _EpPer() {
                _revindex.put(new Integer(1015), this);
            }

            public String toString() {
                return "EpPer";
            }

            public int getValue() {
                return 1015;
            }
        }

        private static class _EpOpt
        extends DoubleParam {
            public _EpOpt() {
                _revindex.put(new Integer(1014), this);
            }

            public String toString() {
                return "EpOpt";
            }

            public int getValue() {
                return 1014;
            }
        }

        private static class _EpMrk
        extends DoubleParam {
            public _EpMrk() {
                _revindex.put(new Integer(1013), this);
            }

            public String toString() {
                return "EpMrk";
            }

            public int getValue() {
                return 1013;
            }
        }
    }

    public static abstract class IntParam
    extends Param {
        public static final IntParam AdvInd = new _AdvInd();
        public static final IntParam RootAlg = new _RootAlg();
        public static final IntParam NodeAlg = new _NodeAlg();
        public static final IntParam MIPEmphasis = new _MIPEmphasis();
        public static final IntParam AggFill = new _AggFill();
        public static final IntParam AggInd = new _AggInd();
        public static final IntParam BasInterval = new _BasInterval();
        public static final IntParam ClockType = new _ClockType();
        public static final IntParam CraInd = new _CraInd();
        public static final IntParam DepInd = new _DepInd();
        public static final IntParam PreDual = new _PreDual();
        public static final IntParam PrePass = new _PrePass();
        public static final IntParam RelaxPreInd = new _RelaxPreInd();
        public static final IntParam RepeatPresolve = new _RepeatPresolve();
        public static final IntParam Symmetry = new _Symmetry();
        public static final IntParam DPriInd = new _DPriInd();
        public static final IntParam PriceLim = new _PriceLim();
        public static final IntParam SimDisplay = new _SimDisplay();
        public static final IntParam ItLim = new _ItLim();
        public static final IntParam NetFind = new _NetFind();
        public static final IntParam PerLim = new _PerLim();
        public static final IntParam PPriInd = new _PPriInd();
        public static final IntParam ReInv = new _ReInv();
        public static final IntParam ScaInd = new _ScaInd();
        public static final IntParam Threads = new _Threads();
        public static final IntParam AuxRootThreads = new _AuxRootThreads();
        public static final IntParam ParallelMode = new _ParallelMode();
        public static final IntParam SingLim = new _SingLim();
        public static final IntParam Reduce = new _Reduce();
        public static final IntParam NzReadLim = new _NzReadLim();
        public static final IntParam ColReadLim = new _ColReadLim();
        public static final IntParam RowReadLim = new _RowReadLim();
        public static final IntParam QPNzReadLim = new _QPNzReadLim();
        public static final IntParam WriteLevel = new _WriteLevel();
        public static final IntParam SiftDisplay = new _SiftDisplay();
        public static final IntParam SiftAlg = new _SiftAlg();
        public static final IntParam SiftItLim = new _SiftItLim();
        public static final IntParam BrDir = new _BrDir();
        public static final IntParam Cliques = new _Cliques();
        public static final IntParam CoeRedInd = new _CoeRedInd();
        public static final IntParam Covers = new _Covers();
        public static final IntParam MIPDisplay = new _MIPDisplay();
        public static final IntParam MIPInterval = new _MIPInterval();
        public static final IntParam IntSolLim = new _IntSolLim();
        public static final IntParam NodeFileInd = new _NodeFileInd();
        public static final IntParam NodeLim = new _NodeLim();
        public static final IntParam NodeSel = new _NodeSel();
        public static final IntParam VarSel = new _VarSel();
        public static final IntParam BndStrenInd = new _BndStrenInd();
        public static final IntParam HeurFreq = new _HeurFreq();
        public static final IntParam RINSHeur = new _RINSHeur();
        public static final IntParam FPHeur = new _FPHeur();
        public static final IntParam RepairTries = new _RepairTries();
        public static final IntParam SubMIPNodeLim = new _SubMIPNodeLim();
        public static final IntParam MIPOrdType = new _MIPOrdType();
        public static final IntParam BBInterval = new _BBInterval();
        public static final IntParam FlowCovers = new _FlowCovers();
        public static final IntParam ImplBd = new _ImplBd();
        public static final IntParam Probe = new _Probe();
        public static final IntParam GUBCovers = new _GUBCovers();
        public static final IntParam StrongCandLim = new _StrongCandLim();
        public static final IntParam StrongItLim = new _StrongItLim();
        public static final IntParam FracCand = new _FracCand();
        public static final IntParam FracCuts = new _FracCuts();
        public static final IntParam FracPass = new _FracPass();
        public static final IntParam PreslvNd = new _PreslvNd();
        public static final IntParam FlowPaths = new _FlowPaths();
        public static final IntParam MIRCuts = new _MIRCuts();
        public static final IntParam DisjCuts = new _DisjCuts();
        public static final IntParam ZeroHalfCuts = new _ZeroHalfCuts();
        public static final IntParam MCFCuts = new _MCFCuts();
        public static final IntParam AggCutLim = new _AggCutLim();
        public static final IntParam CutPass = new _CutPass();
        public static final IntParam EachCutLim = new _EachCutLim();
        public static final IntParam DiveType = new _DiveType();
        public static final IntParam MIPSearch = new _MIPSearch();
        public static final IntParam MIQCPStrat = new _MIQCPStrat();
        public static final IntParam SolnPoolCapacity = new _SolnPoolCapacity();
        public static final IntParam SolnPoolReplace = new _SolnPoolReplace();
        public static final IntParam SolnPoolIntensity = new _SolnPoolIntensity();
        public static final IntParam PopulateLim = new _PopulateLim();
        public static final IntParam BarAlg = new _BarAlg();
        public static final IntParam BarColNz = new _BarColNz();
        public static final IntParam BarDisplay = new _BarDisplay();
        public static final IntParam BarItLim = new _BarItLim();
        public static final IntParam BarMaxCor = new _BarMaxCor();
        public static final IntParam BarOrder = new _BarOrder();
        public static final IntParam BarCrossAlg = new _BarCrossAlg();
        public static final IntParam BarStartAlg = new _BarStartAlg();
        public static final IntParam NetItLim = new _NetItLim();
        public static final IntParam NetPPriInd = new _NetPPriInd();
        public static final IntParam NetDisplay = new _NetDisplay();
        public static final IntParam ConflictDisplay = new _ConflictDisplay();
        public static final IntParam FeasOptMode = new _FeasOptMode();
        public static final IntParam TuningMeasure = new _TuningMeasure();
        public static final IntParam TuningRepeat = new _TuningRepeat();
        public static final IntParam TuningDisplay = new _TuningDisplay();
        public static final IntParam PolishAfterNode = new _PolishAfterNode();
        public static final IntParam PolishAfterIntSol = new _PolishAfterIntSol();
        public static final IntParam MIPKappaStats = new _MIPKappaStats();

        private static class _MIPKappaStats
        extends IntParam {
            public _MIPKappaStats() {
                _revindex.put(new Integer(2137), this);
            }

            public String toString() {
                return "MIPKappaStats";
            }

            public int getValue() {
                return 2137;
            }
        }

        private static class _PolishAfterIntSol
        extends IntParam {
            public _PolishAfterIntSol() {
                _revindex.put(new Integer(2129), this);
            }

            public String toString() {
                return "PolishAfterIntSol";
            }

            public int getValue() {
                return 2129;
            }
        }

        private static class _PolishAfterNode
        extends IntParam {
            public _PolishAfterNode() {
                _revindex.put(new Integer(2128), this);
            }

            public String toString() {
                return "PolishAfterNode";
            }

            public int getValue() {
                return 2128;
            }
        }

        private static class _TuningDisplay
        extends IntParam {
            public _TuningDisplay() {
                _revindex.put(new Integer(1113), this);
            }

            public String toString() {
                return "TuningDisplay";
            }

            public int getValue() {
                return 1113;
            }
        }

        private static class _TuningRepeat
        extends IntParam {
            public _TuningRepeat() {
                _revindex.put(new Integer(1111), this);
            }

            public String toString() {
                return "TuningRepeat";
            }

            public int getValue() {
                return 1111;
            }
        }

        private static class _TuningMeasure
        extends IntParam {
            public _TuningMeasure() {
                _revindex.put(new Integer(1110), this);
            }

            public String toString() {
                return "TuningMeasure";
            }

            public int getValue() {
                return 1110;
            }
        }

        private static class _FeasOptMode
        extends IntParam {
            public _FeasOptMode() {
                _revindex.put(new Integer(1084), this);
            }

            public String toString() {
                return "FeasOptMode";
            }

            public int getValue() {
                return 1084;
            }
        }

        private static class _ConflictDisplay
        extends IntParam {
            public _ConflictDisplay() {
                _revindex.put(new Integer(1074), this);
            }

            public String toString() {
                return "ConflictDisplay";
            }

            public int getValue() {
                return 1074;
            }
        }

        private static class _NetDisplay
        extends IntParam {
            public _NetDisplay() {
                _revindex.put(new Integer(5005), this);
            }

            public String toString() {
                return "NetDisplay";
            }

            public int getValue() {
                return 5005;
            }
        }

        private static class _NetPPriInd
        extends IntParam {
            public _NetPPriInd() {
                _revindex.put(new Integer(5004), this);
            }

            public String toString() {
                return "NetPPriInd";
            }

            public int getValue() {
                return 5004;
            }
        }

        private static class _NetItLim
        extends IntParam {
            public _NetItLim() {
                _revindex.put(new Integer(5001), this);
            }

            public String toString() {
                return "NetItLim";
            }

            public int getValue() {
                return 5001;
            }
        }

        private static class _BarStartAlg
        extends IntParam {
            public _BarStartAlg() {
                _revindex.put(new Integer(3017), this);
            }

            public String toString() {
                return "BarStartAlg";
            }

            public int getValue() {
                return 3017;
            }
        }

        private static class _BarCrossAlg
        extends IntParam {
            public _BarCrossAlg() {
                _revindex.put(new Integer(3018), this);
            }

            public String toString() {
                return "BarCrossAlg";
            }

            public int getValue() {
                return 3018;
            }
        }

        private static class _BarOrder
        extends IntParam {
            public _BarOrder() {
                _revindex.put(new Integer(3014), this);
            }

            public String toString() {
                return "BarOrder";
            }

            public int getValue() {
                return 3014;
            }
        }

        private static class _BarMaxCor
        extends IntParam {
            public _BarMaxCor() {
                _revindex.put(new Integer(3013), this);
            }

            public String toString() {
                return "BarMaxCor";
            }

            public int getValue() {
                return 3013;
            }
        }

        private static class _BarItLim
        extends IntParam {
            public _BarItLim() {
                _revindex.put(new Integer(3012), this);
            }

            public String toString() {
                return "BarItLim";
            }

            public int getValue() {
                return 3012;
            }
        }

        private static class _BarDisplay
        extends IntParam {
            public _BarDisplay() {
                _revindex.put(new Integer(3010), this);
            }

            public String toString() {
                return "BarDisplay";
            }

            public int getValue() {
                return 3010;
            }
        }

        private static class _BarColNz
        extends IntParam {
            public _BarColNz() {
                _revindex.put(new Integer(3009), this);
            }

            public String toString() {
                return "BarColNz";
            }

            public int getValue() {
                return 3009;
            }
        }

        private static class _BarAlg
        extends IntParam {
            public _BarAlg() {
                _revindex.put(new Integer(3007), this);
            }

            public String toString() {
                return "BarAlg";
            }

            public int getValue() {
                return 3007;
            }
        }

        private static class _PopulateLim
        extends IntParam {
            public _PopulateLim() {
                _revindex.put(new Integer(2108), this);
            }

            public String toString() {
                return "PopulateLim";
            }

            public int getValue() {
                return 2108;
            }
        }

        private static class _SolnPoolIntensity
        extends IntParam {
            public _SolnPoolIntensity() {
                _revindex.put(new Integer(2107), this);
            }

            public String toString() {
                return "SolnPoolIntensity";
            }

            public int getValue() {
                return 2107;
            }
        }

        private static class _SolnPoolReplace
        extends IntParam {
            public _SolnPoolReplace() {
                _revindex.put(new Integer(2104), this);
            }

            public String toString() {
                return "SolnPoolReplace";
            }

            public int getValue() {
                return 2104;
            }
        }

        private static class _SolnPoolCapacity
        extends IntParam {
            public _SolnPoolCapacity() {
                _revindex.put(new Integer(2103), this);
            }

            public String toString() {
                return "SolnPoolCapacity";
            }

            public int getValue() {
                return 2103;
            }
        }

        private static class _MIQCPStrat
        extends IntParam {
            public _MIQCPStrat() {
                _revindex.put(new Integer(2110), this);
            }

            public String toString() {
                return "MIQCPStrat";
            }

            public int getValue() {
                return 2110;
            }
        }

        private static class _MIPSearch
        extends IntParam {
            public _MIPSearch() {
                _revindex.put(new Integer(2109), this);
            }

            public String toString() {
                return "MIPSearch";
            }

            public int getValue() {
                return 2109;
            }
        }

        private static class _DiveType
        extends IntParam {
            public _DiveType() {
                _revindex.put(new Integer(2060), this);
            }

            public String toString() {
                return "DiveType";
            }

            public int getValue() {
                return 2060;
            }
        }

        private static class _EachCutLim
        extends IntParam {
            public _EachCutLim() {
                _revindex.put(new Integer(2102), this);
            }

            public String toString() {
                return "EachCutLim";
            }

            public int getValue() {
                return 2102;
            }
        }

        private static class _CutPass
        extends IntParam {
            public _CutPass() {
                _revindex.put(new Integer(2056), this);
            }

            public String toString() {
                return "CutPass";
            }

            public int getValue() {
                return 2056;
            }
        }

        private static class _AggCutLim
        extends IntParam {
            public _AggCutLim() {
                _revindex.put(new Integer(2054), this);
            }

            public String toString() {
                return "AggCutLim";
            }

            public int getValue() {
                return 2054;
            }
        }

        private static class _MCFCuts
        extends IntParam {
            public _MCFCuts() {
                _revindex.put(new Integer(2134), this);
            }

            public String toString() {
                return "MCFCuts";
            }

            public int getValue() {
                return 2134;
            }
        }

        private static class _ZeroHalfCuts
        extends IntParam {
            public _ZeroHalfCuts() {
                _revindex.put(new Integer(2111), this);
            }

            public String toString() {
                return "ZeroHalfCuts";
            }

            public int getValue() {
                return 2111;
            }
        }

        private static class _DisjCuts
        extends IntParam {
            public _DisjCuts() {
                _revindex.put(new Integer(2053), this);
            }

            public String toString() {
                return "DisjCuts";
            }

            public int getValue() {
                return 2053;
            }
        }

        private static class _MIRCuts
        extends IntParam {
            public _MIRCuts() {
                _revindex.put(new Integer(2052), this);
            }

            public String toString() {
                return "MIRCuts";
            }

            public int getValue() {
                return 2052;
            }
        }

        private static class _FlowPaths
        extends IntParam {
            public _FlowPaths() {
                _revindex.put(new Integer(2051), this);
            }

            public String toString() {
                return "FlowPaths";
            }

            public int getValue() {
                return 2051;
            }
        }

        private static class _PreslvNd
        extends IntParam {
            public _PreslvNd() {
                _revindex.put(new Integer(2037), this);
            }

            public String toString() {
                return "PreslvNd";
            }

            public int getValue() {
                return 2037;
            }
        }

        private static class _FracPass
        extends IntParam {
            public _FracPass() {
                _revindex.put(new Integer(2050), this);
            }

            public String toString() {
                return "FracPass";
            }

            public int getValue() {
                return 2050;
            }
        }

        private static class _FracCuts
        extends IntParam {
            public _FracCuts() {
                _revindex.put(new Integer(2049), this);
            }

            public String toString() {
                return "FracCuts";
            }

            public int getValue() {
                return 2049;
            }
        }

        private static class _FracCand
        extends IntParam {
            public _FracCand() {
                _revindex.put(new Integer(2048), this);
            }

            public String toString() {
                return "FracCand";
            }

            public int getValue() {
                return 2048;
            }
        }

        private static class _StrongItLim
        extends IntParam {
            public _StrongItLim() {
                _revindex.put(new Integer(2046), this);
            }

            public String toString() {
                return "StrongItLim";
            }

            public int getValue() {
                return 2046;
            }
        }

        private static class _StrongCandLim
        extends IntParam {
            public _StrongCandLim() {
                _revindex.put(new Integer(2045), this);
            }

            public String toString() {
                return "StrongCandLim";
            }

            public int getValue() {
                return 2045;
            }
        }

        private static class _GUBCovers
        extends IntParam {
            public _GUBCovers() {
                _revindex.put(new Integer(2044), this);
            }

            public String toString() {
                return "GUBCovers";
            }

            public int getValue() {
                return 2044;
            }
        }

        private static class _Probe
        extends IntParam {
            public _Probe() {
                _revindex.put(new Integer(2042), this);
            }

            public String toString() {
                return "Probe";
            }

            public int getValue() {
                return 2042;
            }
        }

        private static class _ImplBd
        extends IntParam {
            public _ImplBd() {
                _revindex.put(new Integer(2041), this);
            }

            public String toString() {
                return "ImplBd";
            }

            public int getValue() {
                return 2041;
            }
        }

        private static class _FlowCovers
        extends IntParam {
            public _FlowCovers() {
                _revindex.put(new Integer(2040), this);
            }

            public String toString() {
                return "FlowCovers";
            }

            public int getValue() {
                return 2040;
            }
        }

        private static class _BBInterval
        extends IntParam {
            public _BBInterval() {
                _revindex.put(new Integer(2039), this);
            }

            public String toString() {
                return "BBInterval";
            }

            public int getValue() {
                return 2039;
            }
        }

        private static class _MIPOrdType
        extends IntParam {
            public _MIPOrdType() {
                _revindex.put(new Integer(2032), this);
            }

            public String toString() {
                return "MIPOrdType";
            }

            public int getValue() {
                return 2032;
            }
        }

        private static class _SubMIPNodeLim
        extends IntParam {
            public _SubMIPNodeLim() {
                _revindex.put(new Integer(2062), this);
            }

            public String toString() {
                return "SubMIPNodeLim";
            }

            public int getValue() {
                return 2062;
            }
        }

        private static class _RepairTries
        extends IntParam {
            public _RepairTries() {
                _revindex.put(new Integer(2067), this);
            }

            public String toString() {
                return "RepairTries";
            }

            public int getValue() {
                return 2067;
            }
        }

        private static class _FPHeur
        extends IntParam {
            public _FPHeur() {
                _revindex.put(new Integer(2098), this);
            }

            public String toString() {
                return "FPHeur";
            }

            public int getValue() {
                return 2098;
            }
        }

        private static class _RINSHeur
        extends IntParam {
            public _RINSHeur() {
                _revindex.put(new Integer(2061), this);
            }

            public String toString() {
                return "RINSHeur";
            }

            public int getValue() {
                return 2061;
            }
        }

        private static class _HeurFreq
        extends IntParam {
            public _HeurFreq() {
                _revindex.put(new Integer(2031), this);
            }

            public String toString() {
                return "HeurFreq";
            }

            public int getValue() {
                return 2031;
            }
        }

        private static class _BndStrenInd
        extends IntParam {
            public _BndStrenInd() {
                _revindex.put(new Integer(2029), this);
            }

            public String toString() {
                return "BndStrenInd";
            }

            public int getValue() {
                return 2029;
            }
        }

        private static class _VarSel
        extends IntParam {
            public _VarSel() {
                _revindex.put(new Integer(2028), this);
            }

            public String toString() {
                return "VarSel";
            }

            public int getValue() {
                return 2028;
            }
        }

        private static class _NodeSel
        extends IntParam {
            public _NodeSel() {
                _revindex.put(new Integer(2018), this);
            }

            public String toString() {
                return "NodeSel";
            }

            public int getValue() {
                return 2018;
            }
        }

        private static class _NodeLim
        extends IntParam {
            public _NodeLim() {
                _revindex.put(new Integer(2017), this);
            }

            public String toString() {
                return "NodeLim";
            }

            public int getValue() {
                return 2017;
            }
        }

        private static class _NodeFileInd
        extends IntParam {
            public _NodeFileInd() {
                _revindex.put(new Integer(2016), this);
            }

            public String toString() {
                return "NodeFileInd";
            }

            public int getValue() {
                return 2016;
            }
        }

        private static class _IntSolLim
        extends IntParam {
            public _IntSolLim() {
                _revindex.put(new Integer(2015), this);
            }

            public String toString() {
                return "IntSolLim";
            }

            public int getValue() {
                return 2015;
            }
        }

        private static class _MIPInterval
        extends IntParam {
            public _MIPInterval() {
                _revindex.put(new Integer(2013), this);
            }

            public String toString() {
                return "MIPInterval";
            }

            public int getValue() {
                return 2013;
            }
        }

        private static class _MIPDisplay
        extends IntParam {
            public _MIPDisplay() {
                _revindex.put(new Integer(2012), this);
            }

            public String toString() {
                return "MIPDisplay";
            }

            public int getValue() {
                return 2012;
            }
        }

        private static class _Covers
        extends IntParam {
            public _Covers() {
                _revindex.put(new Integer(2005), this);
            }

            public String toString() {
                return "Covers";
            }

            public int getValue() {
                return 2005;
            }
        }

        private static class _CoeRedInd
        extends IntParam {
            public _CoeRedInd() {
                _revindex.put(new Integer(2004), this);
            }

            public String toString() {
                return "CoeRedInd";
            }

            public int getValue() {
                return 2004;
            }
        }

        private static class _Cliques
        extends IntParam {
            public _Cliques() {
                _revindex.put(new Integer(2003), this);
            }

            public String toString() {
                return "Cliques";
            }

            public int getValue() {
                return 2003;
            }
        }

        private static class _BrDir
        extends IntParam {
            public _BrDir() {
                _revindex.put(new Integer(2001), this);
            }

            public String toString() {
                return "BrDir";
            }

            public int getValue() {
                return 2001;
            }
        }

        private static class _SiftItLim
        extends IntParam {
            public _SiftItLim() {
                _revindex.put(new Integer(1078), this);
            }

            public String toString() {
                return "SiftItLim";
            }

            public int getValue() {
                return 1078;
            }
        }

        private static class _SiftAlg
        extends IntParam {
            public _SiftAlg() {
                _revindex.put(new Integer(1077), this);
            }

            public String toString() {
                return "SiftAlg";
            }

            public int getValue() {
                return 1077;
            }
        }

        private static class _SiftDisplay
        extends IntParam {
            public _SiftDisplay() {
                _revindex.put(new Integer(1076), this);
            }

            public String toString() {
                return "SiftDisplay";
            }

            public int getValue() {
                return 1076;
            }
        }

        private static class _WriteLevel
        extends IntParam {
            public _WriteLevel() {
                _revindex.put(new Integer(1114), this);
            }

            public String toString() {
                return "WriteLevel";
            }

            public int getValue() {
                return 1114;
            }
        }

        private static class _QPNzReadLim
        extends IntParam {
            public _QPNzReadLim() {
                _revindex.put(new Integer(4001), this);
            }

            public String toString() {
                return "QPNzReadLim";
            }

            public int getValue() {
                return 4001;
            }
        }

        private static class _RowReadLim
        extends IntParam {
            public _RowReadLim() {
                _revindex.put(new Integer(1021), this);
            }

            public String toString() {
                return "RowReadLim";
            }

            public int getValue() {
                return 1021;
            }
        }

        private static class _ColReadLim
        extends IntParam {
            public _ColReadLim() {
                _revindex.put(new Integer(1023), this);
            }

            public String toString() {
                return "ColReadLim";
            }

            public int getValue() {
                return 1023;
            }
        }

        private static class _NzReadLim
        extends IntParam {
            public _NzReadLim() {
                _revindex.put(new Integer(1024), this);
            }

            public String toString() {
                return "NzReadLim";
            }

            public int getValue() {
                return 1024;
            }
        }

        private static class _Reduce
        extends IntParam {
            public _Reduce() {
                _revindex.put(new Integer(1057), this);
            }

            public String toString() {
                return "Reduce";
            }

            public int getValue() {
                return 1057;
            }
        }

        private static class _SingLim
        extends IntParam {
            public _SingLim() {
                _revindex.put(new Integer(1037), this);
            }

            public String toString() {
                return "SingLim";
            }

            public int getValue() {
                return 1037;
            }
        }

        private static class _ParallelMode
        extends IntParam {
            public _ParallelMode() {
                _revindex.put(new Integer(1109), this);
            }

            public String toString() {
                return "ParallelMode";
            }

            public int getValue() {
                return 1109;
            }
        }

        private static class _AuxRootThreads
        extends IntParam {
            public _AuxRootThreads() {
                _revindex.put(new Integer(2139), this);
            }

            public String toString() {
                return "AuxRootThreads";
            }

            public int getValue() {
                return 2139;
            }
        }

        private static class _Threads
        extends IntParam {
            public _Threads() {
                _revindex.put(new Integer(1067), this);
            }

            public String toString() {
                return "Threads";
            }

            public int getValue() {
                return 1067;
            }
        }

        private static class _ScaInd
        extends IntParam {
            public _ScaInd() {
                _revindex.put(new Integer(1034), this);
            }

            public String toString() {
                return "ScaInd";
            }

            public int getValue() {
                return 1034;
            }
        }

        private static class _ReInv
        extends IntParam {
            public _ReInv() {
                _revindex.put(new Integer(1031), this);
            }

            public String toString() {
                return "ReInv";
            }

            public int getValue() {
                return 1031;
            }
        }

        private static class _PPriInd
        extends IntParam {
            public _PPriInd() {
                _revindex.put(new Integer(1029), this);
            }

            public String toString() {
                return "PPriInd";
            }

            public int getValue() {
                return 1029;
            }
        }

        private static class _PerLim
        extends IntParam {
            public _PerLim() {
                _revindex.put(new Integer(1028), this);
            }

            public String toString() {
                return "PerLim";
            }

            public int getValue() {
                return 1028;
            }
        }

        private static class _NetFind
        extends IntParam {
            public _NetFind() {
                _revindex.put(new Integer(1022), this);
            }

            public String toString() {
                return "NetFind";
            }

            public int getValue() {
                return 1022;
            }
        }

        private static class _ItLim
        extends IntParam {
            public _ItLim() {
                _revindex.put(new Integer(1020), this);
            }

            public String toString() {
                return "ItLim";
            }

            public int getValue() {
                return 1020;
            }
        }

        private static class _SimDisplay
        extends IntParam {
            public _SimDisplay() {
                _revindex.put(new Integer(1019), this);
            }

            public String toString() {
                return "SimDisplay";
            }

            public int getValue() {
                return 1019;
            }
        }

        private static class _PriceLim
        extends IntParam {
            public _PriceLim() {
                _revindex.put(new Integer(1010), this);
            }

            public String toString() {
                return "PriceLim";
            }

            public int getValue() {
                return 1010;
            }
        }

        private static class _DPriInd
        extends IntParam {
            public _DPriInd() {
                _revindex.put(new Integer(1009), this);
            }

            public String toString() {
                return "DPriInd";
            }

            public int getValue() {
                return 1009;
            }
        }

        private static class _Symmetry
        extends IntParam {
            public _Symmetry() {
                _revindex.put(new Integer(2059), this);
            }

            public String toString() {
                return "Symmetry";
            }

            public int getValue() {
                return 2059;
            }
        }

        private static class _RepeatPresolve
        extends IntParam {
            public _RepeatPresolve() {
                _revindex.put(new Integer(2064), this);
            }

            public String toString() {
                return "RepeatPresolve";
            }

            public int getValue() {
                return 2064;
            }
        }

        private static class _RelaxPreInd
        extends IntParam {
            public _RelaxPreInd() {
                _revindex.put(new Integer(2034), this);
            }

            public String toString() {
                return "RelaxPreInd";
            }

            public int getValue() {
                return 2034;
            }
        }

        private static class _PrePass
        extends IntParam {
            public _PrePass() {
                _revindex.put(new Integer(1052), this);
            }

            public String toString() {
                return "PrePass";
            }

            public int getValue() {
                return 1052;
            }
        }

        private static class _PreDual
        extends IntParam {
            public _PreDual() {
                _revindex.put(new Integer(1044), this);
            }

            public String toString() {
                return "PreDual";
            }

            public int getValue() {
                return 1044;
            }
        }

        private static class _DepInd
        extends IntParam {
            public _DepInd() {
                _revindex.put(new Integer(1008), this);
            }

            public String toString() {
                return "DepInd";
            }

            public int getValue() {
                return 1008;
            }
        }

        private static class _CraInd
        extends IntParam {
            public _CraInd() {
                _revindex.put(new Integer(1007), this);
            }

            public String toString() {
                return "CraInd";
            }

            public int getValue() {
                return 1007;
            }
        }

        private static class _ClockType
        extends IntParam {
            public _ClockType() {
                _revindex.put(new Integer(1006), this);
            }

            public String toString() {
                return "ClockType";
            }

            public int getValue() {
                return 1006;
            }
        }

        private static class _BasInterval
        extends IntParam {
            public _BasInterval() {
                _revindex.put(new Integer(1004), this);
            }

            public String toString() {
                return "BasInterval";
            }

            public int getValue() {
                return 1004;
            }
        }

        private static class _AggInd
        extends IntParam {
            public _AggInd() {
                _revindex.put(new Integer(1003), this);
            }

            public String toString() {
                return "AggInd";
            }

            public int getValue() {
                return 1003;
            }
        }

        private static class _AggFill
        extends IntParam {
            public _AggFill() {
                _revindex.put(new Integer(1002), this);
            }

            public String toString() {
                return "AggFill";
            }

            public int getValue() {
                return 1002;
            }
        }

        private static class _MIPEmphasis
        extends IntParam {
            public _MIPEmphasis() {
                _revindex.put(new Integer(2058), this);
            }

            public String toString() {
                return "MIPEmphasis";
            }

            public int getValue() {
                return 2058;
            }
        }

        private static class _NodeAlg
        extends IntParam {
            public _NodeAlg() {
                _revindex.put(new Integer(2026), this);
            }

            public String toString() {
                return "NodeAlg";
            }

            public int getValue() {
                return 2026;
            }
        }

        private static class _RootAlg
        extends IntParam {
            public _RootAlg() {
                _revindex.put(new Integer(1062), this);
            }

            public String toString() {
                return "RootAlg";
            }

            public int getValue() {
                return 1062;
            }
        }

        private static class _AdvInd
        extends IntParam {
            public _AdvInd() {
                _revindex.put(new Integer(1001), this);
            }

            public String toString() {
                return "AdvInd";
            }

            public int getValue() {
                return 1001;
            }
        }
    }

    public static abstract class BooleanParam
    extends Param {
        public static final BooleanParam PreInd = new _PreInd();
        public static final BooleanParam ReverseInd = new _ReverseInd();
        public static final BooleanParam XXXInd = new _XXXInd();
        public static final BooleanParam MIPOrdInd = new _MIPOrdInd();
        public static final BooleanParam MPSLongNum = new _MPSLongNum();
        public static final BooleanParam LBHeur = new _LBHeur();
        public static final BooleanParam PerInd = new _PerInd();
        public static final BooleanParam PreLinear = new _PreLinear();
        public static final BooleanParam DataCheck = new _DataCheck();
        public static final BooleanParam QPmakePSDInd = new _QPmakePSDInd();
        public static final BooleanParam MemoryEmphasis = new _MemoryEmphasis();
        public static final BooleanParam NumericalEmphasis = new _NumericalEmphasis();

        private static class _NumericalEmphasis
        extends BooleanParam {
            public _NumericalEmphasis() {
                _revindex.put(new Integer(1083), this);
            }

            public String toString() {
                return "NumericalEmphasis";
            }

            public int getValue() {
                return 1083;
            }
        }

        private static class _MemoryEmphasis
        extends BooleanParam {
            public _MemoryEmphasis() {
                _revindex.put(new Integer(1082), this);
            }

            public String toString() {
                return "MemoryEmphasis";
            }

            public int getValue() {
                return 1082;
            }
        }

        private static class _QPmakePSDInd
        extends BooleanParam {
            public _QPmakePSDInd() {
                _revindex.put(new Integer(4010), this);
            }

            public String toString() {
                return "QPmakePSDInd";
            }

            public int getValue() {
                return 4010;
            }
        }

        private static class _DataCheck
        extends BooleanParam {
            public _DataCheck() {
                _revindex.put(new Integer(1056), this);
            }

            public String toString() {
                return "DataCheck";
            }

            public int getValue() {
                return 1056;
            }
        }

        private static class _PreLinear
        extends BooleanParam {
            public _PreLinear() {
                _revindex.put(new Integer(1058), this);
            }

            public String toString() {
                return "PreLinear";
            }

            public int getValue() {
                return 1058;
            }
        }

        private static class _PerInd
        extends BooleanParam {
            public _PerInd() {
                _revindex.put(new Integer(1027), this);
            }

            public String toString() {
                return "PerInd";
            }

            public int getValue() {
                return 1027;
            }
        }

        private static class _LBHeur
        extends BooleanParam {
            public _LBHeur() {
                _revindex.put(new Integer(2063), this);
            }

            public String toString() {
                return "LBHeur";
            }

            public int getValue() {
                return 2063;
            }
        }

        private static class _MPSLongNum
        extends BooleanParam {
            public _MPSLongNum() {
                _revindex.put(new Integer(1081), this);
            }

            public String toString() {
                return "MPSLongNum";
            }

            public int getValue() {
                return 1081;
            }
        }

        private static class _MIPOrdInd
        extends BooleanParam {
            public _MIPOrdInd() {
                _revindex.put(new Integer(2020), this);
            }

            public String toString() {
                return "MIPOrdInd";
            }

            public int getValue() {
                return 2020;
            }
        }

        private static class _XXXInd
        extends BooleanParam {
            public _XXXInd() {
                _revindex.put(new Integer(1041), this);
            }

            public String toString() {
                return "XXXInd";
            }

            public int getValue() {
                return 1041;
            }
        }

        private static class _ReverseInd
        extends BooleanParam {
            public _ReverseInd() {
                _revindex.put(new Integer(1032), this);
            }

            public String toString() {
                return "ReverseInd";
            }

            public int getValue() {
                return 1032;
            }
        }

        private static class _PreInd
        extends BooleanParam {
            public _PreInd() {
                _revindex.put(new Integer(1030), this);
            }

            public String toString() {
                return "PreInd";
            }

            public int getValue() {
                return 1030;
            }
        }
    }

    public static abstract class Param {
        public static Hashtable _revindex = new Hashtable();

        public abstract int getValue();
    }

    public static class Algorithm {
        public static final int None = -1;
        public static final int Auto = 0;
        public static final int Primal = 1;
        public static final int Dual = 2;
        public static final int Network = 3;
        public static final int Barrier = 4;
        public static final int Sifting = 5;
        public static final int Concurrent = 6;
        public static final int FeasOpt = 11;
        public static final int MIP = 12;
    }

    public static class Status {
        int _status;
        public static final Status Error = new Status(-1);
        public static final Status Unknown = new Status(0);
        public static final Status Feasible = new Status(1);
        public static final Status Bounded = new Status(2);
        public static final Status Optimal = new Status(3);
        public static final Status Infeasible = new Status(4);
        public static final Status Unbounded = new Status(8);
        public static final Status InfeasibleOrUnbounded = new Status(12);

        Status(int n) {
            this._status = n;
        }

        public String toString() {
            switch (this._status) {
                case 0: {
                    return "Unknown";
                }
                case 1: {
                    return "Feasible";
                }
                case 2: {
                    return "Bounded";
                }
                case 3: {
                    return "Optimal";
                }
                case 4: {
                    return "Infeasible";
                }
                case 8: {
                    return "Unbounded";
                }
                case 12: {
                    return "InfeasibleOrUnbounded";
                }
            }
            return "Error";
        }
    }
}

