/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloColumnArray;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloRange;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxAnd;
import ilog.cplex.CpxException;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQTerm;
import ilog.cplex.CpxQextractor;
import ilog.cplex.CpxSubVar;
import ilog.cplex.IloCplex;
import ilog.cplex.IloCplexModeler;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class CpxRange
extends CpxSubVar
implements IloRange {
    private static final long serialVersionUID = 1220L;
    int _conUseCnt;
    private CplexIndex _conIndex;
    RangeData _data;

    void end() throws IloException {
        if (this.isInstalledCon()) {
            if (this.isQC()) {
                this.getCplexI().delQC(this._conIndex);
            } else {
                this.getCplexI().delRows(this._conIndex);
            }
            this._conIndex = null;
            this._conUseCnt = 0;
        }
        super.end();
    }

    static void end(CpxRange[] cpxRangeArray, int n) throws IloException {
        if (n <= 0) {
            return;
        }
        CplexI cplexI = cpxRangeArray[0].getCplexI();
        CplexIndex[] cplexIndexArray = new CplexIndex[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            CpxRange cpxRange = cpxRangeArray[i];
            if (cpxRange.getCplexI() == null) continue;
            if (cpxRange.isQC()) {
                cpxRange.end();
                continue;
            }
            --cpxRange._conUseCnt;
            if (cpxRange._conUseCnt != 0) continue;
            cplexIndexArray[n2++] = cpxRange.getIndex();
            cpxRange.setCplexI(null);
        }
        cplexI.delRows(cplexIndexArray, 0, n2);
    }

    boolean isInstalledCon() {
        return this._conIndex.getIndex() >= 0;
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        return iloModeler.range(this.getLB(), (IloNumExpr)iloCopyManager.getCopy(this.getCpxExpr()), this.getUB(), this.getName());
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        CplexI cplexI = this.getCplexI();
        if (cplexI != null) {
            this.uninstallCon();
        }
        ExternalRow externalRow = (ExternalRow)this._conIndex;
        externalRow._linear.removeVars(cplexIndex);
        externalRow._quad.removeVars(cplexIndex);
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    void removeVarsFromSubVar(CplexIndex cplexIndex) throws IloException {
        if (!this.isInstalledCon()) {
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            externalRow._linear.removeVars(cplexIndex);
            externalRow._quad.removeVars(cplexIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        block8: {
            RangeData rangeData = this._data;
            this._data = null;
            try {
                CplexI cplexI = this.getCplexI();
                if (cplexI != null) {
                    int n = this._conUseCnt;
                    CplexIndex cplexIndex = this._conIndex;
                    try {
                        if (n > 0) {
                            this._conUseCnt = 1;
                            this.uninstallCon();
                        }
                        objectOutputStream.defaultWriteObject();
                        if (n > 0) {
                            this.installCon(cplexI);
                        }
                    }
                    catch (IloException iloException) {
                        throw new IOException();
                    }
                    this._conUseCnt = n;
                    this._conIndex = cplexIndex;
                    break block8;
                }
                objectOutputStream.defaultWriteObject();
            }
            finally {
                this._data = rangeData;
            }
        }
    }

    private final ExternalRow makeExternalRow(double d, double d2, CpxLinearNumExpr cpxLinearNumExpr, CpxQExpr cpxQExpr) {
        return new ExternalRow(d, d2, cpxLinearNumExpr, cpxQExpr);
    }

    private final ExternalRow makeExternalRow(double d, double d2, double[] dArray, CpxNumVar[] cpxNumVarArray, int n, int n2, double d3) {
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(dArray, cpxNumVarArray, n, n2, d3);
        return new ExternalRow(d, d2, cpxLinearNumExpr);
    }

    private final ExternalRow makeExternalRow(double d, double d2, int n, double[] dArray, CpxNumVar[] cpxNumVarArray, int n2, double[] dArray2, CpxNumVar[] cpxNumVarArray2, CpxNumVar[] cpxNumVarArray3, double d3) {
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(dArray, cpxNumVarArray, 0, n, d3);
        CpxQExpr cpxQExpr = new CpxQExpr(n2, dArray2, cpxNumVarArray2, cpxNumVarArray3);
        return new ExternalRow(d, d2, cpxLinearNumExpr, cpxQExpr);
    }

    private final ExternalRow makeExternalRow() throws IloException {
        if (!this.isInstalledCon()) {
            return (ExternalRow)this._conIndex;
        }
        ExternalRow externalRow = null;
        if (this.isQC()) {
            CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
            CpxNumVar[][] cpxNumVarArray2 = new CpxNumVar[1][];
            CpxNumVar[][] cpxNumVarArray3 = new CpxNumVar[1][];
            double[][] dArrayArray = new double[1][];
            double[][] dArrayArray2 = new double[1][];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            this.getCplexI().getCpxQC(this, dArray, dArray2, cpxNumVarArray3, dArrayArray, cpxNumVarArray, cpxNumVarArray2, dArrayArray2);
            if (dArray[0] <= -1.0E20) {
                dArray[0] = -1.7976931348623157E308;
            }
            if (dArray2[0] >= 1.0E20) {
                dArray2[0] = Double.MAX_VALUE;
            }
            int n = 0;
            if (cpxNumVarArray3[0] != null) {
                n = cpxNumVarArray3[0].length;
            }
            int n2 = 0;
            if (cpxNumVarArray[0] != null) {
                n2 = cpxNumVarArray[0].length;
            }
            externalRow = this.makeExternalRow(dArray[0], dArray2[0], n, dArrayArray[0], cpxNumVarArray3[0], n2, dArrayArray2[0], cpxNumVarArray[0], cpxNumVarArray2[0], 0.0);
        } else {
            CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
            double[][] dArrayArray = new double[1][];
            double[] dArray = new double[1];
            double[] dArray3 = new double[1];
            CpxRange[] cpxRangeArray = new CpxRange[]{this};
            this.getCplexI().getCpxRows(cpxRangeArray, 0, 1, dArray, dArray3, cpxNumVarArray, dArrayArray);
            if (dArray[0] <= -1.0E20) {
                dArray[0] = -1.7976931348623157E308;
            }
            if (dArray3[0] >= 1.0E20) {
                dArray3[0] = Double.MAX_VALUE;
            }
            externalRow = this.makeExternalRow(dArray[0], dArray3[0], dArrayArray[0], cpxNumVarArray[0], 0, dArrayArray[0].length, 0.0);
        }
        return externalRow;
    }

    void uninstallCon() throws IloException {
        --this._conUseCnt;
        if (this._conUseCnt == 0) {
            if (this.isQC()) {
                CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
                CpxNumVar[][] cpxNumVarArray2 = new CpxNumVar[1][];
                CpxNumVar[][] cpxNumVarArray3 = new CpxNumVar[1][];
                double[][] dArrayArray = new double[1][];
                double[][] dArrayArray2 = new double[1][];
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                this.getCplexI().getCpxQC(this, dArray, dArray2, cpxNumVarArray3, dArrayArray, cpxNumVarArray, cpxNumVarArray2, dArrayArray2);
                this.getCplexI().delQC(this._conIndex);
                if (dArray[0] <= -1.0E20) {
                    dArray[0] = -1.7976931348623157E308;
                }
                if (dArray2[0] >= 1.0E20) {
                    dArray2[0] = Double.MAX_VALUE;
                }
                int n = 0;
                int n2 = 0;
                if (cpxNumVarArray3[0] != null) {
                    this.getCplexI().unUseVars(cpxNumVarArray3[0], 0, cpxNumVarArray3[0].length);
                    n = cpxNumVarArray3[0].length;
                }
                if (cpxNumVarArray[0] != null) {
                    this.getCplexI().unUseVars(cpxNumVarArray[0], 0, cpxNumVarArray[0].length);
                    n2 = cpxNumVarArray[0].length;
                }
                if (cpxNumVarArray2[0] != null) {
                    this.getCplexI().unUseVars(cpxNumVarArray2[0], 0, cpxNumVarArray2[0].length);
                }
                this._conIndex = this.makeExternalRow(dArray[0], dArray2[0], n, dArrayArray[0], cpxNumVarArray3[0], n2, dArrayArray2[0], cpxNumVarArray[0], cpxNumVarArray2[0], 0.0);
                this.setCplexI(null);
            } else {
                CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                double[] dArray3 = new double[1];
                CpxRange[] cpxRangeArray = new CpxRange[]{this};
                this.getCplexI().getCpxRows(cpxRangeArray, 0, 1, dArray, dArray3, cpxNumVarArray, dArrayArray);
                this.getCplexI().delRows(this._conIndex);
                if (dArray[0] <= -1.0E20) {
                    dArray[0] = -1.7976931348623157E308;
                }
                if (dArray3[0] >= 1.0E20) {
                    dArray3[0] = Double.MAX_VALUE;
                }
                this._conIndex = this.makeExternalRow(dArray[0], dArray3[0], dArrayArray[0], cpxNumVarArray[0], 0, dArrayArray[0].length, 0.0);
                this.getCplexI().unUseVars(cpxNumVarArray[0], 0, cpxNumVarArray[0].length);
                this.setCplexI(null);
            }
        }
    }

    static void uninstallRows(CpxRange[] cpxRangeArray, int n) throws IloException {
        if (n <= 0) {
            return;
        }
        CplexI cplexI = cpxRangeArray[0].getCplexI();
        CpxNumVar[][] cpxNumVarArray = new CpxNumVar[n][];
        double[][] dArrayArray = new double[n][];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        CplexIndex[] cplexIndexArray = new CplexIndex[n];
        int n2 = 0;
        cplexI.getCpxRows(cpxRangeArray, 0, n, dArray, dArray2, cpxNumVarArray, dArrayArray);
        for (int i = 0; i < n; ++i) {
            CpxRange cpxRange = cpxRangeArray[i];
            if (cpxRange.getCplexI() == null) continue;
            if (cpxRange.isQC()) {
                cpxRange.uninstallCon();
                continue;
            }
            --cpxRange._conUseCnt;
            if (cpxRange._conUseCnt != 0) continue;
            if (dArray[i] <= -1.0E20) {
                dArray[i] = -1.7976931348623157E308;
            }
            if (dArray2[i] >= 1.0E20) {
                dArray2[i] = Double.MAX_VALUE;
            }
            cplexIndexArray[n2++] = cpxRange.getIndex();
            cpxRange._conIndex = cpxRange.makeExternalRow(dArray[i], dArray2[i], dArrayArray[i], cpxNumVarArray[i], 0, dArrayArray[i].length, 0.0);
            cplexI.unUseVars(cpxNumVarArray[i], 0, cpxNumVarArray[i].length);
            cpxRange.setCplexI(null);
        }
        cplexI.delRows(cplexIndexArray, 0, n2);
    }

    void installCon(CplexI cplexI) throws IloException {
        cplexI.checkCplexI(this);
        ++this._conUseCnt;
        if (this._conUseCnt == 1) {
            this.setCplexI(cplexI);
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            externalRow._linear.removeDuplicates();
            if (externalRow._quad == null || externalRow._quad.getNum() == 0) {
                this.init(cplexI, externalRow._lb, externalRow._ub, externalRow._linear._num, externalRow._linear._vals, externalRow._linear._vars);
            } else {
                externalRow._quad.removeDuplicates();
                this.init(cplexI, externalRow._lb, externalRow._ub, externalRow._linear._num, externalRow._linear._vals, externalRow._linear._vars, externalRow._quad._num, externalRow._quad._val, externalRow._quad._var1, externalRow._quad._var2);
            }
        }
    }

    boolean isInstalledVar() {
        return this._data != null;
    }

    protected void reinstallVar() throws IloException {
        this.uninstallVar(null);
        this.installVar(null);
    }

    void installVar(IloCplexModeler iloCplexModeler) throws IloException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        CpxNumVar[][] cpxNumVarArray;
        double[] dArray;
        double d;
        Object object4;
        Object object5;
        CpxLinearExpr cpxLinearExpr = null;
        CpxQExpr cpxQExpr = null;
        if (this._conIndex.getIndex() < 0) {
            object5 = (ExternalRow)this._conIndex;
            cpxLinearExpr = ((ExternalRow)object5)._linear;
            cpxQExpr = ((ExternalRow)object5)._quad;
            object4 = ((ExternalRow)object5)._lb;
            d = ((ExternalRow)object5)._ub;
        } else if (this.getCplexI().isQC(this)) {
            object5 = new double[]{0.0};
            dArray = new double[]{0.0};
            double[][] dArrayArray = new double[1][];
            cpxNumVarArray = new CpxNumVar[1][];
            object3 = new CpxNumVar[1][];
            double[][] dArrayArray2 = new double[1][];
            object2 = new CpxNumVar[1][];
            this.getCplexI().getCpxQC(this, (double[])object5, dArray, (CpxNumVar[][])object2, dArrayArray2, cpxNumVarArray, (CpxNumVar[][])object3, dArrayArray);
            if (dArrayArray2[0] != null) {
                cpxLinearExpr = new CpxLinearNumExpr(dArrayArray2[0], object2[0], 0, dArrayArray2[0].length, 0.0);
            }
            if (dArrayArray[0] != null) {
                cpxQExpr = new CpxQExpr(dArrayArray[0].length, dArrayArray[0], cpxNumVarArray[0], object3[0]);
            }
            object4 = object5[0];
            d = dArray[0];
        } else {
            object5 = new double[]{0.0};
            dArray = new double[]{0.0};
            CpxRange[] cpxRangeArray = new CpxRange[]{this};
            cpxNumVarArray = new CpxNumVar[1][];
            object3 = new double[1][];
            this.getCplexI().getCpxRows(cpxRangeArray, 0, 1, (double[])object5, dArray, cpxNumVarArray, (double[][])object3);
            if (object3[0] != null) {
                cpxLinearExpr = new CpxLinearNumExpr((double[])object3[0], cpxNumVarArray[0], 0, object3[0].length, 0.0);
            }
            object4 = object5[0];
            d = dArray[0];
        }
        object5 = new RangeData();
        double d2 = 0.0;
        char c = 'E';
        if (object4 == d) {
            d2 = object4;
            c = 'E';
        } else if (object4 <= -1.0E20) {
            d2 = d;
            c = 'L';
        } else if (d >= 1.0E20) {
            d2 = object4;
            c = 'G';
        } else {
            object3 = null;
            if (this.getName() != null) {
                object3 = this.getName() + "_and";
            }
            ((RangeData)object5)._and = (CpxAnd)iloCplexModeler.and(iloCplexModeler.ge(this.getExpr(), (double)object4), iloCplexModeler.le(this.getExpr(), d), (String)object3);
            ((RangeData)object5)._and.installVar(iloCplexModeler);
            this._varIndex = ((RangeData)object5)._and._varIndex;
            this._data = object5;
            return;
        }
        int n = 0;
        int n2 = 0;
        object2 = null;
        CpxNumVar[] cpxNumVarArray2 = null;
        CpxNumVar[] cpxNumVarArray3 = null;
        double[] dArray2 = null;
        CpxNumVar[] cpxNumVarArray4 = null;
        CpxNumVar[] cpxNumVarArray5 = null;
        if (cpxQExpr != null && cpxQExpr._num > 0) {
            object = this.getCplexI();
            n2 = cpxQExpr._num;
            object2 = cpxQExpr._val;
            cpxNumVarArray2 = cpxQExpr._var1;
            cpxNumVarArray3 = cpxQExpr._var2;
            ((CplexI)object).useVars(cpxNumVarArray2, 0, n2, true);
            ((CplexI)object).useVars(cpxNumVarArray3, 0, n2, true);
            cpxNumVarArray5 = new CpxNumVar[]{(CpxNumVar)((CplexI)object).getModeler().numVar(Double.MIN_VALUE, Double.MAX_VALUE)};
            cpxLinearExpr.addTerm((IloNumVar)cpxNumVarArray5[0], 1.0);
        }
        if (cpxLinearExpr != null) {
            n = cpxLinearExpr._num;
            cpxNumVarArray4 = cpxLinearExpr._vars;
            dArray2 = cpxLinearExpr._vals;
            this.getCplexI().useVars(cpxNumVarArray4, 0, n, true);
        }
        if (cpxNumVarArray5 != null) {
            object = new double[]{1.0};
            objectArray = CpxRange.getVarIndices(cpxNumVarArray5, 0, 1);
            int[] nArray = CpxRange.getVarIndices(cpxNumVarArray2, 0, n2);
            int[] nArray2 = CpxRange.getVarIndices(cpxNumVarArray3, 0, n2);
            ((RangeData)object5)._rowindex = this.getCplexI().addQC(this, 0.0, 0.0, 1, (double[])object, (int[])objectArray, n2, (double[])object2, nArray, nArray2, null);
        }
        if (n == 1 && c == 'E' && dArray2[0] == 1.0 && (cpxNumVarArray4[0].getConvType() == 66 || cpxNumVarArray4[0].getConvType() == 73 && cpxNumVarArray4[0].getLB() >= 0.0 && cpxNumVarArray4[0].getUB() <= 1.0)) {
            object = new int[]{this._varIndex.getValue(), cpxNumVarArray4[0].getVarIndexValue()};
            if (d2 == 1.0) {
                objectArray = new double[]{1.0, -1.0};
                double d3 = 0.0;
                ((RangeData)object5)._rowindex = this.getCplexI().addRow(this, d3, d3, 2, (int[])object, (double[])objectArray);
            } else if (d2 == 0.0) {
                objectArray = new double[]{1.0, 1.0};
                double d4 = 1.0;
                ((RangeData)object5)._rowindex = this.getCplexI().addRow(this, d4, d4, 2, (int[])object, (double[])objectArray);
            } else {
                ((RangeData)object5)._gcindex = this.getCplexI().addIndicator(this, this._varIndex, n, dArray2, cpxNumVarArray4, c, d2, this.getName());
            }
        } else {
            ((RangeData)object5)._gcindex = this.getCplexI().addIndicator(this, this._varIndex, n, dArray2, cpxNumVarArray4, c, d2, this.getName());
        }
        this._data = object5;
    }

    void uninstallVar(IloCplexModeler iloCplexModeler) throws IloException {
        CpxNumVar[] cpxNumVarArray;
        Object object;
        CpxNumVar[][] cpxNumVarArray2;
        CpxNumVar[][] cpxNumVarArray3;
        Object object2;
        double[] dArray;
        Object object3;
        if (this._data != null && this._data._and != null) {
            this._data._and.uninstallVar(iloCplexModeler);
            this._data = null;
            return;
        }
        CpxLinearExpr cpxLinearExpr = null;
        CpxQExpr cpxQExpr = null;
        if (this._conIndex.getIndex() < 0) {
            object3 = (ExternalRow)this._conIndex;
            cpxLinearExpr = ((ExternalRow)object3)._linear;
            cpxQExpr = ((ExternalRow)object3)._quad;
        } else if (this.getCplexI().isQC(this)) {
            object3 = new double[]{0.0};
            dArray = new double[]{0.0};
            object2 = new double[1][];
            cpxNumVarArray3 = new CpxNumVar[1][];
            cpxNumVarArray2 = new CpxNumVar[1][];
            object = new double[1][];
            cpxNumVarArray = new CpxNumVar[1][];
            this.getCplexI().getCpxQC(this, (double[])object3, dArray, (CpxNumVar[][])cpxNumVarArray, (double[][])object, cpxNumVarArray3, cpxNumVarArray2, (double[][])object2);
            if (object[0] != null) {
                cpxLinearExpr = new CpxLinearNumExpr(object[0], (CpxNumVar[])cpxNumVarArray[0], 0, object[0].length, 0.0);
            }
            if (object2[0] != null) {
                cpxQExpr = new CpxQExpr(object2[0].length, object2[0], cpxNumVarArray3[0], cpxNumVarArray2[0]);
            }
        } else {
            object3 = new double[]{0.0};
            dArray = new double[]{0.0};
            object2 = new CpxRange[]{this};
            cpxNumVarArray3 = new CpxNumVar[1][];
            cpxNumVarArray2 = (CpxNumVar[][])new double[1][];
            this.getCplexI().getCpxRows((CpxRange[])object2, 0, 1, (double[])object3, dArray, cpxNumVarArray3, (double[][])cpxNumVarArray2);
            if (cpxNumVarArray2[0] != null) {
                cpxLinearExpr = new CpxLinearNumExpr((double[])cpxNumVarArray2[0], cpxNumVarArray3[0], 0, cpxNumVarArray2[0].length, 0.0);
            }
        }
        int n = 0;
        int n2 = 0;
        object2 = null;
        cpxNumVarArray3 = null;
        cpxNumVarArray2 = null;
        object = null;
        cpxNumVarArray = null;
        if (cpxLinearExpr != null) {
            n = cpxLinearExpr._num;
            cpxNumVarArray = cpxLinearExpr._vars;
            object = cpxLinearExpr._vals;
            this.getCplexI().unUseVars(cpxNumVarArray, 0, n);
            if (this._data != null && this._data._rowindex != null) {
                this.getCplexI().delRows(this._data._rowindex);
            }
        }
        if (cpxQExpr != null && cpxQExpr._num > 0) {
            n2 = cpxQExpr._num;
            object2 = cpxQExpr._val;
            cpxNumVarArray3 = cpxQExpr._var1;
            cpxNumVarArray2 = cpxQExpr._var2;
            this.getCplexI().unUseVars((CpxNumVar[])cpxNumVarArray3, 0, n2);
            this.getCplexI().unUseVars((CpxNumVar[])cpxNumVarArray2, 0, n2);
            if (this._data._rowindex != null) {
                this.getCplexI().delQC(this._data._rowindex);
            }
        }
        if (this._data != null && this._data._gcindex != null) {
            this.getCplexI().deleteGC(this._data._gcindex, 6);
        }
        this._data = null;
    }

    final boolean isQC() {
        if (!this.isInstalledCon()) {
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            return externalRow._quad != null && externalRow._quad.getNum() > 0;
        }
        return this.getCplexI().isQC(this);
    }

    public double getLB() throws IloException {
        if (!this.isInstalledCon()) {
            return ((ExternalRow)this._conIndex).getLB();
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (this.getCplexI().isQC(this)) {
            this.getCplexI().getCpxQC(this, dArray, dArray2, null, null, null, null, null);
        } else {
            CpxRange[] cpxRangeArray = new CpxRange[]{this};
            this.getCplexI().getRows(cpxRangeArray, 0, 1, dArray, dArray2, null, null);
        }
        return dArray[0] <= -1.0E20 ? -1.7976931348623157E308 : dArray[0];
    }

    public double getUB() throws IloException {
        if (!this.isInstalledCon()) {
            return ((ExternalRow)this._conIndex).getUB();
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (this.getCplexI().isQC(this)) {
            this.getCplexI().getCpxQC(this, dArray, dArray2, null, null, null, null, null);
        } else {
            CpxRange[] cpxRangeArray = new CpxRange[]{this};
            this.getCplexI().getRows(cpxRangeArray, 0, 1, dArray, dArray2, null, null);
        }
        return dArray2[0] >= 1.0E20 ? Double.MAX_VALUE : dArray2[0];
    }

    public void setLB(double d) throws IloException {
        if (this.getUB() < d) {
            throw new CpxException(-1, "IloRange has incompatible bounds");
        }
        if (this.isInstalledCon()) {
            if (this.getCplexI().isQC(this)) {
                CplexI cplexI = this.getCplexI();
                int n = this._conUseCnt;
                this._conUseCnt = 1;
                this.uninstallCon();
                ((ExternalRow)this._conIndex)._lb = d;
                this.installCon(cplexI);
                this._conUseCnt = n;
            } else {
                this.getCplexI().setLHS(this._conIndex, d);
            }
        } else {
            ((ExternalRow)this._conIndex)._lb = d;
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public void setUB(double d) throws IloException {
        if (d < this.getLB()) {
            throw new CpxException(-1, "IloRange has incompatible bounds");
        }
        if (this.isInstalledCon()) {
            if (this.getCplexI().isQC(this)) {
                CplexI cplexI = this.getCplexI();
                int n = this._conUseCnt;
                this._conUseCnt = 1;
                this.uninstallCon();
                ((ExternalRow)this._conIndex)._ub = d;
                this.installCon(cplexI);
                this._conUseCnt = n;
            } else {
                this.getCplexI().setRHS(this._conIndex, d);
            }
        } else {
            ((ExternalRow)this._conIndex)._ub = d;
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public void setBounds(double d, double d2) throws IloException {
        if (d2 < d) {
            throw new CpxException(-1, "IloRange has incompatible bounds");
        }
        if (this.isInstalledCon()) {
            if (this.getCplexI().isQC(this)) {
                CplexI cplexI = this.getCplexI();
                int n = this._conUseCnt;
                this._conUseCnt = 1;
                this.uninstallCon();
                ((ExternalRow)this._conIndex)._ub = d2;
                ((ExternalRow)this._conIndex)._lb = d;
                this.installCon(cplexI);
                this._conUseCnt = n;
            } else {
                this.getCplexI().setLRHS(this._conIndex, d, d2);
            }
        } else {
            ((ExternalRow)this._conIndex)._lb = d;
            ((ExternalRow)this._conIndex)._ub = d2;
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    CpxNumExpr getCpxExpr() throws IloException {
        if (!this.isInstalledCon()) {
            return ((ExternalRow)this._conIndex).getCpxExpr();
        }
        if (this.getCplexI().isQC(this)) {
            double[][] dArrayArray = new double[1][];
            CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
            CpxNumVar[][] cpxNumVarArray2 = new CpxNumVar[1][];
            double[][] dArrayArray2 = new double[1][];
            CpxNumVar[][] cpxNumVarArray3 = new CpxNumVar[1][];
            this.getCplexI().getCpxQC(this, null, null, cpxNumVarArray3, dArrayArray2, cpxNumVarArray, cpxNumVarArray2, dArrayArray);
            CpxNumExpr cpxNumExpr = new CpxLinearNumExpr(dArrayArray2[0], cpxNumVarArray3[0], 0, dArrayArray2[0] == null ? 0 : dArrayArray2[0].length, 0.0);
            int n = dArrayArray[0].length;
            for (int i = 0; i < n; ++i) {
                cpxNumExpr = IloCplex.staticSum(cpxNumExpr, new CpxQTerm(dArrayArray[0][i], cpxNumVarArray[0][i], cpxNumVarArray2[0][i]));
            }
            return cpxNumExpr;
        }
        CpxRange[] cpxRangeArray = new CpxRange[]{this};
        CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
        double[][] dArrayArray = new double[1][];
        this.getCplexI().getCpxRows(cpxRangeArray, 0, 1, null, null, cpxNumVarArray, dArrayArray);
        return new CpxLinearNumExpr(dArrayArray[0], cpxNumVarArray[0], 0, dArrayArray[0].length, 0.0);
    }

    public IloNumExpr getExpr() throws IloException {
        return this.getCpxExpr();
    }

    public void clearExpr() throws IloException {
        if (!this.isInstalledCon()) {
            ((ExternalRow)this._conIndex).clear();
        } else if (this.getCplexI().isQC(this)) {
            CplexI cplexI = this.getCplexI();
            int n = this._conUseCnt;
            this._conUseCnt = 1;
            this.uninstallCon();
            ((ExternalRow)this._conIndex).clear();
            this.installCon(cplexI);
            this._conUseCnt = n;
        } else {
            CpxLinearExpr cpxLinearExpr = (CpxLinearExpr)this.getCpxExpr();
            int n = cpxLinearExpr.getNum();
            CplexIndex[] cplexIndexArray = new CplexIndex[n];
            CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
            double[] dArray = cpxLinearExpr._vals;
            for (int i = 0; i < n; ++i) {
                dArray[i] = 0.0;
                cplexIndexArray[i] = this._conIndex;
                cplexIndexArray2[i] = cpxLinearExpr._vars[i].getVarIndex();
            }
            this.getCplexI().setNZs(cplexIndexArray, cplexIndexArray2, dArray, 0, n);
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public void setExpr(IloNumExpr iloNumExpr) throws IloException {
        CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
        CpxQextractor cpxQextractor = new CpxQextractor();
        if (cpxNumExpr.accept(cpxQextractor) == null) {
            throw new UnsupportedOperationException("CpxRange for general expressions");
        }
        cpxQextractor._linear.removeDuplicates();
        if (cpxQextractor._quad.getNum() > 0) {
            CplexI cplexI = this.getCplexI();
            int n = this._conUseCnt;
            if (n > 0) {
                this._conUseCnt = 1;
                this.uninstallCon();
            }
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            externalRow.clear();
            externalRow._linear = cpxQextractor._linear;
            externalRow._quad = cpxQextractor._quad;
            if (n > 0) {
                this.installCon(cplexI);
                this._conUseCnt = n;
            }
        } else {
            this.setCpxExpr(cpxQextractor._linear._vars, cpxQextractor._linear._vals, 0, cpxQextractor._linear._num);
            if (cpxQextractor._linear._const != 0.0) {
                double d;
                double d2 = this.getLB();
                if (d2 > -1.0E20) {
                    this.setLB(d2 - cpxQextractor._linear._const);
                }
                if ((d = this.getUB()) < 1.0E20) {
                    this.setUB(d - cpxQextractor._linear._const);
                }
            }
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public void addToExpr(IloNumExpr iloNumExpr) throws IloException {
        CpxNumExpr cpxNumExpr = this.getCpxExpr();
        this.setExpr(IloCplex.staticSum(cpxNumExpr, (CpxNumExpr)iloNumExpr));
    }

    public void setLinearCoef(IloNumVar iloNumVar, double d) throws IloException {
        this.setLinearCoef(d, iloNumVar);
    }

    public void setLinearCoef(double d, IloNumVar iloNumVar) throws IloException {
        if (this.isQC()) {
            throw new UnsupportedOperationException("setLinearCoef called for non-linear constraint");
        }
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (!this.isInstalledCon()) {
            ((ExternalRow)this._conIndex).setLinearCoef(cpxNumVar, d);
        } else {
            CpxLinearExpr cpxLinearExpr = (CpxLinearExpr)this.getCpxExpr();
            int n = cpxLinearExpr.find(cpxNumVar);
            if (n < 0 && d != 0.0) {
                this.getCplexI().useVar(cpxNumVar, true);
                this.getCplexI().setNZ(this._conIndex, cpxNumVar.getVarIndex(), d);
            } else if (n >= 0) {
                this.getCplexI().setNZ(this._conIndex, cpxNumVar.getVarIndex(), d);
            }
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        if (this.isQC()) {
            throw new UnsupportedOperationException("setLinearCoef called for non-linear constraint");
        }
        if (!this.isInstalledCon()) {
            int n3 = n + n2;
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n3];
            for (int i = n; i < n3; ++i) {
                cpxNumVarArray[i] = (CpxNumVar)iloNumVarArray[i];
            }
            ((ExternalRow)this._conIndex).setLinearCoefs(cpxNumVarArray, dArray, n, n2);
        } else {
            int n4 = n + n2;
            CplexIndex[] cplexIndexArray = new CplexIndex[n2 + n];
            CplexIndex[] cplexIndexArray2 = new CplexIndex[n2 + n];
            CpxLinearExpr cpxLinearExpr = (CpxLinearExpr)this.getCpxExpr();
            cpxLinearExpr.markVars();
            try {
                for (int i = n; i < n4; ++i) {
                    CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
                    if (cpxNumVar.isMarked()) {
                        cplexIndexArray[i] = cpxNumVar.getOriginalIndex();
                    } else {
                        this.getCplexI().useVar(cpxNumVar, true);
                        cplexIndexArray[i] = cpxNumVar.getVarIndex();
                    }
                    cplexIndexArray2[i] = this._conIndex;
                }
            }
            finally {
                cpxLinearExpr.unmarkVars();
            }
            this.getCplexI().setNZs(cplexIndexArray2, cplexIndexArray, dArray, n, n2);
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    public IloColumn makeColumn(double d) throws IloException {
        return new RngColumn(this, d);
    }

    public IloColumnArray makeColumnArray(double[] dArray, int n, int n2) throws IloException {
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, n, dArray2, 0, n2);
        return new RngColumnArray(this, dArray2);
    }

    final int getIndexValue() {
        return this._conIndex._index;
    }

    final CplexIndex getIndex() {
        return this._conIndex;
    }

    final void overwriteIndex(CplexIndex cplexIndex) {
        this._conIndex = cplexIndex;
    }

    final void setIndex(CplexIndex cplexIndex) {
        if (cplexIndex != null && this._conIndex != null) {
            throw new UnsupportedOperationException("CpxRange for with two indices");
        }
        this._conIndex = cplexIndex;
        this._conUseCnt = cplexIndex == null || cplexIndex instanceof ExternalRow ? 0 : 1;
    }

    void addNewToExpr(CpxNumVar cpxNumVar, double d) throws IloException {
        if (!this.isInstalledCon()) {
            ((ExternalRow)this._conIndex).addNewLinearCoef(cpxNumVar, d);
        } else {
            this.getCplexI().useVar(cpxNumVar, true);
            this.getCplexI().addNZ(this._conIndex, cpxNumVar.getVarIndex(), d);
        }
        if (this.isInstalledVar()) {
            this.reinstallVar();
        }
    }

    void addNewToExpr(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n3];
        for (int i = n; i < n3; ++i) {
            cpxNumVarArray[i] = (CpxNumVar)iloNumVarArray[i - n];
        }
        if (!this.isInstalledCon()) {
            ((ExternalRow)this._conIndex).addNewLinearCoefs(cpxNumVarArray, dArray, n, n2);
        } else {
            this.getCplexI().useVars(cpxNumVarArray, n, n2, true);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = cpxNumVarArray[i + n].getVarIndexValue();
                nArray[i] = this._conIndex.getValue();
            }
            if (n == 0) {
                this.getCplexI().addNZs(nArray, nArray2, dArray, n2);
            } else {
                double[] dArray2 = new double[n2];
                System.arraycopy(dArray, n, dArray2, 0, n2);
                this.getCplexI().addNZs(nArray, nArray2, dArray2, n2);
            }
        }
    }

    void setCpxExpr(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) throws IloException {
        if (!this.isInstalledCon()) {
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            externalRow.clear();
            externalRow.addNewLinearCoefs(cpxNumVarArray, dArray, n, n2);
        } else if (this.getCplexI().isQC(this)) {
            CplexI cplexI = this.getCplexI();
            int n3 = this._conUseCnt;
            this._conUseCnt = 1;
            this.uninstallCon();
            ExternalRow externalRow = (ExternalRow)this._conIndex;
            externalRow.clear();
            externalRow.addNewLinearCoefs(cpxNumVarArray, dArray, n, n2);
            this.installCon(cplexI);
            this._conUseCnt = n3;
        } else {
            this.clearExpr();
            this.getCplexI().useVars(cpxNumVarArray, n, n2, true);
            int[] nArray = new int[n + n2];
            int[] nArray2 = new int[n + n2];
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                nArray[i] = this._conIndex.getValue();
                nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
            }
            if (n == 0) {
                this.getCplexI().addNZs(nArray, nArray2, dArray, n2);
            } else {
                double[] dArray2 = new double[n2];
                System.arraycopy(dArray, n, dArray2, 0, n2);
                this.getCplexI().addNZs(nArray, nArray2, dArray2, n2);
            }
        }
    }

    void removeMarked() {
        if (this.isInstalledCon()) {
            if (this.getCplexI().isQC(this)) {
                throw new UnsupportedOperationException("CpxRange.removeMarked()");
            }
            throw new UnsupportedOperationException("CpxRange.removeMarked()");
        }
        ((ExternalRow)this._conIndex).removeMarked();
    }

    CpxRange() throws IloException {
    }

    protected CpxRange(CplexIndex cplexIndex, String string) throws IloException {
        super(0.0, 1.0, IloNumVarType.Bool, string);
        this._conIndex = cplexIndex;
        this._conUseCnt = cplexIndex == null ? 0 : 1;
    }

    static int[] getVarIndices(CpxNumVar[] cpxNumVarArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cpxNumVarArray[i + n].getVarIndexValue();
        }
        return nArray;
    }

    private void init(CplexI cplexI, double d, double d2, int n, double[] dArray, CpxNumVar[] cpxNumVarArray, int n2, double[] dArray2, CpxNumVar[] cpxNumVarArray2, CpxNumVar[] cpxNumVarArray3) throws IloException {
        if (d <= -1.7976931348623157E308) {
            d = -1.0E20;
        }
        if (d2 >= Double.MAX_VALUE) {
            d2 = 1.0E20;
        }
        if (d2 < d) {
            throw new CpxException(-1, "IloRange has incompatible bounds");
        }
        this.setCplexI(cplexI);
        cplexI.useVars(cpxNumVarArray, 0, n, true);
        cplexI.useVars(cpxNumVarArray2, 0, n2, true);
        cplexI.useVars(cpxNumVarArray3, 0, n2, true);
        int[] nArray = CpxRange.getVarIndices(cpxNumVarArray, 0, n);
        int[] nArray2 = CpxRange.getVarIndices(cpxNumVarArray2, 0, n2);
        int[] nArray3 = CpxRange.getVarIndices(cpxNumVarArray3, 0, n2);
        this._conIndex = cplexI.addQC(this, d, d2, n, dArray, nArray, n2, dArray2, nArray2, nArray3, this._name);
        this._conUseCnt = 1;
    }

    private void init(CplexI cplexI, double d, double d2, int n, double[] dArray, CpxNumVar[] cpxNumVarArray) throws IloException {
        if (d <= -1.7976931348623157E308) {
            d = -1.0E20;
        }
        if (d2 >= Double.MAX_VALUE) {
            d2 = 1.0E20;
        }
        if (d2 < d) {
            throw new CpxException(-1, "IloRange has incompatible bounds");
        }
        this.setCplexI(cplexI);
        cplexI.useVars(cpxNumVarArray, 0, n, true);
        this._conIndex = cplexI.addRow(this, d, d2, n, CpxRange.getVarIndices(cpxNumVarArray, 0, n), dArray);
        this._conUseCnt = 1;
    }

    protected CpxRange(CplexI cplexI, double d, double d2, String string) throws IloException {
        super(0.0, 1.0, IloNumVarType.Bool, string);
        if (cplexI != null) {
            this.init(cplexI, d, d2, 0, null, null);
        } else {
            this._conIndex = this.makeExternalRow(d, d2, null, null, 0, 0, 0.0);
        }
    }

    protected CpxRange(CplexI cplexI, double d, CpxNumExpr cpxNumExpr, double d2, String string) throws IloException {
        super(0.0, 1.0, IloNumVarType.Bool, string);
        CpxQextractor cpxQextractor = new CpxQextractor();
        if (cpxNumExpr.accept(cpxQextractor) == null) {
            throw new UnsupportedOperationException("CpxRange for general expressions");
        }
        if (d > -1.0E20) {
            d -= cpxQextractor._linear._const;
        }
        if (d2 < 1.0E20) {
            d2 -= cpxQextractor._linear._const;
        }
        cpxQextractor._linear.removeDuplicates();
        if (cplexI != null) {
            cpxQextractor._quad.removeDuplicates();
            if (cpxQextractor._quad.getNum() > 0) {
                this.init(cplexI, d, d2, cpxQextractor._linear._num, cpxQextractor._linear._vals, cpxQextractor._linear._vars, cpxQextractor._quad._num, cpxQextractor._quad._val, cpxQextractor._quad._var1, cpxQextractor._quad._var2);
            } else {
                this.init(cplexI, d, d2, cpxQextractor._linear._num, cpxQextractor._linear._vals, cpxQextractor._linear._vars);
            }
        } else {
            this._conIndex = this.makeExternalRow(d, d2, (CpxLinearNumExpr)cpxQextractor._linear, cpxQextractor._quad);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IloRange ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append(" : ");
        double d = -1.0E20;
        double d2 = 1.0E20;
        try {
            d = this.getLB();
            d2 = this.getUB();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (d > -1.0E20) {
            stringBuffer.append(d);
        } else {
            stringBuffer.append("-infinity");
        }
        try {
            CpxNumExpr cpxNumExpr = this.getCpxExpr();
            stringBuffer.append(" <= ");
            stringBuffer.append(cpxNumExpr);
            stringBuffer.append(" <= ");
        }
        catch (Throwable throwable) {
            stringBuffer.append(" <= ");
        }
        if (d2 < 1.0E20) {
            stringBuffer.append(d2);
        } else {
            stringBuffer.append("infinity");
        }
        return stringBuffer.toString();
    }

    private class RngColumnArray
    extends IloColumnArray {
        CpxRange _rng;
        double[] _val;

        RngColumnArray(CpxRange cpxRange2, double[] dArray) {
            this._rng = cpxRange2;
            this._val = dArray;
        }

        public void install(IloNumVar[] iloNumVarArray) throws IloException {
            this._rng.addNewToExpr(iloNumVarArray, this._val, 0, this._val.length);
        }

        public int getSize() {
            return this._val.length;
        }
    }

    private class RngColumn
    extends IloColumn {
        CpxRange _rng;
        double _val;

        RngColumn(CpxRange cpxRange2, double d) {
            this._rng = cpxRange2;
            this._val = d;
        }

        public void install(IloNumVar iloNumVar) throws IloException {
            this._rng.addNewToExpr((CpxNumVar)iloNumVar, this._val);
        }
    }

    class RangeData {
        CpxAnd _and = null;
        CplexIndex _gcindex = null;
        CplexIndex _rowindex = null;

        RangeData() {
        }
    }

    class ExternalRow
    extends CplexIndex {
        private static final long serialVersionUID = 1220L;
        CpxLinearExpr _linear;
        CpxQExpr _quad;
        double _lb;
        double _ub;

        ExternalRow() {
            super(-10);
        }

        ExternalRow(double d, double d2, CpxLinearNumExpr cpxLinearNumExpr) {
            super(-10);
            this._linear = cpxLinearNumExpr;
            this._quad = null;
            this._lb = d;
            this._ub = d2;
        }

        ExternalRow(double d, double d2, CpxLinearNumExpr cpxLinearNumExpr, CpxQExpr cpxQExpr) {
            super(-10);
            this._linear = cpxLinearNumExpr;
            this._quad = cpxQExpr;
            this._lb = d;
            this._ub = d2;
        }

        final double getLB() {
            return this._lb;
        }

        final double getUB() {
            return this._ub;
        }

        CpxNumExpr getCpxExpr() throws IloException {
            CpxNumExpr cpxNumExpr = new CpxLinearNumExpr(this._linear.getValues(), this._linear.getNumVars(), 0, this._linear.getNum(), 0.0);
            if (this._quad != null) {
                int n = this._quad.getNum();
                CpxNumVar[] cpxNumVarArray = this._quad.getNumVar1();
                CpxNumVar[] cpxNumVarArray2 = this._quad.getNumVar2();
                double[] dArray = this._quad.getNumVal();
                for (int i = 0; i < n; ++i) {
                    cpxNumExpr = IloCplex.staticSum(cpxNumExpr, new CpxQTerm(dArray[i], cpxNumVarArray[i], cpxNumVarArray2[i]));
                }
            }
            return cpxNumExpr;
        }

        final void clear() throws IloException {
            if (this._linear != null) {
                this._linear.clear();
            }
            if (this._quad != null) {
                this._quad.clear();
            }
        }

        final void setLinearCoef(CpxNumVar cpxNumVar, double d) throws IloException {
            this._linear.setCoef(cpxNumVar, d);
        }

        final void setLinearCoefs(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) throws IloException {
            this._linear.setCoefs(cpxNumVarArray, dArray, n, n2);
        }

        final void addNewLinearCoef(CpxNumVar cpxNumVar, double d) throws IloException {
            this._linear.addCoef(cpxNumVar, d);
        }

        final void addNewLinearCoefs(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) throws IloException {
            this._linear.addCoefs(cpxNumVarArray, dArray, n, n2);
            this._linear.removeDuplicates();
        }

        final void removeMarked() {
            if (this._linear != null) {
                this._linear.removeMarked();
            }
            if (this._quad != null) {
                this._quad.removeMarked();
            }
        }
    }
}

