/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.Cplex;
import ilog.cplex.CpxOptimizationCallback;
import ilog.cplex.IloCplex;

class CpxMIPInfoCallback
extends CpxOptimizationCallback {
    protected CpxMIPInfoCallback(IloCplex.Callback callback) {
        super(callback);
    }

    int getCBType() {
        return 17;
    }

    int getIntNodeInfo(int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodeinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), n2, n, this._intAux));
        return this._intAux[0];
    }

    int getIntSeqInfo(int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbackseqinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), n2, n, this._intAux));
        return this._intAux[0];
    }

    Object getObjectNodeInfo(int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodeinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), n2, n, this._objectAux));
        return this._objectAux[0];
    }

    Object getObjectSeqInfo(int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbackseqinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), n2, n, this._objectAux));
        return this._objectAux[0];
    }

    final int getMyThreadNum() throws IloException {
        return this.getIntInfo(123);
    }

    final boolean hasIncumbent() throws IloException {
        return this.getIntInfo(109) == 1;
    }

    final double getBestObjValue() throws IloException {
        return this.getDoubleInfo(102);
    }

    final double getMIPRelativeGap() throws IloException {
        return this.getDoubleInfo(125);
    }

    final double getCutoff() throws IloException {
        return this.getDoubleInfo(106);
    }

    final double getIncumbentObjValue() throws IloException {
        return this.getDoubleInfo(101);
    }

    final double getIncumbentValue(int n) {
        try {
            this.CALL(Cplex.CPXgetcallbackincumbent(this.getEnv(), this.getCBdata(), this.getWherefrom(), this._doubleAux, n, n));
            return this._doubleAux[0];
        }
        catch (IloException iloException) {
            return 0.0;
        }
    }

    final void getIncumbentValues(double[] dArray, int[] nArray) {
        try {
            int n;
            int n2 = nArray[0];
            int n3 = nArray[0];
            int n4 = nArray.length;
            for (n = 1; n < n4; ++n) {
                if (nArray[n] > n2) {
                    n2 = nArray[n];
                    continue;
                }
                if (nArray[n] >= n3) continue;
                n3 = nArray[n];
            }
            double[] dArray2 = new double[n2 - n3 + 1];
            this.CALL(Cplex.CPXgetcallbackincumbent(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray2, n3, n2));
            for (n = 0; n < n4; ++n) {
                dArray[n] = dArray2[nArray[n] - n3];
            }
        }
        catch (IloException iloException) {
            // empty catch block
        }
    }

    final int getNnodes() throws IloException {
        return this.getIntInfo(103);
    }

    final int getNremainingNodes() throws IloException {
        return this.getIntInfo(104);
    }

    final int getNiterations() throws IloException {
        return this.getIntInfo(105);
    }

    final double getQuality(int n) throws IloException {
        switch (n) {
            case 52: {
                return this.getDoubleInfo(127);
            }
            case 53: {
                return this.getDoubleInfo(128);
            }
            case 54: {
                return this.getDoubleInfo(129);
            }
            case 55: {
                return this.getDoubleInfo(130);
            }
            case 56: {
                return this.getDoubleInfo(131);
            }
            case 57: {
                return this.getDoubleInfo(132);
            }
        }
        return this.getDoubleInfo(-1);
    }
}

