/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloConstraint;
import ilog.concert.IloException;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSubVar;
import ilog.cplex.IloCplexModeler;
import ilog.cplex.UnsupportedExpressionException;
import java.io.IOException;
import java.io.ObjectOutputStream;

public abstract class CpxGC
extends CpxSubVar
implements IloConstraint {
    private static final long serialVersionUID = 1220L;
    private int _gcCnt = 0;
    private transient CpxRange _range = null;

    CpxGC(String string) throws IloException {
        super(0.0, 1.0, IloNumVarType.Bool, string);
    }

    void installCon(CplexI cplexI) throws IloException {
        ++this._gcCnt;
        cplexI.checkCplexI(this);
        if (this._gcCnt == 1) {
            this.setCplexI(cplexI);
            this.installGC(cplexI);
        }
    }

    abstract void removeVars(CplexIndex var1) throws IloException;

    protected final CpxRange getGCRange() {
        return this._range;
    }

    CpxRange makeRange(CplexI cplexI) throws IloException {
        throw new UnsupportedExpressionException(this);
    }

    void installVar(IloCplexModeler iloCplexModeler) throws IloException {
        if (this._range == null) {
            this._range = this.makeRange(iloCplexModeler.getCplexI());
        }
        if (this._range != null) {
            CpxNumVar[] cpxNumVarArray = new CpxSubVar[]{this._range};
            iloCplexModeler.getCplexI().useVars(cpxNumVarArray, 0, 1, true);
            this._varIndex = this._range._varIndex;
        }
    }

    void uninstallVar(IloCplexModeler iloCplexModeler) throws IloException {
        if (this._range != null) {
            this._range.uninstallVar(iloCplexModeler);
            if (!this._range.isInstalledCon()) {
                this._range = null;
            }
        }
    }

    final boolean isInstalledCon() {
        return this.isInstalledExt();
    }

    void uninstallCon() throws IloException {
        --this._gcCnt;
        if (this._gcCnt == 0) {
            this.uninstallGC();
            this.setCplexI(null);
        }
    }

    void uninstallGC() throws IloException {
        if (this._range != null) {
            this._range.uninstallCon();
            if (!this._range.isInstalledVar()) {
                this._range = null;
            }
        }
    }

    void installGC(CplexI cplexI) throws IloException {
        if (this._range == null) {
            this._range = this.makeRange(cplexI);
        }
        if (this._range != null) {
            this._range.installCon(cplexI);
        }
    }

    CplexIndex getGCIndex() throws IloException {
        if (this._range != null) {
            return this._range.getIndex();
        }
        return null;
    }

    abstract int getGCExtractedType() throws IloException;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CplexI cplexI = this.getCplexI();
        if (cplexI != null) {
            int n = this._gcCnt;
            try {
                if (n > 0) {
                    this._gcCnt = 1;
                    this.uninstallCon();
                }
                objectOutputStream.defaultWriteObject();
                if (n > 0) {
                    this.installCon(cplexI);
                }
            }
            catch (IloException iloException) {
                throw new IOException();
            }
            this._gcCnt = n;
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }
}

