/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert;

import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloModeler;
import java.util.HashMap;

public class IloCopyManager {
    private IloModeler _modeler;
    private HashMap _map;
    private boolean _copyMode;
    private Check _existGroundTerm = null;
    private Check _existFreeTerm = null;

    public IloCopyManager(IloModeler iloModeler) {
        this(iloModeler, false);
    }

    public IloCopyManager(IloModeler iloModeler, boolean bl) {
        this._modeler = iloModeler;
        this._map = new HashMap();
        this._copyMode = bl;
        this._existGroundTerm = new ExistGroundTerm();
        this._existFreeTerm = new ExistFreeTerm();
    }

    public void resetMap() {
        this._map.clear();
    }

    public IloCopyable findCopy(IloCopyable iloCopyable) {
        if (this._map.containsKey(iloCopyable)) {
            return (IloCopyable)this._map.get(iloCopyable);
        }
        return null;
    }

    public void setCopy(IloCopyable iloCopyable, IloCopyable iloCopyable2) {
        this._map.put(iloCopyable, iloCopyable2);
    }

    public HashMap getMap() {
        return this._map;
    }

    public boolean getCopyMode() {
        return this._copyMode;
    }

    public IloModeler getModeler() {
        return this._modeler;
    }

    boolean check(IloCopyable iloCopyable, Check check) {
        try {
            iloCopyable.needCopy(check);
        }
        catch (Check check2) {
            return true;
        }
        return false;
    }

    public boolean hasGroundTerm(IloCopyable iloCopyable) {
        return this.check(iloCopyable, this._existGroundTerm);
    }

    public boolean hasFreeTerm(IloCopyable iloCopyable) {
        return this.check(iloCopyable, this._existFreeTerm);
    }

    public IloCopyable getCopy(IloCopyable iloCopyable) throws IloException {
        if (this._map.containsKey(iloCopyable)) {
            return (IloCopyable)this._map.get(iloCopyable);
        }
        IloCopyable iloCopyable2 = this._copyMode ? (this.hasFreeTerm(iloCopyable) ? iloCopyable.makeCopy(this) : iloCopyable) : iloCopyable.makeCopy(this);
        this.setCopy(iloCopyable, iloCopyable2);
        return iloCopyable2;
    }

    public static class ExistFreeTerm
    extends Check {
        private static final long serialVersionUID = 4699881584370070149L;

        ExistFreeTerm() {
        }
    }

    public static class ExistGroundTerm
    extends Check {
        private static final long serialVersionUID = -8904441642320167787L;

        ExistGroundTerm() {
        }
    }

    public static abstract class Check
    extends Exception {
        private static final long serialVersionUID = 4141841610611205226L;
    }
}

