/*
 * Decompiled with CFR 0.152.
 */
package frame.options.virtual.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;

public class CreateVirtualSelectPanel
extends JPanel {
    private JLabel networksNumberLabel;
    private JTextField networksNumberTextField;
    private JLabel windowTimeUnitsNumberLabel;
    private JTextField windowTimeUnitsNumberTextField;
    private JLabel poissonArrivesLabel;
    private JTextField poissonArrivesTextField;
    private JLabel exponentialLifetimeLabel;
    private JTextField exponentialLifetimeTextField;
    private JLabel routersNumberLabel;
    private JTextField minRoutersNumberTextField;
    private JTextField maxRoutersNumberTextField;
    private JLabel switchesNumberLabel;
    private JTextField minSwitchesNumberTextField;
    private JTextField maxSwitchesNumberTextField;
    private JLabel serversNumberLabel;
    private JTextField minServersNumberTextField;
    private JTextField maxServersNumberTextField;
    private JLabel osLabel;
    private JTextField linuxPercentageTextField;
    private JTextField windowsPercentageTextField;
    private JTextField solarisPercentageTextField;
    private JTextField androidPercentageTextField;
    private JLabel cpuLabel;
    private JTextField minCPUtextField;
    private JTextField maxCPUtextField;
    private JLabel ramLabel;
    private JTextField minRAMtextField;
    private JTextField maxRAMtextField;
    private JLabel storageLabel;
    private JTextField minStorageTextField;
    private JTextField maxStorageTextField;
    private JLabel bwLabel;
    private JTextField minBWtextField;
    private JTextField maxBWtextField;
    private JLabel informationLabel;

    public JLabel getNetworksNumberLabel() {
        return this.networksNumberLabel;
    }

    public void setNetworksNumberLabel(JLabel networksNumberLabel) {
        this.networksNumberLabel = networksNumberLabel;
    }

    public JTextField getNetworksNumberTextField() {
        return this.networksNumberTextField;
    }

    public void setNetworksNumberTextField(JTextField networksNumberTextField) {
        this.networksNumberTextField = networksNumberTextField;
    }

    public JLabel getWindowTimeUnitsNumberLabel() {
        return this.windowTimeUnitsNumberLabel;
    }

    public void setWindowTimeUnitsNumberLabel(JLabel windowTimeUnitsNumberLabel) {
        this.windowTimeUnitsNumberLabel = windowTimeUnitsNumberLabel;
    }

    public JTextField getWindowTimeUnitsNumberTextField() {
        return this.windowTimeUnitsNumberTextField;
    }

    public void setWindowTimeUnitsNumberTextField(JTextField windowTimeUnitsNumberTextField) {
        this.windowTimeUnitsNumberTextField = windowTimeUnitsNumberTextField;
    }

    public JLabel getPoissonArrivesLabel() {
        return this.poissonArrivesLabel;
    }

    public void setPoissonArrivesLabel(JLabel poissonArrivesLabel) {
        this.poissonArrivesLabel = poissonArrivesLabel;
    }

    public JTextField getPoissonArrivesTextField() {
        return this.poissonArrivesTextField;
    }

    public void setPoissonArrivesTextField(JTextField poissonArrivesTextField) {
        this.poissonArrivesTextField = poissonArrivesTextField;
    }

    public JLabel getExponentialLifetimeLabel() {
        return this.exponentialLifetimeLabel;
    }

    public void setExponentialLifetimeLabel(JLabel exponentialLifetimeLabel) {
        this.exponentialLifetimeLabel = exponentialLifetimeLabel;
    }

    public JTextField getExponentialLifetimeTextField() {
        return this.exponentialLifetimeTextField;
    }

    public void setExponentialLifetimeTextField(JTextField exponentialLifetimeTextField) {
        this.exponentialLifetimeTextField = exponentialLifetimeTextField;
    }

    public JLabel getRoutersNumberLabel() {
        return this.routersNumberLabel;
    }

    public void setRoutersNumberLabel(JLabel routersNumberLabel) {
        this.routersNumberLabel = routersNumberLabel;
    }

    public JTextField getMinRoutersNumberTextField() {
        return this.minRoutersNumberTextField;
    }

    public void setMinRoutersNumberTextField(JTextField minRoutersNumberTextField) {
        this.minRoutersNumberTextField = minRoutersNumberTextField;
    }

    public JTextField getMaxRoutersNumberTextField() {
        return this.maxRoutersNumberTextField;
    }

    public void setMaxRoutersNumberTextField(JTextField maxRoutersNumberTextField) {
        this.maxRoutersNumberTextField = maxRoutersNumberTextField;
    }

    public JLabel getSwitchesNumberLabel() {
        return this.switchesNumberLabel;
    }

    public void setSwitchesNumberLabel(JLabel switchesNumberLabel) {
        this.switchesNumberLabel = switchesNumberLabel;
    }

    public JTextField getMinSwitchesNumberTextField() {
        return this.minSwitchesNumberTextField;
    }

    public void setMinSwitchesNumberTextField(JTextField minSwitchesNumberTextField) {
        this.minSwitchesNumberTextField = minSwitchesNumberTextField;
    }

    public JTextField getMaxSwitchesNumberTextField() {
        return this.maxSwitchesNumberTextField;
    }

    public void setMaxSwitchesNumberTextField(JTextField maxSwitchesNumberTextField) {
        this.maxSwitchesNumberTextField = maxSwitchesNumberTextField;
    }

    public JLabel getServersNumberLabel() {
        return this.serversNumberLabel;
    }

    public void setServersNumberLabel(JLabel serversNumberLabel) {
        this.serversNumberLabel = serversNumberLabel;
    }

    public JTextField getMinServersNumberTextField() {
        return this.minServersNumberTextField;
    }

    public void setMinServersNumberTextField(JTextField minServersNumberTextField) {
        this.minServersNumberTextField = minServersNumberTextField;
    }

    public JTextField getMaxServersNumberTextField() {
        return this.maxServersNumberTextField;
    }

    public void setMaxServersNumberTextField(JTextField maxServersNumberTextField) {
        this.maxServersNumberTextField = maxServersNumberTextField;
    }

    public JLabel getOSlabel() {
        return this.osLabel;
    }

    public void setOSlabel(JLabel osLabel) {
        this.osLabel = osLabel;
    }

    public JTextField getLinuxPercentageTextField() {
        return this.linuxPercentageTextField;
    }

    public void setLinuxPercentageTextField(JTextField linuxPercentageTextField) {
        this.linuxPercentageTextField = linuxPercentageTextField;
    }

    public JTextField getWindowsPercentageTextField() {
        return this.windowsPercentageTextField;
    }

    public void setWindowsPercentageTextField(JTextField windowsPercentageTextField) {
        this.windowsPercentageTextField = windowsPercentageTextField;
    }

    public JTextField getSolarisPercentageTextField() {
        return this.solarisPercentageTextField;
    }

    public void setSolarisPercentageTextField(JTextField solarisPercentageTextField) {
        this.solarisPercentageTextField = solarisPercentageTextField;
    }

    public JTextField getAndroidPercentageTextField() {
        return this.androidPercentageTextField;
    }

    public void getAndroidPercentageTextField(JTextField androidPercentageTextField) {
        this.androidPercentageTextField = androidPercentageTextField;
    }

    public JLabel getCPUlabel() {
        return this.cpuLabel;
    }

    public void setCPUlabel(JLabel cpuLabel) {
        this.cpuLabel = cpuLabel;
    }

    public JTextField getMinCPUtextField() {
        return this.minCPUtextField;
    }

    public void setMinCPUtextField(JTextField minCPUtextField) {
        this.minCPUtextField = minCPUtextField;
    }

    public JTextField getMaxCPUtextField() {
        return this.maxCPUtextField;
    }

    public void setMaxCPUtextField(JTextField maxCPUtextField) {
        this.maxCPUtextField = maxCPUtextField;
    }

    public JLabel getRAMlabel() {
        return this.ramLabel;
    }

    public void setRAMlabel(JLabel ramLabel) {
        this.ramLabel = ramLabel;
    }

    public JTextField getMinRAMtextField() {
        return this.minRAMtextField;
    }

    public void setMinRAMtextField(JTextField minRAMtextField) {
        this.minRAMtextField = minRAMtextField;
    }

    public JTextField getMaxRAMtextField() {
        return this.maxRAMtextField;
    }

    public void setMaxRAMtextField(JTextField maxRAMtextField) {
        this.maxRAMtextField = maxRAMtextField;
    }

    public JLabel getStorageLabel() {
        return this.storageLabel;
    }

    public void setStorageLabel(JLabel storageLabel) {
        this.storageLabel = storageLabel;
    }

    public JTextField getMinStorageTextField() {
        return this.minStorageTextField;
    }

    public void setMinStorageTextField(JTextField minStorageTextField) {
        this.minStorageTextField = minStorageTextField;
    }

    public JTextField getMaxStorageTextField() {
        return this.maxStorageTextField;
    }

    public void setMaxStorageTextField(JTextField maxStorageTextField) {
        this.maxStorageTextField = maxStorageTextField;
    }

    public JLabel getBWlabel() {
        return this.bwLabel;
    }

    public void setBWlabel(JLabel bwLabel) {
        this.bwLabel = bwLabel;
    }

    public JTextField getMinBWtextField() {
        return this.minBWtextField;
    }

    public void setMinBWtextField(JTextField minBWtextField) {
        this.minBWtextField = minBWtextField;
    }

    public JTextField getMaxBWtextField() {
        return this.maxBWtextField;
    }

    public void setMaxBWtextField(JTextField maxBWtextField) {
        this.maxBWtextField = maxBWtextField;
    }

    public JLabel getInformationLabel() {
        return this.informationLabel;
    }

    public void setInformationLabel(JLabel informationLabel) {
        this.informationLabel = informationLabel;
    }

    public CreateVirtualSelectPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Random virtual networks");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)new JSeparator(), "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel informationPanel = this.informationPanel();
        JPanel networksPanel = this.networksPanel();
        JPanel nodesPanel = this.nodesPanel();
        JPanel nodePanel = this.nodePanel();
        JPanel linkPanel = this.linkPanel();
        JPanel contentPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(contentPanel);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(informationPanel).addComponent(networksPanel).addComponent(nodesPanel).addComponent(nodePanel).addComponent(linkPanel)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(informationPanel).addComponent(networksPanel).addComponent(nodesPanel).addComponent(nodePanel).addComponent(linkPanel)));
        contentPanel.setLayout(groupLayout);
        return contentPanel;
    }

    private JPanel informationPanel() {
        this.setInformationLabel(new JLabel());
        JPanel informationPanel = new JPanel();
        informationPanel.add(this.getInformationLabel());
        return informationPanel;
    }

    private JPanel networksPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>VIRTUAL NETWORKS</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel networksPanel = new JPanel();
        networksPanel.setLayout(new GridLayout(0, 1));
        networksPanel.setBorder(titledBorder);
        networksPanel.add(this.networksNumberPanel());
        networksPanel.add(this.windowTimeUnitsNumberPanel());
        networksPanel.add(this.poissonArrivesPanel());
        networksPanel.add(this.exponentialLifetimePanel());
        return networksPanel;
    }

    private JPanel networksNumberPanel() {
        this.setNetworksNumberLabel(new JLabel("<html><b>Networks number:</b></html>"));
        this.setNetworksNumberTextField(new JTextField(Integer.toString(10)));
        this.getNetworksNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getNetworksNumberTextField().setHorizontalAlignment(0);
        JPanel networksNumberPanel = new JPanel(new FlowLayout(1));
        networksNumberPanel.add(this.getNetworksNumberLabel());
        networksNumberPanel.add(this.getNetworksNumberTextField());
        return networksNumberPanel;
    }

    private JPanel windowTimeUnitsNumberPanel() {
        this.setWindowTimeUnitsNumberLabel(new JLabel("<html><b>Window time units number:</b></html>"));
        this.setWindowTimeUnitsNumberTextField(new JTextField(Integer.toString(1)));
        this.getWindowTimeUnitsNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getWindowTimeUnitsNumberTextField().setHorizontalAlignment(0);
        JPanel windowTimeUnitsNumberPanel = new JPanel(new FlowLayout(1));
        windowTimeUnitsNumberPanel.add(this.getWindowTimeUnitsNumberLabel());
        windowTimeUnitsNumberPanel.add(this.getWindowTimeUnitsNumberTextField());
        return windowTimeUnitsNumberPanel;
    }

    private JPanel poissonArrivesPanel() {
        this.setPoissonArrivesLabel(new JLabel("<html><b>Networks number per window in Poisson arrives:</b></html>"));
        this.setPoissonArrivesTextField(new JTextField(Integer.toString(1)));
        this.getPoissonArrivesTextField().setPreferredSize(new Dimension(25, 20));
        this.getPoissonArrivesTextField().setHorizontalAlignment(0);
        JPanel poissonArrivesPanel = new JPanel(new FlowLayout(1));
        poissonArrivesPanel.add(this.getPoissonArrivesLabel());
        poissonArrivesPanel.add(this.getPoissonArrivesTextField());
        return poissonArrivesPanel;
    }

    private JPanel exponentialLifetimePanel() {
        this.setExponentialLifetimeLabel(new JLabel("<html><b>Average time units of exponential lifetime:</b></html>"));
        this.setExponentialLifetimeTextField(new JTextField(Integer.toString(10)));
        this.getExponentialLifetimeTextField().setPreferredSize(new Dimension(25, 20));
        this.getExponentialLifetimeTextField().setHorizontalAlignment(0);
        JPanel exponentialLifetimePanel = new JPanel(new FlowLayout(1));
        exponentialLifetimePanel.add(this.getExponentialLifetimeLabel());
        exponentialLifetimePanel.add(this.getExponentialLifetimeTextField());
        return exponentialLifetimePanel;
    }

    private JPanel nodesPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN NODES</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel nodesPanel = new JPanel();
        nodesPanel.setLayout(new GridLayout(0, 1));
        nodesPanel.setBorder(titledBorder);
        nodesPanel.add(this.routersNumberRangePanel());
        nodesPanel.add(this.switchesNumberRangePanel());
        nodesPanel.add(this.serversNumberRangePanel());
        nodesPanel.add(this.osPercentagesPanel());
        return nodesPanel;
    }

    private JPanel routersNumberRangePanel() {
        this.setRoutersNumberLabel(new JLabel("<html><b>Routers number:</b></html>"));
        this.setMinRoutersNumberTextField(new JTextField(Integer.toString(1)));
        this.getMinRoutersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinRoutersNumberTextField().setHorizontalAlignment(0);
        this.setMaxRoutersNumberTextField(new JTextField(Integer.toString(5)));
        this.getMaxRoutersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxRoutersNumberTextField().setHorizontalAlignment(0);
        JPanel routersNumberRangePanel = new JPanel(new FlowLayout(1));
        routersNumberRangePanel.add(this.getRoutersNumberLabel());
        routersNumberRangePanel.add(new JLabel("Between"));
        routersNumberRangePanel.add(this.getMinRoutersNumberTextField());
        routersNumberRangePanel.add(new JLabel("and"));
        routersNumberRangePanel.add(this.getMaxRoutersNumberTextField());
        return routersNumberRangePanel;
    }

    private JPanel switchesNumberRangePanel() {
        this.setSwitchesNumberLabel(new JLabel("<html><b>Switches number:</b></html>"));
        this.setMinSwitchesNumberTextField(new JTextField(Integer.toString(1)));
        this.getMinSwitchesNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinSwitchesNumberTextField().setHorizontalAlignment(0);
        this.setMaxSwitchesNumberTextField(new JTextField(Integer.toString(5)));
        this.getMaxSwitchesNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxSwitchesNumberTextField().setHorizontalAlignment(0);
        JPanel switchesNumberRangePanel = new JPanel(new FlowLayout(1));
        switchesNumberRangePanel.add(this.getSwitchesNumberLabel());
        switchesNumberRangePanel.add(new JLabel("Between"));
        switchesNumberRangePanel.add(this.getMinSwitchesNumberTextField());
        switchesNumberRangePanel.add(new JLabel("and"));
        switchesNumberRangePanel.add(this.getMaxSwitchesNumberTextField());
        return switchesNumberRangePanel;
    }

    private JPanel serversNumberRangePanel() {
        this.setServersNumberLabel(new JLabel("<html><b>Servers number:</b></html>"));
        this.setMinServersNumberTextField(new JTextField(Integer.toString(1)));
        this.getMinServersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinServersNumberTextField().setHorizontalAlignment(0);
        this.setMaxServersNumberTextField(new JTextField(Integer.toString(5)));
        this.getMaxServersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxServersNumberTextField().setHorizontalAlignment(0);
        JPanel serversNumberRangePanel = new JPanel(new FlowLayout(1));
        serversNumberRangePanel.add(this.getServersNumberLabel());
        serversNumberRangePanel.add(new JLabel("Between"));
        serversNumberRangePanel.add(this.getMinServersNumberTextField());
        serversNumberRangePanel.add(new JLabel("and"));
        serversNumberRangePanel.add(this.getMaxServersNumberTextField());
        return serversNumberRangePanel;
    }

    private JPanel osPercentagesPanel() {
        this.setOSlabel(new JLabel("<html><b>Operating systems %:</b></html>"));
        this.setLinuxPercentageTextField(new JTextField(Integer.toString(100)));
        this.getLinuxPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getLinuxPercentageTextField().setHorizontalAlignment(0);
        this.setWindowsPercentageTextField(new JTextField(Integer.toString(0)));
        this.getWindowsPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getWindowsPercentageTextField().setHorizontalAlignment(0);
        this.setSolarisPercentageTextField(new JTextField(Integer.toString(0)));
        this.getSolarisPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getSolarisPercentageTextField().setHorizontalAlignment(0);
        this.getAndroidPercentageTextField(new JTextField(Integer.toString(0)));
        this.getAndroidPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getAndroidPercentageTextField().setHorizontalAlignment(0);
        JPanel osPercentagePanel = new JPanel(new FlowLayout(1));
        osPercentagePanel.add(this.getOSlabel());
        osPercentagePanel.add(new JLabel("Linux:"));
        osPercentagePanel.add(this.getLinuxPercentageTextField());
        osPercentagePanel.add(new JLabel("Windows:"));
        osPercentagePanel.add(this.getWindowsPercentageTextField());
        osPercentagePanel.add(new JLabel("Solaris:"));
        osPercentagePanel.add(this.getSolarisPercentageTextField());
        osPercentagePanel.add(new JLabel("Android:"));
        osPercentagePanel.add(this.getAndroidPercentageTextField());
        return osPercentagePanel;
    }

    private JPanel nodePanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN NODE</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel nodePanel = new JPanel();
        nodePanel.setLayout(new GridLayout(0, 1));
        nodePanel.setBorder(titledBorder);
        nodePanel.add(this.cpuPanel());
        nodePanel.add(this.ramPanel());
        nodePanel.add(this.storagePanel());
        return nodePanel;
    }

    private JPanel cpuPanel() {
        this.setCPUlabel(new JLabel("<html><b>CPU:</b></html>"));
        this.setMinCPUtextField(new JTextField(Integer.toString(1)));
        this.getMinCPUtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinCPUtextField().setHorizontalAlignment(0);
        this.setMaxCPUtextField(new JTextField(Integer.toString(20)));
        this.getMaxCPUtextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxCPUtextField().setHorizontalAlignment(0);
        JPanel cpuPanel = new JPanel(new FlowLayout(1));
        cpuPanel.add(this.getCPUlabel());
        cpuPanel.add(new JLabel("Between"));
        cpuPanel.add(this.getMinCPUtextField());
        cpuPanel.add(new JLabel("and"));
        cpuPanel.add(this.getMaxCPUtextField());
        return cpuPanel;
    }

    private JPanel ramPanel() {
        this.setRAMlabel(new JLabel("<html><b>RAM:</b></html>"));
        this.setMinRAMtextField(new JTextField(Integer.toString(1)));
        this.getMinRAMtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinRAMtextField().setHorizontalAlignment(0);
        this.setMaxRAMtextField(new JTextField(Integer.toString(20)));
        this.getMaxRAMtextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxRAMtextField().setHorizontalAlignment(0);
        JPanel ramPanel = new JPanel(new FlowLayout(1));
        ramPanel.add(this.getRAMlabel());
        ramPanel.add(new JLabel("Between"));
        ramPanel.add(this.getMinRAMtextField());
        ramPanel.add(new JLabel("and"));
        ramPanel.add(this.getMaxRAMtextField());
        return ramPanel;
    }

    private JPanel storagePanel() {
        this.setStorageLabel(new JLabel("<html><b>Storage:</b></html>"));
        this.setMinStorageTextField(new JTextField(Integer.toString(1)));
        this.getMinStorageTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinStorageTextField().setHorizontalAlignment(0);
        this.setMaxStorageTextField(new JTextField(Integer.toString(20)));
        this.getMaxStorageTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxStorageTextField().setHorizontalAlignment(0);
        JPanel storagePanel = new JPanel(new FlowLayout(1));
        storagePanel.add(this.getStorageLabel());
        storagePanel.add(new JLabel("Between"));
        storagePanel.add(this.getMinStorageTextField());
        storagePanel.add(new JLabel("and"));
        storagePanel.add(this.getMaxStorageTextField());
        return storagePanel;
    }

    private JPanel linkPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN LINK</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new GridLayout(0, 1));
        linkPanel.setBorder(titledBorder);
        linkPanel.add(this.bwPanel());
        return linkPanel;
    }

    private JPanel bwPanel() {
        this.setBWlabel(new JLabel("<html><b>Bandwidth:</b></html>"));
        this.setMinBWtextField(new JTextField(Integer.toString(1)));
        this.getMinBWtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWtextField().setHorizontalAlignment(0);
        this.setMaxBWtextField(new JTextField(Integer.toString(50)));
        this.getMaxBWtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWtextField().setHorizontalAlignment(0);
        JPanel bwPanel = new JPanel(new FlowLayout(1));
        bwPanel.add(this.getBWlabel());
        bwPanel.add(new JLabel("Between"));
        bwPanel.add(this.getMinBWtextField());
        bwPanel.add(new JLabel("and"));
        bwPanel.add(this.getMaxBWtextField());
        return bwPanel;
    }

    public void addListeners(DocumentListener documentListener, ActionListener actionListener) {
        this.getNetworksNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getWindowTimeUnitsNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getPoissonArrivesTextField().getDocument().addDocumentListener(documentListener);
        this.getExponentialLifetimeTextField().getDocument().addDocumentListener(documentListener);
        this.getMinRoutersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxRoutersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinSwitchesNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxSwitchesNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinServersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxServersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getLinuxPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getWindowsPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getSolarisPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getAndroidPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getMinCPUtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxCPUtextField().getDocument().addDocumentListener(documentListener);
        this.getMinRAMtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxRAMtextField().getDocument().addDocumentListener(documentListener);
        this.getMinStorageTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxStorageTextField().getDocument().addDocumentListener(documentListener);
        this.getMinBWtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxBWtextField().getDocument().addDocumentListener(documentListener);
    }

    public boolean check() {
        this.getInformationLabel().setText("Press \"Next\" to create random virtual networks");
        this.getInformationLabel().setForeground(Color.BLACK);
        if (!this.checkNetworksNumber()) {
            return false;
        }
        if (!this.checkWindowTimeUnitsNumber()) {
            return false;
        }
        if (!this.checkPoissonArrives()) {
            return false;
        }
        if (!this.checkExponentialLifetime()) {
            return false;
        }
        if (!this.checkRoutersNumber()) {
            return false;
        }
        if (!this.checkSwitchesNumber()) {
            return false;
        }
        if (!this.checkServersNumber()) {
            return false;
        }
        if (!this.checkOSpercentages()) {
            return false;
        }
        if (!this.checkCPU()) {
            return false;
        }
        if (!this.checkRAM()) {
            return false;
        }
        if (!this.checkStorage()) {
            return false;
        }
        return this.checkBW();
    }

    private boolean checkNetworksNumber() {
        int lowestNetworksNumber = 1;
        int highestNetworksNumber = 50;
        try {
            int networksNumber = Integer.parseInt(this.getNetworksNumberTextField().getText());
            if (lowestNetworksNumber > networksNumber || networksNumber > highestNetworksNumber) {
                throw new NumberFormatException();
            }
            this.getNetworksNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestNetworksNumber + " and " + highestNetworksNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getNetworksNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkWindowTimeUnitsNumber() {
        int lowestWindowTimeUnitsNumber = 1;
        int highestWindowTimeUnitsNumber = 50;
        try {
            int windowTimeUnitsNumber = Integer.parseInt(this.getWindowTimeUnitsNumberTextField().getText());
            if (lowestWindowTimeUnitsNumber > windowTimeUnitsNumber || windowTimeUnitsNumber > highestWindowTimeUnitsNumber) {
                throw new NumberFormatException();
            }
            this.getWindowTimeUnitsNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestWindowTimeUnitsNumber + " and " + highestWindowTimeUnitsNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getWindowTimeUnitsNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkPoissonArrives() {
        int lowestPoissonArrives = 1;
        int highestPoissonArrives = 50;
        try {
            double poissonArrives = Double.parseDouble(this.getPoissonArrivesTextField().getText());
            if (!((double)lowestPoissonArrives <= poissonArrives) || !(poissonArrives <= (double)highestPoissonArrives)) {
                throw new NumberFormatException();
            }
            this.getPoissonArrivesLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestPoissonArrives + " and " + highestPoissonArrives + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getPoissonArrivesLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkExponentialLifetime() {
        int lowestExponentialLifetime = 1;
        int highestExponentialLifetime = 50;
        try {
            double exponentialLifetime = Double.parseDouble(this.getExponentialLifetimeTextField().getText());
            if (!((double)lowestExponentialLifetime <= exponentialLifetime) || !(exponentialLifetime <= (double)highestExponentialLifetime)) {
                throw new NumberFormatException();
            }
            this.getExponentialLifetimeLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestExponentialLifetime + " and " + highestExponentialLifetime + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getExponentialLifetimeLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkRoutersNumber() {
        int lowestMinRoutersNumber = 1;
        int highestMaxRoutersNumber = 50;
        try {
            int minRoutersNumber = Integer.parseInt(this.getMinRoutersNumberTextField().getText());
            int maxRoutersNumber = Integer.parseInt(this.getMaxRoutersNumberTextField().getText());
            if (lowestMinRoutersNumber > minRoutersNumber || minRoutersNumber > maxRoutersNumber || maxRoutersNumber > highestMaxRoutersNumber) {
                throw new NumberFormatException();
            }
            this.getRoutersNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinRoutersNumber + " and maximum value " + highestMaxRoutersNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getRoutersNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkSwitchesNumber() {
        int lowestMinSwitchesNumber = 1;
        int highestMaxSwitchesNumber = 50;
        try {
            int minSwitchesNumber = Integer.parseInt(this.getMinSwitchesNumberTextField().getText());
            int maxSwitchesNumber = Integer.parseInt(this.getMaxSwitchesNumberTextField().getText());
            if (lowestMinSwitchesNumber > minSwitchesNumber || minSwitchesNumber > maxSwitchesNumber || maxSwitchesNumber > highestMaxSwitchesNumber) {
                throw new NumberFormatException();
            }
            this.getSwitchesNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinSwitchesNumber + " and maximum value " + highestMaxSwitchesNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getSwitchesNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkServersNumber() {
        int lowestMinServersNumber = 1;
        int highestMaxServersNumber = 50;
        try {
            int minServersNumber = Integer.parseInt(this.getMinServersNumberTextField().getText());
            int maxServersNumber = Integer.parseInt(this.getMaxServersNumberTextField().getText());
            if (lowestMinServersNumber > minServersNumber || minServersNumber > maxServersNumber || maxServersNumber > highestMaxServersNumber) {
                throw new NumberFormatException();
            }
            this.getServersNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinServersNumber + " and maximum value " + highestMaxServersNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getServersNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkOSpercentages() {
        try {
            int linuxPercentage = Integer.parseInt(this.getLinuxPercentageTextField().getText());
            int windowsPercentage = Integer.parseInt(this.getWindowsPercentageTextField().getText());
            int solarisPercentage = Integer.parseInt(this.getSolarisPercentageTextField().getText());
            int androidPercentage = Integer.parseInt(this.getAndroidPercentageTextField().getText());
            if (linuxPercentage < 0 || linuxPercentage > 100 || windowsPercentage < 0 || windowsPercentage > 100 || solarisPercentage < 0 || solarisPercentage > 100 || androidPercentage < 0 || androidPercentage > 100 || linuxPercentage + windowsPercentage + solarisPercentage + androidPercentage != 100) {
                throw new NumberFormatException();
            }
            this.getOSlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Operating systems of nodes must sum to 100</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getOSlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkCPU() {
        int lowestMinCPU = 0;
        int highestMaxCPU = 100;
        try {
            int minCPU = Integer.parseInt(this.getMinCPUtextField().getText());
            int maxCPU = Integer.parseInt(this.getMaxCPUtextField().getText());
            if (lowestMinCPU > minCPU || minCPU > maxCPU || maxCPU > highestMaxCPU) {
                throw new NumberFormatException();
            }
            this.getCPUlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinCPU + " and maximum value " + highestMaxCPU + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getCPUlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkRAM() {
        int lowestMinRAM = 0;
        int highestMaxRAM = 100;
        try {
            int minRAM = Integer.parseInt(this.getMinRAMtextField().getText());
            int maxRAM = Integer.parseInt(this.getMaxRAMtextField().getText());
            if (lowestMinRAM > minRAM || minRAM > maxRAM || maxRAM > 100) {
                throw new NumberFormatException();
            }
            this.getRAMlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinRAM + " and maximum value " + highestMaxRAM + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getRAMlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkStorage() {
        int lowestMinStorage = 0;
        int highestMaxStorage = 100;
        try {
            int minStorage = Integer.parseInt(this.getMinStorageTextField().getText());
            int maxStorage = Integer.parseInt(this.getMaxStorageTextField().getText());
            if (lowestMinStorage > minStorage || minStorage > maxStorage || maxStorage > highestMaxStorage) {
                throw new NumberFormatException();
            }
            this.getStorageLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinStorage + " and maximum value " + highestMaxStorage + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getStorageLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkBW() {
        int lowestMinBW = 0;
        int highestMaxBW = 100;
        try {
            int minBW = Integer.parseInt(this.getMinBWtextField().getText());
            int maxBW = Integer.parseInt(this.getMaxBWtextField().getText());
            if (lowestMinBW > minBW || minBW > maxBW || maxBW > highestMaxBW) {
                throw new NumberFormatException();
            }
            this.getBWlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinBW + " and maximum value " + highestMaxBW + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getBWlabel().setForeground(Color.RED);
            return false;
        }
    }
}

