/*
 * Decompiled with CFR 0.152.
 */
package frame.options.virtual;

import frame.SimulatorFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import model.components.links.link.VirtualLink;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.virtual.VirtualNode;

public class SaveVirtualMenuItem
extends JMenuItem
implements ActionListener {
    private SimulatorFrame simulatorFrame;
    private JFileChooser fileChooser;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public SaveVirtualMenuItem(SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setText("Save");
        this.setMnemonic(83);
        this.setIcon(new ImageIcon(this.getClass().getResource("/icons/save.png")));
        this.setFileChooser(new JFileChooser());
        this.addActionListener(this);
        if (this.getFrame().getSimulator().getVirtualNetworks().size() == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().setSelectedIndex(1);
        this.getFileChooser().setSelectedFile(new File(String.valueOf(this.getFrame().getSimulator().getVirtualNetworks().get(0).getNamePrefix()) + "s"));
        if (this.getFileChooser().showSaveDialog(this) == 0) {
            try {
                if (this.existFile(new File(String.valueOf(this.getFileChooser().getSelectedFile().toString()) + ".xls"))) {
                    throw new Exception();
                }
                this.saveVirtualNetworks(this.getFrame().getSimulator().getVirtualNetworks(), this.getFileChooser().getSelectedFile().toString());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getFrame().getNetworksPanel(), "Already exists file", "File name error", 1);
            }
        }
    }

    private boolean existFile(File file) {
        try {
            Workbook workbook = Workbook.getWorkbook(file);
            workbook.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void saveVirtualNetworks(List<VirtualNetwork> virtualNetworks, String file) throws Exception {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setLocale(new Locale("en", "EN"));
        WritableWorkbook writableWorkbook = Workbook.createWorkbook(new File(String.valueOf(file) + ".xls"), workbookSettings);
        WritableFont writableFontBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormatBold = new WritableCellFormat(writableFontBold);
        writableCellFormatBold.setWrap(true);
        WritableFont writableFontNoBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat writableCellFormatNoBold = new WritableCellFormat(writableFontNoBold);
        writableCellFormatNoBold.setWrap(true);
        int sheetIndex = 0;
        for (VirtualNetwork virtualNetwork : virtualNetworks) {
            WritableSheet writableSheet = writableWorkbook.createSheet(virtualNetwork.getName(), sheetIndex++);
            int rowCount = 0;
            int columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "NETWORK", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Name prefix", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Starting date", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Ending date", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, virtualNetwork.getNamePrefix(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNetwork.getNumber(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNetwork.getStartingDate(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNetwork.getEndingDate(), (CellFormat)writableCellFormatNoBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "NODES", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Network name", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Type", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "OS", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "CPU", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "RAM", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Storage", (CellFormat)writableCellFormatBold));
            ++rowCount;
            for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
                columnCount = 0;
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualNode.getNetworkName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNode.getNumber(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualNode.getType(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualNode.getOS(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNode.getCPU(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNode.getRAM(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualNode.getStorage(), (CellFormat)writableCellFormatNoBold));
                ++rowCount;
            }
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "LINKS", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Network name", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "First node", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Second node", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "BW", (CellFormat)writableCellFormatBold));
            ++rowCount;
            for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                columnCount = 0;
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualLink.getNetworkName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualLink.getNumber(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualLink.getFirstNode().getName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, virtualLink.getSecondNode().getName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)virtualLink.getBW(), (CellFormat)writableCellFormatNoBold));
                ++rowCount;
            }
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "END", (CellFormat)writableCellFormatBold));
            ++rowCount;
        }
        writableWorkbook.write();
        writableWorkbook.close();
    }
}

