/*
 * Decompiled with CFR 0.152.
 */
package frame.options.virtual;

import frame.SimulatorFrame;
import frame.networks.tables.virtual.VirtualTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import model.components.links.link.VirtualLink;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.Node;
import model.components.nodes.node.virtual.VirtualMachine;
import model.components.nodes.node.virtual.VirtualNode;
import model.components.nodes.node.virtual.VirtualRouter;
import model.components.nodes.node.virtual.VirtualSwitch;

public class OpenVirtualMenuItem
extends JMenuItem
implements ActionListener {
    private SimulatorFrame simulatorFrame;
    private JFileChooser fileChooser;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public OpenVirtualMenuItem(SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setText("Open");
        this.setMnemonic(79);
        this.setIcon(new ImageIcon(this.getClass().getResource("/icons/open.png")));
        this.setFileChooser(new JFileChooser());
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().setSelectedIndex(1);
        if (this.getFileChooser().showOpenDialog(this) == 0) {
            try {
                List<VirtualNetwork> virtualNetworks = this.openVirtualNetworks(this.getFileChooser().getSelectedFile());
                this.getFrame().getNetworksPanel().getVirtualNetworksVisualizationViewersTabbedPane().removeAll();
                this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getVirtualNetworksTable().removeAll();
                this.getFrame().getSimulator().setInitVirtualNetworks(virtualNetworks);
                this.getFrame().getSimulator().reset();
                for (VirtualNetwork virtualNetwork : virtualNetworks) {
                    this.getFrame().getNetworksPanel().getVirtualNetworksVisualizationViewersTabbedPane().addVirtualNetworkTab(virtualNetwork);
                    ((VirtualTableModel)this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getVirtualNetworksTable().getModel()).addRow(new Object[]{virtualNetwork.getName(), virtualNetwork.getStartingDate(), virtualNetwork.getEndingDate(), virtualNetwork.getState()});
                }
                ((VirtualTableModel)this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getVirtualNetworksTable().getModel()).refresh();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getFrame().getNetworksPanel(), "Incorrect file", "Filer error", 1);
            }
        }
    }

    public List<VirtualNetwork> openVirtualNetworks(File file) throws Exception {
        ArrayList<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
        Workbook workbook = Workbook.getWorkbook(file);
        WritableFont writableFontBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormatBold = new WritableCellFormat(writableFontBold);
        writableCellFormatBold.setWrap(true);
        WritableFont writableFontNoBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat writableCellFormatNoBold = new WritableCellFormat(writableFontNoBold);
        writableCellFormatNoBold.setWrap(true);
        String[] sheetNames = workbook.getSheetNames();
        int sheetCount = 0;
        while (sheetCount < sheetNames.length) {
            int number;
            String networkName;
            Sheet sheet = workbook.getSheet(sheetNames[sheetCount++]);
            int columnCount = 0;
            int rowCount = 2;
            String namePrefix = sheet.getCell(columnCount++, rowCount).getContents();
            int networkNumber = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int startingDate = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int endingDate = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            VirtualNetwork virtualNetwork = new VirtualNetwork(namePrefix, networkNumber, startingDate, endingDate);
            ArrayList<Node> nodes = new ArrayList<Node>();
            columnCount = 0;
            rowCount = 5;
            while (!sheet.getCell(columnCount, rowCount).getContents().equals("LINKS")) {
                networkName = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                number = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                String type = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                String os = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                int cpu = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                int ram = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                int storage = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                columnCount = 0;
                ++rowCount;
                VirtualNode virtualNode = null;
                if (type.equals("Router")) {
                    virtualNode = new VirtualRouter(networkName, startingDate, endingDate, number, os, cpu, ram);
                } else if (type.equals("Switch")) {
                    virtualNode = new VirtualSwitch(networkName, startingDate, endingDate, number, os, cpu, ram);
                } else if (type.equals("Server")) {
                    virtualNode = new VirtualMachine(networkName, startingDate, endingDate, number, os, cpu, ram, storage);
                }
                virtualNode.setInitialNumber(number);
                nodes.add(virtualNode);
            }
            columnCount = 0;
            rowCount += 2;
            while (!sheet.getCell(columnCount, rowCount).getContents().equals("END")) {
                networkName = sheet.getCell(columnCount++, rowCount).getContents();
                number = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
                String firstNodeName = sheet.getCell(columnCount++, rowCount).getContents();
                String secondNodeName = sheet.getCell(columnCount++, rowCount).getContents();
                int bw = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
                columnCount = 0;
                ++rowCount;
                VirtualLink virtualLink = new VirtualLink(networkName, startingDate, endingDate, number, bw);
                Node firstNode = this.getNodeByName(firstNodeName, nodes);
                Node secondNode = this.getNodeByName(secondNodeName, nodes);
                virtualLink.setInitialNumber(number);
                virtualNetwork.addLinkAndNodes(virtualLink, firstNode, secondNode);
            }
            virtualNetworks.add(virtualNetwork);
        }
        workbook.close();
        return virtualNetworks;
    }

    private Node getNodeByName(String nodeName, List<Node> nodes) {
        for (Node node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }
}

