/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulator;

import frame.options.simulation.Simulation;
import java.util.ArrayList;
import java.util.List;
import model.algorithms.embedding.EmbeddingAlgorithm;
import model.algorithms.embedding.NCM;
import model.algorithms.embedding.ViNE;
import model.algorithms.linksMapping.LinksMappingAlgorithm;
import model.algorithms.linksMapping.MultiCommodityFlow;
import model.algorithms.linksMapping.ShortPath;
import model.algorithms.nodesMapping.Greedy;
import model.algorithms.nodesMapping.NodesMappingAlgorithm;
import model.algorithms.rounding.Deterministic;
import model.algorithms.rounding.Randomized;
import model.algorithms.rounding.RoundingAlgorithm;
import model.algorithms.splitting.Exact;
import model.algorithms.splitting.IteratedLocalSearch;
import model.algorithms.splitting.RecursiveRandomPermutations;
import model.algorithms.splitting.SplittingAlgorithm;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.sdn.SdnNetworks;
import model.components.networks.virtual.VirtualNetwork;
import model.components.networks.virtual.VirtualNetworks;

public class Simulator {
    private List<SdnNetwork> initSdnNetworks;
    private List<SdnNetwork> sdnNetworks;
    private List<VirtualNetwork> initVirtualNetworks;
    private List<VirtualNetwork> virtualNetworks;
    private List<SplittingAlgorithm> splittingAlgorithms;
    private List<NodesMappingAlgorithm> nodesMappingAlgorithms;
    private List<EmbeddingAlgorithm> embeddingAlgorithms;
    private List<RoundingAlgorithm> roundingAlgorithms;
    private List<LinksMappingAlgorithm> linksMappingAlgorithms;
    private Simulation simulation;

    public List<SdnNetwork> getInitSdnNetworks() {
        return this.initSdnNetworks;
    }

    public void setInitSdnNetworks(List<SdnNetwork> initSdnNetworks) {
        this.initSdnNetworks = initSdnNetworks;
    }

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public List<VirtualNetwork> getInitVirtualNetworks() {
        return this.initVirtualNetworks;
    }

    public void setInitVirtualNetworks(List<VirtualNetwork> initVirtualNetworks) {
        this.initVirtualNetworks = initVirtualNetworks;
    }

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.virtualNetworks;
    }

    public void setVirtualNetworks(List<VirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
    }

    public List<SplittingAlgorithm> getSplittingAlgorithms() {
        return this.splittingAlgorithms;
    }

    public void setSplittingAlgorithms(List<SplittingAlgorithm> splittingAlgorithms) {
        this.splittingAlgorithms = splittingAlgorithms;
    }

    public List<NodesMappingAlgorithm> getNodesMappingAlgorithms() {
        return this.nodesMappingAlgorithms;
    }

    public void setNodesMappingAlgorithms(List<NodesMappingAlgorithm> nodesMappingAlgorithms) {
        this.nodesMappingAlgorithms = nodesMappingAlgorithms;
    }

    public List<EmbeddingAlgorithm> getEmbeddingAlgorithms() {
        return this.embeddingAlgorithms;
    }

    public void setEmbeddingAlgorithms(List<EmbeddingAlgorithm> embeddingAlgorithms) {
        this.embeddingAlgorithms = embeddingAlgorithms;
    }

    public List<RoundingAlgorithm> getRoundingAlgorithms() {
        return this.roundingAlgorithms;
    }

    public void setRoundingAlgorithms(List<RoundingAlgorithm> roundingAlgorithms) {
        this.roundingAlgorithms = roundingAlgorithms;
    }

    public List<LinksMappingAlgorithm> getLinksMappingAlgorithms() {
        return this.linksMappingAlgorithms;
    }

    public void setLinksMappingAlgorithms(List<LinksMappingAlgorithm> linksMappingAlgorithms) {
        this.linksMappingAlgorithms = linksMappingAlgorithms;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public Simulator() {
        this.setInitSdnNetworks(new SdnNetworks().getSdnNetworks());
        this.setInitVirtualNetworks(new VirtualNetworks().getVirtualNetworks());
        this.reset();
    }

    public void reset() {
        ArrayList<SdnNetwork> copySdnNetworks = new ArrayList<SdnNetwork>();
        for (SdnNetwork sdnNetwork : this.getInitSdnNetworks()) {
            copySdnNetworks.add(sdnNetwork.getCopy());
        }
        ArrayList<VirtualNetwork> copyVirtualNetworks = new ArrayList<VirtualNetwork>();
        for (VirtualNetwork virtualNetwork : this.getInitVirtualNetworks()) {
            copyVirtualNetworks.add(virtualNetwork.getCopy());
        }
        this.setSdnNetworks(copySdnNetworks);
        this.setVirtualNetworks(copyVirtualNetworks);
        this.setSplittingAlgorithms(this.splittingAlgorithms());
        this.setNodesMappingAlgorithms(this.nodesMappingAlgorithms());
        this.setEmbeddingAlgorithms(this.embeddingAlgorithms());
        this.setRoundingAlgorithms(this.roundingAlgorithms());
        this.setLinksMappingAlgorithms(this.linksMappingAlgorithms());
    }

    private List<SplittingAlgorithm> splittingAlgorithms() {
        ArrayList<SplittingAlgorithm> splittingAlgorithms = new ArrayList<SplittingAlgorithm>();
        splittingAlgorithms.add(new Exact("Exact"));
        splittingAlgorithms.add(new IteratedLocalSearch("Iterated Local Search"));
        splittingAlgorithms.add(new RecursiveRandomPermutations("Recursive Random Permutations"));
        return splittingAlgorithms;
    }

    private List<NodesMappingAlgorithm> nodesMappingAlgorithms() {
        ArrayList<NodesMappingAlgorithm> nodesMappingAlgorithms = new ArrayList<NodesMappingAlgorithm>();
        nodesMappingAlgorithms.add(new Greedy("Greedy"));
        return nodesMappingAlgorithms;
    }

    private List<EmbeddingAlgorithm> embeddingAlgorithms() {
        ArrayList<EmbeddingAlgorithm> embeddingAlgorithms = new ArrayList<EmbeddingAlgorithm>();
        embeddingAlgorithms.add(new NCM("Networked Cloud Mapping"));
        embeddingAlgorithms.add(new ViNE("Virtual Network Embedding"));
        return embeddingAlgorithms;
    }

    private List<RoundingAlgorithm> roundingAlgorithms() {
        ArrayList<RoundingAlgorithm> roundingAlgorithms = new ArrayList<RoundingAlgorithm>();
        roundingAlgorithms.add(new Deterministic("Deterministic"));
        roundingAlgorithms.add(new Randomized("Randomized"));
        return roundingAlgorithms;
    }

    private List<LinksMappingAlgorithm> linksMappingAlgorithms() {
        ArrayList<LinksMappingAlgorithm> linksMappingAlgorithms = new ArrayList<LinksMappingAlgorithm>();
        linksMappingAlgorithms.add(new MultiCommodityFlow("Multi Commodity Flow"));
        linksMappingAlgorithms.add(new ShortPath("Short Path"));
        return linksMappingAlgorithms;
    }
}

