/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.running;

import frame.SimulatorFrame;
import frame.networks.tables.sdn.SdnTableModel;
import frame.networks.tables.virtual.VirtualTableModel;
import frame.options.simulation.Simulation;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.running.RunningFrame;
import java.awt.Color;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class RunningSwingWorker
extends SwingWorker<Object, Object> {
    private Simulation simulation;
    private SimulatorFrame simulatorFrame;
    private RunningFrame runningFrame;
    private List<VirtualNetwork> resultVirtualNetworks;

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public RunningFrame getRunningFrame() {
        return this.runningFrame;
    }

    public void setRunningFrame(RunningFrame runningFrame) {
        this.runningFrame = runningFrame;
    }

    public List<VirtualNetwork> getResultVirtualNetworks() {
        return this.resultVirtualNetworks;
    }

    public void setResultVirtualNetworks(List<VirtualNetwork> resultVirtualNetworks) {
        this.resultVirtualNetworks = resultVirtualNetworks;
    }

    public RunningSwingWorker(Simulation simulation, SimulatorFrame simulatorFrame, RunningFrame runningFrame) {
        this.setSimulation(simulation);
        this.setFrame(simulatorFrame);
        this.setRunningFrame(runningFrame);
    }

    @Override
    protected List<SdnNetwork> doInBackground() throws Exception {
        ArrayList<SdnNetwork> resultSdnNetworks = new ArrayList<SdnNetwork>();
        for (SdnNetwork sdnNetwork : this.getFrame().getSimulator().getSdnNetworks()) {
            SdnNetwork copySdnNetwork = sdnNetwork.getCopy();
            copySdnNetwork.setName(sdnNetwork.getName());
            resultSdnNetworks.add(copySdnNetwork);
        }
        this.setResultVirtualNetworks(new ArrayList<VirtualNetwork>());
        for (VirtualNetwork virtualNetwork : this.getFrame().getSimulator().getVirtualNetworks()) {
            VirtualNetwork copyVirtualNetwork = virtualNetwork.getCopy();
            copyVirtualNetwork.setName(virtualNetwork.getName());
            this.getResultVirtualNetworks().add(copyVirtualNetwork);
        }
        int rejectedVirtualNetworksNumber = 0;
        this.setProgress(0);
        this.getRunningFrame().getProgressBar().setMinimum(0);
        this.getRunningFrame().getProgressBar().setValue(0);
        this.getRunningFrame().getProgressBar().setMaximum(this.getSimulation().getSimulationEndingDate() + 1);
        int i = 0;
        while (i < this.getSimulation().getSimulationEndingDate() + 1 && !this.isCancelled()) {
            this.setProgress(100 * i / (this.getSimulation().getSimulationEndingDate() + 1));
            this.getRunningFrame().getProgressBar().setValue(i + 1);
            List<VirtualNetwork> completedVirtualNetworks = this.getSimulation().completedVirtualNetworks(i);
            for (VirtualNetwork completedVirtualNetwork : completedVirtualNetworks) {
                if (!completedVirtualNetwork.getState().equals("Accepted")) continue;
                this.getRunningFrame().addTextColor("Time " + i + ": OUT " + completedVirtualNetwork.getName() + "\n", Color.BLUE);
            }
            List<VirtualNetwork> startingVirtualNetworks = this.getSimulation().startingVirtualNetworks(i);
            for (VirtualNetwork startingVirtualNetwork : startingVirtualNetworks) {
                this.getRunningFrame().addTextColor("Time " + i + ": IN " + startingVirtualNetwork.getName() + "...\n", Color.BLACK);
            }
            if (!this.isCancelled()) {
                rejectedVirtualNetworksNumber = this.getSimulation().run(i);
            }
            for (VirtualNetwork startingVirtualNetwork : startingVirtualNetworks) {
                if (startingVirtualNetwork.getState().equals("Rejected")) {
                    this.getRunningFrame().addTextColor("REJECTED\n", Color.RED);
                    continue;
                }
                this.getRunningFrame().addTextColor("ACCEPTED\n", Color.GREEN);
            }
            for (VirtualNetwork virtualNetwork : this.getSimulation().getVirtualNetworks()) {
                if (!virtualNetwork.isChange()) continue;
                virtualNetwork.setTimeStamp(i);
            }
            for (SdnNetwork sdnNetwork : this.getSimulation().getSdnNetworks()) {
                if (!sdnNetwork.isChange()) continue;
                SdnNetwork copySdnNetwork = sdnNetwork.getCopy();
                copySdnNetwork.setName(String.valueOf(sdnNetwork.getName()) + "(" + i + ")");
                copySdnNetwork.setTimeStamp(i);
                resultSdnNetworks.add(copySdnNetwork);
                sdnNetwork.setChange(false);
            }
            for (VirtualNetwork virtualNetwork : this.getSimulation().getVirtualNetworks()) {
                if (!virtualNetwork.isChange()) continue;
                VirtualNetwork copyVirtualNetwork = virtualNetwork.getCopy();
                copyVirtualNetwork.setName(String.valueOf(virtualNetwork.getName()) + "(" + i + ")");
                copyVirtualNetwork.setTimeStamp(i);
                this.getResultVirtualNetworks().add(copyVirtualNetwork);
                virtualNetwork.setChange(false);
            }
            ++i;
        }
        for (SdnNetwork sdnNetwork : this.getSimulation().getSdnNetworks()) {
            for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
                sdnNode.setNumber(sdnNode.getInitialNumber());
            }
            for (SdnLink sdnLink : sdnNetwork.getSdnLinks()) {
                sdnLink.setNumber(sdnLink.getInitialNumber());
            }
        }
        for (VirtualNetwork virtualNetwork : this.getSimulation().getVirtualNetworks()) {
            for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
                virtualNode.setNumber(virtualNode.getInitialNumber());
            }
            for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                virtualLink.setNumber(virtualLink.getInitialNumber());
            }
        }
        this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().setSelectedIndex(1);
        if (this.isCancelled()) {
            this.getRunningFrame().addTextColor("Cancelling simulation...\n", Color.RED);
        }
        System.out.println("Simulation time: " + this.getSimulation().getSimulationEndingDate());
        System.out.println("Number of requests: " + this.getSimulation().getVirtualNetworks().size());
        System.out.println("Number of requests rejected: " + rejectedVirtualNetworksNumber);
        return resultSdnNetworks;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void done() {
        Toolkit.getDefaultToolkit().beep();
        runningFrame = this.getRunningFrame();
        simulation = this.getSimulation();
        virtualTable = this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getVirtualNetworksTable();
        virtualTableModel = (VirtualTableModel)virtualTable.getModel();
        sdnTable = this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getSdnNetworksTable();
        sdnTableModel = (SdnTableModel)sdnTable.getModel();
        if (!this.isCancelled()) {
            block10: {
                runningFrame.addTextColor("Simulation finished\n", Color.BLACK);
                runningFrame.getCancelButton().setEnabled(false);
                simulation.setState("Done");
                if (virtualTable != null) {
                    virtualTableModel.refresh();
                }
                resultSdnNetworks = null;
                try {
                    resultSdnNetworks = (List)this.get();
                    break block10;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    break block10;
                }
                catch (ExecutionException executionException) {
                    runningFrame.addTextColor("Simulation has finished with errors\n", Color.RED);
                    runningFrame.getTextPane().setEditable(false);
                    simulation.setState("Canceled");
                    ** for (virtualNetwork : simulation.getVirtualNetworks())
                }
lbl-1000:
                // 1 sources

                {
                    virtualNetwork.setState("Ready");
                    continue;
                }
lbl28:
                // 1 sources

                virtualTableModel.refresh();
                executionException.printStackTrace();
            }
            if (resultSdnNetworks.size() == 0) {
                return;
            }
            simulatorSdnNetworksNumber = this.getFrame().getSimulator().getSdnNetworks().size();
            resultVirtualNetworks = this.getResultVirtualNetworks();
            simulatorVirtualNetworksNumber = this.getFrame().getSimulator().getVirtualNetworks().size();
            runningFrame.setVisible(false);
            this.getFrame().getSimulator().reset();
            runningFrame.setResultsFrame(new ResultsFrame(resultSdnNetworks, simulatorSdnNetworksNumber, resultVirtualNetworks, simulatorVirtualNetworksNumber, simulation));
            runningFrame.getResultsFrame().pack();
            runningFrame.getResultsFrame().setVisible(true);
        } else {
            runningFrame.addTextColor("Simulation canceled\n", Color.RED);
            simulation.setState("Canceled");
            simulationVirtualNetworks = simulation.getVirtualNetworks();
            for (VirtualNetwork virtualNetwork : simulationVirtualNetworks) {
                virtualNetwork.setState("Available");
            }
            virtualTableModel.refresh();
            simulationSdnNetworks = simulation.getSdnNetworks();
            for (SdnNetwork sdnNetwork : simulationSdnNetworks) {
                sdnNetwork.setState("Available");
            }
            sdnTableModel.refresh();
            runningFrame.setVisible(false);
        }
        runningFrame.getTextPane().setEditable(false);
    }
}

