/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.running;

import frame.SimulatorFrame;
import frame.options.simulation.Simulation;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.running.RunningSwingWorker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class RunningFrame
extends JFrame
implements ActionListener,
WindowListener {
    private RunningSwingWorker runningSwingWorker;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private ResultsFrame resultsFrame;
    private JTextPane textPane;

    public RunningSwingWorker getRunningSwingWorker() {
        return this.runningSwingWorker;
    }

    public void setRunningSwingWorker(RunningSwingWorker runningSwingWorker) {
        this.runningSwingWorker = runningSwingWorker;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public ResultsFrame getResultsFrame() {
        return this.resultsFrame;
    }

    public void setResultsFrame(ResultsFrame resultsFrame) {
        this.resultsFrame = resultsFrame;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void setTextPane(JTextPane textPane) {
        this.textPane = textPane;
    }

    public RunningFrame(Simulation simulation, SimulatorFrame simulatorFrame) {
        this.addWindowListener(this);
        this.setRunningSwingWorker(new RunningSwingWorker(simulation, simulatorFrame, this));
        this.setTitle("Running simulation...");
        this.setLocationRelativeTo(simulatorFrame.getNetworksPanel());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/upcSmall.png")).getImage());
        this.setAlwaysOnTop(false);
        this.setProgressBar(new JProgressBar());
        this.getProgressBar().setPreferredSize(new Dimension(350, 15));
        this.setTextPane(new JTextPane());
        this.getTextPane().setFont(new Font("MS Sans Serif", 1, 11));
        this.addTextColor("Simulation started...\n", Color.BLACK);
        JScrollPane scrollPane = new JScrollPane(this.getTextPane());
        scrollPane.setPreferredSize(new Dimension(350, 100));
        scrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2));
        this.setCancelButton(new JButton("Cancel simulation"));
        this.getCancelButton().setIcon(new ImageIcon(this.getClass().getResource("/icons/cancel.png")));
        this.getCancelButton().addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scrollPane).addComponent(this.getProgressBar()).addComponent(this.getCancelButton(), GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup())));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(scrollPane).addComponent(this.getProgressBar()).addComponent(this.getCancelButton()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)));
        this.getContentPane().setLayout(groupLayout);
    }

    public void addTextColor(String text, Color color) {
        this.getTextPane().setCharacterAttributes(StyleContext.getDefaultStyleContext().addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color), false);
        this.getTextPane().setCaretPosition(this.getTextPane().getDocument().getLength());
        this.getTextPane().replaceSelection(text);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.getCancelButton()) && this.getRunningSwingWorker().cancel(true)) {
            this.getCancelButton().setEnabled(false);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.getRunningSwingWorker().cancel(true)) {
            this.getCancelButton().setEnabled(false);
            JOptionPane.showMessageDialog(this, "Simulation has been interrupted", "Simulation", 2);
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

