/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.virtual.numerical;

import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.virtual.numerical.VirtualNetworkTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.components.networks.virtual.VirtualNetwork;

public class VirtualNetworkTablesPanel
extends JPanel
implements ChangeListener {
    private List<VirtualNetwork> virtualNetworks;
    private ResultsFrame frameResults;
    private List<JScrollPane> scrollPanesTablesNumbersNetworkRequest;
    private JLabel label;
    private JSlider slider;
    private int positionPrevious;

    public List<VirtualNetwork> getNetworksRequest() {
        return this.virtualNetworks;
    }

    public void setNetworksRequest(List<VirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
    }

    public ResultsFrame getFrameResults() {
        return this.frameResults;
    }

    public void setFrameResults(ResultsFrame frameResults) {
        this.frameResults = frameResults;
    }

    public List<JScrollPane> getScrollPanesTablesNumbersNetworkRequest() {
        return this.scrollPanesTablesNumbersNetworkRequest;
    }

    public void setScrollPanesTablesNumbersNetworkRequest(List<JScrollPane> scrollPanesTablesNumbersNetworkRequest) {
        this.scrollPanesTablesNumbersNetworkRequest = scrollPanesTablesNumbersNetworkRequest;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public int getPositionPrevious() {
        return this.positionPrevious;
    }

    public void setPositionPrevious(int positionPrevious) {
        this.positionPrevious = positionPrevious;
    }

    public VirtualNetworkTablesPanel(List<VirtualNetwork> networksRequest, ResultsFrame frameResults) {
        this.setNetworksRequest(networksRequest);
        this.setFrameResults(frameResults);
        this.setScrollPanesTablesNumbersNetworkRequest(this.scrollPanesTablesNumbersNetworkRequest(networksRequest));
        this.setLabel(new JLabel(networksRequest.get(0).getName(), null, 0));
        this.setSlider(this.createSlider(networksRequest.size()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLabel(), "North");
        this.add((Component)this.getScrollPanesTablesNumbersNetworkRequest().get(0), "Center");
        this.add((Component)this.getSlider(), "South");
    }

    private List<JScrollPane> scrollPanesTablesNumbersNetworkRequest(List<VirtualNetwork> networksRequest) {
        ArrayList<JScrollPane> scrollPanesTableNumbersNetworkRequest = new ArrayList<JScrollPane>();
        for (VirtualNetwork virtualNetwork : networksRequest) {
            scrollPanesTableNumbersNetworkRequest.add(new JScrollPane(new VirtualNetworkTable(virtualNetwork)));
        }
        return scrollPanesTableNumbersNetworkRequest;
    }

    private JSlider createSlider(int numberNetworksRequest) {
        JSlider slider = new JSlider();
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.setPaintTrack(true);
        slider.setPaintLabels(true);
        slider.setMinimum(0);
        slider.setMaximum(numberNetworksRequest - 1);
        slider.setMinorTickSpacing(1);
        slider.setMajorTickSpacing(1);
        slider.setValue(0);
        slider.addChangeListener(this);
        return slider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.putValueSliders(this.getSlider().getValue());
    }

    public void putValueSliders(int valueSlider) {
        this.putValueSlider(valueSlider);
        int selectedIndex = this.getFrameResults().getVirtualNetworksTablesPanelsTabbedPane().getSelectedIndex();
        this.getFrameResults().getVirtualNetworksViewersPanelsTabbedPane().setSelectedIndex(selectedIndex);
        this.getFrameResults().getVirtualNetworksViewersPanels().get(selectedIndex).putValueSlider(valueSlider);
    }

    public void putValueSlider(int valueSlider) {
        VirtualNetwork virtualNetwork = this.getNetworksRequest().get(valueSlider);
        if (virtualNetwork.getTimeStamp() == -1) {
            this.getLabel().setText(virtualNetwork.getName());
        } else {
            this.getLabel().setText("Time: " + virtualNetwork.getTimeStamp());
        }
        this.remove(this.getScrollPanesTablesNumbersNetworkRequest().get(this.getPositionPrevious()));
        this.setPositionPrevious(valueSlider);
        this.add((Component)this.getScrollPanesTablesNumbersNetworkRequest().get(valueSlider), "Center");
        this.getSlider().setValue(valueSlider);
        this.repaint();
    }
}

