/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.virtual.numerical;

import java.util.Iterator;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import model.components.links.link.BWbackupFlag;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.virtual.VirtualMachine;
import model.components.nodes.node.virtual.VirtualNode;

public class VirtualNetworkTable
extends JTable {
    private VirtualNetwork virtualNetwork;

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public void setVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
    }

    public VirtualNetworkTable(VirtualNetwork virtualNetwork) {
        this.setVirtualNetwork(virtualNetwork);
        this.setModel(this.defaultTableModel());
        this.setEnabled(false);
    }

    private DefaultTableModel defaultTableModel() {
        int leasedCPU = 0;
        int leasedMemory = 0;
        int leasedDiskSpace = 0;
        int cpuCost = 0;
        int memoryCost = 0;
        int diskSpaceCost = 0;
        for (VirtualNode virtualNode : this.getVirtualNetwork().getVirtualNodes()) {
            int virtualNodeCpu = 0;
            int virtualNodeMemory = 0;
            int virtualNodeDiskSpace = 0;
            if (virtualNode.getSdnNode() != null) {
                virtualNodeCpu = virtualNode.getCPU();
                virtualNodeMemory = virtualNode.getRAM();
                virtualNodeDiskSpace = virtualNode.getStorage();
            }
            leasedCPU += virtualNodeCpu;
            leasedMemory += virtualNodeMemory;
            leasedDiskSpace += virtualNodeDiskSpace;
            cpuCost += virtualNodeCpu * virtualNode.getCPUprice() * virtualNode.getLifeTime();
            memoryCost += virtualNodeMemory * virtualNode.getRAMprice() * virtualNode.getLifeTime();
            if (!virtualNode.getType().equals("Server")) continue;
            diskSpaceCost += virtualNodeDiskSpace * ((VirtualMachine)virtualNode).getStoragePrice() * virtualNode.getLifeTime();
        }
        int leasedBandwidth = 0;
        int bandwidthCost = 0;
        for (VirtualLink virtualLink : this.getVirtualNetwork().getVirtualLinks()) {
            Iterator<Map.Entry<SdnLink, BWbackupFlag>> iterator = virtualLink.getSdnLinksBWbackupFlags().entrySet().iterator();
            while (iterator.hasNext()) {
                int bandwidth = iterator.next().getValue().getBW();
                leasedBandwidth += bandwidth;
                bandwidthCost += bandwidth * virtualLink.getBWprice() * virtualLink.getLifeTime();
            }
        }
        int networkCost = cpuCost + memoryCost + diskSpaceCost + bandwidthCost;
        this.getVirtualNetwork().setNetworkCost(networkCost);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"<html><b>Resource</b></html>", "<html><b>Leased</b></html>", "<html><b>Cost</b></html>"}, 0);
        defaultTableModel.addRow(new Object[]{"<html><b>CPU</b></html>", leasedCPU, cpuCost});
        defaultTableModel.addRow(new Object[]{"<html><b>Memory</b></html>", leasedMemory, memoryCost});
        defaultTableModel.addRow(new Object[]{"<html><b>Disk Space</b></html>", leasedDiskSpace, diskSpaceCost});
        defaultTableModel.addRow(new Object[]{"<html><b>Bandwidth</b></html>", leasedBandwidth, bandwidthCost});
        defaultTableModel.addRow(new Object[]{"<html><b>Total</b></html>", "", "<html><b>" + networkCost + "</b></html>"});
        return defaultTableModel;
    }
}

