/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.virtual.graphical;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.virtual.graphical.VirtualNetworkViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.components.links.link.Link;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.Node;

public class VirtualNetworkViewersPanel
extends JPanel
implements ChangeListener {
    private List<VirtualNetwork> networksRequest;
    private ResultsFrame frameResults;
    private List<VirtualNetworkViewer> visualizationViewersNetworkRequest;
    private JLabel label;
    private JSlider slider;
    private int positionPrevious;

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.networksRequest;
    }

    public void setNetworksRequest(List<VirtualNetwork> networksRequest) {
        this.networksRequest = networksRequest;
    }

    public ResultsFrame getFrameResults() {
        return this.frameResults;
    }

    public void setFrameResults(ResultsFrame frameResults) {
        this.frameResults = frameResults;
    }

    public List<VirtualNetworkViewer> getVisualizationViewersNetworkRequest() {
        return this.visualizationViewersNetworkRequest;
    }

    public void setVisualizationViewersNetworkRequest(List<VirtualNetworkViewer> visualizationViewersNetworkRequest) {
        this.visualizationViewersNetworkRequest = visualizationViewersNetworkRequest;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public int getPositionPrevious() {
        return this.positionPrevious;
    }

    public void setPositionPrevious(int positionPrevious) {
        this.positionPrevious = positionPrevious;
    }

    public VirtualNetworkViewersPanel(List<VirtualNetwork> virtualNetworks, ResultsFrame frameResults) {
        this.setNetworksRequest(virtualNetworks);
        this.setFrameResults(frameResults);
        this.setVisualizationViewersNetworkRequest(this.visualizationViewersNetworkRequest(virtualNetworks));
        this.setLabel(new JLabel(virtualNetworks.get(0).getName(), null, 0));
        this.setSlider(this.slider(virtualNetworks.size()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLabel(), "North");
        this.add((Component)this.getVisualizationViewersNetworkRequest().get(0), "Center");
        this.add((Component)this.getSlider(), "South");
    }

    private List<VirtualNetworkViewer> visualizationViewersNetworkRequest(List<VirtualNetwork> virtualNetworks) {
        ArrayList<VirtualNetworkViewer> visualizationViewersNetworkRequest = new ArrayList<VirtualNetworkViewer>();
        for (VirtualNetwork virtualNetwork : virtualNetworks) {
            CircleLayout<Node, Link> circleLayout = new CircleLayout<Node, Link>(virtualNetwork.getGraph());
            circleLayout.setGraph(virtualNetwork.getGraph());
            circleLayout.setVertexOrder(virtualNetwork.getNodes());
            VirtualNetworkViewer visualizationViewerNetworkRequest = new VirtualNetworkViewer(circleLayout, this.getFrameResults());
            visualizationViewerNetworkRequest.setBackground(Color.GRAY);
            visualizationViewersNetworkRequest.add(visualizationViewerNetworkRequest);
        }
        return visualizationViewersNetworkRequest;
    }

    private JSlider slider(int numberNetworksRequest) {
        JSlider slider = new JSlider();
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.setPaintTrack(true);
        slider.setPaintLabels(true);
        slider.setMinimum(0);
        slider.setMaximum(numberNetworksRequest - 1);
        slider.setMinorTickSpacing(1);
        slider.setMajorTickSpacing(1);
        slider.setValue(0);
        slider.addChangeListener(this);
        return slider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.putValueSliders(this.getSlider().getValue());
    }

    public void putValueSliderss(int i) {
        this.putValueSliders(i);
        this.getFrameResults().getVirtualNetworksTabbedPane().setSelectedIndex(0);
    }

    public void putValueSliders(int i) {
        this.putValueSlider(i);
        int selectedIndex = this.getFrameResults().getVirtualNetworksViewersPanelsTabbedPane().getSelectedIndex();
        this.getFrameResults().getVirtualNetworksTablesPanelsTabbedPane().setSelectedIndex(selectedIndex);
        this.getFrameResults().getVirtualNetworksTablesPanels().get(selectedIndex).putValueSlider(i);
    }

    public void putValueSlider(int i) {
        VirtualNetwork virtualNetwork = this.getVirtualNetworks().get(i);
        if (virtualNetwork.getTimeStamp() == -1) {
            this.getLabel().setText(virtualNetwork.getName());
        } else {
            this.getLabel().setText("Time: " + virtualNetwork.getTimeStamp());
        }
        this.remove(this.getVisualizationViewersNetworkRequest().get(this.getPositionPrevious()));
        this.setPositionPrevious(i);
        this.add((Component)this.getVisualizationViewersNetworkRequest().get(i), "Center");
        this.getSlider().setValue(i);
        this.repaint();
    }
}

