/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.virtual.graphical;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.virtual.graphical.VirtualLinkColorTransformer;
import frame.options.simulation.results.virtual.graphical.VirtualNetworkPlugin;
import frame.options.simulation.results.virtual.graphical.VirtualNodeIconTransformer;
import frame.options.simulation.results.virtual.graphical.VirtualNodeLabelTransformer;
import model.components.links.link.Link;
import model.components.nodes.node.Node;

public class VirtualNetworkViewer
extends VisualizationViewer<Node, Link> {
    public VirtualNetworkViewer(Layout<Node, Link> layout, ResultsFrame frameResults) {
        super(layout);
        this.setLayout(this.getLayout());
        this.getRenderContext().setVertexIconTransformer(new VirtualNodeIconTransformer());
        this.getRenderContext().setVertexLabelTransformer(new VirtualNodeLabelTransformer());
        this.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        this.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
        this.getRenderContext().setEdgeDrawPaintTransformer(new VirtualLinkColorTransformer());
        DefaultModalGraphMouse defaultModalGraphMouse = new DefaultModalGraphMouse();
        defaultModalGraphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        defaultModalGraphMouse.add(new VirtualNetworkPlugin(frameResults));
        this.addKeyListener(defaultModalGraphMouse.getModeKeyListener());
        this.setGraphMouse(defaultModalGraphMouse);
    }
}

