/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.sdn.numerical;

import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.sdn.numerical.SdnNetworkTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.components.networks.sdn.SdnNetwork;

public class SdnNetworkTablesPanel
extends JPanel
implements ChangeListener {
    private List<SdnNetwork> sdnNetworks;
    private ResultsFrame resultsFrame;
    private List<JScrollPane> sdnNetworkTablesScrollPanes;
    private JLabel label;
    private JSlider slider;
    private int sliderPreviousValue;

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public ResultsFrame getResultsFrame() {
        return this.resultsFrame;
    }

    public void setResultsFrame(ResultsFrame resultsFrame) {
        this.resultsFrame = resultsFrame;
    }

    public List<JScrollPane> getSdnNetworkTablesScrollPanes() {
        return this.sdnNetworkTablesScrollPanes;
    }

    public void setSdnNetworkTablesScrollPanes(List<JScrollPane> sdnNetworkTablesScrollPanes) {
        this.sdnNetworkTablesScrollPanes = sdnNetworkTablesScrollPanes;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public int getSliderPreviousValue() {
        return this.sliderPreviousValue;
    }

    public void setSliderPreviousValue(int sliderPreviousValue) {
        this.sliderPreviousValue = sliderPreviousValue;
    }

    public SdnNetworkTablesPanel(List<SdnNetwork> sdnNetworks, ResultsFrame resultsFrame) {
        this.setSdnNetworks(sdnNetworks);
        this.setResultsFrame(resultsFrame);
        this.setSdnNetworkTablesScrollPanes(this.sdnNetworkTablesScrollPanes(sdnNetworks));
        this.setLabel(new JLabel(sdnNetworks.get(0).getName(), null, 0));
        this.setSlider(this.slider(sdnNetworks.size()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLabel(), "North");
        this.add((Component)this.getSdnNetworkTablesScrollPanes().get(0), "Center");
        this.add((Component)this.getSlider(), "South");
    }

    private List<JScrollPane> sdnNetworkTablesScrollPanes(List<SdnNetwork> sdnNetworks) {
        ArrayList<JScrollPane> sdnNetworkTablesScrollPanes = new ArrayList<JScrollPane>();
        for (SdnNetwork sdnNetwork : sdnNetworks) {
            sdnNetworkTablesScrollPanes.add(new JScrollPane(new SdnNetworkTable(sdnNetwork)));
        }
        return sdnNetworkTablesScrollPanes;
    }

    private JSlider slider(int sdnNetworksNumber) {
        JSlider slider = new JSlider();
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.setPaintTrack(true);
        slider.setPaintLabels(true);
        slider.setMinimum(0);
        slider.setMaximum(sdnNetworksNumber - 1);
        slider.setMinorTickSpacing(1);
        slider.setMajorTickSpacing(1);
        slider.setValue(0);
        slider.addChangeListener(this);
        return slider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.putValueSliders(this.getSlider().getValue());
    }

    public void putValueSliders(int valueSlider) {
        this.setSliderValue(valueSlider);
        int selectedIndex = this.getResultsFrame().getSdnNetworksTablesPanelsTabbedPane().getSelectedIndex();
        this.getResultsFrame().getSdnNetworksViewersPanelsTabbedPane().setSelectedIndex(selectedIndex);
        this.getResultsFrame().getSdnNetworksViewersPanels().get(selectedIndex).setSliderValue(valueSlider);
    }

    public void setSliderValue(int valueSlider) {
        SdnNetwork sdnNetwork = this.getSdnNetworks().get(valueSlider);
        if (sdnNetwork.getTimeStamp() == -1) {
            this.getLabel().setText(sdnNetwork.getName());
        } else {
            this.getLabel().setText("Time: " + sdnNetwork.getTimeStamp());
        }
        this.remove(this.getSdnNetworkTablesScrollPanes().get(this.getSliderPreviousValue()));
        this.setSliderPreviousValue(valueSlider);
        this.add((Component)this.getSdnNetworkTablesScrollPanes().get(valueSlider), "Center");
        this.getSlider().setValue(valueSlider);
        this.repaint();
    }
}

