/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.sdn.numerical;

import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import model.components.links.link.BWbackupFlag;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualNode;

public class SdnNetworkTable
extends JTable {
    private SdnNetwork sdnNetwork;

    public SdnNetwork getSdnNetwork() {
        return this.sdnNetwork;
    }

    public void setSdnNetwork(SdnNetwork sdnNetwork) {
        this.sdnNetwork = sdnNetwork;
    }

    public SdnNetworkTable(SdnNetwork sdnNetwork) {
        this.setSdnNetwork(sdnNetwork);
        this.setModel(this.defaultTableModel());
        this.setEnabled(false);
    }

    private DefaultTableModel defaultTableModel() {
        int leasedCPU = 0;
        int leasedRAM = 0;
        int leasedStorage = 0;
        int cpuPrice = this.getSdnNetwork().getCPUprice();
        int ramPrice = this.getSdnNetwork().getRAMprice();
        int storagePrice = this.getSdnNetwork().getStoragePrice();
        int cpuRevenue = 0;
        int ramRevenue = 0;
        int storageRevenue = 0;
        for (SdnNode sdnNode : this.getSdnNetwork().getSdnNodes()) {
            if (sdnNode.getVirtualNodes().size() == 0) continue;
            for (VirtualNode virtualNode : sdnNode.getVirtualNodes()) {
                if (virtualNode.getStartingDate() != this.getSdnNetwork().getTimeStamp()) continue;
                leasedCPU += virtualNode.getCPU();
                leasedRAM += virtualNode.getRAM();
                leasedStorage += virtualNode.getStorage();
                cpuRevenue += virtualNode.getCPU() * cpuPrice * virtualNode.getLifeTime();
                ramRevenue += virtualNode.getRAM() * ramPrice * virtualNode.getLifeTime();
                storageRevenue += virtualNode.getStorage() * storagePrice * virtualNode.getLifeTime();
            }
        }
        int leasedBW = 0;
        int bwRevenue = 0;
        int bwPrice = this.getSdnNetwork().getBWprice();
        for (SdnLink sdnLink : this.getSdnNetwork().getSdnLinks()) {
            for (Map.Entry<VirtualLink, BWbackupFlag> entry : sdnLink.getVirtualLinksBWbackupFlags().entrySet()) {
                VirtualLink virtualLink = entry.getKey();
                int bw = entry.getValue().getBW();
                if (virtualLink.getStartingDate() != this.getSdnNetwork().getTimeStamp()) continue;
                leasedBW += bw;
                bwRevenue += bw * bwPrice * virtualLink.getLifeTime();
            }
        }
        int networkRevenue = cpuRevenue + ramRevenue + storageRevenue + bwRevenue;
        this.getSdnNetwork().setNetworkRevenue(networkRevenue);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"<html><b>Resource</b></html>", "<html><b>Leased</b></html>", "<html><b>Unit Price</b>", "<html><b>Revenue</b></html>"}, 0);
        defaultTableModel.addRow(new Object[]{"<html><b>CPU</b></html>", leasedCPU, cpuPrice, cpuRevenue});
        defaultTableModel.addRow(new Object[]{"<html><b>RAM</b></html>", leasedRAM, ramPrice, ramRevenue});
        defaultTableModel.addRow(new Object[]{"<html><b>Storage</b></html>", leasedStorage, storagePrice, storageRevenue});
        defaultTableModel.addRow(new Object[]{"<html><b>BW</b></html>", leasedBW, bwPrice, bwRevenue});
        defaultTableModel.addRow(new Object[]{"<html><b>Total</b></html>", "", "", "<html><b>" + networkRevenue + "</b></html>"});
        return defaultTableModel;
    }
}

