/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.sdn.graphical;

import javax.swing.Icon;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.sdn.SdnServer;
import org.apache.commons.collections15.Transformer;

public class SdnNodeIconTransformer
implements Transformer<Node, Icon> {
    @Override
    public Icon transform(Node node) {
        if (node.isSelected()) {
            return node.getGreenIcon();
        }
        if (node.getType().equals("Router") || node.getType().equals("Switch")) {
            SdnNode sdnNode = (SdnNode)node;
            if ((double)sdnNode.getAvailableCPU() < (double)sdnNode.getCPU() * 0.2 || (double)sdnNode.getAvailableRAM() < (double)sdnNode.getRAM() * 0.2) {
                return sdnNode.getRedIcon();
            }
            if (sdnNode.getAvailableCPU() < sdnNode.getCPU() || sdnNode.getAvailableRAM() < sdnNode.getRAM()) {
                return sdnNode.getYellowIcon();
            }
        } else if (node.getType().equals("Server")) {
            SdnServer sdnServer = (SdnServer)node;
            if ((double)sdnServer.getAvailableCPU() < (double)sdnServer.getCPU() * 0.2 || (double)sdnServer.getAvailableRAM() < (double)sdnServer.getRAM() * 0.2 || (double)sdnServer.getAvailableStorage() < (double)sdnServer.getStorage() * 0.2) {
                return sdnServer.getRedIcon();
            }
            if (sdnServer.getAvailableCPU() < sdnServer.getCPU() || sdnServer.getAvailableRAM() < sdnServer.getRAM() || sdnServer.getAvailableStorage() < sdnServer.getStorage()) {
                return sdnServer.getYellowIcon();
            }
        }
        return node.getGreyIcon();
    }
}

