/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.sdn.graphical;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.sdn.graphical.SdnNetworkViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.components.links.link.Link;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.comparator.NodeNumberComparator;
import model.components.nodes.node.Node;

public class SdnNetworkViewersPanel
extends JPanel
implements ChangeListener {
    private List<SdnNetwork> sdnNetworks;
    private ResultsFrame resultsFrame;
    private List<SdnNetworkViewer> sdnNetworkViewers;
    private JLabel label;
    private JSlider slider;
    private int sliderPreviousValue;

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public ResultsFrame getResultsFrame() {
        return this.resultsFrame;
    }

    public void setResultsFrame(ResultsFrame resultsFrame) {
        this.resultsFrame = resultsFrame;
    }

    public List<SdnNetworkViewer> getSdnNetworkViewers() {
        return this.sdnNetworkViewers;
    }

    public void setSdnNetworkViewers(List<SdnNetworkViewer> sdnNetworkViewers) {
        this.sdnNetworkViewers = sdnNetworkViewers;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public int getSliderPreviousValue() {
        return this.sliderPreviousValue;
    }

    public void setSliderPreviousValue(int sliderPreviousValue) {
        this.sliderPreviousValue = sliderPreviousValue;
    }

    public SdnNetworkViewersPanel(List<SdnNetwork> sdnNetworks, ResultsFrame resultsFrame) {
        this.setSdnNetworks(sdnNetworks);
        this.setResultsFrame(resultsFrame);
        this.setSdnNetworkViewers(this.sdnNetworkViewers(sdnNetworks));
        this.setLabel(new JLabel(sdnNetworks.get(0).getName(), null, 0));
        this.setSlider(this.slider(sdnNetworks.size()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLabel(), "North");
        this.add((Component)this.getSdnNetworkViewers().get(0), "Center");
        this.add((Component)this.getSlider(), "South");
    }

    private List<SdnNetworkViewer> sdnNetworkViewers(List<SdnNetwork> sdnNetworks) {
        ArrayList<SdnNetworkViewer> sdnNetworkViewers = new ArrayList<SdnNetworkViewer>();
        for (SdnNetwork sdnNetwork : sdnNetworks) {
            CircleLayout<Node, Link> circleLayout = new CircleLayout<Node, Link>(sdnNetwork.getGraph());
            circleLayout.setVertexOrder(new NodeNumberComparator());
            SdnNetworkViewer sdnNetworkViewer = new SdnNetworkViewer(circleLayout, this.getResultsFrame());
            sdnNetworkViewer.setBackground(Color.GRAY);
            sdnNetworkViewers.add(sdnNetworkViewer);
        }
        return sdnNetworkViewers;
    }

    private JSlider slider(int sdnNetworksNumber) {
        JSlider slider = new JSlider();
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.setPaintTrack(true);
        slider.setPaintLabels(true);
        slider.setMinimum(0);
        slider.setMaximum(sdnNetworksNumber - 1);
        slider.setMinorTickSpacing(1);
        slider.setMajorTickSpacing(1);
        slider.setValue(0);
        slider.addChangeListener(this);
        return slider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setSlidersValue(this.getSlider().getValue());
    }

    public void putValueSliderss(int index) {
        this.setSlidersValue(index);
        this.getResultsFrame().getSdnNetworksTabbedPane().setSelectedIndex(0);
    }

    private void setSlidersValue(int index) {
        this.setSliderValue(index);
        int selectedIndex = this.getResultsFrame().getSdnNetworksViewersPanelsTabbedPane().getSelectedIndex();
        this.getResultsFrame().getSdnNetworksTablesPanelsTabbedPane().setSelectedIndex(selectedIndex);
        this.getResultsFrame().getSdnNetworksTablesPanels().get(selectedIndex).setSliderValue(index);
    }

    public void setSliderValue(int index) {
        SdnNetwork sdnNetwork = this.getSdnNetworks().get(index);
        if (sdnNetwork.getTimeStamp() == -1) {
            this.getLabel().setText(sdnNetwork.getName());
        } else {
            this.getLabel().setText("Time: " + sdnNetwork.getTimeStamp());
        }
        this.remove(this.getSdnNetworkViewers().get(this.getSliderPreviousValue()));
        this.setSliderPreviousValue(index);
        this.add((Component)this.getSdnNetworkViewers().get(index), "Center");
        this.getSlider().setValue(index);
        this.repaint();
    }
}

