/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results.sdn.graphical;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import frame.options.simulation.results.ResultsFrame;
import frame.options.simulation.results.sdn.graphical.SdnLinkColorTransformer;
import frame.options.simulation.results.sdn.graphical.SdnNetworkPlugin;
import frame.options.simulation.results.sdn.graphical.SdnNodeIconTransformer;
import frame.options.simulation.results.sdn.graphical.SdnNodeLabelTransformer;
import model.components.links.link.Link;
import model.components.nodes.node.Node;

public class SdnNetworkViewer
extends VisualizationViewer<Node, Link> {
    public SdnNetworkViewer(Layout<Node, Link> layout, ResultsFrame resultsFrame) {
        super(layout);
        try {
            this.getRenderContext().setVertexIconTransformer(new SdnNodeIconTransformer());
            this.getRenderContext().setVertexLabelTransformer(new SdnNodeLabelTransformer());
            this.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
            this.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
            this.getRenderContext().setEdgeDrawPaintTransformer(new SdnLinkColorTransformer());
            DefaultModalGraphMouse defaultModalGraphMouse = new DefaultModalGraphMouse();
            defaultModalGraphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            defaultModalGraphMouse.add(new SdnNetworkPlugin(resultsFrame));
            this.addKeyListener(defaultModalGraphMouse.getModeKeyListener());
            this.setGraphMouse(defaultModalGraphMouse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

