/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.results;

import frame.options.simulation.Simulation;
import frame.options.simulation.results.sdn.graphical.SdnNetworkViewersPanel;
import frame.options.simulation.results.sdn.numerical.SdnNetworkTablesPanel;
import frame.options.simulation.results.sdn.summary.SdnNetworksTable;
import frame.options.simulation.results.virtual.graphical.VirtualNetworkViewersPanel;
import frame.options.simulation.results.virtual.numerical.VirtualNetworkTablesPanel;
import frame.options.simulation.results.virtual.summary.VirtualNetworksTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;

public class ResultsFrame
extends JFrame
implements ChangeListener {
    private Simulation simulation;
    private JTabbedPane sdnNetworksTabbedPane;
    private JTabbedPane virtualNetworksTabbedPane;
    private List<SdnNetworkViewersPanel> sdnNetworksViewersPanels;
    private List<VirtualNetworkViewersPanel> virtualNetworksViewersPanels;
    private JTabbedPane sdnNetworksViewersPanelsTabbedPane;
    private JTabbedPane virtualNetworksViewersPanelsTabbedPane;
    private List<SdnNetworkTablesPanel> sdnNetworksTablesPanels;
    private List<VirtualNetworkTablesPanel> virtualNetworksTablesPanels;
    private JTabbedPane sdnNetworksTablesPanelsTabbedPane;
    private JTabbedPane virtualNetworksTablesPanelsTabbedPane;
    private JPanel sdnNetworksTablePanel;
    private JPanel virtualNetworksTablePanel;

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public JTabbedPane getSdnNetworksTabbedPane() {
        return this.sdnNetworksTabbedPane;
    }

    public void setSdnNetworksTabbedPane(JTabbedPane sdnNetworksTabbedPane) {
        this.sdnNetworksTabbedPane = sdnNetworksTabbedPane;
    }

    public JTabbedPane getVirtualNetworksTabbedPane() {
        return this.virtualNetworksTabbedPane;
    }

    public void setVirtualNetworksTabbedPane(JTabbedPane virtualNetworksTabbedPane) {
        this.virtualNetworksTabbedPane = virtualNetworksTabbedPane;
    }

    public List<SdnNetworkViewersPanel> getSdnNetworksViewersPanels() {
        return this.sdnNetworksViewersPanels;
    }

    public void setSdnNetworksViewersPanels(List<SdnNetworkViewersPanel> sdnNetworksViewersPanels) {
        this.sdnNetworksViewersPanels = sdnNetworksViewersPanels;
    }

    public List<VirtualNetworkViewersPanel> getVirtualNetworksViewersPanels() {
        return this.virtualNetworksViewersPanels;
    }

    public void setVirtualNetworksViewersPanels(List<VirtualNetworkViewersPanel> virtualNetworksViewersPanels) {
        this.virtualNetworksViewersPanels = virtualNetworksViewersPanels;
    }

    public JTabbedPane getSdnNetworksViewersPanelsTabbedPane() {
        return this.sdnNetworksViewersPanelsTabbedPane;
    }

    public void setSdnNetworksViewersPanelsTabbedPane(JTabbedPane sdnNetworksViewersPanelsTabbedPane) {
        this.sdnNetworksViewersPanelsTabbedPane = sdnNetworksViewersPanelsTabbedPane;
    }

    public JTabbedPane getVirtualNetworksViewersPanelsTabbedPane() {
        return this.virtualNetworksViewersPanelsTabbedPane;
    }

    public void setVirtualNetworksViewersPanelsTabbedPane(JTabbedPane virtualNetworksViewersPanelsTabbedPane) {
        this.virtualNetworksViewersPanelsTabbedPane = virtualNetworksViewersPanelsTabbedPane;
    }

    public List<SdnNetworkTablesPanel> getSdnNetworksTablesPanels() {
        return this.sdnNetworksTablesPanels;
    }

    public void setSdnNetworksTablesPanels(List<SdnNetworkTablesPanel> sdnNetworksTablesPanels) {
        this.sdnNetworksTablesPanels = sdnNetworksTablesPanels;
    }

    public List<VirtualNetworkTablesPanel> getVirtualNetworksTablesPanels() {
        return this.virtualNetworksTablesPanels;
    }

    public void setVirtualNetworksTablesPanels(List<VirtualNetworkTablesPanel> virtualNetworksTablesPanels) {
        this.virtualNetworksTablesPanels = virtualNetworksTablesPanels;
    }

    public JTabbedPane getSdnNetworksTablesPanelsTabbedPane() {
        return this.sdnNetworksTablesPanelsTabbedPane;
    }

    public void setSdnNetworksTablesPanelsTabbedPane(JTabbedPane sdnNetworksTablesPanelsTabbedPane) {
        this.sdnNetworksTablesPanelsTabbedPane = sdnNetworksTablesPanelsTabbedPane;
    }

    public JTabbedPane getVirtualNetworksTablesPanelsTabbedPane() {
        return this.virtualNetworksTablesPanelsTabbedPane;
    }

    public void setVirtualNetworksTablesPanelsTabbedPane(JTabbedPane virtualNetworksTablesPanelsTabbedPane) {
        this.virtualNetworksTablesPanelsTabbedPane = virtualNetworksTablesPanelsTabbedPane;
    }

    public JPanel getSdnNetworksTablePanel() {
        return this.sdnNetworksTablePanel;
    }

    public void setSdnNetworksTablePanel(JPanel sdnNetworksTablePanel) {
        this.sdnNetworksTablePanel = sdnNetworksTablePanel;
    }

    public JPanel getVirtualNetworksTablePanel() {
        return this.virtualNetworksTablePanel;
    }

    public void setVirtualNetworksTablePanel(JPanel virtualNetworksTablePanel) {
        this.virtualNetworksTablePanel = virtualNetworksTablePanel;
    }

    public ResultsFrame(List<SdnNetwork> resultSdnNetworks, int simulatorSdnNetworksNumber, List<VirtualNetwork> resultVirtualNetworks, int simulatorVirtualNetworksNumber, Simulation simulation) {
        this.setSimulation(simulation);
        this.setSdnNetworksTabbedPane(this.physicalNetworksTabbedPane(resultSdnNetworks, simulatorSdnNetworksNumber));
        this.setVirtualNetworksTabbedPane(this.virtualNetworksTabbedPane(resultVirtualNetworks, simulatorVirtualNetworksNumber));
        JSplitPane networksSplitPane = new JSplitPane();
        networksSplitPane.setLeftComponent(this.getSdnNetworksTabbedPane());
        networksSplitPane.setRightComponent(this.getVirtualNetworksTabbedPane());
        this.setLayout(new BorderLayout());
        this.add((Component)this.simulationDataPanel(), "North");
        this.add((Component)networksSplitPane, "Center");
        this.setTitle("Simulation results");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/upcSmall.png")).getImage());
        this.setAlwaysOnTop(false);
        this.setExtendedState(6);
    }

    private JPanel simulationDataPanel() {
        String text = null;
        text = "<html><b>SDN NETWORKS:</b> ";
        int i = 0;
        for (SdnNetwork sdnNetwork : this.getSimulation().getSdnNetworks()) {
            text = ++i == this.getSimulation().getSdnNetworks().size() - 1 ? String.valueOf(text) + sdnNetwork.getName() + " and " : (i < this.getSimulation().getSdnNetworks().size() - 1 ? String.valueOf(text) + sdnNetwork.getName() + ", " : String.valueOf(text) + sdnNetwork.getName());
        }
        text = String.valueOf(text) + "<br><b>VIRTUAL NETWORKS:</b> ";
        i = 0;
        for (VirtualNetwork virtualNetwork : this.getSimulation().getVirtualNetworks()) {
            text = ++i == this.getSimulation().getVirtualNetworks().size() - 1 ? String.valueOf(text) + virtualNetwork.getName() + " and " : (i < this.getSimulation().getVirtualNetworks().size() - 1 ? String.valueOf(text) + virtualNetwork.getName() + ", " : String.valueOf(text) + virtualNetwork.getName());
        }
        text = String.valueOf(text) + "<b> WITH BACKUP:</b> ";
        text = this.getSimulation().getLinksMappingAlgorithm().isBackupVirtualNetwork() ? String.valueOf(text) + "Yes" : String.valueOf(text) + "No";
        text = String.valueOf(text) + "<br><b>VIRTUAL NETWORK SPLITTING ALGORITHM:</b> " + this.getSimulation().getSplittingAlgorithm().getName();
        text = String.valueOf(text) + "<br><b>WITH COORDINATED VIRTUAL NODE AND LINK MAPPING:</b> ";
        if (this.getSimulation().getEmbeddingAlgorithm() == null) {
            text = String.valueOf(text) + "No";
            text = String.valueOf(text) + " <b>VIRTUAL NODE MAPPING ALGORITHM:</b> " + this.getSimulation().getNodesMappingAlgorithm().getName();
        } else {
            text = String.valueOf(text) + "Yes";
            text = String.valueOf(text) + " <b>VIRTUAL NETWORK EMBEDDING ALGORITHM:</b> " + this.getSimulation().getEmbeddingAlgorithm().getName();
            text = String.valueOf(text) + " <b>ROUNDED VIRTUAL NODE MAPPING ALGORITHM:</b> " + this.getSimulation().getRoundingAlgorithm().getName();
        }
        text = String.valueOf(text) + "<br><b>VIRTUAL LINK MAPPING ALGORITHM:</b> " + this.getSimulation().getLinksMappingAlgorithm().getName();
        text = String.valueOf(text) + " <b>COST METRIC:</b> ";
        if (this.getSimulation().getLinksMappingAlgorithm().getCostMetric().equals("distance")) {
            text = String.valueOf(text) + "Distance</html>";
        } else if (this.getSimulation().getLinksMappingAlgorithm().getCostMetric().equals("availableBandwidth")) {
            text = String.valueOf(text) + "Bandwidth</html>";
        }
        JPanel simulationDataPanel = new JPanel();
        simulationDataPanel.add(new JLabel(text));
        return simulationDataPanel;
    }

    private JTabbedPane physicalNetworksTabbedPane(List<SdnNetwork> resultPhysicalNetworks, int simulatorPhysicalNetworksNumber) {
        ArrayList<List<SdnNetwork>> physicalNetworksNetworks = new ArrayList<List<SdnNetwork>>();
        int i = 0;
        while (i < simulatorPhysicalNetworksNumber) {
            physicalNetworksNetworks.add(new ArrayList());
            ++i;
        }
        for (SdnNetwork physicalNetwork : resultPhysicalNetworks) {
            ((List)physicalNetworksNetworks.get(physicalNetwork.getNumber())).add(physicalNetwork);
        }
        this.setSdnNetworksViewersPanelsTabbedPane(this.physicalNetworksVisualizationViewersPanelsTabbedPane(physicalNetworksNetworks));
        this.setSdnNetworksTablesPanelsTabbedPane(this.physicalNetworksTablesPanelsTabbedPane(physicalNetworksNetworks));
        this.setSdnNetworksTablePanel(this.physicalNetworksTablePanel(physicalNetworksNetworks));
        JTabbedPane physicalNetworksTabbedPane = new JTabbedPane();
        physicalNetworksTabbedPane.setName("physicalNetworksTabbedPane");
        physicalNetworksTabbedPane.setTabPlacement(1);
        physicalNetworksTabbedPane.addTab("Graphical", null, this.getSdnNetworksViewersPanelsTabbedPane(), "Graphical results of physical networks");
        physicalNetworksTabbedPane.addTab("Numerical", null, this.getSdnNetworksTablesPanelsTabbedPane(), "Numerical results of physical networks");
        physicalNetworksTabbedPane.addTab("Summary", null, this.getSdnNetworksTablePanel(), "Summary results of physical networks");
        physicalNetworksTabbedPane.addChangeListener(this);
        return physicalNetworksTabbedPane;
    }

    private JTabbedPane physicalNetworksVisualizationViewersPanelsTabbedPane(List<List<SdnNetwork>> physicalNetworksNetworks) {
        this.setSdnNetworksViewersPanels(new ArrayList<SdnNetworkViewersPanel>());
        JTabbedPane physicalNetworksVisualizationViewersPanelsTabbedPane = new JTabbedPane();
        int i = 0;
        while (i < physicalNetworksNetworks.size()) {
            String physicalNetworkName = physicalNetworksNetworks.get(i).get(0).getName();
            List<SdnNetwork> physicalNetworkNetworks = physicalNetworksNetworks.get(i);
            SdnNetworkViewersPanel sdnNetworkVisualizationViewersPanel = new SdnNetworkViewersPanel(physicalNetworkNetworks, this);
            physicalNetworksVisualizationViewersPanelsTabbedPane.addTab(physicalNetworkName, null, sdnNetworkVisualizationViewersPanel, null);
            this.getSdnNetworksViewersPanels().add(sdnNetworkVisualizationViewersPanel);
            ++i;
        }
        return physicalNetworksVisualizationViewersPanelsTabbedPane;
    }

    private JTabbedPane physicalNetworksTablesPanelsTabbedPane(List<List<SdnNetwork>> physicalNetworksNetworks) {
        JTabbedPane physicalNetworksTablesPanelsTabbedPane = new JTabbedPane();
        this.setSdnNetworksTablesPanels(new ArrayList<SdnNetworkTablesPanel>());
        int i = 0;
        while (i < physicalNetworksNetworks.size()) {
            List<SdnNetwork> physicalNetworkNetworks = physicalNetworksNetworks.get(i);
            String physicalNetworkName = physicalNetworkNetworks.get(0).getName();
            SdnNetworkTablesPanel sdnNetworkTablesPanel = new SdnNetworkTablesPanel(physicalNetworkNetworks, this);
            physicalNetworksTablesPanelsTabbedPane.addTab(physicalNetworkName, null, sdnNetworkTablesPanel, null);
            this.getSdnNetworksTablesPanels().add(sdnNetworkTablesPanel);
            ++i;
        }
        return physicalNetworksTablesPanelsTabbedPane;
    }

    private JPanel physicalNetworksTablePanel(List<List<SdnNetwork>> physicalNetworksNetworks) {
        JPanel panel = new JPanel();
        panel.add(new JScrollPane(new SdnNetworksTable(physicalNetworksNetworks)));
        return panel;
    }

    private JTabbedPane virtualNetworksTabbedPane(List<VirtualNetwork> resultVirtualNetworks, int simulatorVirtualNetworksNumber) {
        ArrayList<List<VirtualNetwork>> virtualNetworksNetworks = new ArrayList<List<VirtualNetwork>>();
        int i = 0;
        while (i < simulatorVirtualNetworksNumber) {
            virtualNetworksNetworks.add(new ArrayList());
            ++i;
        }
        for (VirtualNetwork resultVirtualNetwork : resultVirtualNetworks) {
            ((List)virtualNetworksNetworks.get(resultVirtualNetwork.getNumber())).add(resultVirtualNetwork);
        }
        this.setVirtualNetworksViewersPanelsTabbedPane(this.virtualNetworksVisualizationViewersPanelsTabbedPane(virtualNetworksNetworks));
        this.setVirtualNetworksTablesPanelsTabbedPane(this.virtualNetworksTablesPanelsTabbedPane(virtualNetworksNetworks));
        this.setVirtualNetworksTablePanel(this.virtualNetworksTablePanel(virtualNetworksNetworks));
        JTabbedPane virtualNetworksTabbedPane = new JTabbedPane();
        virtualNetworksTabbedPane.setName("virtualNetworksTabbedPane");
        virtualNetworksTabbedPane.setTabPlacement(1);
        virtualNetworksTabbedPane.addTab("Graphical", null, this.getVirtualNetworksViewersPanelsTabbedPane(), "Graphical results of virtual networks");
        virtualNetworksTabbedPane.addTab("Numerical", null, this.getVirtualNetworksTablesPanelsTabbedPane(), "Numerical results of virtual networks");
        virtualNetworksTabbedPane.addTab("Summary", null, this.getVirtualNetworksTablePanel(), "Summary results of virtual networks");
        virtualNetworksTabbedPane.addChangeListener(this);
        return virtualNetworksTabbedPane;
    }

    private JTabbedPane virtualNetworksVisualizationViewersPanelsTabbedPane(List<List<VirtualNetwork>> virtualNetworksNetworks) {
        this.setVirtualNetworksViewersPanels(new ArrayList<VirtualNetworkViewersPanel>());
        JTabbedPane virtualNetworksVisualizationViewersPanelsTabbedPane = new JTabbedPane();
        int i = 0;
        while (i < virtualNetworksNetworks.size()) {
            String virtualNetworkName = virtualNetworksNetworks.get(i).get(0).getName();
            List<VirtualNetwork> virtualNetworkNetworks = virtualNetworksNetworks.get(i);
            VirtualNetworkViewersPanel virtualNetworkVisualizationViewersPanel = new VirtualNetworkViewersPanel(virtualNetworkNetworks, this);
            virtualNetworksVisualizationViewersPanelsTabbedPane.addTab(virtualNetworkName, null, virtualNetworkVisualizationViewersPanel, null);
            this.getVirtualNetworksViewersPanels().add(virtualNetworkVisualizationViewersPanel);
            ++i;
        }
        return virtualNetworksVisualizationViewersPanelsTabbedPane;
    }

    private JTabbedPane virtualNetworksTablesPanelsTabbedPane(List<List<VirtualNetwork>> virtualNetworksNetworks) {
        JTabbedPane virtualNetworksTablesPanelsTabbedPane = new JTabbedPane();
        this.setVirtualNetworksTablesPanels(new ArrayList<VirtualNetworkTablesPanel>());
        int i = 0;
        while (i < virtualNetworksNetworks.size()) {
            List<VirtualNetwork> virtualNetworkNetworks = virtualNetworksNetworks.get(i);
            String virtualNetworkName = virtualNetworkNetworks.get(0).getName();
            VirtualNetworkTablesPanel virtualNetworkTablesPanel = new VirtualNetworkTablesPanel(virtualNetworkNetworks, this);
            virtualNetworksTablesPanelsTabbedPane.addTab(virtualNetworkName, null, virtualNetworkTablesPanel, null);
            this.getVirtualNetworksTablesPanels().add(virtualNetworkTablesPanel);
            ++i;
        }
        return virtualNetworksTablesPanelsTabbedPane;
    }

    private JPanel virtualNetworksTablePanel(List<List<VirtualNetwork>> virtualNetworksNetworks) {
        JPanel panel = new JPanel();
        panel.add(new JScrollPane(new VirtualNetworksTable(virtualNetworksNetworks)));
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        String tabbedPaneName = ((JTabbedPane)changeEvent.getSource()).getName();
        int tabbedPaneSelectedIndex = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
        if (tabbedPaneName.equals(this.getSdnNetworksTabbedPane().getName())) {
            if (tabbedPaneSelectedIndex == 0) {
                tabbedPaneSelectedIndex = this.getSdnNetworksTablesPanelsTabbedPane().getSelectedIndex();
                this.getSdnNetworksViewersPanelsTabbedPane().setSelectedIndex(tabbedPaneSelectedIndex);
            } else if (tabbedPaneSelectedIndex == 1) {
                tabbedPaneSelectedIndex = this.getSdnNetworksViewersPanelsTabbedPane().getSelectedIndex();
                this.getSdnNetworksTablesPanelsTabbedPane().setSelectedIndex(tabbedPaneSelectedIndex);
            }
        } else if (tabbedPaneName.equals(this.getVirtualNetworksTabbedPane().getName())) {
            if (tabbedPaneSelectedIndex == 0) {
                tabbedPaneSelectedIndex = this.getVirtualNetworksTablesPanelsTabbedPane().getSelectedIndex();
                this.getVirtualNetworksViewersPanelsTabbedPane().setSelectedIndex(tabbedPaneSelectedIndex);
            } else if (tabbedPaneSelectedIndex == 1) {
                tabbedPaneSelectedIndex = this.getVirtualNetworksViewersPanelsTabbedPane().getSelectedIndex();
                this.getVirtualNetworksTablesPanelsTabbedPane().setSelectedIndex(tabbedPaneSelectedIndex);
            }
        }
    }
}

