/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.virtual;

import com.nexes.wizard.WizardPanelDescriptor;
import frame.options.simulation.create.CreateSimulationWizard;
import frame.options.simulation.create.backup.BackupDescriptor;
import frame.options.simulation.create.sdn.SdnDescriptor;
import frame.options.simulation.create.virtual.VirtualPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import model.components.networks.virtual.VirtualNetwork;

public class VirtualDescriptor
extends WizardPanelDescriptor
implements ActionListener,
ListSelectionListener,
MouseListener {
    public static final String IDENTIFIER = VirtualDescriptor.class.getSimpleName();
    private VirtualPanel virtualPanel;

    public VirtualPanel getVirtualPanel() {
        return this.virtualPanel;
    }

    public void setVirtualPanel(VirtualPanel virtualPanel) {
        this.virtualPanel = virtualPanel;
    }

    public VirtualDescriptor(List<VirtualNetwork> virtualNetworks) {
        this.setVirtualPanel(new VirtualPanel(virtualNetworks));
        this.getVirtualPanel().addListeners(this, this, this);
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.getVirtualPanel());
    }

    @Override
    public Object getBackPanelDescriptor() {
        return SdnDescriptor.IDENTIFIER;
    }

    @Override
    public Object getNextPanelDescriptor() {
        return BackupDescriptor.IDENTIFIER;
    }

    @Override
    public void aboutToDisplayPanel() {
        this.setNextFinishButtonEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getVirtualPanel().performButtonAction((JButton)actionEvent.getSource());
        this.getVirtualPanel().updateButtons();
        this.setNextFinishButtonEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.getVirtualPanel().updateButtons();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int virtualNetworksListIndex;
        JList virtualNetworksList = (JList)mouseEvent.getSource();
        if (mouseEvent.getClickCount() == 2 && (virtualNetworksListIndex = virtualNetworksList.locationToIndex(mouseEvent.getPoint())) >= 0) {
            this.getVirtualPanel().mouseDoubleClicked(virtualNetworksList, virtualNetworksListIndex);
            this.setNextFinishButtonEnabled();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    private void setNextFinishButtonEnabled() {
        if (this.getVirtualPanel().getSelectedVirtualNetworksListModel().getSize() > 0) {
            ((CreateSimulationWizard)this.getWizard()).setVirtualNetworks(this.getVirtualPanel().getSelectedVirtualNetworks());
            this.getWizard().setNextFinishButtonEnabled(true);
        } else {
            this.getWizard().setNextFinishButtonEnabled(false);
        }
    }
}

