/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.splitting;

import frame.options.simulation.create.splitting.SplittingListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import model.algorithms.splitting.SplittingAlgorithm;

public class SplittingPanel
extends JPanel {
    public static final String AVAILABLE_LIST = "AvailableList";
    private JList<SplittingAlgorithm> splittingAlgorithmsList;
    private JLabel errorLabel;

    public JList<SplittingAlgorithm> getSplittingAlgorithmsList() {
        return this.splittingAlgorithmsList;
    }

    public void setSplittingAlgorithmsList(JList<SplittingAlgorithm> splittingAlgorithmsList) {
        this.splittingAlgorithmsList = splittingAlgorithmsList;
    }

    public JLabel getErrorLabel() {
        return this.errorLabel;
    }

    public void setErrorLabel(JLabel errorLabel) {
        this.errorLabel = errorLabel;
    }

    public SplittingPanel(List<SplittingAlgorithm> splittingAlgorithms) {
        DefaultListModel<SplittingAlgorithm> splittingAlgorithmsListModel = new DefaultListModel<SplittingAlgorithm>();
        for (SplittingAlgorithm splittingAlgorithm : splittingAlgorithms) {
            splittingAlgorithmsListModel.addElement(splittingAlgorithm);
        }
        this.setSplittingAlgorithmsList(new JList<SplittingAlgorithm>(splittingAlgorithmsListModel));
        this.getSplittingAlgorithmsList().setName(AVAILABLE_LIST);
        this.getSplittingAlgorithmsList().setCellRenderer(new SplittingListCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
        this.add((Component)this.errorPanel(), "South");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Virtual network splitting algorithm");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JSeparator separator = new JSeparator();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)separator, "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(new Insets(50, 50, 50, 50)));
        contentPanel.add(this.availablePanel());
        return contentPanel;
    }

    private JPanel availablePanel() {
        JLabel availableLabel = new JLabel("Available");
        availableLabel.setFont(new Font("MS Sans Serif", 1, 12));
        availableLabel.setAlignmentX(0.5f);
        JScrollPane scrollPane = new JScrollPane(this.getSplittingAlgorithmsList());
        scrollPane.setPreferredSize(new Dimension(200, 250));
        scrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2));
        JPanel availablePanel = new JPanel();
        availablePanel.setLayout(new BoxLayout(availablePanel, 3));
        availablePanel.add(availableLabel);
        availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        availablePanel.add(scrollPane);
        return availablePanel;
    }

    private JPanel errorPanel() {
        this.setErrorLabel(new JLabel(""));
        this.getErrorLabel().setForeground(Color.RED);
        JPanel errorPanel = new JPanel();
        errorPanel.add(this.getErrorLabel());
        return errorPanel;
    }

    public void addListeners(ListSelectionListener listSelectionListener) {
        this.getSplittingAlgorithmsList().addListSelectionListener(listSelectionListener);
    }

    public SplittingAlgorithm getSelectedSplittingAlgorithm() {
        if (this.getSplittingAlgorithmsList().getSelectedValuesList().size() != 1) {
            return null;
        }
        return this.getSplittingAlgorithmsList().getSelectedValue();
    }
}

