/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.sdn;

import com.nexes.wizard.WizardPanelDescriptor;
import frame.options.simulation.create.CreateSimulationWizard;
import frame.options.simulation.create.sdn.SdnPanel;
import frame.options.simulation.create.virtual.VirtualDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import model.components.networks.sdn.SdnNetwork;

public class SdnDescriptor
extends WizardPanelDescriptor
implements ActionListener,
ListSelectionListener,
MouseListener {
    public static final String IDENTIFIER = SdnDescriptor.class.getSimpleName();
    private SdnPanel sdnPanel;

    public SdnPanel getSdnPanel() {
        return this.sdnPanel;
    }

    public void setSdnPanel(SdnPanel sdnPanel) {
        this.sdnPanel = sdnPanel;
    }

    public SdnDescriptor(List<SdnNetwork> sdnNetworks) {
        this.setSdnPanel(new SdnPanel(sdnNetworks));
        this.getSdnPanel().addListeners(this, this, this);
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.getSdnPanel());
    }

    @Override
    public Object getBackPanelDescriptor() {
        return null;
    }

    @Override
    public Object getNextPanelDescriptor() {
        return VirtualDescriptor.IDENTIFIER;
    }

    @Override
    public void aboutToDisplayPanel() {
        this.setNextFinishButtonEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getSdnPanel().buttonClicked((JButton)actionEvent.getSource());
        this.getSdnPanel().updateButtons();
        this.setNextFinishButtonEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.getSdnPanel().updateButtons();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int sdnNetworksListIndex;
        JList sdnNetworksList = (JList)mouseEvent.getSource();
        if (mouseEvent.getClickCount() == 2 && (sdnNetworksListIndex = sdnNetworksList.locationToIndex(mouseEvent.getPoint())) >= 0) {
            this.getSdnPanel().mouseDoubleClicked(sdnNetworksList, sdnNetworksListIndex);
            this.setNextFinishButtonEnabled();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    private void setNextFinishButtonEnabled() {
        if (this.getSdnPanel().getSelectedSdnNetworksListModel().getSize() > 0) {
            ((CreateSimulationWizard)this.getWizard()).setSdnNetwork(this.getSdnPanel().getSelectedSdnNetworks());
            this.getWizard().setNextFinishButtonEnabled(true);
        } else {
            this.getWizard().setNextFinishButtonEnabled(false);
        }
    }
}

