/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.rounding;

import frame.options.simulation.create.rounding.RoundingListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import model.algorithms.rounding.RoundingAlgorithm;

public class RoundingPanel
extends JPanel {
    public static final String AVAILABLE_LIST = "AvailableList";
    private JList<RoundingAlgorithm> roundingAlgorithmsList;

    public JList<RoundingAlgorithm> getRoundingAlgorithmsList() {
        return this.roundingAlgorithmsList;
    }

    public void setRoundingAlgorithmsList(JList<RoundingAlgorithm> roundingAlgorithmsList) {
        this.roundingAlgorithmsList = roundingAlgorithmsList;
    }

    public RoundingPanel(List<RoundingAlgorithm> roundingAlgorithms) {
        DefaultListModel<RoundingAlgorithm> roundingAlgorithmsListModel = new DefaultListModel<RoundingAlgorithm>();
        for (RoundingAlgorithm roundingAlgorithm : roundingAlgorithms) {
            roundingAlgorithmsListModel.addElement(roundingAlgorithm);
        }
        this.setRoundingAlgorithmsList(new JList<RoundingAlgorithm>(roundingAlgorithmsListModel));
        this.getRoundingAlgorithmsList().setName(AVAILABLE_LIST);
        this.getRoundingAlgorithmsList().setCellRenderer(new RoundingListCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Rounding virtual node mapping algorithm");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JSeparator separator = new JSeparator();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)separator, "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(new Insets(50, 50, 50, 50)));
        contentPanel.add(this.availablePanel());
        return contentPanel;
    }

    private JPanel availablePanel() {
        JLabel availableLabel = new JLabel("Available");
        availableLabel.setFont(new Font("MS Sans Serif", 1, 12));
        availableLabel.setAlignmentX(0.5f);
        JScrollPane availableScrollPane = new JScrollPane(this.getRoundingAlgorithmsList());
        availableScrollPane.setPreferredSize(new Dimension(200, 250));
        availableScrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2));
        JPanel availablePanel = new JPanel();
        availablePanel.setLayout(new BoxLayout(availablePanel, 3));
        availablePanel.add(availableLabel);
        availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        availablePanel.add(availableScrollPane);
        return availablePanel;
    }

    public void addListeners(ListSelectionListener listSelectionListener) {
        this.getRoundingAlgorithmsList().addListSelectionListener(listSelectionListener);
    }

    public RoundingAlgorithm getSelectedRoundingAlgorithm() {
        if (this.getRoundingAlgorithmsList().getSelectedValuesList().size() != 1) {
            return null;
        }
        return this.getRoundingAlgorithmsList().getSelectedValue();
    }
}

